/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class InvertConditionRefactoring
implements Refactoring {
    private AbstractCodeFragment originalConditional;
    private AbstractCodeFragment invertedConditional;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;

    public InvertConditionRefactoring(AbstractCodeFragment originalConditional, AbstractCodeFragment invertedConditional, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter) {
        this.originalConditional = originalConditional;
        this.invertedConditional = invertedConditional;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
    }

    public AbstractCodeFragment getOriginalConditional() {
        return this.originalConditional;
    }

    public AbstractCodeFragment getInvertedConditional() {
        return this.invertedConditional;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalConditional.codeRange().setDescription("original conditional").setCodeElement(this.originalConditional.toString()));
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.invertedConditional.codeRange().setDescription("inverted conditional").setCodeElement(this.invertedConditional.toString()));
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with inverted conditional").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.INVERT_CONDITION;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        String conditionalString = this.originalConditional.getString();
        String oldConditional = conditionalString.contains("\n") ? conditionalString.substring(0, conditionalString.indexOf("\n")) : conditionalString;
        sb.append(oldConditional);
        sb.append(" to ");
        conditionalString = this.invertedConditional.getString();
        String newConditional = conditionalString.contains("\n") ? conditionalString.substring(0, conditionalString.indexOf("\n")) : conditionalString;
        sb.append(newConditional);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.invertedConditional, this.operationAfter, this.operationBefore, this.originalConditional);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvertConditionRefactoring other = (InvertConditionRefactoring)obj;
        return Objects.equals(this.invertedConditional, other.invertedConditional) && Objects.equals(this.operationAfter, other.operationAfter) && Objects.equals(this.operationBefore, other.operationBefore) && Objects.equals(this.originalConditional, other.originalConditional);
    }
}

