/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObjectMapping;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.CodeFragmentComparator;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.ExtractVariableRefactoring;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.InlineVariableRefactoring;
import gr.uom.java.xmi.diff.MoveCodeRefactoring;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.refactoringminer.api.Refactoring;

public class MappingOptimizer {
    private UMLAbstractClassDiff classDiff;

    public MappingOptimizer(UMLAbstractClassDiff classDiff) {
        this.classDiff = classDiff;
    }

    public void optimizeDuplicateMappingsForMoveCode(List<UMLOperationBodyMapper> moveCodeMappers, List<Refactoring> refactorings) {
        if (moveCodeMappers.size() > 1) {
            HashMap<AbstractCodeFragment, List<AbstractCodeMapping>> oneToManyMappings = new HashMap<AbstractCodeFragment, List<AbstractCodeMapping>>();
            HashMap<AbstractCodeFragment, List<UMLOperationBodyMapper>> oneToManyMappers = new HashMap<AbstractCodeFragment, List<UMLOperationBodyMapper>>();
            for (UMLOperationBodyMapper moveCodeMapper : moveCodeMappers) {
                for (AbstractCodeMapping mapping : moveCodeMapper.getMappings()) {
                    AbstractCodeFragment fragmentContainingExpression = null;
                    if (oneToManyMappings.containsKey(mapping.getFragment2())) {
                        ((List)oneToManyMappings.get(mapping.getFragment2())).add(mapping);
                        ((List)oneToManyMappers.get(mapping.getFragment2())).add(moveCodeMapper);
                        continue;
                    }
                    if (mapping.getFragment2() instanceof AbstractExpression && (fragmentContainingExpression = this.findFragmentContainingExpression(oneToManyMappings.keySet(), (AbstractExpression)mapping.getFragment2())) != null) {
                        ((List)oneToManyMappings.get(fragmentContainingExpression)).add(mapping);
                        ((List)oneToManyMappers.get(fragmentContainingExpression)).add(moveCodeMapper);
                        continue;
                    }
                    ArrayList<AbstractCodeMapping> mappings = new ArrayList<AbstractCodeMapping>();
                    ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
                    mappings.add(mapping);
                    mappers.add(moveCodeMapper);
                    oneToManyMappings.put(mapping.getFragment2(), mappings);
                    oneToManyMappers.put(mapping.getFragment2(), mappers);
                }
            }
            this.optimizeDuplicateMappings(oneToManyMappings, oneToManyMappers, refactorings);
        }
    }

    private AbstractCodeFragment findFragmentContainingExpression(Set<AbstractCodeFragment> fragments, AbstractExpression expression) {
        for (AbstractCodeFragment fragment : fragments) {
            CompositeStatementObject comp;
            if (!(fragment instanceof CompositeStatementObject) || !(comp = (CompositeStatementObject)fragment).getExpressions().contains(expression)) continue;
            return fragment;
        }
        return null;
    }

    public void optimizeDuplicateMappingsForInline(UMLOperationBodyMapper parentMapper, List<Refactoring> refactorings) {
        if (parentMapper.getChildMappers().size() > 0) {
            HashMap<AbstractCodeFragment, List<AbstractCodeMapping>> oneToManyMappings = new HashMap<AbstractCodeFragment, List<AbstractCodeMapping>>();
            HashMap<AbstractCodeFragment, List<UMLOperationBodyMapper>> oneToManyMappers = new HashMap<AbstractCodeFragment, List<UMLOperationBodyMapper>>();
            for (UMLOperationBodyMapper childMapper : parentMapper.getChildMappers()) {
                for (AbstractCodeMapping mapping : childMapper.getMappings()) {
                    AbstractCodeFragment fragmentContainingExpression = null;
                    if (oneToManyMappings.containsKey(mapping.getFragment2())) {
                        ((List)oneToManyMappings.get(mapping.getFragment2())).add(mapping);
                        ((List)oneToManyMappers.get(mapping.getFragment2())).add(childMapper);
                        continue;
                    }
                    if (mapping.getFragment2() instanceof AbstractExpression && (fragmentContainingExpression = this.findFragmentContainingExpression(oneToManyMappings.keySet(), (AbstractExpression)mapping.getFragment2())) != null) {
                        ((List)oneToManyMappings.get(fragmentContainingExpression)).add(mapping);
                        ((List)oneToManyMappers.get(fragmentContainingExpression)).add(childMapper);
                        continue;
                    }
                    ArrayList<AbstractCodeMapping> mappings = new ArrayList<AbstractCodeMapping>();
                    ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
                    mappings.add(mapping);
                    mappers.add(childMapper);
                    oneToManyMappings.put(mapping.getFragment2(), mappings);
                    oneToManyMappers.put(mapping.getFragment2(), mappers);
                }
            }
            for (AbstractCodeMapping mapping : parentMapper.getMappings()) {
                if (oneToManyMappings.containsKey(mapping.getFragment2())) {
                    ((List)oneToManyMappings.get(mapping.getFragment2())).add(mapping);
                    ((List)oneToManyMappers.get(mapping.getFragment2())).add(parentMapper);
                    continue;
                }
                ArrayList<AbstractCodeMapping> mappings = new ArrayList<AbstractCodeMapping>();
                ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
                mappings.add(mapping);
                mappers.add(parentMapper);
                oneToManyMappings.put(mapping.getFragment2(), mappings);
                oneToManyMappers.put(mapping.getFragment2(), mappers);
            }
            this.optimizeDuplicateMappings(oneToManyMappings, oneToManyMappers, refactorings);
        }
    }

    private boolean subexpressionOverlap(List<AbstractCodeMapping> mappings, AbstractCodeMapping newMapping) {
        for (AbstractCodeMapping previousMapping : mappings) {
            String newReturnExpression;
            String previousReturnExpression;
            AbstractCodeFragment previousFragment2 = previousMapping.getFragment2();
            AbstractCodeFragment newFragment2 = newMapping.getFragment2();
            if (!previousFragment2.getString().startsWith("return ") || !previousFragment2.getString().endsWith(";\n") || !newFragment2.getString().startsWith("return ") || !newFragment2.getString().endsWith(";\n") || !(previousReturnExpression = previousFragment2.getString().substring("return ".length(), previousFragment2.getString().length() - 2)).contains("(" + (newReturnExpression = newFragment2.getString().substring("return ".length(), newFragment2.getString().length() - 2)) + ")") && !newReturnExpression.contains("(" + previousReturnExpression + ")")) continue;
            return true;
        }
        return false;
    }

    public void optimizeDuplicateMappingsForExtract(UMLOperationBodyMapper parentMapper, List<Refactoring> refactorings) {
        if (parentMapper.getChildMappers().size() > 0) {
            HashMap<AbstractCodeFragment, List<AbstractCodeMapping>> oneToManyMappings = new HashMap<AbstractCodeFragment, List<AbstractCodeMapping>>();
            HashMap<AbstractCodeFragment, List<UMLOperationBodyMapper>> oneToManyMappers = new HashMap<AbstractCodeFragment, List<UMLOperationBodyMapper>>();
            for (UMLOperationBodyMapper childMapper : parentMapper.getChildMappers()) {
                for (AbstractCodeMapping mapping : childMapper.getMappings()) {
                    AbstractCodeFragment fragmentContainingExpression = null;
                    if (oneToManyMappings.containsKey(mapping.getFragment1())) {
                        if (this.subexpressionOverlap((List)oneToManyMappings.get(mapping.getFragment1()), mapping)) continue;
                        ((List)oneToManyMappings.get(mapping.getFragment1())).add(mapping);
                        ((List)oneToManyMappers.get(mapping.getFragment1())).add(childMapper);
                        continue;
                    }
                    if (mapping.getFragment1() instanceof AbstractExpression && (fragmentContainingExpression = this.findFragmentContainingExpression(oneToManyMappings.keySet(), (AbstractExpression)mapping.getFragment1())) != null) {
                        ((List)oneToManyMappings.get(fragmentContainingExpression)).add(mapping);
                        ((List)oneToManyMappers.get(fragmentContainingExpression)).add(childMapper);
                        continue;
                    }
                    ArrayList<AbstractCodeMapping> mappings = new ArrayList<AbstractCodeMapping>();
                    ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
                    mappings.add(mapping);
                    mappers.add(childMapper);
                    oneToManyMappings.put(mapping.getFragment1(), mappings);
                    oneToManyMappers.put(mapping.getFragment1(), mappers);
                }
            }
            for (AbstractCodeMapping mapping : parentMapper.getMappings()) {
                if (oneToManyMappings.containsKey(mapping.getFragment1())) {
                    ((List)oneToManyMappings.get(mapping.getFragment1())).add(mapping);
                    ((List)oneToManyMappers.get(mapping.getFragment1())).add(parentMapper);
                    continue;
                }
                ArrayList<AbstractCodeMapping> mappings = new ArrayList<AbstractCodeMapping>();
                ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
                mappings.add(mapping);
                mappers.add(parentMapper);
                oneToManyMappings.put(mapping.getFragment1(), mappings);
                oneToManyMappers.put(mapping.getFragment1(), mappers);
            }
            this.optimizeDuplicateMappings(oneToManyMappings, oneToManyMappers, refactorings);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void optimizeDuplicateMappings(Map<AbstractCodeFragment, List<AbstractCodeMapping>> oneToManyMappings, Map<AbstractCodeFragment, List<UMLOperationBodyMapper>> oneToManyMappers, List<Refactoring> refactorings) {
        for (AbstractCodeFragment fragment : oneToManyMappers.keySet()) {
            if (oneToManyMappings.get(fragment).size() != 1) continue;
            oneToManyMappings.remove(fragment);
        }
        TreeSet<AbstractCodeFragment> sortedKeys = new TreeSet<AbstractCodeFragment>(new CodeFragmentComparator());
        sortedKeys.addAll(oneToManyMappings.keySet());
        LinkedHashSet<UMLOperationBodyMapper> updatedMappers = new LinkedHashSet<UMLOperationBodyMapper>();
        for (AbstractCodeFragment fragment : sortedKeys) {
            List<AbstractCodeMapping> mappings = oneToManyMappings.get(fragment);
            List<UMLOperationBodyMapper> mappers = oneToManyMappers.get(fragment);
            Iterator<AbstractCodeMapping> mappingIterator = mappings.iterator();
            Iterator<UMLOperationBodyMapper> mapperIterator = mappers.iterator();
            ArrayList<Boolean> callsExtractedInlinedMethod = new ArrayList<Boolean>();
            ArrayList<Boolean> parentMappingFound = new ArrayList<Boolean>();
            ArrayList<Boolean> parentIsContainerBody = new ArrayList<Boolean>();
            ArrayList<Boolean> nestedMapper = new ArrayList<Boolean>();
            ArrayList<Boolean> identical = new ArrayList<Boolean>();
            ArrayList<Integer> identicalStatementsForCompositeMappings = new ArrayList<Integer>();
            ArrayList<Integer> exactMappingsNestedUnderCompositeExcludingBlocks = new ArrayList<Integer>();
            ArrayList<Integer> nonMappedNodes = new ArrayList<Integer>();
            ArrayList<Integer> replacementTypeCount = new ArrayList<Integer>();
            ArrayList<Boolean> replacementCoversEntireStatement = new ArrayList<Boolean>();
            ArrayList<Boolean> extractInlineOverlappingRefactoring = new ArrayList<Boolean>();
            ArrayList<UMLOperationBodyMapper> parentMappers = new ArrayList<UMLOperationBodyMapper>();
            ArrayList<Double> editDistances = new ArrayList<Double>();
            LinkedHashSet<AbstractCodeMapping> mappingsAsSet = new LinkedHashSet<AbstractCodeMapping>();
            mappingsAsSet.addAll(mappings);
            LinkedHashSet<UMLOperationBodyMapper> mappersAsSet = new LinkedHashSet<UMLOperationBodyMapper>();
            mappersAsSet.addAll(mappers);
            if (mappingsAsSet.size() == 1 || mappersAsSet.size() == 1 && ((UMLOperationBodyMapper)mappersAsSet.iterator().next()).getParentMapper() == null) continue;
            while (mappingIterator.hasNext()) {
                AbstractCodeMapping mapping = mappingIterator.next();
                UMLOperationBodyMapper mapper = mapperIterator.next();
                if (mapping instanceof CompositeStatementObjectMapping) {
                    CompositeStatementObject comp1 = (CompositeStatementObject)mapping.getFragment1();
                    CompositeStatementObject comp2 = (CompositeStatementObject)mapping.getFragment2();
                    List<String> list = comp1.stringRepresentation();
                    List<String> stringRepresentation2 = comp2.stringRepresentation();
                    int minSize = Math.min(list.size(), stringRepresentation2.size());
                    int identicalStatements = 0;
                    for (int i = 0; i < minSize; ++i) {
                        if (!list.get(i).equals(stringRepresentation2.get(i)) || list.get(i).equals("{") || list.get(i).equals("}")) continue;
                        ++identicalStatements;
                    }
                    identicalStatementsForCompositeMappings.add(identicalStatements);
                    exactMappingsNestedUnderCompositeExcludingBlocks.add(mapper.exactMappingsNestedUnderCompositeExcludingBlocks((CompositeStatementObjectMapping)mapping));
                } else {
                    identicalStatementsForCompositeMappings.add(0);
                    exactMappingsNestedUnderCompositeExcludingBlocks.add(0);
                }
                callsExtractedInlinedMethod.add(mapper.containsExtractedOrInlinedOperationInvocation(mapping));
                parentMappingFound.add(mapper.containsParentMapping(mapping));
                parentIsContainerBody.add(mapper.parentIsContainerBody(mapping));
                nestedMapper.add(mapper.isNested());
                identical.add(mapping.getFragment1().getString().equals(mapping.getFragment2().getString()));
                if (mapper.getParentMapper() != null) {
                    if (mapper.getContainer1().equals(mapper.getParentMapper().getContainer1()) && !mapper.getContainer2().equals(mapper.getParentMapper().getContainer2())) {
                        nonMappedNodes.add(mapper.nonMappedElementsT2());
                    } else if (!mapper.getContainer1().equals(mapper.getParentMapper().getContainer1()) && mapper.getContainer2().equals(mapper.getParentMapper().getContainer2())) {
                        nonMappedNodes.add(mapper.nonMappedElementsT1());
                    }
                } else {
                    nonMappedNodes.add(0);
                }
                replacementTypeCount.add(mapper.getReplacementTypesExcludingParameterToArgumentMaps(mapping).size());
                boolean replacementFound = false;
                for (Replacement replacement : mapping.getReplacements()) {
                    if (!replacement.getBefore().equals(mapping.getFragment1().getString()) && !(replacement.getBefore() + ";\n").equals(mapping.getFragment1().getString()) || !replacement.getAfter().equals(mapping.getFragment2().getString()) && !(replacement.getAfter() + ";\n").equals(mapping.getFragment2().getString())) continue;
                    replacementFound = true;
                    break;
                }
                replacementCoversEntireStatement.add(replacementFound);
                boolean containsExtractInlineVariableRefactoring = false;
                for (Refactoring r3 : mapping.getRefactorings()) {
                    if (!(r3 instanceof ExtractVariableRefactoring) && !(r3 instanceof InlineVariableRefactoring)) continue;
                    containsExtractInlineVariableRefactoring = true;
                    break;
                }
                if (mapping.isIdenticalWithExtractedVariable() || mapping.isIdenticalWithInlinedVariable() || containsExtractInlineVariableRefactoring) {
                    extractInlineOverlappingRefactoring.add(true);
                } else {
                    extractInlineOverlappingRefactoring.add(false);
                }
                parentMappers.add(mapper.getParentMapper());
                editDistances.add(mapping.editDistance());
            }
            LinkedHashSet<Integer> indicesToBeRemoved = new LinkedHashSet<Integer>();
            if (callsExtractedInlinedMethod.contains(true) && callsExtractedInlinedMethod.contains(false)) {
                int i;
                for (i = 0; i < callsExtractedInlinedMethod.size(); ++i) {
                    if (!((Boolean)callsExtractedInlinedMethod.get(i)).booleanValue() || this.callToExtractedInlinedMethodIsArgument(mappings.get(i), mappers.get(callsExtractedInlinedMethod.indexOf(false)))) continue;
                    indicesToBeRemoved.add(i);
                }
                if (this.matchingParentMappers(parentMappers) > 1 && parentMappingFound.contains(true)) {
                    for (i = 0; i < parentMappingFound.size(); ++i) {
                        if (((Boolean)parentMappingFound.get(i)).booleanValue()) continue;
                        indicesToBeRemoved.add(i);
                    }
                    this.determineIndicesToBeRemoved(nestedMapper, identical, exactMappingsNestedUnderCompositeExcludingBlocks, replacementTypeCount, replacementCoversEntireStatement, extractInlineOverlappingRefactoring, indicesToBeRemoved, editDistances);
                }
            } else if (parentMappingFound.contains(true)) {
                void var31_44;
                boolean anonymousClassDeclarationMatch = false;
                boolean splitConditional = false;
                boolean splitDeclaration = false;
                boolean bl = false;
                while (var31_44 < parentMappingFound.size()) {
                    if (!((Boolean)parentMappingFound.get((int)var31_44)).booleanValue()) {
                        boolean skip = false;
                        if (!identicalStatementsForCompositeMappings.isEmpty()) {
                            int indexOfTrueParentMapping = parentMappingFound.indexOf(true);
                            if ((Integer)identicalStatementsForCompositeMappings.get((int)var31_44) > (Integer)identicalStatementsForCompositeMappings.get(indexOfTrueParentMapping)) {
                                skip = true;
                            }
                            if (mappings.get((int)var31_44).getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) && mappings.get((int)var31_44).getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
                                String condition = mappings.get((int)var31_44).getFragment2().getString().substring(3, mappings.get((int)var31_44).getFragment2().getString().length() - 1);
                                String conditionOfTrueParentMapping = mappings.get(indexOfTrueParentMapping).getFragment2().getString().substring(3, mappings.get(indexOfTrueParentMapping).getFragment2().getString().length() - 1);
                                if (mappings.get((int)var31_44).getFragment1().getString().contains(condition) && mappings.get(indexOfTrueParentMapping).getFragment1().getString().contains(conditionOfTrueParentMapping)) {
                                    splitConditional = true;
                                }
                            }
                        }
                        if (((Boolean)parentIsContainerBody.get((int)var31_44)).booleanValue() && ((Double)editDistances.get((int)var31_44)).equals(editDistances.get(parentMappingFound.indexOf(true))) && !mappings.get((int)var31_44).getFragment1().getString().startsWith("return ") && !mappings.get((int)var31_44).getFragment2().getString().startsWith("return ")) {
                            skip = true;
                        }
                        if (((Boolean)parentIsContainerBody.get((int)var31_44)).booleanValue() && mappings.get((int)var31_44).getFragment1().getAnonymousClassDeclarations().size() > 0 && mappings.get((int)var31_44).getFragment2().getAnonymousClassDeclarations().size() > 0) {
                            skip = true;
                            anonymousClassDeclarationMatch = true;
                        }
                        List<VariableDeclaration> fragment2VariableDeclarations = mappings.get((int)var31_44).getFragment2().getVariableDeclarations();
                        if (((Boolean)parentIsContainerBody.get((int)var31_44)).booleanValue() && fragment2VariableDeclarations.size() > 0 && mappings.get(parentMappingFound.indexOf(true)).getFragment2().getString().startsWith(fragment2VariableDeclarations.get(0).getVariableName() + "=")) {
                            skip = true;
                            splitDeclaration = true;
                        }
                        if (!skip) {
                            indicesToBeRemoved.add((int)var31_44);
                        }
                    }
                    ++var31_44;
                }
                if (!(anonymousClassDeclarationMatch || splitConditional || splitDeclaration)) {
                    this.determineIndicesToBeRemoved(nestedMapper, identical, exactMappingsNestedUnderCompositeExcludingBlocks, replacementTypeCount, replacementCoversEntireStatement, extractInlineOverlappingRefactoring, indicesToBeRemoved, editDistances);
                }
            } else if (parentIsContainerBody.contains(true)) {
                boolean splitConditional = false;
                boolean splitDeclaration = false;
                for (int i = 0; i < parentIsContainerBody.size(); ++i) {
                    List<VariableDeclaration> fragment2VariableDeclarations;
                    if (((Boolean)parentIsContainerBody.get(i)).booleanValue() || ((Boolean)nestedMapper.get(parentIsContainerBody.indexOf(true))).booleanValue()) continue;
                    boolean bl = false;
                    if (!identicalStatementsForCompositeMappings.isEmpty()) {
                        int indexOfTrueParentIsContainerBody = parentIsContainerBody.indexOf(true);
                        if ((Integer)identicalStatementsForCompositeMappings.get(i) > (Integer)identicalStatementsForCompositeMappings.get(indexOfTrueParentIsContainerBody)) {
                            bl = true;
                        }
                        if (mappings.get(i).getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) && mappings.get(i).getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
                            String condition = mappings.get(i).getFragment2().getString().substring(3, mappings.get(i).getFragment2().getString().length() - 1);
                            String conditionOfTrueParentIsContainerBody = mappings.get(indexOfTrueParentIsContainerBody).getFragment2().getString().substring(3, mappings.get(indexOfTrueParentIsContainerBody).getFragment2().getString().length() - 1);
                            if (mappings.get(i).getFragment1().getString().contains(condition) && mappings.get(indexOfTrueParentIsContainerBody).getFragment1().getString().contains(conditionOfTrueParentIsContainerBody)) {
                                splitConditional = true;
                            }
                        }
                    }
                    if ((fragment2VariableDeclarations = mappings.get(parentIsContainerBody.indexOf(true)).getFragment2().getVariableDeclarations()).size() > 0 && mappings.get(i).getFragment2().getString().startsWith(fragment2VariableDeclarations.get(0).getVariableName() + "=")) {
                        bl = true;
                        splitDeclaration = true;
                    }
                    if (bl) continue;
                    indicesToBeRemoved.add(i);
                }
                if (!splitConditional && !splitDeclaration) {
                    this.determineIndicesToBeRemoved(nestedMapper, identical, exactMappingsNestedUnderCompositeExcludingBlocks, replacementTypeCount, replacementCoversEntireStatement, extractInlineOverlappingRefactoring, indicesToBeRemoved, editDistances);
                }
            } else {
                this.determineIndicesToBeRemoved(nestedMapper, identical, exactMappingsNestedUnderCompositeExcludingBlocks, replacementTypeCount, replacementCoversEntireStatement, extractInlineOverlappingRefactoring, indicesToBeRemoved, editDistances);
            }
            if (indicesToBeRemoved.isEmpty() && this.matchingParentMappers(parentMappers) == parentMappers.size()) {
                int i;
                int minimum = (Integer)nonMappedNodes.get(0);
                for (i = 1; i < nonMappedNodes.size(); ++i) {
                    if ((Integer)nonMappedNodes.get(i) >= minimum) continue;
                    minimum = (Integer)nonMappedNodes.get(i);
                }
                for (i = 0; i < nonMappedNodes.size(); ++i) {
                    if ((Integer)nonMappedNodes.get(i) <= minimum) continue;
                    indicesToBeRemoved.add(i);
                }
            }
            mappingIterator = mappings.iterator();
            mapperIterator = mappers.iterator();
            int index = 0;
            boolean atLeastOneMappingCallsExtractedOrInlinedMethodWithVariableDeclarationOrThrow = this.atLeastOneMappingCallsExtractedOrInlinedMethodWithVariableDeclarationOrThrow(mappings, mappers);
            while (mappingIterator.hasNext()) {
                AbstractCodeMapping mapping = mappingIterator.next();
                UMLOperationBodyMapper uMLOperationBodyMapper = mapperIterator.next();
                if (indicesToBeRemoved.contains(index) && !atLeastOneMappingCallsExtractedOrInlinedMethodWithVariableDeclarationOrThrow) {
                    uMLOperationBodyMapper.removeMapping(mapping);
                    for (LeafMapping leafMapping : mapping.getSubExpressionMappings()) {
                        uMLOperationBodyMapper.removeMapping(leafMapping);
                    }
                    if (mapping instanceof LeafMapping) {
                        if (!uMLOperationBodyMapper.getNonMappedLeavesT1().contains(mapping.getFragment1())) {
                            uMLOperationBodyMapper.getNonMappedLeavesT1().add(mapping.getFragment1());
                        }
                        if (!uMLOperationBodyMapper.getNonMappedLeavesT2().contains(mapping.getFragment2())) {
                            uMLOperationBodyMapper.getNonMappedLeavesT2().add(mapping.getFragment2());
                        }
                    } else if (mapping instanceof CompositeStatementObjectMapping) {
                        if (!uMLOperationBodyMapper.getNonMappedInnerNodesT1().contains(mapping.getFragment1())) {
                            uMLOperationBodyMapper.getNonMappedInnerNodesT1().add((CompositeStatementObject)mapping.getFragment1());
                        }
                        if (!uMLOperationBodyMapper.getNonMappedInnerNodesT2().contains(mapping.getFragment2())) {
                            uMLOperationBodyMapper.getNonMappedInnerNodesT2().add((CompositeStatementObject)mapping.getFragment2());
                        }
                    }
                    LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
                    Set<Refactoring> refactoringsAfterPostProcessing = uMLOperationBodyMapper.getRefactoringsAfterPostProcessing();
                    for (Refactoring r : refactoringsAfterPostProcessing) {
                        ReferenceBasedRefactoring referenceBased;
                        Set<AbstractCodeMapping> references;
                        if (!(r instanceof ReferenceBasedRefactoring) || !(references = (referenceBased = (ReferenceBasedRefactoring)((Object)r)).getReferences()).contains(mapping)) continue;
                        refactoringsToBeRemoved.add(r);
                    }
                    refactoringsAfterPostProcessing.removeAll(refactoringsToBeRemoved);
                    updatedMappers.add(uMLOperationBodyMapper);
                }
                ++index;
            }
        }
        LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
        for (Refactoring ref : refactorings) {
            Refactoring refactoring;
            if (ref instanceof ExtractOperationRefactoring) {
                refactoring = (ExtractOperationRefactoring)ref;
                if (!updatedMappers.contains(((ExtractOperationRefactoring)refactoring).getBodyMapper())) continue;
                if (((ExtractOperationRefactoring)refactoring).getBodyMapper().getMappings().size() == 0) {
                    refactoringsToBeRemoved.add(refactoring);
                    continue;
                }
                ((ExtractOperationRefactoring)refactoring).updateMapperInfo();
                continue;
            }
            if (ref instanceof InlineOperationRefactoring) {
                refactoring = (InlineOperationRefactoring)ref;
                if (!updatedMappers.contains(((InlineOperationRefactoring)refactoring).getBodyMapper())) continue;
                if (((InlineOperationRefactoring)refactoring).getBodyMapper().getMappings().size() == 0) {
                    refactoringsToBeRemoved.add(refactoring);
                    continue;
                }
                ((InlineOperationRefactoring)refactoring).updateMapperInfo();
                continue;
            }
            if (!(ref instanceof MoveCodeRefactoring) || !updatedMappers.contains(((MoveCodeRefactoring)(refactoring = (MoveCodeRefactoring)ref)).getBodyMapper())) continue;
            if (((MoveCodeRefactoring)refactoring).getBodyMapper().getMappings().size() == 0) {
                refactoringsToBeRemoved.add(refactoring);
                continue;
            }
            ((MoveCodeRefactoring)refactoring).updateMapperInfo();
        }
        refactorings.removeAll(refactoringsToBeRemoved);
    }

    private boolean callToExtractedInlinedMethodIsArgument(AbstractCodeMapping mapping, UMLOperationBodyMapper mapper) {
        if (mapper.getOperationInvocation() != null) {
            AbstractCodeFragment fragment1 = mapping.getFragment1();
            for (AbstractCall call : fragment1.getCreations()) {
                if (!call.arguments().contains(mapper.getOperationInvocation().actualString())) continue;
                return true;
            }
            for (AbstractCall call : fragment1.getMethodInvocations()) {
                if (!call.arguments().contains(mapper.getOperationInvocation().actualString())) continue;
                return true;
            }
            AbstractCodeFragment fragment2 = mapping.getFragment2();
            for (AbstractCall call : fragment2.getCreations()) {
                if (!call.arguments().contains(mapper.getOperationInvocation().actualString())) continue;
                return true;
            }
            for (AbstractCall call : fragment2.getMethodInvocations()) {
                if (!call.arguments().contains(mapper.getOperationInvocation().actualString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean atLeastOneMappingCallsExtractedOrInlinedMethodWithVariableDeclarationOrThrow(List<AbstractCodeMapping> mappings, List<UMLOperationBodyMapper> mappers) {
        LinkedHashSet<AbstractCall> operationInvocations = new LinkedHashSet<AbstractCall>();
        for (UMLOperationBodyMapper mapper : mappers) {
            if (mapper.getOperationInvocation() == null) continue;
            operationInvocations.add(mapper.getOperationInvocation());
        }
        int matches = 0;
        boolean identicalMapping = false;
        for (AbstractCodeMapping mapping : mappings) {
            if (mapping.getFragment1().getString().equals(mapping.getFragment2().getString())) {
                identicalMapping = true;
            }
            for (AbstractCall operationInvocation : operationInvocations) {
                if (!this.callsExtractedOrInlinedMethodWithVariableDeclarationOrThrow(mapping, operationInvocation)) continue;
                ++matches;
            }
        }
        return matches == operationInvocations.size() && !identicalMapping;
    }

    private boolean callsExtractedOrInlinedMethodWithVariableDeclarationOrThrow(AbstractCodeMapping mapping, AbstractCall operationInvocation) {
        if (operationInvocation != null) {
            if (this.stringBasedInvocationMatch(mapping.getFragment1(), operationInvocation)) {
                return true;
            }
            if (this.stringBasedInvocationMatch(mapping.getFragment2(), operationInvocation)) {
                return true;
            }
        }
        return false;
    }

    private boolean stringBasedInvocationMatch(AbstractCodeFragment callFragment, AbstractCall operationInvocation) {
        ObjectCreation creation;
        AbstractCall invocation = callFragment.invocationCoveringEntireFragment();
        if (invocation == null && (invocation = callFragment.fieldAssignmentInvocationCoveringEntireStatement(this.classDiff)) != null && invocation.actualString().equals(operationInvocation.actualString())) {
            return true;
        }
        if (invocation == null && callFragment.getVariableDeclarations().size() > 0) {
            for (AbstractCall call : callFragment.getMethodInvocations()) {
                if (!call.actualString().equals(operationInvocation.actualString())) continue;
                return true;
            }
        }
        if (invocation != null && invocation.actualString().equals(operationInvocation.actualString())) {
            if (invocation.getCoverage().equals((Object)AbstractCall.StatementCoverageType.VARIABLE_DECLARATION_INITIALIZER_CALL)) {
                return true;
            }
            String expression = invocation.getExpression();
            if (expression != null && !expression.equals("this")) {
                return true;
            }
        }
        if (invocation != null) {
            for (String argument : invocation.arguments()) {
                if (!argument.contains(operationInvocation.actualString())) continue;
                return true;
            }
        }
        return (creation = callFragment.creationCoveringEntireFragment()) != null && ((AbstractCall)creation).actualString().contains(operationInvocation.actualString());
    }

    private int matchingParentMappers(List<UMLOperationBodyMapper> parentMappers) {
        int matchingParentMappers = 1;
        for (int i = 1; i < parentMappers.size(); ++i) {
            if (parentMappers.get(i) == null || !parentMappers.get(i).equals(parentMappers.get(i - 1))) continue;
            ++matchingParentMappers;
        }
        return matchingParentMappers;
    }

    private void determineIndicesToBeRemoved(List<Boolean> nestedMapper, List<Boolean> identical, List<Integer> exactMappingsNestedUnderCompositeExcludingBlocks, List<Integer> replacementTypeCount, List<Boolean> replacementCoversEntireStatement, List<Boolean> extractInlineOverlappingRefactoring, Set<Integer> indicesToBeRemoved, List<Double> editDistances) {
        block15: {
            int i;
            block16: {
                int i2;
                if (!indicesToBeRemoved.isEmpty()) break block15;
                if (nestedMapper.contains(false)) {
                    double editDistanceFalseNestedMapper = editDistances.get(nestedMapper.indexOf(false));
                    for (i = 0; i < nestedMapper.size(); ++i) {
                        if (!nestedMapper.get(i).booleanValue() || identical.get(i).booleanValue() || !(editDistances.get(i) > editDistanceFalseNestedMapper)) continue;
                        indicesToBeRemoved.add(i);
                    }
                }
                if (!identical.contains(true)) break block16;
                for (int i3 = 0; i3 < identical.size(); ++i3) {
                    if (identical.get(i3).booleanValue()) continue;
                    indicesToBeRemoved.add(i3);
                }
                if (!indicesToBeRemoved.isEmpty()) break block15;
                int zeroCount = 0;
                for (i2 = 0; i2 < exactMappingsNestedUnderCompositeExcludingBlocks.size(); ++i2) {
                    if (exactMappingsNestedUnderCompositeExcludingBlocks.get(i2) != 0) continue;
                    ++zeroCount;
                }
                if (zeroCount == 1) {
                    for (i2 = 0; i2 < exactMappingsNestedUnderCompositeExcludingBlocks.size(); ++i2) {
                        if (exactMappingsNestedUnderCompositeExcludingBlocks.get(i2) != 0) continue;
                        indicesToBeRemoved.add(i2);
                    }
                }
                break block15;
            }
            boolean allReplacementsCoverEntireStatement = false;
            if (replacementCoversEntireStatement.contains(false)) {
                for (int i4 = 0; i4 < replacementCoversEntireStatement.size(); ++i4) {
                    if (!replacementCoversEntireStatement.get(i4).booleanValue()) continue;
                    indicesToBeRemoved.add(i4);
                }
            } else {
                allReplacementsCoverEntireStatement = true;
            }
            if (!allReplacementsCoverEntireStatement) {
                int minimum = replacementTypeCount.get(0);
                for (i = 1; i < replacementTypeCount.size(); ++i) {
                    if (replacementTypeCount.get(i) >= minimum) continue;
                    minimum = replacementTypeCount.get(i);
                }
                for (i = 0; i < replacementTypeCount.size(); ++i) {
                    if (replacementTypeCount.get(i) <= minimum || !(extractInlineOverlappingRefactoring.get(i) == false)) continue;
                    indicesToBeRemoved.add(i);
                }
            }
            if (indicesToBeRemoved.isEmpty()) {
                int i5;
                double minimumEditDistance = editDistances.get(0);
                for (i5 = 1; i5 < editDistances.size(); ++i5) {
                    if (!(editDistances.get(i5) < minimumEditDistance)) continue;
                    minimumEditDistance = editDistances.get(i5);
                }
                for (i5 = 0; i5 < editDistances.size(); ++i5) {
                    if (!(editDistances.get(i5) > minimumEditDistance)) continue;
                    indicesToBeRemoved.add(i5);
                }
            }
        }
    }
}

