/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CandidateMergeVariableRefactoring;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class MergeAttributeRefactoring
implements Refactoring {
    private Set<UMLAttribute> mergedAttributes;
    private UMLAttribute newAttribute;
    private Set<CandidateMergeVariableRefactoring> attributeMerges;
    private String classNameBefore;
    private String classNameAfter;

    public MergeAttributeRefactoring(Set<UMLAttribute> mergedAttributes, UMLAttribute newAttribute, String classNameBefore, String classNameAfter, Set<CandidateMergeVariableRefactoring> attributeMerges) {
        this.mergedAttributes = mergedAttributes;
        this.newAttribute = newAttribute;
        this.classNameBefore = classNameBefore;
        this.classNameAfter = classNameAfter;
        this.attributeMerges = attributeMerges;
    }

    public Set<UMLAttribute> getMergedAttributes() {
        return this.mergedAttributes;
    }

    public UMLAttribute getNewAttribute() {
        return this.newAttribute;
    }

    public Set<CandidateMergeVariableRefactoring> getAttributeMerges() {
        return this.attributeMerges;
    }

    public String getClassNameBefore() {
        return this.classNameBefore;
    }

    public String getClassNameAfter() {
        return this.classNameAfter;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MERGE_ATTRIBUTE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.getMergedVariables());
        sb.append(" to ");
        sb.append(this.newAttribute.getVariableDeclaration());
        sb.append(" in class ").append(this.classNameAfter);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classNameAfter == null ? 0 : this.classNameAfter.hashCode());
        result = 31 * result + (this.classNameBefore == null ? 0 : this.classNameBefore.hashCode());
        Set<VariableDeclaration> mergedVariables = this.getMergedVariables();
        result = 31 * result + (mergedVariables.isEmpty() ? 0 : mergedVariables.hashCode());
        result = 31 * result + (this.newAttribute == null || this.newAttribute.getVariableDeclaration() == null ? 0 : this.newAttribute.getVariableDeclaration().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeAttributeRefactoring other = (MergeAttributeRefactoring)obj;
        if (this.classNameAfter == null ? other.classNameAfter != null : !this.classNameAfter.equals(other.classNameAfter)) {
            return false;
        }
        if (this.classNameBefore == null ? other.classNameBefore != null : !this.classNameBefore.equals(other.classNameBefore)) {
            return false;
        }
        if (!this.getMergedVariables().equals(other.getMergedVariables())) {
            return false;
        }
        return !(this.newAttribute == null ? other.newAttribute != null : (this.newAttribute.getVariableDeclaration() == null ? other.newAttribute.getVariableDeclaration() != null : !this.newAttribute.getVariableDeclaration().equals(other.newAttribute.getVariableDeclaration())));
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (UMLAttribute mergedAttribute : this.mergedAttributes) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)mergedAttribute.getLocationInfo().getFilePath(), (Object)this.getClassNameBefore()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getNewAttribute().getLocationInfo().getFilePath(), (Object)this.getClassNameAfter()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclaration mergedAttribute : this.getMergedVariables()) {
            ranges.add(mergedAttribute.codeRange().setDescription("merged attribute declaration").setCodeElement(mergedAttribute.toString()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.newAttribute.getVariableDeclaration().codeRange().setDescription("new attribute declaration").setCodeElement(this.newAttribute.getVariableDeclaration().toString()));
        return ranges;
    }

    public Set<VariableDeclaration> getMergedVariables() {
        return this.mergedAttributes.stream().map(UMLAttribute::getVariableDeclaration).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

