/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class MergeCatchRefactoring
implements Refactoring {
    private Set<AbstractCodeFragment> mergedCatchBlocks;
    private AbstractCodeFragment newCatchBlock;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;

    public MergeCatchRefactoring(Set<AbstractCodeFragment> mergedCatchBlocks, AbstractCodeFragment newCatchBlock, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter) {
        this.mergedCatchBlocks = mergedCatchBlocks;
        this.newCatchBlock = newCatchBlock;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
    }

    public Set<AbstractCodeFragment> getMergedCatchBlocks() {
        return this.mergedCatchBlocks;
    }

    public AbstractCodeFragment getNewCatchBlock() {
        return this.newCatchBlock;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeFragment mergedConditional : this.mergedCatchBlocks) {
            ranges.add(mergedConditional.codeRange().setDescription("merged catch block").setCodeElement(mergedConditional.toString()));
        }
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.newCatchBlock.codeRange().setDescription("new catch block").setCodeElement(this.newCatchBlock.toString()));
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with merged catch blocks").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MERGE_CATCH;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append("[");
        int i = 0;
        for (AbstractCodeFragment mergedCatch : this.mergedCatchBlocks) {
            String catchString = mergedCatch.getString();
            VariableDeclaration exceptionDeclaration = mergedCatch.getVariableDeclarations().get(0);
            catchString = catchString.replace(exceptionDeclaration.getVariableName() + ")", exceptionDeclaration.getType() + " " + exceptionDeclaration.getVariableName() + ")");
            sb.append(catchString);
            if (i < this.mergedCatchBlocks.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        sb.append(" to ");
        String catchString = this.newCatchBlock.getString();
        VariableDeclaration exceptionDeclaration = this.newCatchBlock.getVariableDeclarations().get(0);
        catchString = catchString.replace(exceptionDeclaration.getVariableName() + ")", exceptionDeclaration.getType() + " " + exceptionDeclaration.getVariableName() + ")");
        sb.append(catchString);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mergedCatchBlocks, this.newCatchBlock, this.operationAfter, this.operationBefore);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeCatchRefactoring other = (MergeCatchRefactoring)obj;
        return Objects.equals(this.mergedCatchBlocks, other.mergedCatchBlocks) && Objects.equals(this.newCatchBlock, other.newCatchBlock) && Objects.equals(this.operationAfter, other.operationAfter) && Objects.equals(this.operationBefore, other.operationBefore);
    }
}

