/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class MergeOperationRefactoring
implements Refactoring {
    private Set<VariableDeclarationContainer> mergedMethods;
    private Set<UMLOperationBodyMapper> mappers;
    private VariableDeclarationContainer newMethodAfterMerge;
    private String classNameBefore;
    private String classNameAfter;

    public MergeOperationRefactoring(Set<VariableDeclarationContainer> mergedMethods, VariableDeclarationContainer newMethodAfterMerge, String classNameBefore, String classNameAfter, Set<UMLOperationBodyMapper> mappers) {
        this.mergedMethods = mergedMethods;
        this.newMethodAfterMerge = newMethodAfterMerge;
        this.classNameBefore = classNameBefore;
        this.classNameAfter = classNameAfter;
        this.mappers = mappers;
    }

    public Set<VariableDeclarationContainer> getMergedMethods() {
        return this.mergedMethods;
    }

    public Set<UMLOperationBodyMapper> getMappers() {
        return this.mappers;
    }

    public VariableDeclarationContainer getNewMethodAfterMerge() {
        return this.newMethodAfterMerge;
    }

    public String getClassNameBefore() {
        return this.classNameBefore;
    }

    public String getClassNameAfter() {
        return this.classNameAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclarationContainer mergedMethod : this.getMergedMethods()) {
            ranges.add(mergedMethod.codeRange().setDescription("merged method declaration").setCodeElement(mergedMethod.toString()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.newMethodAfterMerge.codeRange().setDescription("new method declaration").setCodeElement(this.newMethodAfterMerge.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MERGE_OPERATION;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (VariableDeclarationContainer mergedMethod : this.mergedMethods) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)mergedMethod.getLocationInfo().getFilePath(), (Object)this.getClassNameBefore()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getNewMethodAfterMerge().getLocationInfo().getFilePath(), (Object)this.getClassNameAfter()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.getMergedMethods());
        sb.append(" to ");
        sb.append(this.newMethodAfterMerge);
        sb.append(" in class ").append(this.classNameAfter);
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.classNameAfter, this.classNameBefore, this.mergedMethods, this.newMethodAfterMerge);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeOperationRefactoring other = (MergeOperationRefactoring)obj;
        return Objects.equals(this.classNameAfter, other.classNameAfter) && Objects.equals(this.classNameBefore, other.classNameBefore) && Objects.equals(this.mergedMethods, other.mergedMethods) && Objects.equals(this.newMethodAfterMerge, other.newMethodAfterMerge);
    }
}

