/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ModifyVariableAnnotationRefactoring
implements Refactoring {
    private UMLAnnotation annotationBefore;
    private UMLAnnotation annotationAfter;
    private VariableDeclaration variableBefore;
    private VariableDeclaration variableAfter;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private boolean insideExtractedOrInlinedMethod;

    public ModifyVariableAnnotationRefactoring(UMLAnnotation annotationBefore, UMLAnnotation annotationAfter, VariableDeclaration variableBefore, VariableDeclaration variableAfter, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter, boolean insideExtractedOrInlinedMethod) {
        this.annotationBefore = annotationBefore;
        this.annotationAfter = annotationAfter;
        this.variableBefore = variableBefore;
        this.variableAfter = variableAfter;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
    }

    public UMLAnnotation getAnnotationBefore() {
        return this.annotationBefore;
    }

    public UMLAnnotation getAnnotationAfter() {
        return this.annotationAfter;
    }

    public VariableDeclaration getVariableBefore() {
        return this.variableBefore;
    }

    public VariableDeclaration getVariableAfter() {
        return this.variableAfter;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationBefore.codeRange().setDescription("original annotation").setCodeElement(this.annotationBefore.toString()));
        ranges.add(this.variableBefore.codeRange().setDescription("original variable declaration").setCodeElement(this.variableBefore.toString()));
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.annotationAfter.codeRange().setDescription("modified annotation").setCodeElement(this.annotationAfter.toString()));
        ranges.add(this.variableAfter.codeRange().setDescription("variable declaration with modified annotation").setCodeElement(this.variableAfter.toString()));
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with modified variable annotation").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.variableBefore.isParameter() && this.variableAfter.isParameter()) {
            return RefactoringType.MODIFY_PARAMETER_ANNOTATION;
        }
        if (this.variableAfter.isParameter()) {
            return RefactoringType.MODIFY_PARAMETER_ANNOTATION;
        }
        return RefactoringType.MODIFY_VARIABLE_ANNOTATION;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.annotationBefore);
        sb.append(" to ");
        sb.append(this.annotationAfter);
        if (this.variableAfter.isParameter()) {
            sb.append(" in parameter ");
        } else {
            sb.append(" in variable ");
        }
        sb.append(this.variableAfter);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ");
        sb.append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationAfter == null ? 0 : this.annotationAfter.hashCode());
        result = 31 * result + (this.annotationBefore == null ? 0 : this.annotationBefore.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.variableAfter == null ? 0 : this.variableAfter.hashCode());
        result = 31 * result + (this.variableBefore == null ? 0 : this.variableBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyVariableAnnotationRefactoring other = (ModifyVariableAnnotationRefactoring)obj;
        if (this.annotationAfter == null ? other.annotationAfter != null : !this.annotationAfter.equals(other.annotationAfter)) {
            return false;
        }
        if (this.annotationBefore == null ? other.annotationBefore != null : !this.annotationBefore.equals(other.annotationBefore)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.variableAfter == null ? other.variableAfter != null : !this.variableAfter.equals(other.variableAfter)) {
            return false;
        }
        return !(this.variableBefore == null ? other.variableBefore != null : !this.variableBefore.equals(other.variableBefore));
    }
}

