/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.diff.CandidateAttributeRefactoring;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.MoveAttributeRefactoring;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.refactoringminer.api.RefactoringType;

public class MoveAndRenameAttributeRefactoring
extends MoveAttributeRefactoring {
    private Set<CandidateAttributeRefactoring> attributeRenames;

    public MoveAndRenameAttributeRefactoring(UMLAttribute originalAttribute, UMLAttribute movedAttribute, Set<CandidateAttributeRefactoring> attributeRenames) {
        super(originalAttribute, movedAttribute);
        this.attributeRenames = attributeRenames;
    }

    public Set<CandidateAttributeRefactoring> getAttributeRenames() {
        return this.attributeRenames;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalAttribute.toQualifiedString());
        sb.append(" renamed to ");
        sb.append(this.movedAttribute.toQualifiedString());
        sb.append(" and moved from class ");
        sb.append(this.getSourceClassName());
        sb.append(" to class ");
        sb.append(this.getTargetClassName());
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_RENAME_ATTRIBUTE;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.movedAttribute.codeRange().setDescription("moved and renamed attribute declaration").setCodeElement(this.movedAttribute.toString()));
        return ranges;
    }
}

