/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.util.PrefixSuffixUtils;

public class MoveClassRefactoring
implements PackageLevelRefactoring {
    private UMLClass originalClass;
    private UMLClass movedClass;

    public MoveClassRefactoring(UMLClass originalClass, UMLClass movedClass) {
        this.originalClass = originalClass;
        this.movedClass = movedClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalClass.getName());
        sb.append(" moved to ");
        sb.append(this.movedClass.getName());
        return sb.toString();
    }

    @Override
    public RenamePattern getRenamePattern() {
        int separatorPos = PrefixSuffixUtils.separatorPosOfCommonSuffix('.', this.originalClass.getName(), this.movedClass.getName());
        if (separatorPos == -1) {
            return new RenamePattern(this.originalClass.getName(), this.movedClass.getName());
        }
        String originalPath = this.originalClass.getName().substring(0, this.originalClass.getName().length() - separatorPos);
        String movedPath = this.movedClass.getName().substring(0, this.movedClass.getName().length() - separatorPos);
        return new RenamePattern(originalPath, movedPath);
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_CLASS;
    }

    @Override
    public String getOriginalClassName() {
        return this.originalClass.getName();
    }

    @Override
    public String getMovedClassName() {
        return this.movedClass.getName();
    }

    @Override
    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    @Override
    public UMLClass getMovedClass() {
        return this.movedClass;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getMovedClass().getLocationInfo().getFilePath(), (Object)this.getMovedClass().getName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalClass.codeRange().setDescription("original type declaration").setCodeElement(this.originalClass.getName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.movedClass.codeRange().setDescription("moved type declaration").setCodeElement(this.movedClass.getName()));
        return ranges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.movedClass == null ? 0 : this.movedClass.hashCode());
        result = 31 * result + (this.originalClass == null ? 0 : this.originalClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveClassRefactoring other = (MoveClassRefactoring)obj;
        if (this.movedClass == null ? other.movedClass != null : !this.movedClass.equals(other.movedClass)) {
            return false;
        }
        return !(this.originalClass == null ? other.originalClass != null : !this.originalClass.equals(other.originalClass));
    }
}

