/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class MoveCodeRefactoring
implements Refactoring {
    private VariableDeclarationContainer sourceContainer;
    private VariableDeclarationContainer targetContainer;
    private UMLOperationBodyMapper bodyMapper;
    private Set<AbstractCodeFragment> movedCodeFragmentsFromSourceOperation;
    private Set<AbstractCodeFragment> movedCodeFragmentsToTargetOperation;

    public MoveCodeRefactoring(VariableDeclarationContainer sourceContainer, VariableDeclarationContainer targetContainer, UMLOperationBodyMapper mapper) {
        this.sourceContainer = sourceContainer;
        this.targetContainer = targetContainer;
        this.bodyMapper = mapper;
        this.movedCodeFragmentsFromSourceOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.movedCodeFragmentsToTargetOperation = new LinkedHashSet<AbstractCodeFragment>();
        for (AbstractCodeMapping mapping : mapper.getMappings()) {
            this.movedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.movedCodeFragmentsToTargetOperation.add(mapping.getFragment2());
        }
    }

    public void updateMapperInfo() {
        this.movedCodeFragmentsFromSourceOperation.clear();
        this.movedCodeFragmentsToTargetOperation.clear();
        for (AbstractCodeMapping mapping : this.bodyMapper.getMappings()) {
            this.movedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.movedCodeFragmentsToTargetOperation.add(mapping.getFragment2());
        }
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public VariableDeclarationContainer getSourceContainer() {
        return this.sourceContainer;
    }

    public VariableDeclarationContainer getTargetContainer() {
        return this.targetContainer;
    }

    public Set<AbstractCodeMapping> getMappings() {
        return this.bodyMapper.getMappings();
    }

    public Set<AbstractCodeFragment> getMovedCodeFragmentsFromSourceOperation() {
        return this.movedCodeFragmentsFromSourceOperation;
    }

    public Set<AbstractCodeFragment> getMovedCodeFragmentsToTargetOperation() {
        return this.movedCodeFragmentsToTargetOperation;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getSourceContainer().codeRange().setDescription("source method declaration").setCodeElement(this.getSourceContainer().toString()));
        for (AbstractCodeFragment extractedCodeFragment : this.movedCodeFragmentsFromSourceOperation) {
            ranges.add(extractedCodeFragment.codeRange().setDescription("moved code from source method declaration"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getTargetContainer().codeRange().setDescription("target method declaration").setCodeElement(this.getTargetContainer().toString()));
        for (AbstractCodeFragment extractedCodeFragment : this.movedCodeFragmentsToTargetOperation) {
            ranges.add(extractedCodeFragment.codeRange().setDescription("moved code to target method declaration"));
        }
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_CODE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSourceContainer().getLocationInfo().getFilePath(), (Object)this.getSourceContainer().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getTargetContainer().getLocationInfo().getFilePath(), (Object)this.getTargetContainer().getClassName()));
        return pairs;
    }

    public int hashCode() {
        return Objects.hash(this.movedCodeFragmentsFromSourceOperation, this.movedCodeFragmentsToTargetOperation, this.sourceContainer, this.targetContainer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveCodeRefactoring other = (MoveCodeRefactoring)obj;
        return Objects.equals(this.movedCodeFragmentsFromSourceOperation, other.movedCodeFragmentsFromSourceOperation) && Objects.equals(this.movedCodeFragmentsToTargetOperation, other.movedCodeFragmentsToTargetOperation) && Objects.equals(this.sourceContainer, other.sourceContainer) && Objects.equals(this.targetContainer, other.targetContainer);
    }

    private String getClassName() {
        String targetClassName;
        String sourceClassName = this.getSourceContainer().getClassName();
        return sourceClassName.equals(targetClassName = this.getTargetContainer().getClassName()) ? sourceClassName : targetClassName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append("from ");
        sb.append(this.sourceContainer);
        sb.append(" to ");
        sb.append(this.targetContainer);
        sb.append(" in class ");
        sb.append(this.getClassName());
        return sb.toString();
    }
}

