/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ParameterizeTestRefactoring
implements Refactoring {
    private UMLOperation removedOperation;
    private UMLOperation parameterizedTestOperation;
    private UMLOperationBodyMapper bodyMapper;

    public ParameterizeTestRefactoring(UMLOperationBodyMapper bodyMapper) {
        this.bodyMapper = bodyMapper;
        this.removedOperation = bodyMapper.getOperation1();
        this.parameterizedTestOperation = bodyMapper.getOperation2();
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getRemovedOperation() {
        return this.removedOperation;
    }

    public UMLOperation getParameterizedTestOperation() {
        return this.parameterizedTestOperation;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.removedOperation.codeRange().setDescription("removed method declaration").setCodeElement(this.removedOperation.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.parameterizedTestOperation.codeRange().setDescription("parameterized test method declaration").setCodeElement(this.parameterizedTestOperation.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.PARAMETERIZE_TEST;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getRemovedOperation().getLocationInfo().getFilePath(), (Object)this.getRemovedOperation().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getParameterizedTestOperation().getLocationInfo().getFilePath(), (Object)this.getParameterizedTestOperation().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.removedOperation);
        sb.append(" to ");
        sb.append(this.parameterizedTestOperation);
        sb.append(" in class ");
        sb.append(this.parameterizedTestOperation.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.parameterizedTestOperation, this.removedOperation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterizeTestRefactoring other = (ParameterizeTestRefactoring)obj;
        return Objects.equals(this.parameterizedTestOperation, other.parameterizedTestOperation) && Objects.equals(this.removedOperation, other.removedOperation);
    }
}

