/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLModifier;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class RemoveAttributeModifierRefactoring
implements Refactoring {
    private String modifier;
    private UMLAttribute attributeBefore;
    private UMLAttribute attributeAfter;

    public RemoveAttributeModifierRefactoring(String modifier, UMLAttribute attributeBefore, UMLAttribute attributeAfter) {
        this.modifier = modifier;
        this.attributeBefore = attributeBefore;
        this.attributeAfter = attributeAfter;
    }

    public UMLModifier getRemovedModifier() {
        for (UMLModifier m : this.attributeBefore.getVariableDeclaration().getModifiers()) {
            if (!m.getKeyword().equals(this.modifier)) continue;
            return m;
        }
        return null;
    }

    public String getModifier() {
        return this.modifier;
    }

    public UMLAttribute getAttributeBefore() {
        return this.attributeBefore;
    }

    public UMLAttribute getAttributeAfter() {
        return this.attributeAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.attributeBefore.codeRange().setDescription("original attribute declaration").setCodeElement(this.attributeBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.attributeAfter.codeRange().setDescription("attribute declaration with removed modifier").setCodeElement(this.attributeAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.REMOVE_ATTRIBUTE_MODIFIER;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getAttributeBefore().getLocationInfo().getFilePath(), (Object)this.getAttributeBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getAttributeAfter().getLocationInfo().getFilePath(), (Object)this.getAttributeAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.modifier);
        if (this.attributeBefore instanceof UMLEnumConstant) {
            sb.append(" in enum constant ");
        } else {
            sb.append(" in attribute ");
        }
        sb.append(this.attributeBefore);
        sb.append(" from class ");
        sb.append(this.attributeBefore.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modifier == null ? 0 : this.modifier.hashCode());
        result = 31 * result + (this.attributeAfter == null || this.attributeAfter.getVariableDeclaration() == null ? 0 : this.attributeAfter.getVariableDeclaration().hashCode());
        result = 31 * result + (this.attributeBefore == null || this.attributeBefore.getVariableDeclaration() == null ? 0 : this.attributeBefore.getVariableDeclaration().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveAttributeModifierRefactoring other = (RemoveAttributeModifierRefactoring)obj;
        if (this.modifier == null ? other.modifier != null : !this.modifier.equals(other.modifier)) {
            return false;
        }
        if (this.attributeBefore == null ? other.attributeBefore != null : (this.attributeBefore.getVariableDeclaration() == null ? other.attributeBefore.getVariableDeclaration() != null : !this.attributeBefore.getVariableDeclaration().equals(other.attributeBefore.getVariableDeclaration()))) {
            return false;
        }
        return !(this.attributeAfter == null ? other.attributeAfter != null : (this.attributeAfter.getVariableDeclaration() == null ? other.attributeAfter.getVariableDeclaration() != null : !this.attributeAfter.getVariableDeclaration().equals(other.attributeAfter.getVariableDeclaration())));
    }
}

