/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class RenamePackageRefactoring
implements Refactoring {
    private List<PackageLevelRefactoring> moveClassRefactorings = new ArrayList<PackageLevelRefactoring>();
    private RenamePattern pattern;

    public RenamePackageRefactoring(RenamePattern pattern) {
        this.pattern = pattern;
    }

    public RenamePackageRefactoring(PackageLevelRefactoring moveClassRefactoring) {
        this.moveClassRefactorings.add(moveClassRefactoring);
        this.pattern = moveClassRefactoring.getRenamePattern();
    }

    public void addMoveClassRefactoring(PackageLevelRefactoring moveClassRefactoring) {
        this.moveClassRefactorings.add(moveClassRefactoring);
    }

    public RenamePattern getPattern() {
        return this.pattern;
    }

    public List<PackageLevelRefactoring> getMoveClassRefactorings() {
        return this.moveClassRefactorings;
    }

    @Override
    public RefactoringType getRefactoringType() {
        String prefix2;
        String prefix1;
        String movedPath;
        String originalPath = this.pattern.getBefore().endsWith(".") ? this.pattern.getBefore().substring(0, this.pattern.getBefore().length() - 1) : this.pattern.getBefore();
        String string = movedPath = this.pattern.getAfter().endsWith(".") ? this.pattern.getAfter().substring(0, this.pattern.getAfter().length() - 1) : this.pattern.getAfter();
        if (originalPath.contains(".") && movedPath.contains(".") ? (prefix1 = originalPath.substring(0, originalPath.lastIndexOf("."))).equals(prefix2 = movedPath.substring(0, movedPath.lastIndexOf("."))) : !originalPath.contains(".") && !movedPath.contains(".")) {
            return RefactoringType.RENAME_PACKAGE;
        }
        return RefactoringType.MOVE_PACKAGE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        String originalPath = this.pattern.getBefore().endsWith(".") ? this.pattern.getBefore().substring(0, this.pattern.getBefore().length() - 1) : this.pattern.getBefore();
        sb.append(originalPath);
        sb.append(" to ");
        String movedPath = this.pattern.getAfter().endsWith(".") ? this.pattern.getAfter().substring(0, this.pattern.getAfter().length() - 1) : this.pattern.getAfter();
        sb.append(movedPath);
        return sb.toString();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (PackageLevelRefactoring ref : this.moveClassRefactorings) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getOriginalClass().getLocationInfo().getFilePath(), (Object)ref.getOriginalClassName()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (PackageLevelRefactoring ref : this.moveClassRefactorings) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getMovedClass().getLocationInfo().getFilePath(), (Object)ref.getMovedClassName()));
        }
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (PackageLevelRefactoring ref : this.moveClassRefactorings) {
            ranges.add(ref.getOriginalClass().codeRange().setDescription("original type declaration").setCodeElement(ref.getOriginalClass().getName()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (PackageLevelRefactoring ref : this.moveClassRefactorings) {
            ranges.add(ref.getMovedClass().codeRange().setDescription("moved type declaration").setCodeElement(ref.getMovedClass().getName()));
        }
        return ranges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenamePackageRefactoring other = (RenamePackageRefactoring)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }
}

