/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CandidateSplitVariableRefactoring;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class SplitAttributeRefactoring
implements Refactoring {
    private UMLAttribute oldAttribute;
    private Set<UMLAttribute> splitAttributes;
    private Set<CandidateSplitVariableRefactoring> attributeSplits;
    private String classNameBefore;
    private String classNameAfter;

    public SplitAttributeRefactoring(UMLAttribute oldAttribute, Set<UMLAttribute> splitAttributes, String classNameBefore, String classNameAfter, Set<CandidateSplitVariableRefactoring> attributeSplits) {
        this.oldAttribute = oldAttribute;
        this.splitAttributes = splitAttributes;
        this.classNameBefore = classNameBefore;
        this.classNameAfter = classNameAfter;
        this.attributeSplits = attributeSplits;
    }

    public UMLAttribute getOldAttribute() {
        return this.oldAttribute;
    }

    public Set<UMLAttribute> getSplitAttributes() {
        return this.splitAttributes;
    }

    public Set<CandidateSplitVariableRefactoring> getAttributeSplits() {
        return this.attributeSplits;
    }

    public String getClassNameBefore() {
        return this.classNameBefore;
    }

    public String getClassNameAfter() {
        return this.classNameAfter;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.SPLIT_ATTRIBUTE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.oldAttribute.getVariableDeclaration());
        sb.append(" to ");
        sb.append(this.getSplitVariables());
        sb.append(" in class ").append(this.classNameAfter);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classNameAfter == null ? 0 : this.classNameAfter.hashCode());
        result = 31 * result + (this.classNameBefore == null ? 0 : this.classNameBefore.hashCode());
        result = 31 * result + (this.oldAttribute == null || this.oldAttribute.getVariableDeclaration() == null ? 0 : this.oldAttribute.getVariableDeclaration().hashCode());
        Set<VariableDeclaration> splitVariables = this.getSplitVariables();
        result = 31 * result + (splitVariables.isEmpty() ? 0 : splitVariables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitAttributeRefactoring other = (SplitAttributeRefactoring)obj;
        if (this.classNameAfter == null ? other.classNameAfter != null : !this.classNameAfter.equals(other.classNameAfter)) {
            return false;
        }
        if (this.classNameBefore == null ? other.classNameBefore != null : !this.classNameBefore.equals(other.classNameBefore)) {
            return false;
        }
        if (this.oldAttribute == null ? other.oldAttribute != null : (this.oldAttribute.getVariableDeclaration() == null ? other.oldAttribute.getVariableDeclaration() != null : !this.oldAttribute.getVariableDeclaration().equals(other.oldAttribute.getVariableDeclaration()))) {
            return false;
        }
        if (this.splitAttributes == null && other.splitAttributes != null) {
            return false;
        }
        return this.getSplitVariables().equals(other.getSplitVariables());
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOldAttribute().getLocationInfo().getFilePath(), (Object)this.getClassNameBefore()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (UMLAttribute splitAttribute : this.splitAttributes) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)splitAttribute.getLocationInfo().getFilePath(), (Object)this.getClassNameAfter()));
        }
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.oldAttribute.getVariableDeclaration().codeRange().setDescription("original attribute declaration").setCodeElement(this.oldAttribute.getVariableDeclaration().toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclaration splitVariableDeclaration : this.getSplitVariables()) {
            ranges.add(splitVariableDeclaration.codeRange().setDescription("split attribute declaration").setCodeElement(splitVariableDeclaration.toString()));
        }
        return ranges;
    }

    public Set<VariableDeclaration> getSplitVariables() {
        return this.splitAttributes.stream().map(UMLAttribute::getVariableDeclaration).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

