/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import gr.uom.java.xmi.diff.UMLClassRenameDiff;
import gr.uom.java.xmi.diff.UMLClassSplitDiff;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.util.PrefixSuffixUtils;

public class SplitClassRefactoring
implements PackageLevelRefactoring {
    private Set<UMLClass> splitClasses = new LinkedHashSet<UMLClass>();
    private UMLClass originalClass;

    public SplitClassRefactoring(UMLClassSplitDiff mergeDiff) {
        for (UMLClassRenameDiff renameDiff : mergeDiff.getClassRenameDiffs()) {
            if (this.originalClass == null) {
                this.originalClass = renameDiff.getOriginalClass();
            }
            this.splitClasses.add(renameDiff.getRenamedClass());
        }
    }

    public Set<UMLClass> getSplitClasses() {
        return this.splitClasses;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.SPLIT_CLASS;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.originalClass.getLocationInfo().getFilePath(), (Object)this.originalClass.getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (UMLClass splitClass : this.splitClasses) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)splitClass.getLocationInfo().getFilePath(), (Object)splitClass.getName()));
        }
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalClass.codeRange().setDescription("original type declaration").setCodeElement(this.originalClass.getName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (UMLClass splitClass : this.splitClasses) {
            ranges.add(splitClass.codeRange().setDescription("split type declaration").setCodeElement(splitClass.getName()));
        }
        return ranges;
    }

    @Override
    public RenamePattern getRenamePattern() {
        UMLClass renamedClass = this.splitClasses.iterator().next();
        UMLClass originalClass = this.originalClass;
        int separatorPos = PrefixSuffixUtils.separatorPosOfCommonSuffix('.', originalClass.getPackageName(), renamedClass.getPackageName());
        if (separatorPos == -1) {
            return new RenamePattern(originalClass.getPackageName(), renamedClass.getPackageName());
        }
        String originalPath = originalClass.getName().substring(0, originalClass.getName().length() - separatorPos);
        String movedPath = renamedClass.getName().substring(0, renamedClass.getName().length() - separatorPos);
        return new RenamePattern(originalPath, movedPath);
    }

    @Override
    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    @Override
    public UMLClass getMovedClass() {
        return this.splitClasses.iterator().next();
    }

    @Override
    public String getOriginalClassName() {
        return this.originalClass.getName();
    }

    @Override
    public String getMovedClassName() {
        return this.splitClasses.iterator().next().getName();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalClass);
        sb.append(" split to ");
        sb.append(this.splitClasses);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.splitClasses == null ? 0 : this.splitClasses.hashCode());
        result = 31 * result + (this.originalClass == null ? 0 : this.originalClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitClassRefactoring other = (SplitClassRefactoring)obj;
        if (this.splitClasses == null ? other.splitClasses != null : !this.splitClasses.equals(other.splitClasses)) {
            return false;
        }
        return !(this.originalClass == null ? other.originalClass != null : !this.originalClass.equals(other.originalClass));
    }
}

