/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.LeafMappingProvider;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class SplitConditionalRefactoring
implements Refactoring,
LeafMappingProvider {
    private AbstractCodeFragment originalConditional;
    private Set<AbstractCodeFragment> splitConditionals;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private List<LeafMapping> subExpressionMappings;

    public SplitConditionalRefactoring(AbstractCodeFragment originalConditional, Set<AbstractCodeFragment> splitConditionals, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter) {
        this.originalConditional = originalConditional;
        this.splitConditionals = splitConditionals;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.subExpressionMappings = new ArrayList<LeafMapping>();
    }

    @Override
    public void addSubExpressionMapping(LeafMapping newLeafMapping) {
        boolean alreadyPresent = false;
        for (LeafMapping oldLeafMapping : this.subExpressionMappings) {
            if (!oldLeafMapping.getFragment1().getLocationInfo().equals(newLeafMapping.getFragment1().getLocationInfo()) || !oldLeafMapping.getFragment2().getLocationInfo().equals(newLeafMapping.getFragment2().getLocationInfo())) continue;
            alreadyPresent = true;
            break;
        }
        if (!alreadyPresent) {
            this.subExpressionMappings.add(newLeafMapping);
        }
    }

    public AbstractCodeFragment getOriginalConditional() {
        return this.originalConditional;
    }

    public Set<AbstractCodeFragment> getSplitConditionals() {
        return this.splitConditionals;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<LeafMapping> getSubExpressionMappings() {
        return this.subExpressionMappings;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalConditional.codeRange().setDescription("original conditional").setCodeElement(this.originalConditional.toString()));
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeFragment splitConditional : this.splitConditionals) {
            ranges.add(splitConditional.codeRange().setDescription("split conditional").setCodeElement(splitConditional.toString()));
        }
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with split conditional").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.SPLIT_CONDITIONAL;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        String conditionalString = this.originalConditional.getString();
        String oldConditional = conditionalString.contains("\n") ? conditionalString.substring(0, conditionalString.indexOf("\n")) : conditionalString;
        sb.append(oldConditional);
        sb.append(" to ");
        sb.append("[");
        int i = 0;
        for (AbstractCodeFragment splitConditional : this.splitConditionals) {
            conditionalString = splitConditional.getString();
            String newConditional = conditionalString.contains("\n") ? conditionalString.substring(0, conditionalString.indexOf("\n")) : conditionalString;
            sb.append(newConditional);
            if (i < this.splitConditionals.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.operationAfter, this.operationBefore, this.originalConditional, this.splitConditionals);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitConditionalRefactoring other = (SplitConditionalRefactoring)obj;
        return Objects.equals(this.operationAfter, other.operationAfter) && Objects.equals(this.operationBefore, other.operationBefore) && Objects.equals(this.originalConditional, other.originalConditional) && Objects.equals(this.splitConditionals, other.splitConditionals);
    }
}

