/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class SplitOperationRefactoring
implements Refactoring {
    private Set<VariableDeclarationContainer> splitMethods;
    private Set<UMLOperationBodyMapper> mappers;
    private VariableDeclarationContainer originalMethodBeforeSplit;
    private String classNameBefore;
    private String classNameAfter;

    public SplitOperationRefactoring(VariableDeclarationContainer originalMethodBeforeSplit, Set<VariableDeclarationContainer> splitMethods, String classNameBefore, String classNameAfter, Set<UMLOperationBodyMapper> mappers) {
        this.originalMethodBeforeSplit = originalMethodBeforeSplit;
        this.splitMethods = splitMethods;
        this.classNameBefore = classNameBefore;
        this.classNameAfter = classNameAfter;
        this.mappers = mappers;
    }

    public Set<VariableDeclarationContainer> getSplitMethods() {
        return this.splitMethods;
    }

    public Set<UMLOperationBodyMapper> getMappers() {
        return this.mappers;
    }

    public VariableDeclarationContainer getOriginalMethodBeforeSplit() {
        return this.originalMethodBeforeSplit;
    }

    public String getClassNameBefore() {
        return this.classNameBefore;
    }

    public String getClassNameAfter() {
        return this.classNameAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalMethodBeforeSplit.codeRange().setDescription("original method declaration").setCodeElement(this.originalMethodBeforeSplit.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclarationContainer splitMethod : this.getSplitMethods()) {
            ranges.add(splitMethod.codeRange().setDescription("split method declaration").setCodeElement(splitMethod.toString()));
        }
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.SPLIT_OPERATION;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalMethodBeforeSplit().getLocationInfo().getFilePath(), (Object)this.getClassNameBefore()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (VariableDeclarationContainer splitMethod : this.splitMethods) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)splitMethod.getLocationInfo().getFilePath(), (Object)this.getClassNameAfter()));
        }
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalMethodBeforeSplit);
        sb.append(" to ");
        sb.append(this.getSplitMethods());
        sb.append(" in class ").append(this.classNameAfter);
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.classNameAfter, this.classNameBefore, this.originalMethodBeforeSplit, this.splitMethods);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitOperationRefactoring other = (SplitOperationRefactoring)obj;
        return Objects.equals(this.classNameAfter, other.classNameAfter) && Objects.equals(this.classNameBefore, other.classNameBefore) && Objects.equals(this.originalMethodBeforeSplit, other.originalMethodBeforeSplit) && Objects.equals(this.splitMethods, other.splitMethods);
    }
}

