/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.RenamePackageRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class SplitPackageRefactoring
implements Refactoring {
    private String originalPackage;
    private Set<String> splitPackages;
    private Set<RenamePackageRefactoring> renamePackageRefactorings;

    public SplitPackageRefactoring(Set<RenamePackageRefactoring> renamePackageRefactorings) {
        this.renamePackageRefactorings = renamePackageRefactorings;
        this.splitPackages = new TreeSet<String>();
        for (RenamePackageRefactoring refactoring : renamePackageRefactorings) {
            RenamePattern pattern = refactoring.getPattern();
            if (this.originalPackage == null) {
                this.originalPackage = pattern.getBefore();
            }
            this.splitPackages.add(pattern.getAfter());
        }
    }

    public String getOriginalPackage() {
        return this.originalPackage;
    }

    public Set<String> getSplitPackages() {
        return this.splitPackages;
    }

    public Set<RenamePackageRefactoring> getRenamePackageRefactorings() {
        return this.renamePackageRefactorings;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                ranges.add(ref.getOriginalClass().codeRange().setDescription("original type declaration").setCodeElement(ref.getOriginalClass().getName()));
            }
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                ranges.add(ref.getMovedClass().codeRange().setDescription("moved type declaration").setCodeElement(ref.getMovedClass().getName()));
            }
        }
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.SPLIT_PACKAGE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getOriginalClass().getLocationInfo().getFilePath(), (Object)ref.getOriginalClassName()));
            }
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (RenamePackageRefactoring renamePackage : this.renamePackageRefactorings) {
            for (PackageLevelRefactoring ref : renamePackage.getMoveClassRefactorings()) {
                pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getMovedClass().getLocationInfo().getFilePath(), (Object)ref.getMovedClassName()));
            }
        }
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        String originalPath = this.originalPackage.endsWith(".") ? this.originalPackage.substring(0, this.originalPackage.length() - 1) : this.originalPackage;
        sb.append(originalPath);
        sb.append(" to ");
        LinkedHashSet<String> splitPaths = new LinkedHashSet<String>();
        for (String splitPackage : this.splitPackages) {
            String splitPath = splitPackage.endsWith(".") ? splitPackage.substring(0, splitPackage.length() - 1) : splitPackage;
            splitPaths.add(splitPath);
        }
        sb.append(splitPaths);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originalPackage == null ? 0 : this.originalPackage.hashCode());
        result = 31 * result + (this.splitPackages == null ? 0 : this.splitPackages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitPackageRefactoring other = (SplitPackageRefactoring)obj;
        if (this.originalPackage == null ? other.originalPackage != null : !this.originalPackage.equals(other.originalPackage)) {
            return false;
        }
        return !(this.splitPackages == null ? other.splitPackages != null : !this.splitPackages.equals(other.splitPackages));
    }
}

