/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class SplitVariableRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private Set<VariableDeclaration> splitVariables;
    private VariableDeclaration oldVariable;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private Set<AbstractCodeMapping> variableReferences;
    private boolean insideExtractedOrInlinedMethod;

    public SplitVariableRefactoring(VariableDeclaration oldVariable, Set<VariableDeclaration> splitVariables, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter, Set<AbstractCodeMapping> variableReferences, boolean insideExtractedOrInlinedMethod) {
        this.splitVariables = splitVariables;
        this.oldVariable = oldVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
    }

    public Set<VariableDeclaration> getSplitVariables() {
        return this.splitVariables;
    }

    public VariableDeclaration getOldVariable() {
        return this.oldVariable;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.variableReferences;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    private boolean allVariablesAreParameters() {
        for (VariableDeclaration declaration : this.splitVariables) {
            if (declaration.isParameter()) continue;
            return false;
        }
        return this.oldVariable.isParameter();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.allVariablesAreParameters()) {
            return RefactoringType.SPLIT_PARAMETER;
        }
        return RefactoringType.SPLIT_VARIABLE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.oldVariable);
        sb.append(" to ");
        sb.append(this.splitVariables);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oldVariable == null ? 0 : this.oldVariable.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.splitVariables == null ? 0 : this.splitVariables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitVariableRefactoring other = (SplitVariableRefactoring)obj;
        if (this.oldVariable == null ? other.oldVariable != null : !this.oldVariable.equals(other.oldVariable)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        return !(this.splitVariables == null ? other.splitVariables != null : !this.splitVariables.equals(other.splitVariables));
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.oldVariable.codeRange().setDescription("original variable declaration").setCodeElement(this.oldVariable.toString()));
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclaration splitVariable : this.splitVariables) {
            ranges.add(splitVariable.codeRange().setDescription("split variable declaration").setCodeElement(splitVariable.toString()));
        }
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with split variable").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }
}

