/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.ConsistentReplacementDetector;
import gr.uom.java.xmi.decomposition.replacement.MergeVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.SplitVariableReplacement;
import gr.uom.java.xmi.diff.CandidateAttributeRefactoring;
import gr.uom.java.xmi.diff.CandidateMergeMethodRefactoring;
import gr.uom.java.xmi.diff.CandidateMergeVariableRefactoring;
import gr.uom.java.xmi.diff.CandidateSplitMethodRefactoring;
import gr.uom.java.xmi.diff.CandidateSplitVariableRefactoring;
import gr.uom.java.xmi.diff.ChangeTypeDeclarationKindRefactoring;
import gr.uom.java.xmi.diff.ChangeVariableTypeRefactoring;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.MergeAttributeRefactoring;
import gr.uom.java.xmi.diff.MergeVariableRefactoring;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import gr.uom.java.xmi.diff.RenameVariableRefactoring;
import gr.uom.java.xmi.diff.SplitAttributeRefactoring;
import gr.uom.java.xmi.diff.SplitVariableRefactoring;
import gr.uom.java.xmi.diff.UMLAttributeDiff;
import gr.uom.java.xmi.diff.UMLClassBaseDiff;
import gr.uom.java.xmi.diff.UMLEnumConstantDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;
import org.refactoringminer.util.PrefixSuffixUtils;

public abstract class UMLAbstractClassDiff {
    protected List<UMLOperation> addedOperations;
    protected List<UMLOperation> removedOperations;
    protected List<UMLAttribute> addedAttributes;
    protected List<UMLAttribute> removedAttributes;
    protected List<UMLOperationBodyMapper> operationBodyMapperList;
    protected List<UMLAttributeDiff> attributeDiffList;
    protected List<UMLEnumConstantDiff> enumConstantDiffList;
    protected Set<Pair<UMLAttribute, UMLAttribute>> commonAtrributes;
    protected Set<Pair<UMLEnumConstant, UMLEnumConstant>> commonEnumConstants;
    protected UMLAbstractClass originalClass;
    protected UMLAbstractClass nextClass;
    protected List<UMLEnumConstant> addedEnumConstants;
    protected List<UMLEnumConstant> removedEnumConstants;
    protected List<UMLAnonymousClass> addedAnonymousClasses;
    protected List<UMLAnonymousClass> removedAnonymousClasses;
    protected Set<CandidateMergeMethodRefactoring> candidateMethodMerges = new LinkedHashSet<CandidateMergeMethodRefactoring>();
    protected Set<CandidateSplitMethodRefactoring> candidateMethodSplits = new LinkedHashSet<CandidateSplitMethodRefactoring>();
    private Set<CandidateAttributeRefactoring> candidateAttributeRenames = new LinkedHashSet<CandidateAttributeRefactoring>();
    private Set<CandidateMergeVariableRefactoring> candidateAttributeMerges = new LinkedHashSet<CandidateMergeVariableRefactoring>();
    private Set<CandidateSplitVariableRefactoring> candidateAttributeSplits = new LinkedHashSet<CandidateSplitVariableRefactoring>();
    private Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap = new LinkedHashMap<Replacement, Set<CandidateAttributeRefactoring>>();
    private Map<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>> mergeMap = new LinkedHashMap<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>>();
    private Map<SplitVariableReplacement, Set<CandidateSplitVariableRefactoring>> splitMap = new LinkedHashMap<SplitVariableReplacement, Set<CandidateSplitVariableRefactoring>>();
    protected List<Refactoring> refactorings;
    protected UMLModelDiff modelDiff;
    private static final List<String> collectionAPINames = List.of("get", "add", "contains", "put", "putAll", "addAll", "equals");

    public UMLAbstractClassDiff(UMLAbstractClass originalClass, UMLAbstractClass nextClass, UMLModelDiff modelDiff) {
        this.addedOperations = new ArrayList<UMLOperation>();
        this.removedOperations = new ArrayList<UMLOperation>();
        this.addedAttributes = new ArrayList<UMLAttribute>();
        this.removedAttributes = new ArrayList<UMLAttribute>();
        this.addedEnumConstants = new ArrayList<UMLEnumConstant>();
        this.removedEnumConstants = new ArrayList<UMLEnumConstant>();
        this.addedAnonymousClasses = new ArrayList<UMLAnonymousClass>();
        this.removedAnonymousClasses = new ArrayList<UMLAnonymousClass>();
        this.operationBodyMapperList = new ArrayList<UMLOperationBodyMapper>();
        this.attributeDiffList = new ArrayList<UMLAttributeDiff>();
        this.enumConstantDiffList = new ArrayList<UMLEnumConstantDiff>();
        this.commonAtrributes = new LinkedHashSet<Pair<UMLAttribute, UMLAttribute>>();
        this.commonEnumConstants = new LinkedHashSet<Pair<UMLEnumConstant, UMLEnumConstant>>();
        this.refactorings = new ArrayList<Refactoring>();
        this.originalClass = originalClass;
        this.nextClass = nextClass;
        this.modelDiff = modelDiff;
    }

    public List<UMLOperation> getAddedOperations() {
        return this.addedOperations;
    }

    public List<UMLOperation> getRemovedOperations() {
        return this.removedOperations;
    }

    public List<UMLAttribute> getAddedAttributes() {
        return this.addedAttributes;
    }

    public List<UMLAttribute> getRemovedAttributes() {
        return this.removedAttributes;
    }

    public List<UMLAnonymousClass> getAddedAnonymousClasses() {
        return this.addedAnonymousClasses;
    }

    public List<UMLAnonymousClass> getRemovedAnonymousClasses() {
        return this.removedAnonymousClasses;
    }

    public List<UMLOperationBodyMapper> getOperationBodyMapperList() {
        return this.operationBodyMapperList;
    }

    public List<UMLAttributeDiff> getAttributeDiffList() {
        return this.attributeDiffList;
    }

    public Set<Pair<UMLAttribute, UMLAttribute>> getCommonAtrributes() {
        return this.commonAtrributes;
    }

    public List<UMLEnumConstantDiff> getEnumConstantDiffList() {
        return this.enumConstantDiffList;
    }

    public Set<Pair<UMLEnumConstant, UMLEnumConstant>> getCommonEnumConstants() {
        return this.commonEnumConstants;
    }

    public void reportAddedAnonymousClass(UMLAnonymousClass umlClass) {
        this.addedAnonymousClasses.add(umlClass);
    }

    public void reportRemovedAnonymousClass(UMLAnonymousClass umlClass) {
        this.removedAnonymousClasses.add(umlClass);
    }

    public void addOperationBodyMapper(UMLOperationBodyMapper operationBodyMapper) {
        this.operationBodyMapperList.add(operationBodyMapper);
    }

    public UMLModelDiff getModelDiff() {
        return this.modelDiff;
    }

    protected boolean mapperListContainsOperation(UMLOperation operation1, UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (!mapper.getContainer1().equals(operation1) && !mapper.getContainer2().equals(operation2)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsMapperForOperation1(UMLOperation operation) {
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            if (!mapper.getContainer1().equals(operation)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsMapperForOperation2(UMLOperation operation) {
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            if (!mapper.getContainer2().equals(operation)) continue;
            return true;
        }
        return false;
    }

    public UMLOperation matchesOperation(AbstractCall invocation, List<UMLOperation> operations, VariableDeclarationContainer callerOperation) {
        for (UMLOperation operation : operations) {
            if (!invocation.matchesOperation(operation, callerOperation, this, this.modelDiff)) continue;
            return operation;
        }
        return null;
    }

    public Set<Replacement> getReplacementsOfType(Replacement.ReplacementType type) {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            replacements.addAll(mapper.getReplacementsOfType(type));
        }
        for (UMLAttributeDiff diff : this.getAttributeDiffList()) {
            if (!diff.getInitializerMapper().isPresent()) continue;
            UMLOperationBodyMapper initializerMapper = diff.getInitializerMapper().get();
            replacements.addAll(initializerMapper.getReplacementsOfType(type));
        }
        return replacements;
    }

    public abstract void process() throws RefactoringMinerTimedOutException;

    protected abstract void checkForAttributeChanges() throws RefactoringMinerTimedOutException;

    protected abstract void createBodyMappers() throws RefactoringMinerTimedOutException;

    protected boolean isPartOfMethodMovedToAddedMethod(VariableDeclarationContainer removedOperation, VariableDeclarationContainer addedOperation, UMLOperationBodyMapper operationBodyMapper) {
        if (this.removedOperations.size() != this.addedOperations.size()) {
            if (removedOperation.hasTestAnnotation() && addedOperation.hasTestAnnotation() && addedOperation.getName().contains(removedOperation.getName())) {
                List<AbstractCall> removedOperationInvocations = removedOperation.getAllOperationInvocations();
                List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
                LinkedHashSet<AbstractCall> movedInvocations = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
                movedInvocations.removeAll(addedOperationInvocations);
                if (movedInvocations.size() > 0) {
                    for (UMLOperation insertedOperation : this.addedOperations) {
                        boolean bl;
                        if (insertedOperation.equals(addedOperation)) continue;
                        LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(movedInvocations);
                        intersection.retainAll(insertedOperation.getAllOperationInvocations());
                        Iterator operationInvocationIterator = intersection.iterator();
                        while (operationInvocationIterator.hasNext()) {
                            boolean collectionGet;
                            AbstractCall invocation = (AbstractCall)operationInvocationIterator.next();
                            boolean bl2 = invocation.getName().equals("get") && invocation.arguments().size() == 0;
                            boolean bl3 = collectionGet = invocation.getName().startsWith("get") && invocation.arguments().size() == 1;
                            if (bl2 || !collectionAPINames.contains(invocation.getName()) && !collectionGet) continue;
                            operationInvocationIterator.remove();
                        }
                        ArrayList<AbstractCall> unmatchedCalls = new ArrayList<AbstractCall>(movedInvocations);
                        unmatchedCalls.removeAll(insertedOperation.getAllOperationInvocations());
                        if (!movedInvocations.containsAll(intersection) || intersection.size() <= 0 || intersection.size() < unmatchedCalls.size()) continue;
                        for (CompositeStatementObject compositeStatementObject : operationBodyMapper.getNonMappedInnerNodesT1()) {
                            unmatchedCalls.removeAll(compositeStatementObject.getMethodInvocations());
                        }
                        for (AbstractCodeFragment abstractCodeFragment : operationBodyMapper.getNonMappedLeavesT1()) {
                            unmatchedCalls.removeAll(abstractCodeFragment.getMethodInvocations());
                        }
                        if (!unmatchedCalls.isEmpty()) continue;
                        CandidateSplitMethodRefactoring newCandidate = new CandidateSplitMethodRefactoring();
                        newCandidate.addSplitMethod(addedOperation);
                        newCandidate.addSplitMethod(insertedOperation);
                        newCandidate.setOriginalMethodBeforeSplit(removedOperation);
                        boolean bl4 = false;
                        for (CandidateSplitMethodRefactoring oldCandidate : this.candidateMethodSplits) {
                            if (!newCandidate.equals(oldCandidate)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this.candidateMethodSplits.add(newCandidate);
                        }
                        return true;
                    }
                }
            }
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                List<AbstractCall> invocationsCalledInOperation1 = mapper.getContainer1().getAllOperationInvocations();
                List<AbstractCall> invocationsCalledInOperation2 = mapper.getContainer2().getAllOperationInvocations();
                LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation1 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation1);
                LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation2 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation2);
                invocationsCalledOnlyInOperation1.removeAll(invocationsCalledInOperation2);
                invocationsCalledOnlyInOperation2.removeAll(invocationsCalledInOperation1);
                boolean removedOperationCalledInContainer1 = false;
                for (AbstractCall abstractCall : invocationsCalledOnlyInOperation1) {
                    if (!abstractCall.matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff)) continue;
                    removedOperationCalledInContainer1 = true;
                    break;
                }
                boolean addedOperationCalledInContainer2 = false;
                for (AbstractCall invocation3 : invocationsCalledOnlyInOperation2) {
                    if (!invocation3.matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff)) continue;
                    addedOperationCalledInContainer2 = true;
                    break;
                }
                if (!removedOperationCalledInContainer1 || !addedOperationCalledInContainer2) continue;
                List<AbstractCall> list = removedOperation.getAllOperationInvocations();
                List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
                LinkedHashSet<AbstractCall> movedInvocations = new LinkedHashSet<AbstractCall>(list);
                movedInvocations.removeAll(addedOperationInvocations);
                if (movedInvocations.size() <= 1) continue;
                for (UMLOperation insertedOperation : this.addedOperations) {
                    if (insertedOperation.equals(addedOperation)) continue;
                    LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(movedInvocations);
                    intersection.retainAll(insertedOperation.getAllOperationInvocations());
                    Iterator operationInvocationIterator = intersection.iterator();
                    while (operationInvocationIterator.hasNext()) {
                        boolean collectionGet;
                        AbstractCall invocation4 = (AbstractCall)operationInvocationIterator.next();
                        boolean lambdaGet = invocation4.getName().equals("get") && invocation4.arguments().size() == 0;
                        boolean bl = collectionGet = invocation4.getName().startsWith("get") && invocation4.arguments().size() == 1;
                        if (lambdaGet || !collectionAPINames.contains(invocation4.getName()) && !collectionGet) continue;
                        operationInvocationIterator.remove();
                    }
                    ArrayList<AbstractCall> unmatchedCalls = new ArrayList<AbstractCall>(movedInvocations);
                    unmatchedCalls.removeAll(insertedOperation.getAllOperationInvocations());
                    if (!movedInvocations.containsAll(intersection) || intersection.size() <= 1 || intersection.size() < unmatchedCalls.size()) continue;
                    for (CompositeStatementObject composite : operationBodyMapper.getNonMappedInnerNodesT1()) {
                        unmatchedCalls.removeAll(composite.getMethodInvocations());
                    }
                    for (AbstractCodeFragment fragment : operationBodyMapper.getNonMappedLeavesT1()) {
                        unmatchedCalls.removeAll(fragment.getMethodInvocations());
                    }
                    boolean callsInsertedOperation = false;
                    for (AbstractCodeFragment fragment : operationBodyMapper.getNonMappedLeavesT2()) {
                        for (AbstractCall call : fragment.getMethodInvocations()) {
                            if (!call.matchesOperation(insertedOperation, operationBodyMapper.getContainer2(), this, this.modelDiff)) continue;
                            callsInsertedOperation = true;
                            break;
                        }
                        if (!callsInsertedOperation) continue;
                        break;
                    }
                    if (!callsInsertedOperation) {
                        for (CompositeStatementObject composite : operationBodyMapper.getNonMappedInnerNodesT2()) {
                            for (AbstractCall call : composite.getMethodInvocations()) {
                                if (!call.matchesOperation(insertedOperation, operationBodyMapper.getContainer2(), this, this.modelDiff)) continue;
                                callsInsertedOperation = true;
                                break;
                            }
                            if (!callsInsertedOperation) continue;
                            break;
                        }
                    }
                    if (!unmatchedCalls.isEmpty() || callsInsertedOperation) continue;
                    CandidateSplitMethodRefactoring newCandidate = new CandidateSplitMethodRefactoring();
                    newCandidate.addSplitMethod(addedOperation);
                    newCandidate.addSplitMethod(insertedOperation);
                    newCandidate.setOriginalMethodBeforeSplit(removedOperation);
                    boolean alreadyInCandidates = false;
                    for (CandidateSplitMethodRefactoring oldCandidate : this.candidateMethodSplits) {
                        if (!newCandidate.equals(oldCandidate)) continue;
                        alreadyInCandidates = true;
                        break;
                    }
                    if (!alreadyInCandidates) {
                        this.candidateMethodSplits.add(newCandidate);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isPartOfMethodMovedFromDeletedMethod(VariableDeclarationContainer removedOperation, VariableDeclarationContainer addedOperation, UMLOperationBodyMapper operationBodyMapper) {
        if (this.removedOperations.size() != this.addedOperations.size()) {
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                List<AbstractCall> invocationsCalledInOperation1 = mapper.getContainer1().getAllOperationInvocations();
                List<AbstractCall> invocationsCalledInOperation2 = mapper.getContainer2().getAllOperationInvocations();
                LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation1 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation1);
                LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation2 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation2);
                invocationsCalledOnlyInOperation1.removeAll(invocationsCalledInOperation2);
                invocationsCalledOnlyInOperation2.removeAll(invocationsCalledInOperation1);
                boolean removedOperationCalledInContainer1 = false;
                for (AbstractCall abstractCall : invocationsCalledOnlyInOperation1) {
                    if (!abstractCall.matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff)) continue;
                    removedOperationCalledInContainer1 = true;
                    break;
                }
                boolean addedOperationCalledInContainer2 = false;
                for (AbstractCall invocation3 : invocationsCalledOnlyInOperation2) {
                    if (!invocation3.matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff)) continue;
                    addedOperationCalledInContainer2 = true;
                    break;
                }
                if (!removedOperationCalledInContainer1 || !addedOperationCalledInContainer2) continue;
                List<AbstractCall> list = removedOperation.getAllOperationInvocations();
                List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
                LinkedHashSet<AbstractCall> movedInvocations = new LinkedHashSet<AbstractCall>(addedOperationInvocations);
                boolean identicalOperationInvocations = list.equals(addedOperationInvocations);
                if (!identicalOperationInvocations) {
                    movedInvocations.removeAll(list);
                }
                if (movedInvocations.size() <= 1) continue;
                for (UMLOperation deletedOperation : this.removedOperations) {
                    if (deletedOperation.equals(removedOperation)) continue;
                    LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(movedInvocations);
                    intersection.retainAll(deletedOperation.getAllOperationInvocations());
                    Iterator operationInvocationIterator = intersection.iterator();
                    while (operationInvocationIterator.hasNext()) {
                        boolean collectionGet;
                        AbstractCall invocation4 = (AbstractCall)operationInvocationIterator.next();
                        boolean lambdaGet = invocation4.getName().equals("get") && invocation4.arguments().size() == 0;
                        boolean bl = collectionGet = invocation4.getName().startsWith("get") && invocation4.arguments().size() == 1;
                        if (lambdaGet || !collectionAPINames.contains(invocation4.getName()) && !collectionGet) continue;
                        operationInvocationIterator.remove();
                    }
                    ArrayList<AbstractCall> unmatchedCalls = new ArrayList<AbstractCall>(movedInvocations);
                    unmatchedCalls.removeAll(deletedOperation.getAllOperationInvocations());
                    if (!movedInvocations.containsAll(intersection) || intersection.size() <= 1 || intersection.size() < unmatchedCalls.size()) continue;
                    for (CompositeStatementObject composite : operationBodyMapper.getNonMappedInnerNodesT2()) {
                        unmatchedCalls.removeAll(composite.getMethodInvocations());
                    }
                    for (AbstractCodeFragment fragment : operationBodyMapper.getNonMappedLeavesT2()) {
                        unmatchedCalls.removeAll(fragment.getMethodInvocations());
                    }
                    boolean callsDeletedOperation = false;
                    for (AbstractCodeFragment fragment : operationBodyMapper.getNonMappedLeavesT1()) {
                        for (AbstractCall call : fragment.getMethodInvocations()) {
                            if (!call.matchesOperation(deletedOperation, operationBodyMapper.getContainer1(), this, this.modelDiff)) continue;
                            callsDeletedOperation = true;
                            break;
                        }
                        if (!callsDeletedOperation) continue;
                        break;
                    }
                    if (!callsDeletedOperation) {
                        for (CompositeStatementObject composite : operationBodyMapper.getNonMappedInnerNodesT1()) {
                            for (AbstractCall call : composite.getMethodInvocations()) {
                                if (!call.matchesOperation(deletedOperation, operationBodyMapper.getContainer1(), this, this.modelDiff)) continue;
                                callsDeletedOperation = true;
                                break;
                            }
                            if (!callsDeletedOperation) continue;
                            break;
                        }
                    }
                    if (!unmatchedCalls.isEmpty() || callsDeletedOperation) continue;
                    boolean addedOperationHasAdditionalParameters = false;
                    if (identicalOperationInvocations) {
                        List<UMLType> addedOperationParameterTypes = addedOperation.getParameterTypeList();
                        List<UMLType> removedOperationParameterTypes = removedOperation.getParameterTypeList();
                        List<UMLType> deletedOperationParameterTypes = deletedOperation.getParameterTypeList();
                        if (addedOperationParameterTypes.containsAll(removedOperationParameterTypes) && addedOperationParameterTypes.containsAll(deletedOperationParameterTypes) && addedOperationParameterTypes.size() > removedOperationParameterTypes.size() && addedOperationParameterTypes.size() > deletedOperationParameterTypes.size()) {
                            addedOperationHasAdditionalParameters = true;
                        }
                    }
                    if (identicalOperationInvocations && !addedOperationHasAdditionalParameters) continue;
                    CandidateMergeMethodRefactoring newCandidate = new CandidateMergeMethodRefactoring();
                    newCandidate.addMergedMethod(removedOperation);
                    newCandidate.addMergedMethod(deletedOperation);
                    newCandidate.setNewMethodAfterMerge(addedOperation);
                    boolean alreadyInCandidates = false;
                    for (CandidateMergeMethodRefactoring oldCandidate : this.candidateMethodMerges) {
                        if (!newCandidate.equals(oldCandidate)) continue;
                        alreadyInCandidates = true;
                        break;
                    }
                    if (!alreadyInCandidates) {
                        this.candidateMethodMerges.add(newCandidate);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isPartOfMethodMovedFromExistingMethod(VariableDeclarationContainer removedOperation, VariableDeclarationContainer addedOperation) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            List<AbstractCall> invocationsCalledInOperation1 = mapper.getContainer1().getAllOperationInvocations();
            List<AbstractCall> invocationsCalledInOperation2 = mapper.getContainer2().getAllOperationInvocations();
            LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation1 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation1);
            LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation2 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation2);
            invocationsCalledOnlyInOperation1.removeAll(invocationsCalledInOperation2);
            invocationsCalledOnlyInOperation2.removeAll(invocationsCalledInOperation1);
            for (AbstractCall invocation : invocationsCalledOnlyInOperation2) {
                if (!invocation.matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff)) continue;
                List<AbstractCall> removedOperationInvocations = removedOperation.getAllOperationInvocations();
                List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
                LinkedHashSet<AbstractCall> movedInvocations = new LinkedHashSet<AbstractCall>(addedOperationInvocations);
                movedInvocations.removeAll(removedOperationInvocations);
                movedInvocations.retainAll(invocationsCalledOnlyInOperation1);
                LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(addedOperationInvocations);
                intersection.retainAll(removedOperationInvocations);
                int chainedCalls = 0;
                AbstractCall previous = null;
                for (AbstractCall inv : intersection) {
                    if (previous != null && previous.getExpression() != null && previous.getExpression().equals(inv.actualString())) {
                        ++chainedCalls;
                    }
                    previous = inv;
                }
                if (movedInvocations.size() <= 1 || intersection.size() - chainedCalls <= 1) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isPartOfMethodMovedToExistingMethod(VariableDeclarationContainer removedOperation, VariableDeclarationContainer addedOperation) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            List<AbstractCall> invocationsCalledInOperation1 = mapper.getContainer1().getAllOperationInvocations();
            List<AbstractCall> invocationsCalledInOperation2 = mapper.getContainer2().getAllOperationInvocations();
            LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation1 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation1);
            LinkedHashSet<AbstractCall> invocationsCalledOnlyInOperation2 = new LinkedHashSet<AbstractCall>(invocationsCalledInOperation2);
            invocationsCalledOnlyInOperation1.removeAll(invocationsCalledInOperation2);
            invocationsCalledOnlyInOperation2.removeAll(invocationsCalledInOperation1);
            for (AbstractCall invocation : invocationsCalledOnlyInOperation1) {
                if (!invocation.matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff)) continue;
                List<AbstractCall> removedOperationInvocations = removedOperation.getAllOperationInvocations();
                List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
                LinkedHashSet<AbstractCall> movedInvocations = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
                movedInvocations.removeAll(addedOperationInvocations);
                movedInvocations.retainAll(invocationsCalledOnlyInOperation2);
                LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
                intersection.retainAll(addedOperationInvocations);
                int chainedCalls = 0;
                AbstractCall previous = null;
                for (AbstractCall inv : intersection) {
                    if (previous != null && previous.getExpression() != null && previous.getExpression().equals(inv.actualString())) {
                        ++chainedCalls;
                    }
                    previous = inv;
                }
                int renamedCalls = 0;
                block3: for (AbstractCall inv : addedOperationInvocations) {
                    if (intersection.contains(inv)) continue;
                    for (Refactoring ref : this.refactorings) {
                        RenameOperationRefactoring rename;
                        if (!(ref instanceof RenameOperationRefactoring) || !inv.matchesOperation((rename = (RenameOperationRefactoring)ref).getRenamedOperation(), addedOperation, this, this.modelDiff)) continue;
                        ++renamedCalls;
                        continue block3;
                    }
                }
                if (movedInvocations.size() <= 1 || intersection.size() + renamedCalls - chainedCalls <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartOfMethodExtracted(VariableDeclarationContainer removedOperation, VariableDeclarationContainer addedOperation) {
        List<AbstractCall> removedOperationInvocations = removedOperation.getAllOperationInvocations();
        List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
        intersection.retainAll(addedOperationInvocations);
        int numberOfInvocationsMissingFromRemovedOperation = new LinkedHashSet<AbstractCall>(removedOperationInvocations).size() - intersection.size();
        Set<String> removedOperationVariableDeclarationNames = this.getVariableDeclarationNamesInMethodBody(removedOperation);
        Set<String> addedOperationVariableDeclarationNames = this.getVariableDeclarationNamesInMethodBody(addedOperation);
        LinkedHashSet<String> variableDeclarationIntersection = new LinkedHashSet<String>(removedOperationVariableDeclarationNames);
        variableDeclarationIntersection.retainAll(addedOperationVariableDeclarationNames);
        int numberOfVariableDeclarationsMissingFromRemovedOperation = removedOperationVariableDeclarationNames.size() - variableDeclarationIntersection.size();
        LinkedHashSet<AbstractCall> operationInvocationsInMethodsCalledByAddedOperation = new LinkedHashSet<AbstractCall>();
        LinkedHashSet<String> variableDeclarationsInMethodsCalledByAddedOperation = new LinkedHashSet<String>();
        LinkedHashSet<AbstractCall> matchedOperationInvocations = new LinkedHashSet<AbstractCall>();
        for (AbstractCall addedOperationInvocation : addedOperationInvocations) {
            if (intersection.contains(addedOperationInvocation)) continue;
            for (UMLOperation operation : this.addedOperations) {
                if (operation.equals(addedOperation) || operation.getBody() == null || !addedOperationInvocation.matchesOperation(operation, addedOperation, this, this.modelDiff)) continue;
                operationInvocationsInMethodsCalledByAddedOperation.addAll(operation.getAllOperationInvocations());
                variableDeclarationsInMethodsCalledByAddedOperation.addAll(this.getVariableDeclarationNamesInMethodBody(operation));
                matchedOperationInvocations.add(addedOperationInvocation);
            }
        }
        if (this.modelDiff != null) {
            for (AbstractCall addedOperationInvocation : addedOperationInvocations) {
                UMLOperation operation;
                String expression = addedOperationInvocation.getExpression();
                if (expression == null || expression.equals("this") || intersection.contains(addedOperationInvocation) || matchedOperationInvocations.contains(addedOperationInvocation) || (operation = this.modelDiff.findOperationInAddedClasses(addedOperationInvocation, addedOperation, this)) == null) continue;
                operationInvocationsInMethodsCalledByAddedOperation.addAll(operation.getAllOperationInvocations());
                variableDeclarationsInMethodsCalledByAddedOperation.addAll(this.getVariableDeclarationNamesInMethodBody(operation));
            }
        }
        LinkedHashSet<AbstractCall> newIntersection = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
        newIntersection.retainAll(operationInvocationsInMethodsCalledByAddedOperation);
        LinkedHashSet<String> newVariableDeclarationIntersection = new LinkedHashSet<String>(removedOperationVariableDeclarationNames);
        newVariableDeclarationIntersection.retainAll(variableDeclarationsInMethodsCalledByAddedOperation);
        LinkedHashSet<AbstractCall> removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(intersection);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(newIntersection);
        Iterator operationInvocationIterator = removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.iterator();
        while (operationInvocationIterator.hasNext()) {
            AbstractCall invocation = (AbstractCall)operationInvocationIterator.next();
            if (!invocation.getName().startsWith("get") && !invocation.getName().equals("add") && !invocation.getName().equals("contains")) continue;
            operationInvocationIterator.remove();
        }
        int numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations = newIntersection.size();
        int numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations = numberOfInvocationsMissingFromRemovedOperation - numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations;
        int numberOfVariableDeclarationsInRemovedOperationFoundInOtherAddedOperations = newVariableDeclarationIntersection.size();
        int numberOfVariableDeclarationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations = numberOfVariableDeclarationsMissingFromRemovedOperation - numberOfVariableDeclarationsInRemovedOperationFoundInOtherAddedOperations;
        return numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations || numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.size() || numberOfVariableDeclarationsInRemovedOperationFoundInOtherAddedOperations > numberOfVariableDeclarationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations;
    }

    public String getOriginalClassName() {
        return this.originalClass.getName();
    }

    public String getNextClassName() {
        return this.nextClass.getName();
    }

    public UMLAbstractClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLAbstractClass getNextClass() {
        return this.nextClass;
    }

    public Set<CandidateAttributeRefactoring> getCandidateAttributeRenames() {
        return this.candidateAttributeRenames;
    }

    public Set<CandidateMergeVariableRefactoring> getCandidateAttributeMerges() {
        return this.candidateAttributeMerges;
    }

    public Set<CandidateSplitVariableRefactoring> getCandidateAttributeSplits() {
        return this.candidateAttributeSplits;
    }

    public List<Refactoring> getRefactorings() throws RefactoringMinerTimedOutException {
        Refactoring ref;
        Set<ReferenceBasedRefactoring> set;
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>(this.refactorings);
        if (!this.originalClass.getTypeDeclarationKind().equals(this.nextClass.getTypeDeclarationKind())) {
            boolean anonymousToClass;
            boolean bl = anonymousToClass = this.originalClass.getTypeDeclarationKind().endsWith("class") && this.nextClass.getTypeDeclarationKind().endsWith("class");
            if (!anonymousToClass) {
                ChangeTypeDeclarationKindRefactoring ref2 = new ChangeTypeDeclarationKindRefactoring(this.originalClass.getTypeDeclarationKind(), this.nextClass.getTypeDeclarationKind(), this.originalClass, this.nextClass);
                refactorings.add(ref2);
            }
        }
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            this.processMapperRefactorings(mapper, refactorings);
        }
        refactorings.addAll(this.inferAttributeMergesAndSplits(this.renameMap, refactorings));
        block1: for (MergeVariableReplacement merge : this.mergeMap.keySet()) {
            LinkedHashSet<UMLAttribute> mergedAttributes = new LinkedHashSet<UMLAttribute>();
            LinkedHashSet<VariableDeclaration> mergedVariables = new LinkedHashSet<VariableDeclaration>();
            for (String mergedVariable : merge.getMergedVariables()) {
                UMLAttribute a1 = this.findAttributeInOriginalClass(mergedVariable);
                if (a1 == null) continue;
                mergedAttributes.add(a1);
                mergedVariables.add(a1.getVariableDeclaration());
            }
            UMLAttribute a2 = this.findAttributeInNextClass(merge.getAfter());
            set = this.mergeMap.get(merge);
            for (ReferenceBasedRefactoring candidate : set) {
                if (mergedVariables.size() > 1 && mergedVariables.size() == merge.getMergedVariables().size() && a2 != null) {
                    ref = new MergeAttributeRefactoring(mergedAttributes, a2, this.getOriginalClassName(), this.getNextClassName(), set);
                    if (refactorings.contains(ref)) continue;
                    refactorings.add(ref);
                    continue block1;
                }
                ((CandidateMergeVariableRefactoring)candidate).setMergedAttributes(mergedAttributes);
                ((CandidateMergeVariableRefactoring)candidate).setNewAttribute(a2);
                this.candidateAttributeMerges.add((CandidateMergeVariableRefactoring)candidate);
            }
        }
        block4: for (SplitVariableReplacement split : this.splitMap.keySet()) {
            LinkedHashSet<UMLAttribute> splitAttributes = new LinkedHashSet<UMLAttribute>();
            LinkedHashSet<VariableDeclaration> splitVariables = new LinkedHashSet<VariableDeclaration>();
            for (String splitVariable : split.getSplitVariables()) {
                UMLAttribute a2 = this.findAttributeInNextClass(splitVariable);
                if (a2 == null) continue;
                splitAttributes.add(a2);
                splitVariables.add(a2.getVariableDeclaration());
            }
            UMLAttribute a1 = this.findAttributeInOriginalClass(split.getBefore());
            set = this.splitMap.get(split);
            for (ReferenceBasedRefactoring candidate : set) {
                if (splitVariables.size() > 1 && splitVariables.size() == split.getSplitVariables().size() && a1 != null && this.findAttributeInNextClass(split.getBefore()) == null) {
                    ref = new SplitAttributeRefactoring(a1, splitAttributes, this.getOriginalClassName(), this.getNextClassName(), set);
                    if (refactorings.contains(ref)) continue;
                    refactorings.add(ref);
                    continue block4;
                }
                ((CandidateSplitVariableRefactoring)candidate).setSplitAttributes(splitAttributes);
                ((CandidateSplitVariableRefactoring)candidate).setOldAttribute(a1);
                this.candidateAttributeSplits.add((CandidateSplitVariableRefactoring)candidate);
            }
        }
        Set<Replacement> renames = this.renameMap.keySet();
        LinkedHashSet allConsistentRenames = new LinkedHashSet();
        LinkedHashSet allInconsistentRenames = new LinkedHashSet();
        Map<String, Set<String>> aliasedAttributesInOriginalClass = this.originalClass.aliasedAttributes();
        Map<String, Set<String>> aliasedAttributesInNextClass = this.nextClass.aliasedAttributes();
        ConsistentReplacementDetector.updateRenames(allConsistentRenames, allInconsistentRenames, renames, aliasedAttributesInOriginalClass, aliasedAttributesInNextClass, this.renameMap);
        allConsistentRenames.removeAll(allInconsistentRenames);
        block7: for (Replacement pattern : allConsistentRenames) {
            UMLAttribute a1 = this.findAttributeInOriginalClass(pattern.getBefore());
            UMLAttribute a2 = this.findAttributeInNextClass(pattern.getAfter());
            Set<CandidateAttributeRefactoring> set2 = this.renameMap.get(pattern);
            for (CandidateAttributeRefactoring candidate : set2) {
                RenameVariableRefactoring ref3;
                if (candidate.getOriginalVariableDeclaration() == null && candidate.getRenamedVariableDeclaration() == null) {
                    if (a1 != null && a2 != null) {
                        Set<Refactoring> attributeDiffRefactorings;
                        if (this.originalClass.containsAttributeWithName(pattern.getAfter()) && !UMLAbstractClassDiff.cyclicRename(this.renameMap, pattern) || this.nextClass.containsAttributeWithName(pattern.getBefore()) && !UMLAbstractClassDiff.cyclicRename(this.renameMap, pattern) || this.inconsistentAttributeRename(pattern, aliasedAttributesInOriginalClass, aliasedAttributesInNextClass) || this.attributeMerged(a1, a2, refactorings) || this.attributeSplit(a1, a2, refactorings)) continue;
                        if (a1 instanceof UMLEnumConstant && a2 instanceof UMLEnumConstant) {
                            Set<Refactoring> enumConstantDiffRefactorings;
                            UMLEnumConstantDiff enumConstantDiff = new UMLEnumConstantDiff((UMLEnumConstant)a1, (UMLEnumConstant)a2, this, this.modelDiff);
                            if (!this.enumConstantDiffList.contains(enumConstantDiff)) {
                                this.enumConstantDiffList.add(enumConstantDiff);
                            }
                            if (refactorings.containsAll(enumConstantDiffRefactorings = enumConstantDiff.getRefactorings(set2))) continue;
                            refactorings.addAll(enumConstantDiffRefactorings);
                            continue block7;
                        }
                        UMLAttributeDiff attributeDiff = new UMLAttributeDiff(a1, a2, this, this.modelDiff);
                        if (!this.attributeDiffList.contains(attributeDiff)) {
                            this.attributeDiffList.add(attributeDiff);
                        }
                        if (refactorings.containsAll(attributeDiffRefactorings = attributeDiff.getRefactorings(set2))) continue;
                        refactorings.addAll(attributeDiffRefactorings);
                        continue block7;
                    }
                    candidate.setOriginalAttribute(a1);
                    candidate.setRenamedAttribute(a2);
                    if (a1 != null) {
                        candidate.setOriginalVariableDeclaration(a1.getVariableDeclaration());
                    }
                    if (a2 != null) {
                        candidate.setRenamedVariableDeclaration(a2.getVariableDeclaration());
                    }
                    this.candidateAttributeRenames.add(candidate);
                    continue;
                }
                if (candidate.getOriginalVariableDeclaration() != null) {
                    if (a2 != null) {
                        ref3 = new RenameVariableRefactoring(candidate.getOriginalVariableDeclaration(), a2.getVariableDeclaration(), candidate.getOperationBefore(), candidate.getOperationAfter(), candidate.getReferences(), false);
                        if (refactorings.contains(ref3)) continue;
                        refactorings.add(ref3);
                        if (candidate.getOriginalVariableDeclaration().equalType(a2.getVariableDeclaration()) && candidate.getOriginalVariableDeclaration().equalQualifiedType(a2.getVariableDeclaration())) continue;
                        ChangeVariableTypeRefactoring refactoring = new ChangeVariableTypeRefactoring(candidate.getOriginalVariableDeclaration(), a2.getVariableDeclaration(), candidate.getOperationBefore(), candidate.getOperationAfter(), candidate.getReferences(), false);
                        refactoring.addRelatedRefactoring(ref3);
                        refactorings.add(refactoring);
                        continue;
                    }
                    this.candidateAttributeRenames.add(candidate);
                    continue;
                }
                if (candidate.getRenamedVariableDeclaration() == null) continue;
                if (a1 != null) {
                    ref3 = new RenameVariableRefactoring(a1.getVariableDeclaration(), candidate.getRenamedVariableDeclaration(), candidate.getOperationBefore(), candidate.getOperationAfter(), candidate.getReferences(), false);
                    if (refactorings.contains(ref3)) continue;
                    refactorings.add(ref3);
                    continue;
                }
                this.candidateAttributeRenames.add(candidate);
            }
        }
        return refactorings;
    }

    public List<Refactoring> getRefactoringsBeforePostProcessing() {
        return this.refactorings;
    }

    protected void processMapperRefactorings(UMLOperationBodyMapper mapper, List<Refactoring> refactorings) throws RefactoringMinerTimedOutException {
        Object before;
        LinkedHashSet<Refactoring> refactorings2 = new LinkedHashSet<Refactoring>();
        refactorings2.addAll(mapper.getRefactoringsAfterPostProcessing());
        refactorings2.addAll(mapper.getRefactorings());
        for (Refactoring refactoring : refactorings2) {
            if (refactorings.contains(refactoring)) {
                int index = refactorings.indexOf(refactoring);
                refactorings.remove(index);
                refactorings.add(index, refactoring);
                continue;
            }
            refactorings.add(refactoring);
        }
        for (CandidateAttributeRefactoring candidateAttributeRefactoring : mapper.getCandidateAttributeRenames()) {
            Object renamePattern;
            String prefix2;
            String prefix1;
            if (this.multipleExtractedMethodInvocationsWithDifferentAttributesAsArguments(candidateAttributeRefactoring, refactorings)) continue;
            String before2 = PrefixSuffixUtils.normalize(candidateAttributeRefactoring.getOriginalVariableName());
            String after = PrefixSuffixUtils.normalize(candidateAttributeRefactoring.getRenamedVariableName());
            if (before2.contains(".") && after.contains(".") && (prefix1 = before2.substring(0, before2.lastIndexOf(".") + 1)).equals(prefix2 = after.substring(0, after.lastIndexOf(".") + 1))) {
                before2 = before2.substring(prefix1.length(), before2.length());
                after = after.substring(prefix2.length(), after.length());
            }
            if (this.renameMap.containsKey(renamePattern = new Replacement(before2, after, Replacement.ReplacementType.VARIABLE_NAME))) {
                this.renameMap.get(renamePattern).add(candidateAttributeRefactoring);
                continue;
            }
            LinkedHashSet<CandidateAttributeRefactoring> set = new LinkedHashSet<CandidateAttributeRefactoring>();
            set.add(candidateAttributeRefactoring);
            this.renameMap.put((Replacement)renamePattern, set);
        }
        for (CandidateMergeVariableRefactoring candidateMergeVariableRefactoring : mapper.getCandidateAttributeMerges()) {
            int movedAttributes = this.movedAttributeCount(candidateMergeVariableRefactoring);
            if (movedAttributes == candidateMergeVariableRefactoring.getMergedVariables().size()) continue;
            before = new LinkedHashSet();
            for (String mergedVariable : candidateMergeVariableRefactoring.getMergedVariables()) {
                before.add(PrefixSuffixUtils.normalize(mergedVariable));
            }
            String after = PrefixSuffixUtils.normalize(candidateMergeVariableRefactoring.getNewVariable());
            MergeVariableReplacement merge = new MergeVariableReplacement((Set<String>)before, after);
            this.processMerge(this.mergeMap, merge, candidateMergeVariableRefactoring);
        }
        for (CandidateSplitVariableRefactoring candidateSplitVariableRefactoring : mapper.getCandidateAttributeSplits()) {
            LinkedHashSet<String> after = new LinkedHashSet<String>();
            for (String splitVariable : candidateSplitVariableRefactoring.getSplitVariables()) {
                after.add(PrefixSuffixUtils.normalize(splitVariable));
            }
            before = PrefixSuffixUtils.normalize(candidateSplitVariableRefactoring.getOldVariable());
            SplitVariableReplacement split = new SplitVariableReplacement((String)before, after);
            this.processSplit(this.splitMap, split, candidateSplitVariableRefactoring);
        }
    }

    public int movedAttributeCount(CandidateMergeVariableRefactoring candidate) {
        UMLClassBaseDiff classDiff;
        UMLAttribute addedAttribute = null;
        for (UMLAttribute attribute : this.addedAttributes) {
            if (!attribute.getName().equals(PrefixSuffixUtils.normalize(candidate.getNewVariable()))) continue;
            addedAttribute = attribute;
            break;
        }
        int movedAttributes = 0;
        if (addedAttribute != null && (classDiff = this.modelDiff.getUMLClassDiff(addedAttribute.getType())) != null) {
            block1: for (String mergedVariable : candidate.getMergedVariables()) {
                UMLAttribute removedAttribute = null;
                for (UMLAttribute attribute : this.removedAttributes) {
                    if (!attribute.getName().equals(PrefixSuffixUtils.normalize(mergedVariable))) continue;
                    removedAttribute = attribute;
                    break;
                }
                if (removedAttribute == null) continue;
                for (UMLAttribute attribute : classDiff.getAddedAttributes()) {
                    if (!attribute.getName().equals(removedAttribute.getName()) || !attribute.getType().equals(removedAttribute.getType())) continue;
                    ++movedAttributes;
                    continue block1;
                }
            }
        }
        return movedAttributes;
    }

    private boolean multipleExtractedMethodInvocationsWithDifferentAttributesAsArguments(CandidateAttributeRefactoring candidate, List<Refactoring> refactorings) {
        for (Refactoring refactoring : refactorings) {
            List<AbstractCall> extractedInvocations;
            ExtractOperationRefactoring extractRefactoring;
            if (!(refactoring instanceof ExtractOperationRefactoring) || !(extractRefactoring = (ExtractOperationRefactoring)refactoring).getExtractedOperation().equals(candidate.getOperationAfter()) || (extractedInvocations = extractRefactoring.getExtractedOperationInvocations()).size() <= 1) continue;
            LinkedHashSet<VariableDeclaration> attributesMatchedWithArguments = new LinkedHashSet<VariableDeclaration>();
            LinkedHashSet<String> attributeNamesMatchedWithArguments = new LinkedHashSet<String>();
            for (AbstractCall extractedInvocation : extractedInvocations) {
                block2: for (String argument : extractedInvocation.arguments()) {
                    for (UMLAttribute attribute : this.originalClass.getAttributes()) {
                        if (!attribute.getName().equals(argument)) continue;
                        attributesMatchedWithArguments.add(attribute.getVariableDeclaration());
                        attributeNamesMatchedWithArguments.add(attribute.getName());
                        continue block2;
                    }
                }
            }
            if (!attributeNamesMatchedWithArguments.contains(candidate.getOriginalVariableName()) && !attributeNamesMatchedWithArguments.contains(candidate.getRenamedVariableName()) || attributesMatchedWithArguments.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private Set<Refactoring> inferAttributeMergesAndSplits(Map<Replacement, Set<CandidateAttributeRefactoring>> map, List<Refactoring> refactorings) {
        LinkedHashSet<Refactoring> newRefactorings = new LinkedHashSet<Refactoring>();
        for (Replacement replacement : map.keySet()) {
            Set<CandidateAttributeRefactoring> candidates = map.get(replacement);
            for (CandidateAttributeRefactoring candidate : candidates) {
                String originalAttributeName = PrefixSuffixUtils.normalize(candidate.getOriginalVariableName());
                String renamedAttributeName = PrefixSuffixUtils.normalize(candidate.getRenamedVariableName());
                UMLOperationBodyMapper candidateMapper = null;
                block2: for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                    if (mapper.getMappings().containsAll(candidate.getReferences())) {
                        candidateMapper = mapper;
                        break;
                    }
                    for (UMLOperationBodyMapper nestedMapper : mapper.getChildMappers()) {
                        if (!nestedMapper.getMappings().containsAll(candidate.getReferences())) continue;
                        candidateMapper = nestedMapper;
                        continue block2;
                    }
                }
                for (Refactoring refactoring : refactorings) {
                    Refactoring ref;
                    LinkedHashSet<String> allMatchingVariables;
                    String matchingVariableName;
                    LinkedHashSet<String> nonMatchingVariableNames;
                    if (refactoring instanceof MergeVariableRefactoring) {
                        MergeVariableRefactoring merge = (MergeVariableRefactoring)refactoring;
                        nonMatchingVariableNames = new LinkedHashSet<String>();
                        matchingVariableName = null;
                        block5: for (VariableDeclaration variableDeclaration : merge.getMergedVariables()) {
                            if (originalAttributeName.equals(variableDeclaration.getVariableName())) {
                                matchingVariableName = variableDeclaration.getVariableName();
                                continue;
                            }
                            for (AbstractCodeFragment abstractCodeFragment : candidateMapper.getNonMappedLeavesT1()) {
                                if (!abstractCodeFragment.getString().startsWith(variableDeclaration.getVariableName() + "=") && !abstractCodeFragment.getString().startsWith("this." + variableDeclaration.getVariableName() + "=")) continue;
                                nonMatchingVariableNames.add(variableDeclaration.getVariableName());
                                continue block5;
                            }
                        }
                        if (matchingVariableName == null || !renamedAttributeName.equals(merge.getNewVariable().getVariableName()) || nonMatchingVariableNames.size() <= 0) continue;
                        LinkedHashSet mergedAttributes = new LinkedHashSet();
                        LinkedHashSet<VariableDeclaration> mergedVariables = new LinkedHashSet<VariableDeclaration>();
                        allMatchingVariables = new LinkedHashSet();
                        if (merge.getMergedVariables().iterator().next().getVariableName().equals(matchingVariableName)) {
                            allMatchingVariables.add(matchingVariableName);
                            allMatchingVariables.addAll(nonMatchingVariableNames);
                        } else {
                            allMatchingVariables.addAll(nonMatchingVariableNames);
                            allMatchingVariables.add(matchingVariableName);
                        }
                        for (String mergedVariable : allMatchingVariables) {
                            UMLAttribute a1 = this.findAttributeInOriginalClass(mergedVariable);
                            if (a1 == null) continue;
                            mergedAttributes.add(a1);
                            mergedVariables.add(a1.getVariableDeclaration());
                        }
                        UMLAttribute uMLAttribute = this.findAttributeInNextClass(renamedAttributeName);
                        if (mergedVariables.size() <= 1 || mergedVariables.size() != merge.getMergedVariables().size() || uMLAttribute == null || refactorings.contains(ref = new MergeAttributeRefactoring(mergedAttributes, uMLAttribute, this.getOriginalClassName(), this.getNextClassName(), new LinkedHashSet<CandidateMergeVariableRefactoring>()))) continue;
                        newRefactorings.add(ref);
                        continue;
                    }
                    if (!(refactoring instanceof SplitVariableRefactoring)) continue;
                    SplitVariableRefactoring split = (SplitVariableRefactoring)refactoring;
                    nonMatchingVariableNames = new LinkedHashSet();
                    matchingVariableName = null;
                    block8: for (VariableDeclaration variableDeclaration : split.getSplitVariables()) {
                        if (renamedAttributeName.equals(variableDeclaration.getVariableName())) {
                            matchingVariableName = variableDeclaration.getVariableName();
                            continue;
                        }
                        for (AbstractCodeFragment abstractCodeFragment : candidateMapper.getNonMappedLeavesT2()) {
                            if (!abstractCodeFragment.getString().startsWith(variableDeclaration.getVariableName() + "=") && !abstractCodeFragment.getString().startsWith("this." + variableDeclaration.getVariableName() + "=")) continue;
                            nonMatchingVariableNames.add(variableDeclaration.getVariableName());
                            continue block8;
                        }
                    }
                    if (matchingVariableName == null || !originalAttributeName.equals(split.getOldVariable().getVariableName()) || nonMatchingVariableNames.size() <= 0) continue;
                    LinkedHashSet<UMLAttribute> splitAttributes = new LinkedHashSet<UMLAttribute>();
                    LinkedHashSet<VariableDeclaration> splitVariables = new LinkedHashSet<VariableDeclaration>();
                    allMatchingVariables = new LinkedHashSet<String>();
                    if (split.getSplitVariables().iterator().next().getVariableName().equals(matchingVariableName)) {
                        allMatchingVariables.add(matchingVariableName);
                        allMatchingVariables.addAll(nonMatchingVariableNames);
                    } else {
                        allMatchingVariables.addAll(nonMatchingVariableNames);
                        allMatchingVariables.add(matchingVariableName);
                    }
                    for (String splitVariable : allMatchingVariables) {
                        UMLAttribute a2 = this.findAttributeInNextClass(splitVariable);
                        if (a2 == null) continue;
                        splitAttributes.add(a2);
                        splitVariables.add(a2.getVariableDeclaration());
                    }
                    UMLAttribute uMLAttribute = this.findAttributeInOriginalClass(originalAttributeName);
                    if (splitVariables.size() <= 1 || splitVariables.size() != split.getSplitVariables().size() || uMLAttribute == null || this.findAttributeInNextClass(originalAttributeName) != null || refactorings.contains(ref = new SplitAttributeRefactoring(uMLAttribute, splitAttributes, this.getOriginalClassName(), this.getNextClassName(), new LinkedHashSet<CandidateSplitVariableRefactoring>()))) continue;
                    newRefactorings.add(ref);
                }
            }
        }
        return newRefactorings;
    }

    private boolean attributeMerged(UMLAttribute a1, UMLAttribute a2, List<Refactoring> refactorings) {
        for (Refactoring refactoring : refactorings) {
            MergeAttributeRefactoring merge;
            if (!(refactoring instanceof MergeAttributeRefactoring) || !(merge = (MergeAttributeRefactoring)refactoring).getMergedVariables().contains(a1.getVariableDeclaration()) || !merge.getNewAttribute().getVariableDeclaration().equals(a2.getVariableDeclaration())) continue;
            return true;
        }
        return false;
    }

    private boolean attributeSplit(UMLAttribute a1, UMLAttribute a2, List<Refactoring> refactorings) {
        for (Refactoring refactoring : refactorings) {
            SplitAttributeRefactoring split;
            if (!(refactoring instanceof SplitAttributeRefactoring) || !(split = (SplitAttributeRefactoring)refactoring).getSplitVariables().contains(a2.getVariableDeclaration()) || !split.getOldAttribute().getVariableDeclaration().equals(a1.getVariableDeclaration())) continue;
            return true;
        }
        return false;
    }

    private void processMerge(Map<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>> mergeMap, MergeVariableReplacement newMerge, CandidateMergeVariableRefactoring candidate) {
        MergeVariableReplacement mergeToBeRemoved = null;
        for (MergeVariableReplacement merge : mergeMap.keySet()) {
            if (merge.subsumes(newMerge)) {
                mergeMap.get(merge).add(candidate);
                return;
            }
            if (merge.equal(newMerge)) {
                mergeMap.get(merge).add(candidate);
                return;
            }
            if (merge.commonAfter(newMerge)) {
                mergeToBeRemoved = merge;
                LinkedHashSet<String> mergedVariables = new LinkedHashSet<String>();
                mergedVariables.addAll(merge.getMergedVariables());
                mergedVariables.addAll(newMerge.getMergedVariables());
                MergeVariableReplacement replacement = new MergeVariableReplacement(mergedVariables, merge.getAfter());
                Set<CandidateMergeVariableRefactoring> candidates = mergeMap.get(mergeToBeRemoved);
                candidates.add(candidate);
                mergeMap.put(replacement, candidates);
                break;
            }
            if (!newMerge.subsumes(merge)) continue;
            mergeToBeRemoved = merge;
            Set<CandidateMergeVariableRefactoring> candidates = mergeMap.get(mergeToBeRemoved);
            candidates.add(candidate);
            mergeMap.put(newMerge, candidates);
            break;
        }
        if (mergeToBeRemoved != null) {
            mergeMap.remove(mergeToBeRemoved);
            return;
        }
        LinkedHashSet<CandidateMergeVariableRefactoring> set = new LinkedHashSet<CandidateMergeVariableRefactoring>();
        set.add(candidate);
        mergeMap.put(newMerge, set);
    }

    private void processSplit(Map<SplitVariableReplacement, Set<CandidateSplitVariableRefactoring>> splitMap, SplitVariableReplacement newSplit, CandidateSplitVariableRefactoring candidate) {
        SplitVariableReplacement splitToBeRemoved = null;
        for (SplitVariableReplacement split : splitMap.keySet()) {
            if (split.subsumes(newSplit)) {
                splitMap.get(split).add(candidate);
                return;
            }
            if (split.equal(newSplit)) {
                splitMap.get(split).add(candidate);
                return;
            }
            if (split.commonBefore(newSplit)) {
                splitToBeRemoved = split;
                LinkedHashSet<String> splitVariables = new LinkedHashSet<String>();
                splitVariables.addAll(split.getSplitVariables());
                splitVariables.addAll(newSplit.getSplitVariables());
                SplitVariableReplacement replacement = new SplitVariableReplacement(split.getBefore(), splitVariables);
                Set<CandidateSplitVariableRefactoring> candidates = splitMap.get(splitToBeRemoved);
                candidates.add(candidate);
                splitMap.put(replacement, candidates);
                break;
            }
            if (!newSplit.subsumes(split)) continue;
            splitToBeRemoved = split;
            Set<CandidateSplitVariableRefactoring> candidates = splitMap.get(splitToBeRemoved);
            candidates.add(candidate);
            splitMap.put(newSplit, candidates);
            break;
        }
        if (splitToBeRemoved != null) {
            splitMap.remove(splitToBeRemoved);
            return;
        }
        LinkedHashSet<CandidateSplitVariableRefactoring> set = new LinkedHashSet<CandidateSplitVariableRefactoring>();
        set.add(candidate);
        splitMap.put(newSplit, set);
    }

    public UMLAttribute findAttributeInOriginalClass(String attributeName) {
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute;
        }
        for (UMLEnumConstant enumConstant : this.originalClass.getEnumConstants()) {
            if (!enumConstant.getName().equals(attributeName) || !this.removedEnumConstants.contains(enumConstant)) continue;
            return enumConstant;
        }
        return null;
    }

    public UMLAttribute findAttributeInNextClass(String attributeName) {
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute;
        }
        for (UMLEnumConstant enumConstant : this.nextClass.getEnumConstants()) {
            if (!enumConstant.getName().equals(attributeName) || !this.addedEnumConstants.contains(enumConstant)) continue;
            return enumConstant;
        }
        return null;
    }

    private boolean inconsistentAttributeRename(Replacement pattern, Map<String, Set<String>> aliasedAttributesInOriginalClass, Map<String, Set<String>> aliasedAttributesInNextClass) {
        for (String key : aliasedAttributesInOriginalClass.keySet()) {
            if (!aliasedAttributesInOriginalClass.get(key).contains(pattern.getBefore())) continue;
            return false;
        }
        for (String key : aliasedAttributesInNextClass.keySet()) {
            if (!aliasedAttributesInNextClass.get(key).contains(pattern.getAfter())) continue;
            return false;
        }
        int counter = 0;
        int allCases = 0;
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            boolean skip;
            boolean variables2Contains;
            List<String> allVariables1 = mapper.getContainer1().getAllVariables();
            List<String> allVariables2 = mapper.getContainer2().getAllVariables();
            for (UMLOperationBodyMapper nestedMapper : mapper.getChildMappers()) {
                allVariables1.addAll(nestedMapper.getContainer1().getAllVariables());
                allVariables2.addAll(nestedMapper.getContainer2().getAllVariables());
            }
            boolean variables1contains = allVariables1.contains(pattern.getBefore()) && !mapper.getContainer1().getParameterNameList().contains(pattern.getBefore()) || allVariables1.contains("this." + pattern.getBefore());
            boolean bl = variables2Contains = allVariables2.contains(pattern.getAfter()) && !mapper.getContainer2().getParameterNameList().contains(pattern.getAfter()) || allVariables2.contains("this." + pattern.getAfter());
            if (variables1contains && !variables2Contains) {
                skip = false;
                for (AbstractCodeMapping mapping : mapper.getMappings()) {
                    for (AbstractCall call : mapping.getFragment2().getMethodInvocations()) {
                        for (UMLOperation addedOperation : this.addedOperations) {
                            List<String> addedOperationVariables;
                            if (!call.matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff) || !(addedOperationVariables = addedOperation.getAllVariables()).contains(pattern.getAfter())) continue;
                            skip = true;
                            break;
                        }
                        if (!skip) continue;
                        break;
                    }
                    if (!skip) continue;
                    break;
                }
                if (!skip) {
                    ++counter;
                }
            }
            if (variables2Contains && !variables1contains) {
                skip = false;
                for (AbstractCodeMapping mapping : mapper.getMappings()) {
                    for (AbstractCall call : mapping.getFragment1().getMethodInvocations()) {
                        for (UMLOperation removedOperation : this.removedOperations) {
                            List<String> removedOperationVariables;
                            if (!call.matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff) || !(removedOperationVariables = removedOperation.getAllVariables()).contains(pattern.getBefore())) continue;
                            skip = true;
                            break;
                        }
                        if (!skip) continue;
                        break;
                    }
                    if (!skip) continue;
                    break;
                }
                if (!skip) {
                    ++counter;
                }
            }
            if (!variables1contains && !variables2Contains) continue;
            ++allCases;
        }
        double percentage = (double)counter / (double)allCases;
        return percentage > 0.5;
    }

    private static boolean cyclicRename(Map<Replacement, Set<CandidateAttributeRefactoring>> renames, Replacement rename) {
        for (Replacement r : renames.keySet()) {
            if (!rename.getAfter().equals(r.getBefore()) && !rename.getBefore().equals(r.getAfter()) || UMLAbstractClassDiff.totalOccurrences(renames.get(rename)) <= 1 && UMLAbstractClassDiff.totalOccurrences(renames.get(r)) <= 1) continue;
            return true;
        }
        return false;
    }

    private static int totalOccurrences(Set<CandidateAttributeRefactoring> candidates) {
        int totalCount = 0;
        for (CandidateAttributeRefactoring candidate : candidates) {
            totalCount += candidate.getOccurrences();
        }
        return totalCount;
    }

    public boolean containsExtractOperationRefactoring(VariableDeclarationContainer sourceOperationBeforeExtraction, UMLOperation extractedOperation) {
        for (Refactoring ref : this.refactorings) {
            ExtractOperationRefactoring extractRef;
            if (!(ref instanceof ExtractOperationRefactoring) || !(extractRef = (ExtractOperationRefactoring)ref).getSourceOperationBeforeExtraction().equals(sourceOperationBeforeExtraction) || !extractRef.getExtractedOperation().equalSignature(extractedOperation)) continue;
            return true;
        }
        return false;
    }

    public boolean containsInlineOperationRefactoring(UMLOperation inlinedOperation, VariableDeclarationContainer targetOperationAfterInline) {
        for (Refactoring ref : this.refactorings) {
            InlineOperationRefactoring inlineRef;
            if (!(ref instanceof InlineOperationRefactoring) || !(inlineRef = (InlineOperationRefactoring)ref).getTargetOperationAfterInline().equals(targetOperationAfterInline) || !inlineRef.getInlinedOperation().equalSignature(inlinedOperation)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getVariableDeclarationNamesInMethodBody(VariableDeclarationContainer operation) {
        if (operation.getBody() != null) {
            LinkedHashSet<String> keySet = new LinkedHashSet<String>(operation.variableDeclarationMap().keySet());
            keySet.removeAll(operation.getParameterNameList());
            return keySet;
        }
        return Collections.emptySet();
    }

    public boolean isPartOfMethodInlined(VariableDeclarationContainer removedOperation, VariableDeclarationContainer addedOperation) {
        int numberOfInvocationsMissingFromAddedOperationWithoutThoseFoundInOtherRemovedOperations;
        List<AbstractCall> removedOperationInvocations = removedOperation.getAllOperationInvocations();
        List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
        intersection.retainAll(addedOperationInvocations);
        int numberOfInvocationsMissingFromAddedOperation = new LinkedHashSet<AbstractCall>(addedOperationInvocations).size() - intersection.size();
        LinkedHashSet<AbstractCall> operationInvocationsInMethodsCalledByRemovedOperation = new LinkedHashSet<AbstractCall>();
        for (AbstractCall removedOperationInvocation : removedOperationInvocations) {
            if (intersection.contains(removedOperationInvocation)) continue;
            for (UMLOperation operation : this.removedOperations) {
                if (operation.equals(removedOperation) || operation.getBody() == null || !removedOperationInvocation.matchesOperation(operation, removedOperation, this, this.modelDiff)) continue;
                operationInvocationsInMethodsCalledByRemovedOperation.addAll(operation.getAllOperationInvocations());
            }
        }
        LinkedHashSet<AbstractCall> newIntersection = new LinkedHashSet<AbstractCall>(addedOperationInvocations);
        newIntersection.retainAll(operationInvocationsInMethodsCalledByRemovedOperation);
        LinkedHashSet<AbstractCall> addedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted = new LinkedHashSet<AbstractCall>(addedOperationInvocations);
        addedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(intersection);
        addedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(newIntersection);
        Iterator operationInvocationIterator = addedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.iterator();
        while (operationInvocationIterator.hasNext()) {
            AbstractCall invocation = (AbstractCall)operationInvocationIterator.next();
            if (!invocation.getName().startsWith("get") && !invocation.getName().equals("add") && !invocation.getName().equals("contains")) continue;
            operationInvocationIterator.remove();
        }
        int numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations = newIntersection.size();
        return numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations > (numberOfInvocationsMissingFromAddedOperationWithoutThoseFoundInOtherRemovedOperations = numberOfInvocationsMissingFromAddedOperation - numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations) || numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations > addedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.size();
    }

    public boolean matchesCandidateAttributeRename(UMLOperation addedOperation) {
        String setPrefix = "set";
        String getPrefix = "get";
        for (Replacement r : this.renameMap.keySet()) {
            if (!(addedOperation.isGetter() ? addedOperation.getName().equals(r.getAfter()) || addedOperation.getName().toLowerCase().equals(getPrefix + r.getAfter().toLowerCase()) : addedOperation.isSetter() && (addedOperation.getName().toLowerCase().equals(setPrefix + r.getAfter().toLowerCase()) || addedOperation.getParameterNameList().get(0).equals(r.getAfter())))) continue;
            return true;
        }
        return false;
    }
}

