/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class UMLAnnotationListDiff {
    private Set<UMLAnnotation> removedAnnotations = new LinkedHashSet<UMLAnnotation>();
    private Set<UMLAnnotation> addedAnnotations = new LinkedHashSet<UMLAnnotation>();
    private Set<UMLAnnotationDiff> annotationDiffs = new LinkedHashSet<UMLAnnotationDiff>();
    private Set<Pair<UMLAnnotation, UMLAnnotation>> commonAnnotations = new LinkedHashSet<Pair<UMLAnnotation, UMLAnnotation>>();

    public UMLAnnotationListDiff(List<UMLAnnotation> annotations1, List<UMLAnnotation> annotations2) {
        boolean found;
        LinkedHashSet<Pair> matchedAnnotations = new LinkedHashSet<Pair>();
        for (UMLAnnotation annotation1 : annotations1) {
            found = false;
            for (UMLAnnotation annotation2 : annotations2) {
                if (!annotation1.equals(annotation2)) continue;
                matchedAnnotations.add(Pair.of((Object)annotation1, (Object)annotation2));
                found = true;
                break;
            }
            if (!found) {
                for (UMLAnnotation annotation2 : annotations2) {
                    if (!annotation1.getTypeName().equals(annotation2.getTypeName())) continue;
                    matchedAnnotations.add(Pair.of((Object)annotation1, (Object)annotation2));
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.removedAnnotations.add(annotation1);
        }
        for (UMLAnnotation annotation2 : annotations2) {
            found = false;
            for (UMLAnnotation annotation1 : annotations1) {
                if (!annotation1.equals(annotation2)) continue;
                matchedAnnotations.add(Pair.of((Object)annotation1, (Object)annotation2));
                found = true;
                break;
            }
            if (!found) {
                for (UMLAnnotation annotation1 : annotations1) {
                    if (!annotation1.getTypeName().equals(annotation2.getTypeName())) continue;
                    matchedAnnotations.add(Pair.of((Object)annotation1, (Object)annotation2));
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.addedAnnotations.add(annotation2);
        }
        for (Pair pair : matchedAnnotations) {
            UMLAnnotationDiff annotationDiff = new UMLAnnotationDiff((UMLAnnotation)pair.getLeft(), (UMLAnnotation)pair.getRight());
            if (!annotationDiff.isEmpty() && !this.annotationDiffs.contains(annotationDiff)) {
                this.annotationDiffs.add(annotationDiff);
                continue;
            }
            if (this.commonAnnotations.contains(pair)) continue;
            this.commonAnnotations.add((Pair<UMLAnnotation, UMLAnnotation>)pair);
        }
    }

    public Set<UMLAnnotation> getRemovedAnnotations() {
        return this.removedAnnotations;
    }

    public Set<UMLAnnotation> getAddedAnnotations() {
        return this.addedAnnotations;
    }

    public Set<UMLAnnotationDiff> getAnnotationDiffs() {
        return this.annotationDiffs;
    }

    public Set<Pair<UMLAnnotation, UMLAnnotation>> getCommonAnnotations() {
        return this.commonAnnotations;
    }

    public boolean isEmpty() {
        return this.removedAnnotations.isEmpty() && this.addedAnnotations.isEmpty() && this.annotationDiffs.isEmpty();
    }
}

