/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLInitializer;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.ExtractOperationDetection;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.InlineOperationDetection;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAttributeDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class UMLAnonymousClassDiff
extends UMLAbstractClassDiff {
    private UMLAbstractClassDiff classDiff;

    public UMLAnonymousClassDiff(UMLAnonymousClass anonymousClass1, UMLAnonymousClass anonymousClass2, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) throws RefactoringMinerTimedOutException {
        super(anonymousClass1, anonymousClass2, modelDiff);
        this.classDiff = classDiff;
    }

    @Override
    public void process() throws RefactoringMinerTimedOutException {
        this.processInitializers();
        this.processOperations();
        this.createBodyMappers();
        this.checkForOperationSignatureChanges();
        this.processAttributes();
        this.checkForAttributeChanges();
        this.checkForInlinedOperations();
        this.checkForExtractedOperations();
    }

    public boolean isEmpty() {
        return this.addedOperations.isEmpty() && this.removedOperations.isEmpty() && this.addedAttributes.isEmpty() && this.removedAttributes.isEmpty() && this.addedEnumConstants.isEmpty() && this.removedEnumConstants.isEmpty() && this.attributeDiffList.isEmpty() && this.enumConstantDiffList.isEmpty();
    }

    protected void processInitializers() throws RefactoringMinerTimedOutException {
        block6: {
            List<UMLInitializer> initializers2;
            List<UMLInitializer> initializers1;
            block7: {
                block5: {
                    initializers1 = this.originalClass.getInitializers();
                    initializers2 = this.nextClass.getInitializers();
                    if (initializers1.size() != initializers2.size()) break block5;
                    for (int i = 0; i < initializers1.size(); ++i) {
                        UMLInitializer initializer2;
                        UMLInitializer initializer1 = initializers1.get(i);
                        UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(initializer1, initializer2 = initializers2.get(i), this.classDiff);
                        int mappings = mapper.mappingsWithoutBlocks();
                        if (mappings <= 0) continue;
                        int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                        int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                        if ((mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) && !this.isPartOfMethodExtracted(initializer1, initializer2) && !this.isPartOfMethodInlined(initializer1, initializer2)) continue;
                        this.operationBodyMapperList.add(mapper);
                    }
                    break block6;
                }
                if (initializers1.size() >= initializers2.size()) break block7;
                for (UMLInitializer initializer1 : initializers1) {
                    for (UMLInitializer initializer2 : initializers2) {
                        UMLOperationBodyMapper mapper;
                        int mappings;
                        if (initializer1.isStatic() != initializer2.isStatic() || (mappings = (mapper = new UMLOperationBodyMapper(initializer1, initializer2, this.classDiff)).mappingsWithoutBlocks()) <= 0) continue;
                        int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                        int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                        if ((mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) && !this.isPartOfMethodExtracted(initializer1, initializer2) && !this.isPartOfMethodInlined(initializer1, initializer2)) continue;
                        this.operationBodyMapperList.add(mapper);
                    }
                }
                break block6;
            }
            if (initializers1.size() <= initializers2.size()) break block6;
            for (UMLInitializer initializer2 : initializers2) {
                for (UMLInitializer initializer1 : initializers1) {
                    UMLOperationBodyMapper mapper;
                    int mappings;
                    if (initializer1.isStatic() != initializer2.isStatic() || (mappings = (mapper = new UMLOperationBodyMapper(initializer1, initializer2, this.classDiff)).mappingsWithoutBlocks()) <= 0) continue;
                    int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                    int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                    if ((mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) && !this.isPartOfMethodExtracted(initializer1, initializer2) && !this.isPartOfMethodInlined(initializer1, initializer2)) continue;
                    this.operationBodyMapperList.add(mapper);
                }
            }
        }
    }

    protected void processOperations() {
        for (UMLOperation operation : this.originalClass.getOperations()) {
            if (this.nextClass.getOperations().contains(operation)) continue;
            this.removedOperations.add(operation);
        }
        for (UMLOperation operation : this.nextClass.getOperations()) {
            if (this.originalClass.getOperations().contains(operation)) continue;
            this.addedOperations.add(operation);
        }
    }

    protected void processAttributes() throws RefactoringMinerTimedOutException {
        Pair pair;
        UMLAttributeDiff attributeDiff;
        UMLAttribute matchingAttribute;
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            matchingAttribute = this.nextClass.containsAttribute(attribute);
            if (matchingAttribute != null) {
                attributeDiff = new UMLAttributeDiff(attribute, matchingAttribute, this.operationBodyMapperList);
                if (!attributeDiff.isEmpty()) {
                    this.refactorings.addAll(attributeDiff.getRefactorings());
                    if (this.attributeDiffList.contains(attributeDiff)) continue;
                    this.attributeDiffList.add(attributeDiff);
                    continue;
                }
                pair = Pair.of((Object)attribute, (Object)matchingAttribute);
                if (!this.commonAtrributes.contains(pair)) {
                    this.commonAtrributes.add(pair);
                }
                if (!attributeDiff.encapsulated()) continue;
                this.refactorings.addAll(attributeDiff.getRefactorings());
                continue;
            }
            this.removedAttributes.add(attribute);
        }
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            matchingAttribute = this.originalClass.containsAttribute(attribute);
            if (matchingAttribute != null) {
                attributeDiff = new UMLAttributeDiff(matchingAttribute, attribute, this.operationBodyMapperList);
                if (!attributeDiff.isEmpty()) {
                    this.refactorings.addAll(attributeDiff.getRefactorings());
                    if (this.attributeDiffList.contains(attributeDiff)) continue;
                    this.attributeDiffList.add(attributeDiff);
                    continue;
                }
                pair = Pair.of((Object)matchingAttribute, (Object)attribute);
                if (!this.commonAtrributes.contains(pair)) {
                    this.commonAtrributes.add(pair);
                }
                if (!attributeDiff.encapsulated()) continue;
                this.refactorings.addAll(attributeDiff.getRefactorings());
                continue;
            }
            this.addedAttributes.add(attribute);
        }
    }

    @Override
    protected void createBodyMappers() throws RefactoringMinerTimedOutException {
        for (UMLOperation operation1 : this.originalClass.getOperations()) {
            for (UMLOperation operation2 : this.nextClass.getOperations()) {
                boolean matchingEmptyBodies;
                if (!operation1.equals(operation2) && !operation1.equalSignature(operation2)) continue;
                UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(operation1, operation2, this.classDiff);
                int mappings = mapper.mappingsWithoutBlocks();
                boolean emptyBodiesWithIdenticalComments = operation1.emptyBodiesWithIdenticalComments(operation2);
                boolean emptyBodiesWithEqualSignature = operation1.hasEmptyBody() && operation2.hasEmptyBody() && (operation1.equals(operation2) || operation1.equalSignature(operation2));
                boolean bl = matchingEmptyBodies = emptyBodiesWithIdenticalComments || emptyBodiesWithEqualSignature;
                if (mappings <= 0 && !matchingEmptyBodies) continue;
                int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                if (mappings <= nonMappedElementsT1 && mappings <= nonMappedElementsT2 && !matchingEmptyBodies && !this.isPartOfMethodExtracted(operation1, operation2) && !this.isPartOfMethodInlined(operation1, operation2)) continue;
                this.operationBodyMapperList.add(mapper);
                this.removedOperations.remove(operation1);
                this.addedOperations.remove(operation2);
            }
        }
    }

    private void checkForOperationSignatureChanges() throws RefactoringMinerTimedOutException {
        for (UMLOperation operation1 : this.originalClass.getOperations()) {
            for (UMLOperation operation2 : this.nextClass.getOperations()) {
                UMLOperationBodyMapper mapper;
                int mappings;
                if (this.containsMapperForOperation1(operation1) || this.containsMapperForOperation2(operation2) || !operation1.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation2) && (!operation1.getName().equals(operation2.getName()) || !operation1.compatibleSignature(operation2)) && operation1.getBodyHashCode() != operation2.getBodyHashCode() || (mappings = (mapper = new UMLOperationBodyMapper(operation1, operation2, this.classDiff)).mappingsWithoutBlocks()) <= 0) continue;
                int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                if ((mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) && !this.isPartOfMethodExtracted(operation1, operation2) && !this.isPartOfMethodInlined(operation1, operation2)) continue;
                this.operationBodyMapperList.add(mapper);
                this.removedOperations.remove(operation1);
                this.addedOperations.remove(operation2);
            }
        }
    }

    @Override
    protected void checkForAttributeChanges() throws RefactoringMinerTimedOutException {
        Iterator removedAttributeIterator = this.removedAttributes.iterator();
        block0: while (removedAttributeIterator.hasNext()) {
            UMLAttribute removedAttribute = (UMLAttribute)removedAttributeIterator.next();
            Iterator addedAttributeIterator = this.addedAttributes.iterator();
            while (addedAttributeIterator.hasNext()) {
                UMLAttribute addedAttribute = (UMLAttribute)addedAttributeIterator.next();
                if (!removedAttribute.getName().equals(addedAttribute.getName())) continue;
                UMLAttributeDiff attributeDiff = new UMLAttributeDiff(removedAttribute, addedAttribute, this.operationBodyMapperList);
                addedAttributeIterator.remove();
                removedAttributeIterator.remove();
                this.refactorings.addAll(attributeDiff.getRefactorings());
                if (this.attributeDiffList.contains(attributeDiff)) continue block0;
                this.attributeDiffList.add(attributeDiff);
                continue block0;
            }
        }
    }

    private void checkForExtractedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        for (UMLOperation addedOperation : this.addedOperations) {
            for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
                ExtractOperationDetection detection = new ExtractOperationDetection(mapper, this.addedOperations, this.classDiff, this.modelDiff);
                List<ExtractOperationRefactoring> refs = detection.check(addedOperation);
                for (ExtractOperationRefactoring refactoring : refs) {
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(addedOperation);
                }
            }
        }
        this.addedOperations.removeAll(operationsToBeRemoved);
    }

    private void checkForInlinedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
                InlineOperationDetection detection = new InlineOperationDetection(mapper, this.removedOperations, this.classDiff, this.modelDiff);
                List<InlineOperationRefactoring> refs = detection.check(removedOperation);
                for (InlineOperationRefactoring refactoring : refs) {
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(removedOperation);
                }
            }
        }
        this.removedOperations.removeAll(operationsToBeRemoved);
    }
}

