/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.SourceAnnotation;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLInitializer;
import gr.uom.java.xmi.UMLModelASTReader;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.Visibility;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.ConsistentReplacementDetector;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.AddClassAnnotationRefactoring;
import gr.uom.java.xmi.diff.AddClassModifierRefactoring;
import gr.uom.java.xmi.diff.CandidateMergeMethodRefactoring;
import gr.uom.java.xmi.diff.CandidateSplitMethodRefactoring;
import gr.uom.java.xmi.diff.ChangeClassAccessModifierRefactoring;
import gr.uom.java.xmi.diff.ExtractOperationDetection;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.InlineOperationDetection;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.MappingOptimizer;
import gr.uom.java.xmi.diff.MergeOperationRefactoring;
import gr.uom.java.xmi.diff.ModifyClassAnnotationRefactoring;
import gr.uom.java.xmi.diff.MoveCodeRefactoring;
import gr.uom.java.xmi.diff.ParameterizeTestRefactoring;
import gr.uom.java.xmi.diff.RemoveClassAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveClassModifierRefactoring;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import gr.uom.java.xmi.diff.SplitOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import gr.uom.java.xmi.diff.UMLAnonymousClassDiff;
import gr.uom.java.xmi.diff.UMLAttributeDiff;
import gr.uom.java.xmi.diff.UMLClassDiff;
import gr.uom.java.xmi.diff.UMLClassMoveDiff;
import gr.uom.java.xmi.diff.UMLEnumConstantDiff;
import gr.uom.java.xmi.diff.UMLImportListDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import gr.uom.java.xmi.diff.UMLOperationDiff;
import gr.uom.java.xmi.diff.UMLTypeParameterListDiff;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.jdt.core.dom.ASTNode;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public abstract class UMLClassBaseDiff
extends UMLAbstractClassDiff
implements Comparable<UMLClassBaseDiff> {
    private static final int MAXIMUM_NUMBER_OF_COMPARED_METHODS = 30;
    public static final double MAX_OPERATION_NAME_DISTANCE = 0.4;
    private boolean visibilityChanged = false;
    private Visibility oldVisibility;
    private Visibility newVisibility;
    private boolean abstractionChanged = false;
    private boolean oldAbstraction;
    private boolean newAbstraction;
    private boolean staticChanged;
    private boolean finalChanged;
    private boolean superclassChanged = false;
    private UMLType oldSuperclass;
    private UMLType newSuperclass;
    private List<UMLType> addedImplementedInterfaces;
    private List<UMLType> removedImplementedInterfaces;
    private UMLAnnotationListDiff annotationListDiff;
    private UMLImportListDiff importDiffList;
    private UMLTypeParameterListDiff typeParameterDiffList;
    private Map<MethodInvocationReplacement, UMLOperationBodyMapper> consistentMethodInvocationRenamesInModel;
    private Map<MethodInvocationReplacement, UMLOperationBodyMapper> consistentMethodInvocationRenames;
    private Set<UMLOperationBodyMapper> potentialCodeMoveBetweenSetUpTearDownMethods = new LinkedHashSet<UMLOperationBodyMapper>();
    private Set<UMLOperationBodyMapper> movedMethodsInDifferentPositionWithinFile = new LinkedHashSet<UMLOperationBodyMapper>();

    public UMLClassBaseDiff(UMLClass originalClass, UMLClass nextClass, UMLModelDiff modelDiff) {
        super(originalClass, nextClass, modelDiff);
        this.addedImplementedInterfaces = new ArrayList<UMLType>();
        this.removedImplementedInterfaces = new ArrayList<UMLType>();
        this.consistentMethodInvocationRenamesInModel = this.findConsistentMethodInvocationRenamesInModelDiff();
    }

    @Override
    public UMLClass getOriginalClass() {
        return (UMLClass)this.originalClass;
    }

    @Override
    public UMLClass getNextClass() {
        return (UMLClass)this.nextClass;
    }

    @Override
    public void process() throws RefactoringMinerTimedOutException {
        this.processImports();
        this.processInitializers();
        this.processModifiers();
        this.processTypeParameters();
        this.processAnnotations();
        this.processEnumConstants();
        this.processInheritance();
        this.processOperations();
        this.createBodyMappers();
        this.processAnonymousClasses();
        this.checkForOperationSignatureChanges();
        this.processAttributes();
        this.checkForAttributeChanges();
        this.checkForInlinedOperations();
        this.checkForExtractedOperations();
        this.checkForExtractedOperationsWithCallsInOtherMappers();
        this.checkForMovedCodeBetweenOperations();
    }

    private void checkForMovedCodeBetweenOperations() throws RefactoringMinerTimedOutException {
        MoveCodeRefactoring ref;
        UMLOperationBodyMapper moveCodeMapper;
        LinkedHashSet<UMLOperationBodyMapper> setUpMappers = new LinkedHashSet<UMLOperationBodyMapper>();
        LinkedHashSet<UMLOperationBodyMapper> tearDownMappers = new LinkedHashSet<UMLOperationBodyMapper>();
        LinkedHashSet<UMLOperationBodyMapper> constructorMappers = new LinkedHashSet<UMLOperationBodyMapper>();
        ArrayList<UMLOperationBodyMapper> moveCodeMappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (mapper.getContainer1().hasSetUpAnnotation() && mapper.getContainer2().hasSetUpAnnotation()) {
                setUpMappers.add(mapper);
            }
            if (mapper.getContainer1().getName().equals("setUp") && mapper.getContainer2().getName().equals("setUp")) {
                setUpMappers.add(mapper);
            }
            if (mapper.getContainer1().hasTearDownAnnotation() && mapper.getContainer2().hasTearDownAnnotation()) {
                tearDownMappers.add(mapper);
            }
            if (mapper.getContainer1().getName().equals("tearDown") && mapper.getContainer2().getName().equals("tearDown")) {
                tearDownMappers.add(mapper);
            }
            if (mapper.getContainer1().isConstructor() && mapper.getContainer2().isConstructor()) {
                constructorMappers.add(mapper);
            }
            if (mapper.getAnonymousClassDiffs().size() <= 0 || mapper.nonMappedElementsT1() <= 0) continue;
            for (UMLAnonymousClassDiff anonymousClassDiff : mapper.getAnonymousClassDiffs()) {
                for (UMLOperationBodyMapper anonymousMapper : anonymousClassDiff.getOperationBodyMapperList()) {
                    if (anonymousMapper.nonMappedElementsT2() <= 0) continue;
                    UMLOperationBodyMapper moveCodeMapper2 = new UMLOperationBodyMapper(mapper, anonymousMapper, (UMLAbstractClassDiff)this);
                    int invalidMappings = 0;
                    for (AbstractCodeMapping mapping : moveCodeMapper2.getMappings()) {
                        if (!mapper.alreadyMatched1(mapping.getFragment1()) && !anonymousMapper.getNonMappedLeavesT1().contains(mapping.getFragment1()) && !anonymousMapper.getNonMappedInnerNodesT1().contains(mapping.getFragment1())) continue;
                        ++invalidMappings;
                    }
                    if (moveCodeMapper2.getMappings().size() <= invalidMappings) continue;
                    MoveCodeRefactoring ref2 = new MoveCodeRefactoring(moveCodeMapper2.getContainer1(), moveCodeMapper2.getContainer2(), moveCodeMapper2);
                    if (!moveCodeMappers.contains(moveCodeMapper2)) {
                        moveCodeMappers.add(moveCodeMapper2);
                    }
                    this.refactorings.add(ref2);
                }
            }
        }
        for (UMLOperationBodyMapper setUpMapper : setUpMappers) {
            if (setUpMapper.nonMappedElementsT2() <= 0 && setUpMapper.nonMappedElementsT1() <= 0) continue;
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                if (mapper.equals(setUpMapper) || (moveCodeMapper = new UMLOperationBodyMapper(mapper, setUpMapper, (UMLAbstractClassDiff)this)).getMappings().size() <= 0) continue;
                ref = new MoveCodeRefactoring(moveCodeMapper.getContainer1(), moveCodeMapper.getContainer2(), moveCodeMapper);
                if (!moveCodeMappers.contains(moveCodeMapper)) {
                    moveCodeMappers.add(moveCodeMapper);
                }
                this.refactorings.add(ref);
            }
        }
        for (UMLOperationBodyMapper tearDownMapper : tearDownMappers) {
            if (tearDownMapper.nonMappedElementsT2() <= 0 && tearDownMapper.nonMappedElementsT1() <= 0) continue;
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                if (mapper.equals(tearDownMapper) || (moveCodeMapper = new UMLOperationBodyMapper(mapper, tearDownMapper, (UMLAbstractClassDiff)this)).getMappings().size() <= 0) continue;
                ref = new MoveCodeRefactoring(moveCodeMapper.getContainer1(), moveCodeMapper.getContainer2(), moveCodeMapper);
                if (!moveCodeMappers.contains(moveCodeMapper)) {
                    moveCodeMappers.add(moveCodeMapper);
                }
                this.refactorings.add(ref);
            }
        }
        for (UMLOperationBodyMapper constructorMapper : constructorMappers) {
            if (constructorMapper.nonMappedElementsT2() <= 0 && constructorMapper.nonMappedElementsT1() <= 0) continue;
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                if (mapper.equals(constructorMapper)) continue;
                if (mapper.nonMappedElementsT1() > 0 && (moveCodeMapper = new UMLOperationBodyMapper(mapper, constructorMapper, (UMLAbstractClassDiff)this)).getExactMatchesWithoutLoggingStatements().size() > 0 && !this.mappingFoundInExtractedMethod(moveCodeMapper.getMappings())) {
                    ref = new MoveCodeRefactoring(moveCodeMapper.getContainer1(), moveCodeMapper.getContainer2(), moveCodeMapper);
                    if (!moveCodeMappers.contains(moveCodeMapper)) {
                        moveCodeMappers.add(moveCodeMapper);
                    }
                    this.refactorings.add(ref);
                }
                if (mapper.nonMappedElementsT2() <= 0 || (moveCodeMapper = new UMLOperationBodyMapper(constructorMapper, mapper, (UMLAbstractClassDiff)this)).getExactMatchesWithoutLoggingStatements().size() <= 0 || this.mappingFoundInExtractedMethod(moveCodeMapper.getMappings())) continue;
                ref = new MoveCodeRefactoring(moveCodeMapper.getContainer1(), moveCodeMapper.getContainer2(), moveCodeMapper);
                if (!moveCodeMappers.contains(moveCodeMapper)) {
                    moveCodeMappers.add(moveCodeMapper);
                }
                this.refactorings.add(ref);
            }
        }
        for (UMLOperation removedOperation : this.removedOperations) {
            if (removedOperation.hasSetUpAnnotation() || removedOperation.hasTearDownAnnotation() || removedOperation.getName().equals("setUp") || removedOperation.getName().equals("tearDown")) {
                for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                    if (mapper.nonMappedElementsT2() <= 0 || (moveCodeMapper = new UMLOperationBodyMapper(removedOperation, mapper, (UMLAbstractClassDiff)this)).getMappings().size() <= 0) continue;
                    ref = new MoveCodeRefactoring(moveCodeMapper.getContainer1(), moveCodeMapper.getContainer2(), moveCodeMapper);
                    if (!moveCodeMappers.contains(moveCodeMapper)) {
                        moveCodeMappers.add(moveCodeMapper);
                    }
                    this.refactorings.add(ref);
                }
                continue;
            }
            if (!removedOperation.isConstructor()) continue;
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                if (mapper.nonMappedElementsT2() <= 0 || (moveCodeMapper = new UMLOperationBodyMapper(removedOperation, mapper, (UMLAbstractClassDiff)this)).mappingsWithoutBlocks() <= 2) continue;
                ref = new MoveCodeRefactoring(moveCodeMapper.getContainer1(), moveCodeMapper.getContainer2(), moveCodeMapper);
                if (!moveCodeMappers.contains(moveCodeMapper)) {
                    moveCodeMappers.add(moveCodeMapper);
                }
                this.refactorings.add(ref);
            }
        }
        for (UMLOperation addedOperation : this.addedOperations) {
            if (!addedOperation.hasSetUpAnnotation() && !addedOperation.hasTearDownAnnotation() && !addedOperation.getName().equals("setUp") && !addedOperation.getName().equals("tearDown")) continue;
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                if (mapper.nonMappedElementsT1() <= 0 || (moveCodeMapper = new UMLOperationBodyMapper(mapper, addedOperation, (UMLAbstractClassDiff)this)).getMappings().size() <= 0) continue;
                ref = new MoveCodeRefactoring(moveCodeMapper.getContainer1(), moveCodeMapper.getContainer2(), moveCodeMapper);
                if (!moveCodeMappers.contains(moveCodeMapper)) {
                    moveCodeMappers.add(moveCodeMapper);
                }
                this.refactorings.add(ref);
            }
        }
        for (UMLOperationBodyMapper moveCodeMapper3 : this.potentialCodeMoveBetweenSetUpTearDownMethods) {
            if (moveCodeMapper3.getMappings().size() <= 0) continue;
            MoveCodeRefactoring ref3 = new MoveCodeRefactoring(moveCodeMapper3.getContainer1(), moveCodeMapper3.getContainer2(), moveCodeMapper3);
            if (!moveCodeMappers.contains(moveCodeMapper3)) {
                moveCodeMappers.add(moveCodeMapper3);
            }
            this.refactorings.add(ref3);
        }
        MappingOptimizer optimizer = new MappingOptimizer(this);
        optimizer.optimizeDuplicateMappingsForMoveCode(moveCodeMappers, this.refactorings);
    }

    private boolean mappingFoundInExtractedMethod(Set<AbstractCodeMapping> mappings) {
        for (Refactoring r : this.refactorings) {
            if (!(r instanceof ExtractOperationRefactoring)) continue;
            ExtractOperationRefactoring extract = (ExtractOperationRefactoring)r;
            for (AbstractCodeMapping newMapping : mappings) {
                for (AbstractCodeMapping oldMapping : extract.getBodyMapper().getMappings()) {
                    if (!newMapping.getFragment1().equals(oldMapping.getFragment1())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processTypeParameters() {
        this.typeParameterDiffList = new UMLTypeParameterListDiff(this.getOriginalClass().getTypeParameters(), this.getNextClass().getTypeParameters());
    }

    private void processImports() {
        if (this.originalClass.isTopLevel() && this.nextClass.isTopLevel()) {
            this.importDiffList = new UMLImportListDiff(this.originalClass.getImportedTypes(), this.nextClass.getImportedTypes());
        }
    }

    public boolean hasBothAddedAndRemovedImports() {
        if (this.importDiffList != null) {
            return this.importDiffList.getAddedImports().size() > 0 && this.importDiffList.getRemovedImports().size() > 0;
        }
        return false;
    }

    public void findImportChanges(String nameBefore, String nameAfter) {
        if (this.importDiffList != null) {
            this.importDiffList.findImportChanges(nameBefore, nameAfter);
        }
    }

    public void findImportChanges(UMLType typeBefore, UMLType typeAfter) {
        if (this.importDiffList != null) {
            this.importDiffList.findImportChanges(typeBefore, typeAfter);
        }
    }

    public UMLImportListDiff getImportDiffList() {
        return this.importDiffList;
    }

    public UMLAnnotationListDiff getAnnotationListDiff() {
        return this.annotationListDiff;
    }

    public UMLTypeParameterListDiff getTypeParameterDiffList() {
        return this.typeParameterDiffList;
    }

    protected void processInitializers() throws RefactoringMinerTimedOutException {
        block6: {
            List<UMLInitializer> initializers2;
            List<UMLInitializer> initializers1;
            block7: {
                block5: {
                    initializers1 = this.originalClass.getInitializers();
                    initializers2 = this.nextClass.getInitializers();
                    if (initializers1.size() != initializers2.size()) break block5;
                    for (int i = 0; i < initializers1.size(); ++i) {
                        UMLInitializer initializer2;
                        UMLInitializer initializer1 = initializers1.get(i);
                        UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(initializer1, initializer2 = initializers2.get(i), (UMLAbstractClassDiff)this);
                        int mappings = mapper.mappingsWithoutBlocks();
                        if (mappings <= 0) continue;
                        int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                        int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                        if ((mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) && !this.isPartOfMethodExtracted(initializer1, initializer2) && !this.isPartOfMethodInlined(initializer1, initializer2)) continue;
                        this.operationBodyMapperList.add(mapper);
                    }
                    break block6;
                }
                if (initializers1.size() >= initializers2.size()) break block7;
                for (UMLInitializer initializer1 : initializers1) {
                    for (UMLInitializer initializer2 : initializers2) {
                        UMLOperationBodyMapper mapper;
                        int mappings;
                        if (initializer1.isStatic() != initializer2.isStatic() || (mappings = (mapper = new UMLOperationBodyMapper(initializer1, initializer2, (UMLAbstractClassDiff)this)).mappingsWithoutBlocks()) <= 0) continue;
                        int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                        int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                        if ((mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) && !this.isPartOfMethodExtracted(initializer1, initializer2) && !this.isPartOfMethodInlined(initializer1, initializer2)) continue;
                        this.operationBodyMapperList.add(mapper);
                    }
                }
                break block6;
            }
            if (initializers1.size() <= initializers2.size()) break block6;
            for (UMLInitializer initializer2 : initializers2) {
                for (UMLInitializer initializer1 : initializers1) {
                    UMLOperationBodyMapper mapper;
                    int mappings;
                    if (initializer1.isStatic() != initializer2.isStatic() || (mappings = (mapper = new UMLOperationBodyMapper(initializer1, initializer2, (UMLAbstractClassDiff)this)).mappingsWithoutBlocks()) <= 0) continue;
                    int nonMappedElementsT1 = mapper.nonMappedElementsT1();
                    int nonMappedElementsT2 = mapper.nonMappedElementsT2();
                    if ((mappings <= nonMappedElementsT1 || mappings <= nonMappedElementsT2) && !this.isPartOfMethodExtracted(initializer1, initializer2) && !this.isPartOfMethodInlined(initializer1, initializer2)) continue;
                    this.operationBodyMapperList.add(mapper);
                }
            }
        }
    }

    private void processModifiers() {
        Refactoring refactoring;
        if (!this.originalClass.getVisibility().equals((Object)this.nextClass.getVisibility())) {
            this.setVisibilityChanged(true);
            this.setOldVisibility(this.originalClass.getVisibility());
            this.setNewVisibility(this.nextClass.getVisibility());
            refactoring = new ChangeClassAccessModifierRefactoring(this.oldVisibility, this.newVisibility, this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
        if (!this.originalClass.isInterface() && !this.nextClass.isInterface() && this.originalClass.isAbstract() != this.nextClass.isAbstract()) {
            this.setAbstractionChanged(true);
            this.setOldAbstraction(this.originalClass.isAbstract());
            this.setNewAbstraction(this.nextClass.isAbstract());
            if (this.nextClass.isAbstract()) {
                refactoring = new AddClassModifierRefactoring("abstract", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            } else if (this.originalClass.isAbstract()) {
                refactoring = new RemoveClassModifierRefactoring("abstract", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            }
        }
        if (this.originalClass.isFinal() != this.nextClass.isFinal()) {
            this.finalChanged = true;
            if (this.nextClass.isFinal()) {
                refactoring = new AddClassModifierRefactoring("final", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            } else if (this.originalClass.isFinal()) {
                refactoring = new RemoveClassModifierRefactoring("final", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            }
        }
        if (this.originalClass.isStatic() != this.nextClass.isStatic()) {
            this.staticChanged = true;
            if (this.nextClass.isStatic()) {
                refactoring = new AddClassModifierRefactoring("static", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            } else if (this.originalClass.isStatic()) {
                refactoring = new RemoveClassModifierRefactoring("static", this.originalClass, this.nextClass);
                this.refactorings.add(refactoring);
            }
        }
    }

    private void processAnnotations() {
        Refactoring refactoring;
        this.annotationListDiff = new UMLAnnotationListDiff(this.originalClass.getAnnotations(), this.nextClass.getAnnotations());
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddClassAnnotationRefactoring(annotation, this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveClassAnnotationRefactoring(annotation, this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyClassAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), this.originalClass, this.nextClass);
            this.refactorings.add(refactoring);
        }
    }

    public UMLOperationBodyMapper findMapperWithMatchingSignatures(UMLOperation operation1, UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (mapper.getOperation1() == null || !mapper.getOperation1().equalSignature(operation1) || mapper.getOperation2() == null || !mapper.getOperation2().equalSignature(operation2)) continue;
            return mapper;
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    public Set<MethodInvocationReplacement> findMethodInvocationReplacementWithMatchingSignatures(UMLOperation operation1, UMLOperation operation2) {
        LinkedHashSet<MethodInvocationReplacement> replacements = new LinkedHashSet<MethodInvocationReplacement>();
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            for (AbstractCodeMapping mapping : mapper.getMappings()) {
                if (mapping.isExact()) continue;
                ArrayList<AbstractCall> methodInvocations1 = new ArrayList<AbstractCall>(mapping.getFragment1().getMethodInvocations());
                ArrayList<AbstractCall> methodInvocations2 = new ArrayList<AbstractCall>(mapping.getFragment2().getMethodInvocations());
                LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(methodInvocations1);
                intersection.retainAll(methodInvocations2);
                methodInvocations1.removeAll(intersection);
                methodInvocations2.removeAll(intersection);
                if (methodInvocations1.size() != methodInvocations2.size()) continue;
                Object matchedCallToOperation1 = null;
                for (Object call : methodInvocations1) {
                    if (!((AbstractCall)call).matchesOperation(operation1, mapper.getContainer1(), this, this.modelDiff)) continue;
                    matchedCallToOperation1 = call;
                    break;
                }
                AbstractCall matchedCallToOperation2 = null;
                if (matchedCallToOperation1 != null) {
                    Object call;
                    call = methodInvocations2.iterator();
                    while (call.hasNext()) {
                        AbstractCall call2 = (AbstractCall)call.next();
                        if (!call2.matchesOperation(operation2, mapper.getContainer2(), this, this.modelDiff)) continue;
                        matchedCallToOperation2 = call2;
                        break;
                    }
                }
                if (matchedCallToOperation1 != null && matchedCallToOperation2 != null) {
                    replacements.add(new MethodInvocationReplacement(((AbstractCall)matchedCallToOperation1).actualString(), matchedCallToOperation2.actualString(), (AbstractCall)matchedCallToOperation1, matchedCallToOperation2, Replacement.ReplacementType.METHOD_INVOCATION));
                    continue;
                }
                if (matchedCallToOperation1 == null && matchedCallToOperation2 == null) continue;
                int index = 0;
                if (matchedCallToOperation1 != null) {
                    index = methodInvocations1.indexOf(matchedCallToOperation1);
                } else if (matchedCallToOperation2 != null) {
                    index = methodInvocations2.indexOf(matchedCallToOperation2);
                }
                replacements.add(new MethodInvocationReplacement(((AbstractCall)methodInvocations1.get(index)).actualString(), ((AbstractCall)methodInvocations2.get(index)).actualString(), (AbstractCall)methodInvocations1.get(index), (AbstractCall)methodInvocations2.get(index), Replacement.ReplacementType.METHOD_INVOCATION));
            }
        }
        return replacements;
    }

    public UMLOperationBodyMapper findMapperWithMatchingSignature2(UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (mapper.getOperation2() == null || !mapper.getOperation2().equalSignature(operation2)) continue;
            return mapper;
        }
        return null;
    }

    public Set<UMLType> nextClassCommonInterfaces(UMLClassBaseDiff other) {
        LinkedHashSet<UMLType> common = new LinkedHashSet<UMLType>(this.nextClass.getImplementedInterfaces());
        common.retainAll(other.nextClass.getImplementedInterfaces());
        return common;
    }

    @Override
    protected void checkForAttributeChanges() throws RefactoringMinerTimedOutException {
    }

    @Override
    protected void createBodyMappers() throws RefactoringMinerTimedOutException {
    }

    protected void processAnonymousClasses() {
        for (UMLAnonymousClass umlAnonymousClass : this.originalClass.getAnonymousClassList()) {
            if (this.nextClass.containsAnonymousWithSameAttributesAndOperations(umlAnonymousClass)) continue;
            this.removedAnonymousClasses.add(umlAnonymousClass);
        }
        for (UMLAnonymousClass umlAnonymousClass : this.nextClass.getAnonymousClassList()) {
            if (this.originalClass.containsAnonymousWithSameAttributesAndOperations(umlAnonymousClass)) continue;
            this.addedAnonymousClasses.add(umlAnonymousClass);
        }
    }

    protected void processEnumConstants() throws RefactoringMinerTimedOutException {
        Pair pair;
        UMLEnumConstantDiff enumConstantDiff;
        UMLEnumConstant matchingEnumConstant;
        for (UMLEnumConstant enumConstant : this.originalClass.getEnumConstants()) {
            matchingEnumConstant = this.nextClass.containsEnumConstant(enumConstant);
            if (matchingEnumConstant == null) {
                this.removedEnumConstants.add(enumConstant);
                continue;
            }
            enumConstantDiff = new UMLEnumConstantDiff(enumConstant, matchingEnumConstant, this, this.modelDiff);
            if (!enumConstantDiff.isEmpty()) {
                this.refactorings.addAll(enumConstantDiff.getRefactorings());
                this.enumConstantDiffList.add(enumConstantDiff);
                continue;
            }
            pair = Pair.of((Object)enumConstant, (Object)matchingEnumConstant);
            if (this.commonEnumConstants.contains(pair)) continue;
            this.commonEnumConstants.add(pair);
            if (!enumConstantDiff.getAnonymousClassDiff().isPresent()) continue;
            this.enumConstantDiffList.add(enumConstantDiff);
        }
        for (UMLEnumConstant enumConstant : this.nextClass.getEnumConstants()) {
            matchingEnumConstant = this.originalClass.containsEnumConstant(enumConstant);
            if (matchingEnumConstant == null) {
                this.addedEnumConstants.add(enumConstant);
                continue;
            }
            enumConstantDiff = new UMLEnumConstantDiff(matchingEnumConstant, enumConstant, this, this.modelDiff);
            if (!enumConstantDiff.isEmpty()) {
                this.refactorings.addAll(enumConstantDiff.getRefactorings());
                this.enumConstantDiffList.add(enumConstantDiff);
                continue;
            }
            pair = Pair.of((Object)matchingEnumConstant, (Object)enumConstant);
            if (this.commonEnumConstants.contains(pair)) continue;
            this.commonEnumConstants.add(pair);
            if (!enumConstantDiff.getAnonymousClassDiff().isPresent()) continue;
            this.enumConstantDiffList.add(enumConstantDiff);
        }
    }

    protected void processAttributes() throws RefactoringMinerTimedOutException {
        Pair pair;
        UMLAttributeDiff attributeDiff;
        UMLAttribute attributeWithTheSameName;
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            attributeWithTheSameName = this.nextClass.attributeWithTheSameNameIgnoringChangedType(attribute);
            if (attributeWithTheSameName == null) {
                this.removedAttributes.add(attribute);
                continue;
            }
            if (this.attributeDiffListContainsAttribute(attribute, attributeWithTheSameName)) continue;
            attributeDiff = new UMLAttributeDiff(attribute, attributeWithTheSameName, this, this.modelDiff);
            if (!attributeDiff.isEmpty()) {
                this.refactorings.addAll(attributeDiff.getRefactorings());
                if (this.attributeDiffList.contains(attributeDiff)) continue;
                this.attributeDiffList.add(attributeDiff);
                continue;
            }
            pair = Pair.of((Object)attribute, (Object)attributeWithTheSameName);
            if (!this.commonAtrributes.contains(pair)) {
                this.commonAtrributes.add(pair);
            }
            if (!attributeDiff.encapsulated()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
        }
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            attributeWithTheSameName = this.originalClass.attributeWithTheSameNameIgnoringChangedType(attribute);
            if (attributeWithTheSameName == null) {
                this.addedAttributes.add(attribute);
                continue;
            }
            if (this.attributeDiffListContainsAttribute(attributeWithTheSameName, attribute)) continue;
            attributeDiff = new UMLAttributeDiff(attributeWithTheSameName, attribute, this, this.modelDiff);
            if (!attributeDiff.isEmpty()) {
                this.refactorings.addAll(attributeDiff.getRefactorings());
                if (this.attributeDiffList.contains(attributeDiff)) continue;
                this.attributeDiffList.add(attributeDiff);
                continue;
            }
            pair = Pair.of((Object)attributeWithTheSameName, (Object)attribute);
            if (!this.commonAtrributes.contains(pair)) {
                this.commonAtrributes.add(pair);
            }
            if (!attributeDiff.encapsulated()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
        }
    }

    protected void processOperations() throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper mapper;
        UMLOperation operationWithTheSameSignature;
        for (UMLOperation operation : this.originalClass.getOperations()) {
            operationWithTheSameSignature = this.nextClass.operationWithTheSameSignatureIgnoringChangedTypes(operation);
            if (operationWithTheSameSignature == null) {
                this.removedOperations.add(operation);
                continue;
            }
            if (this.mapperListContainsOperation(operation, operationWithTheSameSignature)) continue;
            mapper = new UMLOperationBodyMapper(operation, operationWithTheSameSignature, (UMLAbstractClassDiff)this);
            this.operationBodyMapperList.add(mapper);
        }
        for (UMLOperation operation : this.nextClass.getOperations()) {
            operationWithTheSameSignature = this.originalClass.operationWithTheSameSignatureIgnoringChangedTypes(operation);
            if (operationWithTheSameSignature == null) {
                this.addedOperations.add(operation);
                continue;
            }
            if (this.mapperListContainsOperation(operationWithTheSameSignature, operation)) continue;
            mapper = new UMLOperationBodyMapper(operationWithTheSameSignature, operation, (UMLAbstractClassDiff)this);
            this.operationBodyMapperList.add(mapper);
        }
    }

    private boolean attributeDiffListContainsAttribute(UMLAttribute attribute1, UMLAttribute attribute2) {
        for (UMLAttributeDiff diff : this.attributeDiffList) {
            if (!diff.getRemovedAttribute().equals(attribute1) && !diff.getAddedAttribute().equals(attribute2)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String className) {
        return this.originalClass.getName().equals(className) || this.nextClass.getName().equals(className);
    }

    public boolean matches(UMLType type) {
        return this.originalClass.getName().endsWith("." + type.getClassType()) || this.nextClass.getName().endsWith("." + type.getClassType());
    }

    public boolean isInnerClassMove(UMLClassBaseDiff classDiff) {
        return this.originalClass.isInnerClass(classDiff.originalClass) && this.nextClass.isInnerClass(classDiff.nextClass);
    }

    public boolean nextClassImportsType(String targetClass) {
        return this.nextClass.importsType(targetClass);
    }

    public boolean originalClassImportsType(String targetClass) {
        return this.originalClass.importsType(targetClass);
    }

    public List<UMLAttribute> nextClassAttributesOfType(String targetClass) {
        return this.nextClass.attributesOfType(targetClass);
    }

    public List<UMLAttribute> originalClassAttributesOfType(String targetClass) {
        return this.originalClass.attributesOfType(targetClass);
    }

    private void reportAddedImplementedInterface(UMLType implementedInterface) {
        this.addedImplementedInterfaces.add(implementedInterface);
    }

    private void reportRemovedImplementedInterface(UMLType implementedInterface) {
        this.removedImplementedInterfaces.add(implementedInterface);
    }

    private void setVisibilityChanged(boolean visibilityChanged) {
        this.visibilityChanged = visibilityChanged;
    }

    private void setOldVisibility(Visibility oldVisibility) {
        this.oldVisibility = oldVisibility;
    }

    private void setNewVisibility(Visibility newVisibility) {
        this.newVisibility = newVisibility;
    }

    private void setAbstractionChanged(boolean abstractionChanged) {
        this.abstractionChanged = abstractionChanged;
    }

    private void setOldAbstraction(boolean oldAbstraction) {
        this.oldAbstraction = oldAbstraction;
    }

    private void setNewAbstraction(boolean newAbstraction) {
        this.newAbstraction = newAbstraction;
    }

    private void setSuperclassChanged(boolean superclassChanged) {
        this.superclassChanged = superclassChanged;
    }

    private void setOldSuperclass(UMLType oldSuperclass) {
        this.oldSuperclass = oldSuperclass;
    }

    private void setNewSuperclass(UMLType newSuperclass) {
        this.newSuperclass = newSuperclass;
    }

    public UMLType getSuperclass() {
        if (!this.superclassChanged && this.oldSuperclass != null && this.newSuperclass != null) {
            return this.oldSuperclass;
        }
        return null;
    }

    public UMLType getOldSuperclass() {
        return this.oldSuperclass;
    }

    public UMLType getNewSuperclass() {
        return this.newSuperclass;
    }

    public List<UMLType> getAddedImplementedInterfaces() {
        return this.addedImplementedInterfaces;
    }

    public List<UMLType> getRemovedImplementedInterfaces() {
        return this.removedImplementedInterfaces;
    }

    public boolean containsOperationWithTheSameSignatureInOriginalClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.originalClass.getOperations()) {
            if (!originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithTheSameSignatureInNextClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.nextClass.getOperations()) {
            if (!originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public boolean containsConcreteOperationWithTheSameSignatureInNextClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.nextClass.getOperations()) {
            if (originalOperation.getBody() == null || !originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public UMLOperation containsAddedOperationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation addedOperation : this.addedOperations) {
            if (!addedOperation.equalSignature(operation)) continue;
            return addedOperation;
        }
        return null;
    }

    public UMLOperation containsRemovedOperationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation removedOperation : this.removedOperations) {
            if (!removedOperation.equalSignature(operation)) continue;
            return removedOperation;
        }
        return null;
    }

    public List<UMLOperation> removedOperationWithTheSameName(UMLOperation operation) {
        ArrayList<UMLOperation> matchingOperations = new ArrayList<UMLOperation>();
        for (UMLOperation removedOperation : this.removedOperations) {
            if (!removedOperation.getName().equals(operation.getName())) continue;
            matchingOperations.add(removedOperation);
        }
        return matchingOperations;
    }

    public UMLAttribute containsAddedAttributeWithTheSameSignature(UMLAttribute attribute) {
        for (UMLAttribute addedAttribute : this.addedAttributes) {
            if (!addedAttribute.equalsIgnoringChangedVisibility(attribute)) continue;
            return addedAttribute;
        }
        return null;
    }

    public UMLAttribute containsRemovedAttributeWithTheSameSignature(UMLAttribute attribute) {
        for (UMLAttribute removedAttribute : this.removedAttributes) {
            if (!removedAttribute.equalsIgnoringChangedVisibility(attribute)) continue;
            return removedAttribute;
        }
        return null;
    }

    private void processInheritance() {
        if (this.originalClass.getSuperclass() != null && this.nextClass.getSuperclass() != null) {
            if (!this.originalClass.getSuperclass().equals(this.nextClass.getSuperclass())) {
                this.setSuperclassChanged(true);
            }
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        } else if (this.originalClass.getSuperclass() != null && this.nextClass.getSuperclass() == null) {
            this.setSuperclassChanged(true);
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        } else if (this.originalClass.getSuperclass() == null && this.nextClass.getSuperclass() != null) {
            this.setSuperclassChanged(true);
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        }
        for (UMLType implementedInterface : this.originalClass.getImplementedInterfaces()) {
            if (this.nextClass.getImplementedInterfaces().contains(implementedInterface)) continue;
            this.reportRemovedImplementedInterface(implementedInterface);
        }
        for (UMLType implementedInterface : this.nextClass.getImplementedInterfaces()) {
            if (this.originalClass.getImplementedInterfaces().contains(implementedInterface)) continue;
            this.reportAddedImplementedInterface(implementedInterface);
        }
    }

    private int computeAbsoluteDifferenceInPositionWithinClass(UMLOperation removedOperation, UMLOperation addedOperation) {
        int index1 = this.originalClass.getOperations().indexOf(removedOperation);
        int index2 = this.nextClass.getOperations().indexOf(addedOperation);
        for (CandidateSplitMethodRefactoring candidate : this.candidateMethodSplits) {
            int splitMethodsBefore = 0;
            for (VariableDeclarationContainer splitMethod : candidate.getSplitMethods()) {
                int index = this.nextClass.getOperations().indexOf(splitMethod);
                if (index == -1 || index >= index2) continue;
                ++splitMethodsBefore;
            }
            if (splitMethodsBefore != candidate.getSplitMethods().size()) continue;
            index2 -= splitMethodsBefore - 1;
        }
        return Math.abs(index1 - index2);
    }

    private void checkForOperationSignatureChanges() throws RefactoringMinerTimedOutException {
        this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
        int initialNumberOfRemovedOperations = this.removedOperations.size();
        int initialNumberOfAddedOperations = this.addedOperations.size();
        if (this.removedOperations.size() <= this.addedOperations.size()) {
            LinkedHashSet<VariableDeclarationContainer> removedOperationsToBeRemoved = new LinkedHashSet<VariableDeclarationContainer>();
            Iterator removedOperationIterator = this.removedOperations.iterator();
            while (removedOperationIterator.hasNext()) {
                UMLOperation removedOperation = (UMLOperation)removedOperationIterator.next();
                if (this.isCommentedOut(removedOperation)) continue;
                mapperSet = new TreeSet();
                for (UMLOperation addedOperation2 : this.addedOperations) {
                    if (this.containsMapperForOperation1(removedOperation) || this.containsMapperForOperation2(addedOperation2)) continue;
                    maxDifferenceInPosition = removedOperation.hasTestAnnotation() && addedOperation2.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : (removedOperation.hasTestAnnotation() && addedOperation2.hasParameterizedTestAnnotation() ? initialNumberOfRemovedOperations + initialNumberOfAddedOperations : Math.max(this.removedOperations.size(), this.addedOperations.size()));
                    this.updateMapperSet(mapperSet, removedOperation, addedOperation2, maxDifferenceInPosition);
                    List<UMLOperation> operationsInsideAnonymousClass = addedOperation2.getOperationsInsideAnonymousClass(this.addedAnonymousClasses);
                    for (UMLOperation operationInsideAnonymousClass : operationsInsideAnonymousClass) {
                        this.updateMapperSet(mapperSet, removedOperation, operationInsideAnonymousClass, addedOperation2, maxDifferenceInPosition);
                    }
                    if (initialNumberOfRemovedOperations < 30 || initialNumberOfAddedOperations < 30 || mapperSet.size() <= 0 || !removedOperation.getName().equals(addedOperation2.getName())) continue;
                    break;
                }
                if (mapperSet.isEmpty()) continue;
                boolean firstMapperWithIdenticalMethodName = false;
                firstMapper = (UMLOperationBodyMapper)mapperSet.first();
                if (firstMapper.getContainer1().getName().equals(firstMapper.getContainer2().getName())) {
                    firstMapperWithIdenticalMethodName = true;
                }
                matchingMergeCandidateFound = false;
                boolean matchingSplitCandidateFound = false;
                if (!firstMapperWithIdenticalMethodName) {
                    UMLOperationBodyMapper operationBodyMapper;
                    for (Object candidate : this.candidateMethodMerges) {
                        methodsWithMapper = new LinkedHashSet();
                        for (UMLOperationBodyMapper uMLOperationBodyMapper : mapperSet) {
                            if (!((CandidateMergeMethodRefactoring)candidate).getMergedMethods().contains(uMLOperationBodyMapper.getContainer1()) || !((CandidateMergeMethodRefactoring)candidate).getNewMethodAfterMerge().equals(uMLOperationBodyMapper.getContainer2())) continue;
                            ((CandidateMergeMethodRefactoring)candidate).addMapper(uMLOperationBodyMapper);
                            methodsWithMapper.add(uMLOperationBodyMapper.getContainer1());
                            matchingMergeCandidateFound = true;
                        }
                        if (!matchingMergeCandidateFound || ((CandidateMergeMethodRefactoring)candidate).getMappers().size() >= ((CandidateMergeMethodRefactoring)candidate).getMergedMethods().size()) continue;
                        for (VariableDeclarationContainer variableDeclarationContainer : ((CandidateMergeMethodRefactoring)candidate).getMergedMethods()) {
                            if (methodsWithMapper.contains(variableDeclarationContainer)) continue;
                            operationBodyMapper = new UMLOperationBodyMapper((UMLOperation)variableDeclarationContainer, (UMLOperation)((CandidateMergeMethodRefactoring)candidate).getNewMethodAfterMerge(), (UMLAbstractClassDiff)this);
                            ((CandidateMergeMethodRefactoring)candidate).addMapper(operationBodyMapper);
                        }
                    }
                    for (Object candidate : this.candidateMethodSplits) {
                        methodsWithMapper = new LinkedHashSet();
                        for (UMLOperationBodyMapper uMLOperationBodyMapper : mapperSet) {
                            if (!((CandidateSplitMethodRefactoring)candidate).getSplitMethods().contains(uMLOperationBodyMapper.getContainer2()) || !((CandidateSplitMethodRefactoring)candidate).getOriginalMethodBeforeSplit().equals(uMLOperationBodyMapper.getContainer1())) continue;
                            ((CandidateSplitMethodRefactoring)candidate).addMapper(uMLOperationBodyMapper);
                            methodsWithMapper.add(uMLOperationBodyMapper.getContainer2());
                            matchingSplitCandidateFound = true;
                        }
                        if (!matchingSplitCandidateFound || ((CandidateSplitMethodRefactoring)candidate).getMappers().size() >= ((CandidateSplitMethodRefactoring)candidate).getSplitMethods().size()) continue;
                        for (VariableDeclarationContainer variableDeclarationContainer : ((CandidateSplitMethodRefactoring)candidate).getSplitMethods()) {
                            if (methodsWithMapper.contains(variableDeclarationContainer)) continue;
                            operationBodyMapper = new UMLOperationBodyMapper(removedOperation, (UMLOperation)variableDeclarationContainer, (UMLAbstractClassDiff)this);
                            ((CandidateSplitMethodRefactoring)candidate).addMapper(operationBodyMapper);
                        }
                    }
                }
                if (!matchingMergeCandidateFound && !matchingSplitCandidateFound) {
                    bestMapper = this.findBestMapper(mapperSet);
                    if (bestMapper == null) continue;
                    removedOperation = bestMapper.getOperation1();
                    Iterator addedOperation4 = bestMapper.getOperation2();
                    this.addedOperations.remove(addedOperation4);
                    removedOperationIterator.remove();
                    if (!(removedOperation.getName().equals(((UMLOperation)((Object)addedOperation4)).getName()) || removedOperation.isConstructor() && ((UMLOperation)((Object)addedOperation4)).isConstructor())) {
                        Set<MethodInvocationReplacement> callReferences = this.getCallReferences(removedOperation, (UMLOperation)((Object)addedOperation4));
                        RenameOperationRefactoring rename = new RenameOperationRefactoring(bestMapper, callReferences);
                        this.refactorings.add(rename);
                    }
                    this.addOperationBodyMapper(bestMapper);
                    this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
                    continue;
                }
                Iterator<Object> addedOperationsToBeRemoved = new LinkedHashSet();
                for (Object candidate : this.candidateMethodMerges) {
                    addedOperationsToBeRemoved.add(((CandidateMergeMethodRefactoring)candidate).getNewMethodAfterMerge());
                    removedOperationsToBeRemoved.addAll(((CandidateMergeMethodRefactoring)candidate).getMergedMethods());
                    MergeOperationRefactoring merge = new MergeOperationRefactoring(((CandidateMergeMethodRefactoring)candidate).getMergedMethods(), ((CandidateMergeMethodRefactoring)candidate).getNewMethodAfterMerge(), this.getOriginalClassName(), this.getNextClassName(), ((CandidateMergeMethodRefactoring)candidate).getMappers());
                    this.refactorings.add(merge);
                    for (UMLOperationBodyMapper mapper : merge.getMappers()) {
                        mapper.computeRefactoringsWithinBody();
                        this.refactorings.addAll(mapper.getRefactoringsAfterPostProcessing());
                    }
                }
                for (Object candidate : this.candidateMethodSplits) {
                    addedOperationsToBeRemoved.addAll(((CandidateSplitMethodRefactoring)candidate).getSplitMethods());
                    removedOperationsToBeRemoved.add(((CandidateSplitMethodRefactoring)candidate).getOriginalMethodBeforeSplit());
                    SplitOperationRefactoring split = new SplitOperationRefactoring(((CandidateSplitMethodRefactoring)candidate).getOriginalMethodBeforeSplit(), ((CandidateSplitMethodRefactoring)candidate).getSplitMethods(), this.getOriginalClassName(), this.getNextClassName(), ((CandidateSplitMethodRefactoring)candidate).getMappers());
                    this.refactorings.add(split);
                    for (UMLOperationBodyMapper mapper : split.getMappers()) {
                        mapper.computeRefactoringsWithinBody();
                        this.refactorings.addAll(mapper.getRefactoringsAfterPostProcessing());
                    }
                }
                if (this.candidateMethodMerges.size() > 0 || this.candidateMethodSplits.size() > 0) {
                    removedOperationIterator.remove();
                }
                this.addedOperations.removeAll((Collection<?>)((Object)addedOperationsToBeRemoved));
            }
            this.removedOperations.removeAll(removedOperationsToBeRemoved);
        } else {
            LinkedHashSet<VariableDeclarationContainer> addedOperationsToBeRemoved = new LinkedHashSet<VariableDeclarationContainer>();
            Iterator addedOperationIterator = this.addedOperations.iterator();
            while (addedOperationIterator.hasNext()) {
                UMLOperation addedOperation = (UMLOperation)addedOperationIterator.next();
                mapperSet = new TreeSet<UMLOperationBodyMapper>();
                for (UMLOperation removedOperation : this.removedOperations) {
                    if (this.containsMapperForOperation1(removedOperation) || this.containsMapperForOperation2(addedOperation)) continue;
                    maxDifferenceInPosition = removedOperation.hasTestAnnotation() && addedOperation.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : (removedOperation.hasTestAnnotation() && addedOperation.hasParameterizedTestAnnotation() ? initialNumberOfRemovedOperations + initialNumberOfAddedOperations : Math.max(this.removedOperations.size(), this.addedOperations.size()));
                    this.updateMapperSet(mapperSet, removedOperation, addedOperation, maxDifferenceInPosition);
                    List<UMLOperation> operationsInsideAnonymousClass = addedOperation.getOperationsInsideAnonymousClass(this.addedAnonymousClasses);
                    for (UMLOperation operationInsideAnonymousClass : operationsInsideAnonymousClass) {
                        this.updateMapperSet(mapperSet, removedOperation, operationInsideAnonymousClass, addedOperation, maxDifferenceInPosition);
                    }
                    if (initialNumberOfRemovedOperations < 30 || initialNumberOfAddedOperations < 30 || mapperSet.size() <= 0 || !removedOperation.getName().equals(addedOperation.getName())) continue;
                    break;
                }
                if (mapperSet.isEmpty()) continue;
                boolean firstMapperWithIdenticalMethodName = false;
                firstMapper = (UMLOperationBodyMapper)mapperSet.first();
                if (firstMapper.getContainer1().getName().equals(firstMapper.getContainer2().getName())) {
                    firstMapperWithIdenticalMethodName = true;
                }
                matchingMergeCandidateFound = false;
                boolean matchingSplitCandidateFound = false;
                if (!firstMapperWithIdenticalMethodName) {
                    for (CandidateMergeMethodRefactoring candidate : this.candidateMethodMerges) {
                        methodsWithMapper = new LinkedHashSet<VariableDeclarationContainer>();
                        for (UMLOperationBodyMapper uMLOperationBodyMapper : mapperSet) {
                            if (!candidate.getMergedMethods().contains(uMLOperationBodyMapper.getContainer1()) || !candidate.getNewMethodAfterMerge().equals(uMLOperationBodyMapper.getContainer2())) continue;
                            candidate.addMapper(uMLOperationBodyMapper);
                            methodsWithMapper.add(uMLOperationBodyMapper.getContainer1());
                            matchingMergeCandidateFound = true;
                        }
                        if (!matchingMergeCandidateFound || candidate.getMappers().size() >= candidate.getMergedMethods().size()) continue;
                        for (VariableDeclarationContainer variableDeclarationContainer : candidate.getMergedMethods()) {
                            if (methodsWithMapper.contains(variableDeclarationContainer)) continue;
                            UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper((UMLOperation)variableDeclarationContainer, addedOperation, (UMLAbstractClassDiff)this);
                            candidate.addMapper(operationBodyMapper);
                        }
                    }
                    for (CandidateSplitMethodRefactoring candidate : this.candidateMethodSplits) {
                        methodsWithMapper = new LinkedHashSet();
                        for (UMLOperationBodyMapper uMLOperationBodyMapper : mapperSet) {
                            if (!candidate.getSplitMethods().contains(uMLOperationBodyMapper.getContainer2()) || !candidate.getOriginalMethodBeforeSplit().equals(uMLOperationBodyMapper.getContainer1())) continue;
                            candidate.addMapper(uMLOperationBodyMapper);
                            methodsWithMapper.add(uMLOperationBodyMapper.getContainer2());
                            matchingSplitCandidateFound = true;
                        }
                        if (!matchingSplitCandidateFound || candidate.getMappers().size() >= candidate.getSplitMethods().size()) continue;
                        for (VariableDeclarationContainer variableDeclarationContainer : candidate.getSplitMethods()) {
                            if (methodsWithMapper.contains(variableDeclarationContainer)) continue;
                            UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper((UMLOperation)candidate.getOriginalMethodBeforeSplit(), (UMLOperation)variableDeclarationContainer, (UMLAbstractClassDiff)this);
                            candidate.addMapper(operationBodyMapper);
                        }
                    }
                }
                if (!matchingMergeCandidateFound && !matchingSplitCandidateFound) {
                    if (addedOperation.hasParameterizedTestAnnotation()) {
                        LinkedHashSet<UMLOperationBodyMapper> filteredMapperSet = new LinkedHashSet<UMLOperationBodyMapper>();
                        List<List<String>> parameterValues = this.getParameterValues(addedOperation);
                        List<String> parameterNames = addedOperation.getParameterNameList();
                        int overallMaxMatchingTestParameters = -1;
                        for (UMLOperationBodyMapper mapper : mapperSet) {
                            int max;
                            Map<Integer, Integer> matchingTestParameters = UMLClassBaseDiff.matchParamsWithReplacements(parameterValues, parameterNames, mapper.getReplacements());
                            if (matchingTestParameters.isEmpty()) {
                                matchingTestParameters = this.matchParamsWithRemovedStatements(parameterValues, parameterNames, mapper.getNonMappedLeavesT1());
                            }
                            if ((max = matchingTestParameters.isEmpty() ? 0 : Collections.max(matchingTestParameters.values())) < 1 || overallMaxMatchingTestParameters != -1 && max != overallMaxMatchingTestParameters) continue;
                            if (max > overallMaxMatchingTestParameters) {
                                overallMaxMatchingTestParameters = max;
                            }
                            filteredMapperSet.add(mapper);
                        }
                        LinkedHashSet<UMLOperationBodyMapper> linkedHashSet = new LinkedHashSet<UMLOperationBodyMapper>();
                        int maxMappings = -1;
                        int minReplacements = Integer.MAX_VALUE;
                        for (UMLOperationBodyMapper mapper : filteredMapperSet) {
                            int replacements;
                            int mappings = mapper.getMappings().size();
                            if (mappings > maxMappings) {
                                maxMappings = mappings;
                            }
                            if ((replacements = mapper.getReplacements().size()) < minReplacements) {
                                minReplacements = replacements;
                            }
                            if (mappings == maxMappings && replacements == minReplacements) {
                                linkedHashSet.add(mapper);
                                continue;
                            }
                            if (mappings >= maxMappings || replacements != minReplacements || !mapper.getOperation1().getName().contains(mapper.getOperation2().getName())) continue;
                            linkedHashSet.add(mapper);
                        }
                        for (UMLOperationBodyMapper mapper : linkedHashSet) {
                            ParameterizeTestRefactoring refactoring = new ParameterizeTestRefactoring(mapper);
                            this.refactorings.add(refactoring);
                            UMLOperation removedOperation = mapper.getOperation1();
                            this.removedOperations.remove(removedOperation);
                        }
                        if (overallMaxMatchingTestParameters <= -1) continue;
                        addedOperationIterator.remove();
                        continue;
                    }
                    bestMapper = this.findBestMapper(mapperSet);
                    int mapperSetSize = mapperSet.size();
                    if (bestMapper != null) {
                        block25: for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenamesInModel.keySet()) {
                            UMLOperationBodyMapper uMLOperationBodyMapper = this.consistentMethodInvocationRenamesInModel.get(replacement);
                            if (!replacement.getInvokedOperationBefore().matchesOperation(bestMapper.getContainer1(), uMLOperationBodyMapper.getContainer1(), uMLOperationBodyMapper.getClassDiff(), this.modelDiff)) continue;
                            for (UMLOperation addedOperation2 : this.addedOperations) {
                                if (!replacement.getInvokedOperationAfter().matchesOperation(addedOperation2, uMLOperationBodyMapper.getContainer2(), uMLOperationBodyMapper.getClassDiff(), this.modelDiff)) continue;
                                int maxDifferenceInPosition = bestMapper.getContainer1().hasTestAnnotation() && addedOperation2.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : (bestMapper.getContainer1().hasTestAnnotation() && addedOperation2.hasParameterizedTestAnnotation() ? initialNumberOfRemovedOperations + initialNumberOfAddedOperations : Math.max(this.removedOperations.size(), this.addedOperations.size()));
                                this.updateMapperSet(mapperSet, bestMapper.getOperation1(), addedOperation2, maxDifferenceInPosition);
                                break block25;
                            }
                        }
                    }
                    if (mapperSet.size() > mapperSetSize) {
                        bestMapper = this.findBestMapper(mapperSet);
                    }
                    if (bestMapper == null) continue;
                    UMLOperation removedOperation = bestMapper.getOperation1();
                    addedOperation = bestMapper.getOperation2();
                    if (mapperSet.size() > mapperSetSize) {
                        addedOperationsToBeRemoved.add(addedOperation);
                    } else {
                        addedOperationIterator.remove();
                    }
                    this.removedOperations.remove(removedOperation);
                    if (!(removedOperation.getName().equals(addedOperation.getName()) || removedOperation.isConstructor() && addedOperation.isConstructor())) {
                        Set<MethodInvocationReplacement> callReferences = this.getCallReferences(removedOperation, addedOperation);
                        RenameOperationRefactoring renameOperationRefactoring = new RenameOperationRefactoring(bestMapper, callReferences);
                        this.refactorings.add(renameOperationRefactoring);
                    }
                    this.addOperationBodyMapper(bestMapper);
                    this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
                    continue;
                }
                LinkedHashSet<VariableDeclarationContainer> removedOperationsToBeRemoved = new LinkedHashSet<VariableDeclarationContainer>();
                for (Object candidate : this.candidateMethodMerges) {
                    addedOperationsToBeRemoved.add(((CandidateMergeMethodRefactoring)candidate).getNewMethodAfterMerge());
                    removedOperationsToBeRemoved.addAll(((CandidateMergeMethodRefactoring)candidate).getMergedMethods());
                    MergeOperationRefactoring merge = new MergeOperationRefactoring(((CandidateMergeMethodRefactoring)candidate).getMergedMethods(), ((CandidateMergeMethodRefactoring)candidate).getNewMethodAfterMerge(), this.getOriginalClassName(), this.getNextClassName(), ((CandidateMergeMethodRefactoring)candidate).getMappers());
                    this.refactorings.add(merge);
                    for (UMLOperationBodyMapper mapper : merge.getMappers()) {
                        mapper.computeRefactoringsWithinBody();
                        this.refactorings.addAll(mapper.getRefactoringsAfterPostProcessing());
                    }
                }
                for (Object candidate : this.candidateMethodSplits) {
                    addedOperationsToBeRemoved.addAll(((CandidateSplitMethodRefactoring)candidate).getSplitMethods());
                    removedOperationsToBeRemoved.add(((CandidateSplitMethodRefactoring)candidate).getOriginalMethodBeforeSplit());
                    SplitOperationRefactoring split = new SplitOperationRefactoring(((CandidateSplitMethodRefactoring)candidate).getOriginalMethodBeforeSplit(), ((CandidateSplitMethodRefactoring)candidate).getSplitMethods(), this.getOriginalClassName(), this.getNextClassName(), ((CandidateSplitMethodRefactoring)candidate).getMappers());
                    this.refactorings.add(split);
                    for (UMLOperationBodyMapper mapper : split.getMappers()) {
                        mapper.computeRefactoringsWithinBody();
                        this.refactorings.addAll(mapper.getRefactoringsAfterPostProcessing());
                    }
                }
                if (this.candidateMethodMerges.size() > 0 || this.candidateMethodSplits.size() > 0) {
                    addedOperationIterator.remove();
                }
                this.removedOperations.removeAll(removedOperationsToBeRemoved);
            }
            this.addedOperations.removeAll(addedOperationsToBeRemoved);
        }
        Iterator removedOperationIterator = this.removedOperations.iterator();
        while (removedOperationIterator.hasNext()) {
            UMLOperation removedOperation = (UMLOperation)removedOperationIterator.next();
            AbstractCall removedOperationInvocation = removedOperation.isDelegate();
            if (removedOperationInvocation == null) continue;
            Iterator addedOperationIterator = this.addedOperations.iterator();
            block32: while (addedOperationIterator.hasNext()) {
                UMLOperation addedOperation = (UMLOperation)addedOperationIterator.next();
                AbstractCall addedOperationInvocation = addedOperation.isDelegate();
                if (addedOperationInvocation == null) continue;
                for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                    if (!removedOperationInvocation.matchesOperation(mapper.getContainer1(), removedOperation, this, this.modelDiff) || !addedOperationInvocation.matchesOperation(mapper.getContainer2(), addedOperation, this, this.modelDiff) || !removedOperation.getParameterTypeList().equals(addedOperation.getParameterTypeList())) continue;
                    addedOperationIterator.remove();
                    removedOperationIterator.remove();
                    UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, this);
                    this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                    if (removedOperation.getName().equals(addedOperation.getName()) || removedOperation.isConstructor() && addedOperation.isConstructor()) continue block32;
                    RenameOperationRefactoring rename = new RenameOperationRefactoring(removedOperation, addedOperation);
                    this.refactorings.add(rename);
                    continue block32;
                }
            }
        }
    }

    private List<List<String>> getParameterValues(UMLOperation addedOperation) {
        ArrayList<List<String>> parameterValues = new ArrayList<List<String>>();
        for (UMLAnnotation annotation : addedOperation.getAnnotations()) {
            try {
                List<List<String>> testParameters = SourceAnnotation.create(annotation, addedOperation, this.modelDiff.getChildModel()).getTestParameters();
                parameterValues.addAll(testParameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return parameterValues;
    }

    private Map<Integer, Integer> matchParamsWithRemovedStatements(List<List<String>> parameterValues, List<String> parameterNames, List<AbstractCodeFragment> nonMappedLeavesT1) {
        LinkedHashMap<Integer, Integer> matchingTestParameters = new LinkedHashMap<Integer, Integer>();
        for (AbstractCodeFragment fragment : nonMappedLeavesT1) {
            if (!(fragment instanceof StatementObject) || !fragment.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT)) continue;
            StatementObject statement = (StatementObject)fragment;
            List<VariableDeclaration> declarations = statement.getVariableDeclarations();
            assert (declarations.size() == 1);
            String variableInitialValue = declarations.get(0).getInitializer().getString();
            for (int parameterIndex = 0; parameterIndex < parameterValues.size(); ++parameterIndex) {
                for (String value : parameterValues.get(parameterIndex)) {
                    if (!variableInitialValue.contains(UMLClassBaseDiff.sanitizeStringLiteral(value))) continue;
                    int previousValue = matchingTestParameters.getOrDefault(parameterIndex, 0);
                    matchingTestParameters.put(parameterIndex, previousValue + 1);
                }
            }
        }
        return matchingTestParameters;
    }

    private static Map<Integer, Integer> matchParamsWithReplacements(List<List<String>> testParameters, List<String> parameterNames, Set<Replacement> replacements) {
        LinkedHashMap<Integer, Integer> matchingTestParameters = new LinkedHashMap<Integer, Integer>();
        for (Replacement r : replacements) {
            if (!parameterNames.contains(r.getAfter())) continue;
            String paramsWithoutDoubleQuotes = UMLClassBaseDiff.sanitizeStringLiteral(r.getBefore());
            for (int parameterRow = 0; parameterRow < testParameters.size(); ++parameterRow) {
                if (!testParameters.get(parameterRow).contains(paramsWithoutDoubleQuotes)) continue;
                Integer previousValue = matchingTestParameters.getOrDefault(parameterRow, 0);
                matchingTestParameters.put(parameterRow, previousValue + 1);
            }
        }
        return matchingTestParameters;
    }

    private static String sanitizeStringLiteral(String expression) {
        if (expression.startsWith("\"") && expression.endsWith("\"")) {
            return expression.substring(1, expression.length() - 1);
        }
        if (expression.endsWith(".class")) {
            return expression.substring(0, expression.lastIndexOf(".class"));
        }
        if (expression.contains(".")) {
            return expression.substring(expression.lastIndexOf(46) + 1);
        }
        return expression;
    }

    private void extractParametersFromCsvFile(List<List<String>> testParameters, String csvFile) {
        try {
            List<String> tests = this.readCsvFile(csvFile);
            for (String test : tests) {
                List<String> parameters = UMLClassBaseDiff.extractParametersFromCsv(test);
                testParameters.add(parameters);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> readCsvFile(String csvFile) throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(csvFile));
        String line = br.readLine();
        while (line != null) {
            parameters.add(line);
            line = br.readLine();
        }
        br.close();
        return parameters;
    }

    private static List<String> extractParametersFromCsv(String s) {
        String[] tokens;
        ArrayList<String> parameters = new ArrayList<String>();
        for (String token : tokens = s.split(",")) {
            String trimmed = token.trim();
            if (trimmed.startsWith("\"")) {
                trimmed = trimmed.substring(1, trimmed.length());
            }
            if (trimmed.endsWith("\"")) {
                trimmed = trimmed.substring(0, trimmed.length() - 1);
            }
            parameters.add(trimmed);
        }
        return parameters;
    }

    private boolean isCommentedOut(UMLOperation removedOperation) {
        List<UMLComment> nextClassComments = this.nextClass.getComments();
        for (UMLComment nextClassComment : nextClassComments) {
            String comment = nextClassComment.getText();
            boolean commentedOut = false;
            Scanner scanner = new Scanner(comment);
            int openCurlyBrackets = 0;
            int closeCurlyBrackets = 0;
            String methodSignature = null;
            int bodyStartOffset = -1;
            while (scanner.hasNextLine()) {
                int methodBodyHashCode;
                String methodBody;
                ASTNode methodBodyBlock;
                String line = scanner.nextLine();
                if (line.contains("/*")) {
                    line = line.replace("/*", "");
                }
                if (line.contains("//")) {
                    line = line.replace("//", "");
                }
                if (Visitor.METHOD_SIGNATURE_PATTERN.matcher(line = line.trim()).matches()) {
                    methodSignature = line;
                    openCurlyBrackets = 0;
                    closeCurlyBrackets = 0;
                }
                for (int i = 0; i < line.length(); ++i) {
                    if (line.charAt(i) == '{') {
                        if (methodSignature != null && openCurlyBrackets == 0) {
                            int indexOfSignature = comment.indexOf(methodSignature);
                            String commentSubString = comment.substring(indexOfSignature, comment.length());
                            int indexOfOpenCurlyBracket = commentSubString.indexOf("{");
                            bodyStartOffset = indexOfSignature + indexOfOpenCurlyBracket;
                        }
                        ++openCurlyBrackets;
                        continue;
                    }
                    if (line.charAt(i) != '}') continue;
                    ++closeCurlyBrackets;
                }
                if (openCurlyBrackets <= 0 || openCurlyBrackets != closeCurlyBrackets || methodSignature == null) continue;
                int indexOfSignature = comment.indexOf(methodSignature);
                String commentSubString = comment.substring(indexOfSignature, comment.length());
                int indexOfCloseCurlyBracket = -1;
                int occurrences = 0;
                for (int i = 0; i < commentSubString.length(); ++i) {
                    if (commentSubString.charAt(i) != '}') continue;
                    indexOfCloseCurlyBracket = i;
                    if (++occurrences == closeCurlyBrackets) break;
                }
                int bodyEndOffset = indexOfSignature + indexOfCloseCurlyBracket;
                if (bodyStartOffset < 0 || comment.charAt(bodyStartOffset) != '{' || bodyEndOffset < 0 || comment.charAt(bodyEndOffset) != '}' || (methodBodyBlock = UMLModelASTReader.processBlock(methodBody = comment.substring(bodyStartOffset, bodyEndOffset + 1))) == null || (methodBodyHashCode = Visitor.stringify(methodBodyBlock).hashCode()) != removedOperation.getBodyHashCode()) continue;
                commentedOut = true;
                break;
            }
            scanner.close();
            if (!commentedOut) continue;
            return true;
        }
        return false;
    }

    private Set<MethodInvocationReplacement> getCallReferences(UMLOperation removedOperation, UMLOperation addedOperation) {
        LinkedHashSet<MethodInvocationReplacement> callReferences = new LinkedHashSet<MethodInvocationReplacement>();
        for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
            UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
            if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff)) continue;
            callReferences.add(replacement);
        }
        return callReferences;
    }

    private Map<MethodInvocationReplacement, UMLOperationBodyMapper> findConsistentMethodInvocationRenamesInModelDiff() {
        HashMap<MethodInvocationReplacement, UMLOperationBodyMapper> map = new HashMap<MethodInvocationReplacement, UMLOperationBodyMapper>();
        if (this.modelDiff != null) {
            LinkedHashSet allConsistentMethodInvocationRenames = new LinkedHashSet();
            LinkedHashSet allInconsistentMethodInvocationRenames = new LinkedHashSet();
            for (UMLClassDiff classDiff : this.modelDiff.getCommonClassDiffList()) {
                for (UMLOperationBodyMapper bodyMapper : classDiff.getOperationBodyMapperList()) {
                    Set<MethodInvocationReplacement> methodInvocationRenames = bodyMapper.getMethodInvocationRenameReplacements();
                    for (MethodInvocationReplacement replacement : methodInvocationRenames) {
                        map.put(replacement, bodyMapper);
                    }
                    ConsistentReplacementDetector.updateRenames(allConsistentMethodInvocationRenames, allInconsistentMethodInvocationRenames, methodInvocationRenames);
                }
            }
            map.keySet().removeAll(allInconsistentMethodInvocationRenames);
        }
        return map;
    }

    private Map<MethodInvocationReplacement, UMLOperationBodyMapper> findConsistentMethodInvocationRenames() {
        HashMap<MethodInvocationReplacement, UMLOperationBodyMapper> map = new HashMap<MethodInvocationReplacement, UMLOperationBodyMapper>();
        LinkedHashSet allConsistentMethodInvocationRenames = new LinkedHashSet();
        LinkedHashSet allInconsistentMethodInvocationRenames = new LinkedHashSet();
        for (UMLOperationBodyMapper bodyMapper : this.operationBodyMapperList) {
            Set<MethodInvocationReplacement> methodInvocationRenames = bodyMapper.getMethodInvocationRenameReplacements();
            for (MethodInvocationReplacement replacement : methodInvocationRenames) {
                map.put(replacement, bodyMapper);
            }
            ConsistentReplacementDetector.updateRenames(allConsistentMethodInvocationRenames, allInconsistentMethodInvocationRenames, methodInvocationRenames);
        }
        map.keySet().removeAll(allInconsistentMethodInvocationRenames);
        return map;
    }

    private void updateMapperSet(TreeSet<UMLOperationBodyMapper> mapperSet, UMLOperation removedOperation, UMLOperation addedOperation, int differenceInPosition) throws RefactoringMinerTimedOutException {
        int absoluteDifferenceInPosition;
        boolean mapperWithZeroNonMappedStatementsOrIdenticalMethodName = false;
        for (UMLOperationBodyMapper mapper : mapperSet) {
            int sum;
            if (mapper.getContainer1().getBodyHashCode() == mapper.getContainer2().getBodyHashCode()) {
                return;
            }
            if (mapper.getContainer1().getName().equals(mapper.getContainer2().getName())) {
                mapperWithZeroNonMappedStatementsOrIdenticalMethodName = true;
            }
            if ((sum = mapper.getNonMappedLeavesT1().size() + mapper.getNonMappedLeavesT2().size() + mapper.getNonMappedInnerNodesT1().size() + mapper.getNonMappedInnerNodesT2().size()) != 0) continue;
            mapperWithZeroNonMappedStatementsOrIdenticalMethodName = true;
        }
        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)this);
        ArrayList<AbstractCodeMapping> totalMappings = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        if (mappings > 0 || removedOperation.getName().equals(addedOperation.getName()) && removedOperation.getBody() != null && addedOperation.getBody() != null) {
            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.exactMappings(operationBodyMapper)) {
                mapperSet.add(operationBodyMapper);
            } else if (this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition) && removedOperation.testMethodCheck(addedOperation)) {
                this.isPartOfMethodMovedFromDeletedMethod(removedOperation, addedOperation, operationBodyMapper);
                this.isPartOfMethodMovedToAddedMethod(removedOperation, addedOperation, operationBodyMapper);
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodExtracted(removedOperation, addedOperation) || this.isPartOfMethodMovedToExistingMethod(removedOperation, addedOperation) || operationBodyMapper.exactMatches() > 0 && !mapperWithZeroNonMappedStatementsOrIdenticalMethodName && this.isPartOfMethodMovedToAddedMethod(removedOperation, addedOperation, operationBodyMapper)) && removedOperation.testMethodCheck(addedOperation)) {
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT1(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodInlined(removedOperation, addedOperation) || this.isPartOfMethodMovedFromExistingMethod(removedOperation, addedOperation) || operationBodyMapper.exactMatches() > 0 && !mapperWithZeroNonMappedStatementsOrIdenticalMethodName && this.isPartOfMethodMovedFromDeletedMethod(removedOperation, addedOperation, operationBodyMapper)) && removedOperation.testMethodCheck(addedOperation)) {
                mapperSet.add(operationBodyMapper);
            } else {
                if ((removedOperation.hasSetUpAnnotation() || removedOperation.getName().equals("setUp")) && (addedOperation.hasSetUpAnnotation() || addedOperation.getName().equals("setUp"))) {
                    this.potentialCodeMoveBetweenSetUpTearDownMethods.add(operationBodyMapper);
                } else if ((removedOperation.hasTearDownAnnotation() || removedOperation.getName().equals("tearDown")) && (addedOperation.hasTearDownAnnotation() || addedOperation.getName().equals("tearDown"))) {
                    this.potentialCodeMoveBetweenSetUpTearDownMethods.add(operationBodyMapper);
                } else if (this.allStatementsMappedOrParameterized(operationBodyMapper)) {
                    this.movedMethodsInDifferentPositionWithinFile.add(operationBodyMapper);
                }
                for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
                    UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
                    if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff)) continue;
                    mapperSet.add(operationBodyMapper);
                    break;
                }
            }
        } else {
            for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
                UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
                if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff)) continue;
                mapperSet.add(operationBodyMapper);
                break;
            }
            if (this.matchingGetterSetterWithSameRenamePattern(removedOperation, addedOperation) && this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation) <= differenceInPosition) {
                mapperSet.add(operationBodyMapper);
            }
            for (UMLOperationBodyMapper m : this.movedMethodsInDifferentPositionWithinFile) {
                int nonMappedElementsT2CallingAddedOperation = operationBodyMapper.nonMappedElementsT2CallingAddedOperation(List.of(m.getContainer2()));
                if (nonMappedElementsT2CallingAddedOperation <= 0) continue;
                mapperSet.add(operationBodyMapper);
            }
            for (UMLOperation operation : this.addedOperations) {
                int nonMappedElementsT2CallingAddedOperation = operationBodyMapper.nonMappedElementsT2CallingAddedOperation(List.of(operation));
                boolean nameMatch = operationBodyMapper.getContainer1().getName().contains(operationBodyMapper.getContainer2().getName()) || operationBodyMapper.getContainer2().getName().contains(operationBodyMapper.getContainer1().getName());
                if (!nameMatch || operationBodyMapper.nonMappedElementsT2() != 1 || nonMappedElementsT2CallingAddedOperation != 1 || operationBodyMapper.getContainer2().stringRepresentation().size() != 3) continue;
                boolean callToNewClass = false;
                List<AbstractCodeFragment> nonMappedLeavesT2 = operationBodyMapper.getNonMappedLeavesT2();
                if (nonMappedLeavesT2.size() > 0) {
                    AbstractCodeFragment nonMappedLeafT2 = nonMappedLeavesT2.get(0);
                    AbstractCall call = nonMappedLeafT2.invocationCoveringEntireFragment();
                    if (call == null) {
                        call = nonMappedLeafT2.assignmentInvocationCoveringEntireStatement();
                    }
                    if (call != null && call.getExpression() != null) {
                        String expression = call.getExpression();
                        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
                            if (!attribute.getName().equals(expression) || this.originalClass.containsAttributeWithName(expression) || this.modelDiff == null || this.modelDiff.findClassInChildModel(attribute.getType().getClassType()) == null && !this.modelDiff.partialModel()) continue;
                            callToNewClass = true;
                            break;
                        }
                    }
                }
                if (callToNewClass) continue;
                mapperSet.add(operationBodyMapper);
            }
        }
        if (totalMappings.size() > 0) {
            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.singleUnmatchedStatementCallsAddedOperation(operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) {
                mapperSet.add(operationBodyMapper);
            }
        }
    }

    private void updateMapperSet(TreeSet<UMLOperationBodyMapper> mapperSet, UMLOperation removedOperation, UMLOperation operationInsideAnonymousClass, UMLOperation addedOperation, int differenceInPosition) throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, operationInsideAnonymousClass, (UMLAbstractClassDiff)this);
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        if (mappings > 0) {
            int absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.exactMappings(operationBodyMapper)) {
                mapperSet.add(operationBodyMapper);
            } else if (this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) {
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodExtracted(removedOperation, addedOperation) || this.isPartOfMethodMovedToExistingMethod(removedOperation, addedOperation))) {
                mapperSet.add(operationBodyMapper);
            } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.mappedElementsMoreThanNonMappedT1(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && (this.isPartOfMethodInlined(removedOperation, addedOperation) || this.isPartOfMethodMovedFromExistingMethod(removedOperation, addedOperation))) {
                mapperSet.add(operationBodyMapper);
            } else {
                for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames.keySet()) {
                    UMLOperationBodyMapper mapper = this.consistentMethodInvocationRenames.get(replacement);
                    if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation, mapper.getContainer1(), this, this.modelDiff) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation, mapper.getContainer2(), this, this.modelDiff)) continue;
                    mapperSet.add(operationBodyMapper);
                    break;
                }
            }
        }
    }

    private boolean allStatementsMappedOrParameterized(UMLOperationBodyMapper operationBodyMapper) {
        boolean matchFound;
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        if (mappings > 0 && operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
            return true;
        }
        int nonMappedStatements1ThatCanBeIgnored = 0;
        int nonMappedStatements1 = 0;
        for (AbstractCodeFragment fragment1 : operationBodyMapper.getNonMappedLeavesT1()) {
            if (!fragment1.countableStatement()) continue;
            for (String parameterName : operationBodyMapper.getContainer2().getParameterNameList()) {
                if (fragment1.getVariableDeclaration(parameterName) == null) continue;
                ++nonMappedStatements1ThatCanBeIgnored;
                break;
            }
            ++nonMappedStatements1;
        }
        int nonMappedStatements2ThatCanBeIgnored = 0;
        int nonMappedStatements2 = 0;
        for (CompositeStatementObject composite2 : operationBodyMapper.getNonMappedInnerNodesT2()) {
            if (!composite2.countableStatement()) continue;
            for (String parameterName : operationBodyMapper.getContainer2().getParameterNameList()) {
                matchFound = false;
                for (LeafExpression leafExpression : composite2.getVariables()) {
                    if (!leafExpression.getString().equals(parameterName)) continue;
                    ++nonMappedStatements2ThatCanBeIgnored;
                    matchFound = true;
                    break;
                }
                if (!matchFound) continue;
                break;
            }
            ++nonMappedStatements2;
        }
        for (AbstractCodeFragment fragment2 : operationBodyMapper.getNonMappedLeavesT2()) {
            if (!fragment2.countableStatement()) continue;
            for (String parameterName : operationBodyMapper.getContainer2().getParameterNameList()) {
                matchFound = false;
                for (LeafExpression leafExpression : fragment2.getVariables()) {
                    if (!leafExpression.getString().equals(parameterName)) continue;
                    ++nonMappedStatements2ThatCanBeIgnored;
                    matchFound = true;
                    break;
                }
                if (!matchFound) continue;
                break;
            }
            ++nonMappedStatements2;
        }
        return operationBodyMapper.exactMatches() > 0 && nonMappedStatements1 == nonMappedStatements1ThatCanBeIgnored && nonMappedStatements2 == nonMappedStatements2ThatCanBeIgnored;
    }

    private boolean matchingGetterSetterWithSameRenamePattern(UMLOperation removedOperation, UMLOperation addedOperation) {
        block3: {
            String getPrefix;
            String setPrefix;
            block2: {
                setPrefix = "set";
                getPrefix = "get";
                if (!removedOperation.getName().startsWith(setPrefix) || !addedOperation.getName().startsWith(setPrefix)) break block2;
                String removedOperationSuffix = removedOperation.getName().substring(setPrefix.length());
                String addedOperationSuffix = addedOperation.getName().substring(setPrefix.length());
                for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                    if (!mapper.getContainer1().getName().startsWith(getPrefix) || !mapper.getContainer2().getName().startsWith(getPrefix)) continue;
                    String container1Suffix = mapper.getContainer1().getName().substring(getPrefix.length());
                    String container2Suffix = mapper.getContainer2().getName().substring(getPrefix.length());
                    if (!container1Suffix.equals(removedOperationSuffix) || !container2Suffix.equals(addedOperationSuffix)) continue;
                    return true;
                }
                break block3;
            }
            if (!removedOperation.getName().startsWith(getPrefix) || !addedOperation.getName().startsWith(getPrefix)) break block3;
            String removedOperationSuffix = removedOperation.getName().substring(getPrefix.length());
            String addedOperationSuffix = addedOperation.getName().substring(getPrefix.length());
            for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                if (!mapper.getContainer1().getName().startsWith(setPrefix) || !mapper.getContainer2().getName().startsWith(setPrefix)) continue;
                String container1Suffix = mapper.getContainer1().getName().substring(setPrefix.length());
                String container2Suffix = mapper.getContainer2().getName().substring(setPrefix.length());
                if (!container1Suffix.equals(removedOperationSuffix) || !container2Suffix.equals(addedOperationSuffix)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean exactMappings(UMLOperationBodyMapper operationBodyMapper) {
        if (operationBodyMapper.allMappingsAreExactMatches()) {
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                return true;
            }
            if (operationBodyMapper.nonMappedElementsT1() > 0 && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                VariableDeclarationContainer addedOperation = operationBodyMapper.getContainer2();
                ArrayList<String> nonMappedLeavesT1 = new ArrayList<String>();
                for (AbstractCodeFragment abstractCodeFragment : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!abstractCodeFragment.countableStatement()) continue;
                    nonMappedLeavesT1.add(abstractCodeFragment.getString());
                    for (String string : addedOperation.getParameterNameList()) {
                        if (abstractCodeFragment.getVariableDeclaration(string) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                int nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation = 0;
                for (UMLOperation operation : this.addedOperations) {
                    if (operation.equals(addedOperation) || operation.getBody() == null) continue;
                    for (AbstractCodeFragment statement : operation.getBody().getCompositeStatement().getLeaves()) {
                        if (!nonMappedLeavesT1.contains(statement.getString())) continue;
                        ++nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation;
                    }
                }
                return (countableStatements == parameterizedVariableDeclarationStatements || countableStatements == nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation + parameterizedVariableDeclarationStatements) && countableStatements > 0;
            }
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() > 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                VariableDeclarationContainer removedOperation = operationBodyMapper.getContainer1();
                for (AbstractCodeFragment statement : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!statement.countableStatement()) continue;
                    for (String parameterName : removedOperation.getParameterNameList()) {
                        if (statement.getVariableDeclaration(parameterName) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                return countableStatements == parameterizedVariableDeclarationStatements && countableStatements > 0;
            }
            if ((operationBodyMapper.nonMappedElementsT1() == 1 || operationBodyMapper.nonMappedElementsT2() == 1) && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                AbstractCodeFragment statementUsingParameterAsInvoker1 = null;
                VariableDeclarationContainer removedOperation = operationBodyMapper.getContainer1();
                block6: for (AbstractCodeFragment statement : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!statement.countableStatement()) continue;
                    for (String string : removedOperation.getParameterNameList()) {
                        AbstractCall invocation = statement.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker1 = statement;
                        continue block6;
                    }
                }
                AbstractCodeFragment statementUsingParameterAsInvoker2 = null;
                VariableDeclarationContainer addedOperation = operationBodyMapper.getContainer2();
                block8: for (AbstractCodeFragment abstractCodeFragment : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!abstractCodeFragment.countableStatement()) continue;
                    for (String string : addedOperation.getParameterNameList()) {
                        AbstractCall invocation = abstractCodeFragment.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker2 = abstractCodeFragment;
                        continue block8;
                    }
                }
                if (statementUsingParameterAsInvoker1 != null && statementUsingParameterAsInvoker2 != null) {
                    for (AbstractCodeMapping abstractCodeMapping : operationBodyMapper.getMappings()) {
                        if (!(abstractCodeMapping.getFragment1() instanceof CompositeStatementObject) || !(abstractCodeMapping.getFragment2() instanceof CompositeStatementObject)) continue;
                        CompositeStatementObject parent1 = (CompositeStatementObject)abstractCodeMapping.getFragment1();
                        CompositeStatementObject compositeStatementObject = (CompositeStatementObject)abstractCodeMapping.getFragment2();
                        if (!parent1.getLeaves().contains(statementUsingParameterAsInvoker1) || !compositeStatementObject.getLeaves().contains(statementUsingParameterAsInvoker2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean mappedElementsMoreThanNonMappedT1AndT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        List<CompositeReplacement> composites = operationBodyMapper.getCompositeReplacements();
        int additionallyMatchedStatements1 = 0;
        int additionallyMatchedStatements2 = 0;
        for (CompositeReplacement composite : composites) {
            additionallyMatchedStatements1 += composite.getAdditionallyMatchedStatements1().size();
            additionallyMatchedStatements2 += composite.getAdditionallyMatchedStatements2().size();
        }
        mappings += additionallyMatchedStatements1 + additionallyMatchedStatements2;
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1() - additionallyMatchedStatements1;
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2() - additionallyMatchedStatements2;
        int exactMappings = operationBodyMapper.exactMatches();
        if (operationBodyMapper.getContainer1() instanceof UMLOperation && operationBodyMapper.getContainer2() instanceof UMLOperation) {
            UMLParameter returnParameter1 = ((UMLOperation)operationBodyMapper.getContainer1()).getReturnParameter();
            UMLParameter returnParameter2 = ((UMLOperation)operationBodyMapper.getContainer2()).getReturnParameter();
            if (returnParameter1 != null && returnParameter2 != null) {
                UMLType returnType1 = returnParameter1.getType();
                UMLType returnType2 = returnParameter2.getType();
                boolean returnFound = false;
                if (returnType1.getClassType().equals("void") && !returnType2.getClassType().equals("void")) {
                    for (AbstractCodeFragment fragment1 : operationBodyMapper.getNonMappedLeavesT1()) {
                        if (!fragment1.getString().equals("return;\n")) continue;
                        returnFound = true;
                        break;
                    }
                }
                if (!returnFound) {
                    for (AbstractCodeFragment statement2 : operationBodyMapper.getNonMappedLeavesT2()) {
                        VariableDeclaration variableDeclaration2;
                        if (statement2.getVariables().size() <= 0 || !statement2.getString().equals("return " + statement2.getVariables().get(0).getString() + ";\n") || (variableDeclaration2 = operationBodyMapper.getContainer2().getVariableDeclaration(statement2.getVariables().get(0).getString())) == null || !variableDeclaration2.getType().equals(returnType2)) continue;
                        --nonMappedElementsT2;
                    }
                }
            }
        }
        return mappings > nonMappedElementsT1 && mappings > nonMappedElementsT2 || nonMappedElementsT1 == 0 && (double)mappings > Math.floor((double)nonMappedElementsT2 / 2.0) && !operationBodyMapper.involvesTestMethods() || nonMappedElementsT2 == 0 && (double)mappings > Math.floor((double)nonMappedElementsT1 / 2.0) && !operationBodyMapper.involvesTestMethods() && !(this instanceof UMLClassMoveDiff) || nonMappedElementsT1 == 0 && (double)exactMappings >= Math.floor((double)nonMappedElementsT2 / 2.0) || mappings == 1 && nonMappedElementsT1 + nonMappedElementsT2 == 1 && operationBodyMapper.getContainer1().getName().equals(operationBodyMapper.getContainer2().getName());
    }

    private boolean mappedElementsMoreThanNonMappedT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        int nonMappedElementsT2CallingAddedOperation = operationBodyMapper.nonMappedElementsT2CallingAddedOperation(this.addedOperations);
        int nonMappedElementsT2WithoutThoseCallingAddedOperation = nonMappedElementsT2 - nonMappedElementsT2CallingAddedOperation;
        boolean matchFound = false;
        for (AbstractCodeFragment nonMappedLeafT1 : operationBodyMapper.getNonMappedLeavesT1()) {
            if (nonMappedLeafT1.getVariableDeclarations().size() <= 0) continue;
            for (AbstractCodeFragment nonMappedLeafT2 : operationBodyMapper.getNonMappedLeavesT2()) {
                if (!nonMappedLeafT1.getVariableDeclarations().toString().equals(nonMappedLeafT2.getVariableDeclarations().toString())) continue;
                ++mappings;
                --nonMappedElementsT2;
                matchFound = true;
                break;
            }
            if (!matchFound) continue;
            break;
        }
        return mappings > nonMappedElementsT2 || mappings >= nonMappedElementsT2WithoutThoseCallingAddedOperation && nonMappedElementsT2CallingAddedOperation >= nonMappedElementsT2WithoutThoseCallingAddedOperation || operationBodyMapper.getMappings().size() > nonMappedElementsT2 && nonMappedElementsT2CallingAddedOperation > 0 && operationBodyMapper.getContainer1().getClassName().equals(operationBodyMapper.getContainer2().getClassName());
    }

    private boolean mappedElementsMoreThanNonMappedT1(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT1CallingRemovedOperation = operationBodyMapper.nonMappedElementsT1CallingRemovedOperation(this.removedOperations);
        int nonMappedElementsT1WithoutThoseCallingRemovedOperation = nonMappedElementsT1 - nonMappedElementsT1CallingRemovedOperation;
        boolean matchFound = false;
        for (AbstractCodeFragment nonMappedLeafT1 : operationBodyMapper.getNonMappedLeavesT1()) {
            if (nonMappedLeafT1.getVariableDeclarations().size() <= 0) continue;
            for (AbstractCodeFragment nonMappedLeafT2 : operationBodyMapper.getNonMappedLeavesT2()) {
                if (!nonMappedLeafT1.getVariableDeclarations().toString().equals(nonMappedLeafT2.getVariableDeclarations().toString())) continue;
                ++mappings;
                --nonMappedElementsT1;
                matchFound = true;
                break;
            }
            if (!matchFound) continue;
            break;
        }
        return mappings > nonMappedElementsT1 || mappings >= nonMappedElementsT1WithoutThoseCallingRemovedOperation && nonMappedElementsT1CallingRemovedOperation >= nonMappedElementsT1WithoutThoseCallingRemovedOperation;
    }

    private UMLOperationBodyMapper findBestMapper(TreeSet<UMLOperationBodyMapper> mapperSet) {
        ArrayList<UMLOperationBodyMapper> mapperList = new ArrayList<UMLOperationBodyMapper>(mapperSet);
        UMLOperationBodyMapper bestMapper = mapperSet.first();
        VariableDeclarationContainer bestMapperOperation1 = bestMapper.getContainer1();
        VariableDeclarationContainer bestMapperOperation2 = bestMapper.getContainer2();
        boolean identicalBodyWithOperation1OfTheBestMapper = this.identicalBodyWithAnotherAddedMethod(bestMapper);
        boolean identicalBodyWithOperation2OfTheBestMapper = this.identicalBodyWithAnotherRemovedMethod(bestMapper);
        if (this.equalSignatureWithCommonParameterTypes(bestMapperOperation1, bestMapperOperation2) && !identicalBodyWithOperation1OfTheBestMapper && !identicalBodyWithOperation2OfTheBestMapper) {
            return bestMapper;
        }
        for (int i = 1; i < mapperList.size(); ++i) {
            UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperList.get(i);
            if (!this.checkForCalls(mapper)) continue;
            VariableDeclarationContainer operation2 = mapper.getContainer2();
            List<AbstractCall> operationInvocations2 = operation2.getAllOperationInvocations();
            boolean anotherMapperCallsOperation2OfTheBestMapper = false;
            for (AbstractCall invocation : operationInvocations2) {
                if (!invocation.matchesOperation(bestMapper.getContainer2(), operation2, this, this.modelDiff) || invocation.matchesOperation(bestMapper.getContainer1(), operation2, this, this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.removedOperations)) continue;
                anotherMapperCallsOperation2OfTheBestMapper = true;
                break;
            }
            VariableDeclarationContainer operation1 = mapper.getContainer1();
            List<AbstractCall> operationInvocations1 = operation1.getAllOperationInvocations();
            boolean anotherMapperCallsOperation1OfTheBestMapper = false;
            for (AbstractCall invocation : operationInvocations1) {
                if (!invocation.matchesOperation(bestMapper.getContainer1(), operation1, this, this.modelDiff) || invocation.matchesOperation(bestMapper.getContainer2(), operation1, this, this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.addedOperations)) continue;
                anotherMapperCallsOperation1OfTheBestMapper = true;
                break;
            }
            if (!anotherMapperCallsOperation2OfTheBestMapper && !anotherMapperCallsOperation1OfTheBestMapper) continue;
            return mapper;
        }
        int consistentMethodInvocationRenameMismatchesForBestMapper = this.mismatchesConsistentMethodInvocationRename(bestMapper);
        if (consistentMethodInvocationRenameMismatchesForBestMapper > 0 && !this.exactMappings(bestMapper)) {
            for (int i = 1; i < mapperList.size(); ++i) {
                UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperList.get(i);
                int consistentMethodInvocationRenameMismatchesForCurrentMapper = this.mismatchesConsistentMethodInvocationRename(mapper);
                if (consistentMethodInvocationRenameMismatchesForCurrentMapper >= consistentMethodInvocationRenameMismatchesForBestMapper) continue;
                return mapper;
            }
            return null;
        }
        if (identicalBodyWithOperation2OfTheBestMapper || identicalBodyWithOperation1OfTheBestMapper) {
            return null;
        }
        return bestMapper;
    }

    private boolean checkForCalls(UMLOperationBodyMapper mapper) {
        if (mapper.getMappings().size() > 1) {
            return true;
        }
        if (mapper.getMappings().size() == 1) {
            AbstractCodeMapping mapping = mapper.getMappings().iterator().next();
            AbstractCodeFragment fragment1 = mapping.getFragment1();
            AbstractCodeFragment fragment2 = mapping.getFragment2();
            AbstractCall call1 = fragment1.invocationCoveringEntireFragment();
            AbstractCall call2 = fragment2.invocationCoveringEntireFragment();
            if (call1 != null && call2 != null && call1.identicalExpression(call2) && call1.identicalName(call2)) {
                return true;
            }
        }
        return false;
    }

    private boolean equalSignatureWithCommonParameterTypes(VariableDeclarationContainer operation1, VariableDeclarationContainer operation2) {
        return operation1.equalReturnParameter(operation2) && operation1.getName().equals(operation2.getName()) && operation1.commonParameterTypes(operation2).size() > 0;
    }

    private boolean identicalBodyWithAnotherAddedMethod(UMLOperationBodyMapper mapper) {
        VariableDeclarationContainer operation1 = mapper.getContainer1();
        List<String> stringRepresentation = operation1.stringRepresentation();
        if (stringRepresentation.size() > 3) {
            for (UMLOperation addedOperation : this.addedOperations) {
                if (mapper.getContainer2().equals(addedOperation)) continue;
                OperationBody body = addedOperation.getBody();
                if (body != null && body.getBodyHashCode() == operation1.getBody().getBodyHashCode()) {
                    return true;
                }
                if (!this.equalSignatureWithCommonParameterTypes(operation1, addedOperation)) continue;
                ArrayList<String> commonStatements = new ArrayList<String>();
                List<String> addedOperationStringRepresentation = addedOperation.stringRepresentation();
                for (String statement : addedOperationStringRepresentation) {
                    if (statement.equals("{") || statement.equals("}") || statement.equals("try") || statement.startsWith("catch(") || statement.startsWith("case ") || statement.startsWith("default :") || statement.startsWith("return true;") || statement.startsWith("return false;") || statement.startsWith("return this;") || statement.startsWith("return null;") || statement.startsWith("return;") || !stringRepresentation.contains(statement)) continue;
                    commonStatements.add(statement);
                }
                if (commonStatements.size() <= mapper.exactMatches() * 2) continue;
                return true;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass addedClass : this.modelDiff.getAddedClasses()) {
                    for (UMLOperation addedOperation : addedClass.getOperations()) {
                        OperationBody body = addedOperation.getBody();
                        List<String> parameterNameList = addedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation1.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation1.getParameterNameList())) continue;
                        return true;
                    }
                }
            }
        } else if (stringRepresentation.size() == 3) {
            int counter = 0;
            for (UMLOperation addedOperation : this.addedOperations) {
                if (mapper.getContainer2().equals(addedOperation)) continue;
                OperationBody body = addedOperation.getBody();
                List<String> parameterNameList = addedOperation.getParameterNameList();
                if (body == null || body.getBodyHashCode() != operation1.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation1.getParameterNameList())) continue;
                ++counter;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass addedClass : this.modelDiff.getAddedClasses()) {
                    for (UMLOperation addedOperation : addedClass.getOperations()) {
                        OperationBody body = addedOperation.getBody();
                        List<String> parameterNameList = addedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation1.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation1.getParameterNameList())) continue;
                        ++counter;
                    }
                }
            }
            if (counter == 1 && !this.existingMapperWithIdenticalMapping(stringRepresentation.get(1))) {
                return true;
            }
        }
        return false;
    }

    private boolean identicalBodyWithAnotherRemovedMethod(UMLOperationBodyMapper mapper) {
        VariableDeclarationContainer operation2 = mapper.getContainer2();
        List<String> stringRepresentation = operation2.stringRepresentation();
        if (stringRepresentation.size() > 3) {
            for (UMLOperation removedOperation : this.removedOperations) {
                if (mapper.getContainer1().equals(removedOperation)) continue;
                OperationBody body = removedOperation.getBody();
                if (body != null && body.getBodyHashCode() == operation2.getBody().getBodyHashCode()) {
                    return true;
                }
                if (!this.equalSignatureWithCommonParameterTypes(removedOperation, operation2)) continue;
                ArrayList<String> commonStatements = new ArrayList<String>();
                List<String> removedOperationStringRepresentation = removedOperation.stringRepresentation();
                for (String statement : removedOperationStringRepresentation) {
                    if (statement.equals("{") || statement.equals("}") || statement.equals("try") || statement.startsWith("catch(") || statement.startsWith("case ") || statement.startsWith("default :") || statement.startsWith("return true;") || statement.startsWith("return false;") || statement.startsWith("return this;") || statement.startsWith("return null;") || statement.startsWith("return;") || !stringRepresentation.contains(statement)) continue;
                    commonStatements.add(statement);
                }
                if (commonStatements.size() <= mapper.exactMatches() * 2) continue;
                return true;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass removedClass : this.modelDiff.getRemovedClasses()) {
                    for (UMLOperation removedOperation : removedClass.getOperations()) {
                        OperationBody body = removedOperation.getBody();
                        List<String> parameterNameList = removedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation2.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation2.getParameterNameList())) continue;
                        return true;
                    }
                }
            }
        } else if (stringRepresentation.size() == 3) {
            int counter = 0;
            for (UMLOperation removedOperation : this.removedOperations) {
                if (mapper.getContainer1().equals(removedOperation)) continue;
                OperationBody body = removedOperation.getBody();
                List<String> parameterNameList = removedOperation.getParameterNameList();
                if (body == null || body.getBodyHashCode() != operation2.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation2.getParameterNameList())) continue;
                ++counter;
            }
            if (this.nextClass.hasDeprecatedAnnotation() != this.originalClass.hasDeprecatedAnnotation()) {
                for (UMLClass removedClass : this.modelDiff.getRemovedClasses()) {
                    for (UMLOperation removedOperation : removedClass.getOperations()) {
                        OperationBody body = removedOperation.getBody();
                        List<String> parameterNameList = removedOperation.getParameterNameList();
                        if (body == null || body.getBodyHashCode() != operation2.getBody().getBodyHashCode() || parameterNameList.size() <= 0 || !parameterNameList.equals(operation2.getParameterNameList())) continue;
                        ++counter;
                    }
                }
            }
            if (counter == 1 && !this.existingMapperWithIdenticalMapping(stringRepresentation.get(1))) {
                return true;
            }
        }
        return false;
    }

    private boolean existingMapperWithIdenticalMapping(String stringRepresentation) {
        for (int i = this.operationBodyMapperList.size() - 1; i >= 0; --i) {
            UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)this.operationBodyMapperList.get(i);
            for (AbstractCodeMapping mapping : mapper.getExactMatches()) {
                if (!mapping.getFragment1().getString().equals(stringRepresentation) && !mapping.getFragment2().getString().equals(stringRepresentation)) continue;
                return true;
            }
        }
        return false;
    }

    private int mismatchesConsistentMethodInvocationRename(UMLOperationBodyMapper mapper) {
        int mismatchCount = 0;
        for (MethodInvocationReplacement rename : this.consistentMethodInvocationRenames.keySet()) {
            UMLOperationBodyMapper referringMapper = this.consistentMethodInvocationRenames.get(rename);
            AbstractCall callBefore = rename.getInvokedOperationBefore();
            AbstractCall callAfter = rename.getInvokedOperationAfter();
            if (callBefore.matchesOperation(mapper.getContainer1(), referringMapper.getContainer1(), this, this.modelDiff) && !callAfter.matchesOperation(mapper.getContainer2(), referringMapper.getContainer2(), this, this.modelDiff)) {
                ++mismatchCount;
                continue;
            }
            if (callBefore.matchesOperation(mapper.getContainer1(), referringMapper.getContainer1(), this, this.modelDiff) || !callAfter.matchesOperation(mapper.getContainer2(), referringMapper.getContainer2(), this, this.modelDiff)) continue;
            ++mismatchCount;
        }
        return mismatchCount;
    }

    private boolean operationContainsMethodInvocationWithTheSameNameAndCommonArguments(AbstractCall invocation, List<UMLOperation> operations) {
        for (UMLOperation operation : operations) {
            List<AbstractCall> operationInvocations = operation.getAllOperationInvocations();
            for (AbstractCall operationInvocation : operationInvocations) {
                LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(operationInvocation.arguments());
                argumentIntersection.retainAll(invocation.arguments());
                if (operationInvocation.getName().equals(invocation.getName()) && !argumentIntersection.isEmpty()) {
                    return true;
                }
                if (argumentIntersection.size() <= 0 || argumentIntersection.size() != invocation.arguments().size()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean singleUnmatchedStatementCallsAddedOperation(UMLOperationBodyMapper operationBodyMapper) {
        AbstractCodeFragment statementT2;
        AbstractCall invocationT2;
        List<AbstractCodeFragment> nonMappedLeavesT1 = operationBodyMapper.getNonMappedLeavesT1();
        List<AbstractCodeFragment> nonMappedLeavesT2 = operationBodyMapper.getNonMappedLeavesT2();
        if (nonMappedLeavesT1.size() == 1 && nonMappedLeavesT2.size() == 1 && (invocationT2 = (statementT2 = nonMappedLeavesT2.get(0)).invocationCoveringEntireFragment()) != null) {
            for (UMLOperation addedOperation : this.addedOperations) {
                AbstractCodeFragment statementT1;
                AbstractCall invocationT1;
                if (!invocationT2.matchesOperation(addedOperation, operationBodyMapper.getContainer2(), this, this.modelDiff) || (invocationT1 = (statementT1 = nonMappedLeavesT1.get(0)).invocationCoveringEntireFragment()) == null || !addedOperation.getAllOperationInvocations().contains(invocationT1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compatibleSignatures(UMLOperation removedOperation, UMLOperation addedOperation, int absoluteDifferenceInPosition) {
        if (addedOperation.compatibleSignature(removedOperation)) {
            return true;
        }
        if ((absoluteDifferenceInPosition == 0 || this.operationsBeforeAndAfterMatch(removedOperation, addedOperation)) && !this.gettersWithDifferentReturnType(removedOperation, addedOperation)) {
            if (addedOperation.getParameterTypeList().equals(removedOperation.getParameterTypeList()) || addedOperation.normalizedNameDistance(removedOperation) <= 0.4) {
                return true;
            }
            if (addedOperation.isSetter() && removedOperation.isSetter() && this.sameAttributeIndex(removedOperation, addedOperation)) {
                return true;
            }
            if (addedOperation.hasTestAnnotation() && removedOperation.hasTestAnnotation()) {
                return true;
            }
        }
        return false;
    }

    private boolean gettersWithDifferentReturnType(UMLOperation removedOperation, UMLOperation addedOperation) {
        if (removedOperation.isGetter() && addedOperation.isGetter()) {
            UMLType type1 = removedOperation.getReturnParameter().getType();
            UMLType type2 = addedOperation.getReturnParameter().getType();
            if (!(removedOperation.equalReturnParameter(addedOperation) || type1.compatibleTypes(type2) || this.sameAttributeIndex(removedOperation, addedOperation))) {
                return true;
            }
        }
        return false;
    }

    private boolean sameAttributeIndex(UMLOperation removedOperation, UMLOperation addedOperation) {
        List<String> variables1 = removedOperation.getAllVariables();
        int index1 = -1;
        if (variables1.size() > 0) {
            int count = 0;
            for (UMLAttribute attribute : this.originalClass.getAttributes()) {
                if (attribute.getName().equals(variables1.get(0)) || variables1.get(0).equals("this." + attribute.getName())) {
                    index1 = count;
                    break;
                }
                ++count;
            }
        }
        List<String> variables2 = addedOperation.getAllVariables();
        int index2 = -1;
        if (variables2.size() > 0) {
            int count = 0;
            for (UMLAttribute attribute : this.nextClass.getAttributes()) {
                if (attribute.getName().equals(variables2.get(0)) || variables2.get(0).equals("this." + attribute.getName())) {
                    index2 = count;
                    break;
                }
                ++count;
            }
        }
        boolean sameAttributeIndex = index1 == index2 && index1 != -1;
        return sameAttributeIndex;
    }

    private boolean operationsBeforeAndAfterMatch(UMLOperation removedOperation, UMLOperation addedOperation) {
        UMLOperation operationBefore1 = null;
        UMLOperation operationAfter1 = null;
        List<UMLOperation> originalClassOperations = this.originalClass.getOperations();
        for (int i = 0; i < originalClassOperations.size(); ++i) {
            UMLOperation current = originalClassOperations.get(i);
            if (!current.equals(removedOperation)) continue;
            if (i > 0) {
                operationBefore1 = originalClassOperations.get(i - 1);
            }
            if (i >= originalClassOperations.size() - 1) continue;
            operationAfter1 = originalClassOperations.get(i + 1);
        }
        UMLOperation operationBefore2 = null;
        UMLOperation operationAfter2 = null;
        List<UMLOperation> nextClassOperations = this.nextClass.getOperations();
        for (int i = 0; i < nextClassOperations.size(); ++i) {
            UMLOperation current = nextClassOperations.get(i);
            if (!current.equals(addedOperation)) continue;
            if (i > 0) {
                operationBefore2 = nextClassOperations.get(i - 1);
            }
            if (i >= nextClassOperations.size() - 1) continue;
            operationAfter2 = nextClassOperations.get(i + 1);
        }
        boolean operationsBeforeMatch = false;
        if (operationBefore1 != null && operationBefore2 != null) {
            operationsBeforeMatch = operationBefore1.equalReturnParameter(operationBefore2) && operationBefore1.equalParameterTypes(operationBefore2) && operationBefore1.getName().equals(operationBefore2.getName()) || this.matchingDataProviderAnnotation(removedOperation, operationBefore1) && this.matchingDataProviderAnnotation(addedOperation, operationBefore2);
        } else if (operationBefore1 == null && operationBefore2 == null) {
            operationsBeforeMatch = true;
        }
        boolean operationsAfterMatch = false;
        if (operationAfter1 != null && operationAfter2 != null) {
            operationsAfterMatch = operationAfter1.equalReturnParameter(operationAfter2) && operationAfter1.equalParameterTypes(operationAfter2) && operationAfter1.getName().equals(operationAfter2.getName()) || this.matchingDataProviderAnnotation(removedOperation, operationAfter1) && this.matchingDataProviderAnnotation(addedOperation, operationAfter2);
        } else if (operationAfter1 == null && operationAfter2 == null) {
            operationsAfterMatch = true;
        }
        return operationsBeforeMatch || operationsAfterMatch;
    }

    private boolean matchingDataProviderAnnotation(UMLOperation operation1, UMLOperation operation2) {
        Map<String, AbstractExpression> dataProviderMemberValuePairs;
        Map<String, AbstractExpression> testMemberValuePairs;
        UMLAnnotation testAnnotation = null;
        UMLAnnotation dataProviderAnnotation = null;
        if (operation1.hasTestAnnotation() && operation2.hasDataProviderAnnotation()) {
            List<UMLAnnotation> annotations1 = operation1.getAnnotations();
            for (UMLAnnotation uMLAnnotation : annotations1) {
                if (!uMLAnnotation.getTypeName().equals("Test")) continue;
                testAnnotation = uMLAnnotation;
                break;
            }
            List<UMLAnnotation> annotations2 = operation2.getAnnotations();
            Iterator iterator = annotations2.iterator();
            while (iterator.hasNext()) {
                UMLAnnotation annotation2 = (UMLAnnotation)iterator.next();
                if (!annotation2.getTypeName().equals("DataProvider")) continue;
                dataProviderAnnotation = annotation2;
                break;
            }
        } else if (operation2.hasTestAnnotation() && operation1.hasDataProviderAnnotation()) {
            List<UMLAnnotation> annotations2 = operation2.getAnnotations();
            for (UMLAnnotation uMLAnnotation : annotations2) {
                if (!uMLAnnotation.getTypeName().equals("Test")) continue;
                testAnnotation = uMLAnnotation;
                break;
            }
            List<UMLAnnotation> annotations1 = operation1.getAnnotations();
            for (UMLAnnotation annotation1 : annotations1) {
                if (!annotation1.getTypeName().equals("DataProvider")) continue;
                dataProviderAnnotation = annotation1;
                break;
            }
        }
        if (testAnnotation != null && dataProviderAnnotation != null && (testMemberValuePairs = testAnnotation.getMemberValuePairs()).containsKey("dataProvider") && (dataProviderMemberValuePairs = dataProviderAnnotation.getMemberValuePairs()).containsKey("name")) {
            return testMemberValuePairs.get("dataProvider").getExpression().equals(dataProviderMemberValuePairs.get("name").getExpression());
        }
        return false;
    }

    private void checkForInlinedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperationBodyMapper> inlinedOperationMappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            InlineOperationDetection detection = new InlineOperationDetection(mapper, this.removedOperations, this, this.modelDiff);
            List<UMLOperation> sortedRemovedOperations = detection.getRemovedOperationsSortedByCalls();
            for (UMLOperation removedOperation : sortedRemovedOperations) {
                List<InlineOperationRefactoring> refs = detection.check(removedOperation);
                for (InlineOperationRefactoring refactoring : refs) {
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    inlinedOperationMappers.add(operationBodyMapper);
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(removedOperation);
                }
            }
        }
        MappingOptimizer optimizer = new MappingOptimizer(this);
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            optimizer.optimizeDuplicateMappingsForInline(mapper, this.refactorings);
        }
        for (UMLOperationBodyMapper operationBodyMapper : inlinedOperationMappers) {
            this.processMapperRefactorings(operationBodyMapper, this.refactorings);
        }
        this.removedOperations.removeAll(operationsToBeRemoved);
    }

    private void checkForExtractedOperationsWithCallsInOtherMappers() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperationBodyMapper> extractedOperationMappers = new ArrayList<UMLOperationBodyMapper>();
        LinkedHashSet<UMLOperationBodyMapper> parentMappersToBeOptimized = new LinkedHashSet<UMLOperationBodyMapper>();
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            if (mapper.getNonMappedLeavesT1().isEmpty() && mapper.getNonMappedInnerNodesT1().isEmpty() || mapper.getChildMappers().size() != 0) continue;
            ExtractOperationDetection detection = new ExtractOperationDetection(mapper, (List<UMLOperation>)this.addedOperations, this, this.modelDiff, true);
            List<UMLOperation> sortedAddedOperations = detection.getAddedOperationsSortedByCalls();
            for (UMLOperation addedOperation : sortedAddedOperations) {
                List<ExtractOperationRefactoring> refs = detection.check(addedOperation);
                for (ExtractOperationRefactoring refactoring : refs) {
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    if (operationBodyMapper.exactMatches() <= 1) continue;
                    this.refactorings.add(refactoring);
                    extractedOperationMappers.add(operationBodyMapper);
                    mapper.addChildMapper(operationBodyMapper);
                    parentMappersToBeOptimized.add(mapper);
                    operationsToBeRemoved.add(addedOperation);
                }
            }
        }
        MappingOptimizer optimizer = new MappingOptimizer(this);
        for (UMLOperationBodyMapper mapper : parentMappersToBeOptimized) {
            optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
        }
        for (UMLOperationBodyMapper operationBodyMapper : extractedOperationMappers) {
            this.processMapperRefactorings(operationBodyMapper, this.refactorings);
        }
        this.addedOperations.removeAll(operationsToBeRemoved);
    }

    private void checkForExtractedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperationBodyMapper> extractedOperationMappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            ExtractOperationDetection detection = new ExtractOperationDetection(mapper, this.addedOperations, this, this.modelDiff);
            List<UMLOperation> sortedAddedOperations = detection.getAddedOperationsSortedByCalls();
            for (UMLOperation addedOperation : sortedAddedOperations) {
                List<ExtractOperationRefactoring> refs = detection.check(addedOperation);
                ArrayList<ExtractOperationRefactoring> discarded = new ArrayList<ExtractOperationRefactoring>();
                if (refs.size() > 1) {
                    for (ExtractOperationRefactoring refactoring : refs) {
                        AbstractCodeMapping mapping;
                        Set<AbstractCodeMapping> mappings = refactoring.getBodyMapper().getMappings();
                        if (mappings.size() != 1 || (mapping = mappings.iterator().next()).getFragment1().getString().equals(mapping.getFragment2().getString())) continue;
                        AbstractCall call1 = mapping.getFragment1().invocationCoveringEntireFragment();
                        AbstractCall call2 = mapping.getFragment2().invocationCoveringEntireFragment();
                        if (call1 == null || call2 == null || !call1.getName().equals(refactoring.getExtractedOperation().getName()) || !call2.getName().equals(refactoring.getExtractedOperation().getName())) continue;
                        discarded.add(refactoring);
                    }
                }
                if (discarded.equals(refs)) {
                    discarded.clear();
                }
                for (ExtractOperationRefactoring refactoring : refs) {
                    if (discarded.contains(refactoring)) continue;
                    CompositeStatementObject synchronizedBlock = refactoring.extractedFromSynchronizedBlock();
                    if (synchronizedBlock != null) {
                        refactoring.getBodyMapper().getParentMapper().getNonMappedInnerNodesT1().remove(synchronizedBlock);
                    }
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    extractedOperationMappers.add(operationBodyMapper);
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(addedOperation);
                }
            }
        }
        MappingOptimizer optimizer = new MappingOptimizer(this);
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
        }
        for (UMLOperationBodyMapper operationBodyMapper : extractedOperationMappers) {
            this.processMapperRefactorings(operationBodyMapper, this.refactorings);
        }
        this.addedOperations.removeAll(operationsToBeRemoved);
    }

    public boolean isEmpty() {
        return this.addedOperations.isEmpty() && this.removedOperations.isEmpty() && this.addedAttributes.isEmpty() && this.removedAttributes.isEmpty() && this.addedEnumConstants.isEmpty() && this.removedEnumConstants.isEmpty() && this.attributeDiffList.isEmpty() && this.operationBodyMapperList.isEmpty() && this.enumConstantDiffList.isEmpty() && this.annotationListDiff.isEmpty() && this.typeParameterDiffList.isEmpty() && !this.visibilityChanged && !this.abstractionChanged && !this.finalChanged && !this.staticChanged && !this.superclassChanged;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.originalClass.getName()).append(":").append("\n");
        if (this.visibilityChanged) {
            sb.append("\t").append("visibility changed from " + this.oldVisibility + " to " + this.newVisibility).append("\n");
        }
        if (this.abstractionChanged) {
            sb.append("\t").append("abstraction changed from " + (this.oldAbstraction ? "abstract" : "concrete") + " to " + (this.newAbstraction ? "abstract" : "concrete")).append("\n");
        }
        Collections.sort(this.removedOperations);
        for (UMLOperation umlOperation : this.removedOperations) {
            sb.append("operation " + umlOperation + " removed").append("\n");
        }
        Collections.sort(this.addedOperations);
        for (UMLOperation umlOperation : this.addedOperations) {
            sb.append("operation " + umlOperation + " added").append("\n");
        }
        Collections.sort(this.removedAttributes);
        for (UMLAttribute umlAttribute : this.removedAttributes) {
            sb.append("attribute " + umlAttribute + " removed").append("\n");
        }
        Collections.sort(this.addedAttributes);
        for (UMLAttribute umlAttribute : this.addedAttributes) {
            sb.append("attribute " + umlAttribute + " added").append("\n");
        }
        for (UMLAttributeDiff attributeDiff : this.attributeDiffList) {
            sb.append(attributeDiff);
        }
        Collections.sort(this.operationBodyMapperList);
        for (UMLOperationBodyMapper operationBodyMapper : this.operationBodyMapperList) {
            sb.append(operationBodyMapper).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(UMLClassBaseDiff other) {
        if (!this.originalClass.getName().equals(other.originalClass.getName())) {
            return this.originalClass.getName().compareTo(other.originalClass.getName());
        }
        return this.nextClass.getName().compareTo(other.nextClass.getName());
    }

    public boolean samePackage() {
        return this.originalClass.getPackageName().equals(this.nextClass.getPackageName());
    }
}

