/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAttributeDiff;
import gr.uom.java.xmi.diff.UMLClassBaseDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class UMLClassDiff
extends UMLClassBaseDiff {
    private String className;

    public UMLClassDiff(UMLClass originalClass, UMLClass nextClass, UMLModelDiff modelDiff) {
        super(originalClass, nextClass, modelDiff);
        this.className = originalClass.getName();
    }

    private void reportAddedOperation(UMLOperation umlOperation) {
        this.addedOperations.add(umlOperation);
    }

    private void reportRemovedOperation(UMLOperation umlOperation) {
        this.removedOperations.add(umlOperation);
    }

    private void reportAddedAttribute(UMLAttribute umlAttribute) {
        this.addedAttributes.add(umlAttribute);
    }

    private void reportRemovedAttribute(UMLAttribute umlAttribute) {
        this.removedAttributes.add(umlAttribute);
    }

    @Override
    protected void processAttributes() throws RefactoringMinerTimedOutException {
        Pair pair;
        UMLAttributeDiff attributeDiff;
        UMLAttribute matchingAttribute;
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            matchingAttribute = this.nextClass.containsAttribute(attribute);
            if (matchingAttribute == null) {
                this.reportRemovedAttribute(attribute);
                continue;
            }
            attributeDiff = new UMLAttributeDiff(attribute, matchingAttribute, this, this.modelDiff);
            if (!attributeDiff.isEmpty()) {
                this.refactorings.addAll(attributeDiff.getRefactorings());
                if (this.attributeDiffList.contains(attributeDiff)) continue;
                this.attributeDiffList.add(attributeDiff);
                continue;
            }
            pair = Pair.of((Object)attribute, (Object)matchingAttribute);
            if (!this.commonAtrributes.contains(pair)) {
                this.commonAtrributes.add(pair);
            }
            if (!attributeDiff.encapsulated()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
        }
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            matchingAttribute = this.originalClass.containsAttribute(attribute);
            if (matchingAttribute == null) {
                this.reportAddedAttribute(attribute);
                continue;
            }
            attributeDiff = new UMLAttributeDiff(matchingAttribute, attribute, this, this.modelDiff);
            if (!attributeDiff.isEmpty()) {
                this.refactorings.addAll(attributeDiff.getRefactorings());
                if (this.attributeDiffList.contains(attributeDiff)) continue;
                this.attributeDiffList.add(attributeDiff);
                continue;
            }
            pair = Pair.of((Object)matchingAttribute, (Object)attribute);
            if (!this.commonAtrributes.contains(pair)) {
                this.commonAtrributes.add(pair);
            }
            if (!attributeDiff.encapsulated()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
        }
    }

    @Override
    protected void processOperations() {
        int index;
        for (UMLOperation operation : this.originalClass.getOperations()) {
            index = this.nextClass.getOperations().indexOf(operation);
            UMLOperation operation2 = null;
            if (index != -1) {
                operation2 = this.nextClass.getOperations().get(index);
            }
            if (index != -1 && !this.differentParameterNames(operation, operation2)) continue;
            this.reportRemovedOperation(operation);
        }
        for (UMLOperation operation : this.nextClass.getOperations()) {
            index = this.originalClass.getOperations().indexOf(operation);
            UMLOperation operation1 = null;
            if (index != -1) {
                operation1 = this.originalClass.getOperations().get(index);
            }
            if (index != -1 && !this.differentParameterNames(operation1, operation)) continue;
            this.reportAddedOperation(operation);
        }
    }

    private boolean differentParameterNames(UMLOperation operation1, UMLOperation operation2) {
        if (operation1 != null && operation2 != null && !operation1.getParameterNameList().equals(operation2.getParameterNameList())) {
            int methodsWithIdenticalName1 = 0;
            for (UMLOperation operation : this.originalClass.getOperations()) {
                if (operation == operation1 || !operation.getName().equals(operation1.getName()) || operation.hasVarargsParameter()) continue;
                ++methodsWithIdenticalName1;
            }
            int methodsWithIdenticalName2 = 0;
            for (UMLOperation operation : this.nextClass.getOperations()) {
                if (operation == operation2 || !operation.getName().equals(operation2.getName()) || operation.hasVarargsParameter()) continue;
                ++methodsWithIdenticalName2;
            }
            if (methodsWithIdenticalName1 > 0 && methodsWithIdenticalName2 > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean containCallToOperation(VariableDeclarationContainer calledOperation, VariableDeclarationContainer callerOperation) {
        for (AbstractCall invocation : callerOperation.getAllOperationInvocations()) {
            if (!invocation.matchesOperation(calledOperation, callerOperation, this, this.modelDiff)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void createBodyMappers() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> removedOperationsToBeRemoved = new ArrayList<UMLOperation>();
        ArrayList<UMLOperation> addedOperationsToBeRemoved = new ArrayList<UMLOperation>();
        block0: for (UMLOperation originalOperation : this.originalClass.getOperations()) {
            for (UMLOperation nextOperation : this.nextClass.getOperations()) {
                UMLOperation operation1;
                List<UMLOperationBodyMapper> mappers;
                if (!originalOperation.equalsQualified(nextOperation) || this.differentParameterNames(originalOperation, nextOperation)) continue;
                if (this.getModelDiff() != null && (mappers = this.getModelDiff().findMappersWithMatchingSignature2(nextOperation)).size() > 0 && !(operation1 = mappers.get(0).getOperation1()).equalSignature(originalOperation) && this.getModelDiff().commonlyImplementedOperations(operation1, nextOperation, this)) {
                    if (this.removedOperations.contains(originalOperation)) continue block0;
                    this.removedOperations.add(originalOperation);
                    continue block0;
                }
                boolean matchFound = false;
                List<String> nextOperationStringRepresentation = nextOperation.stringRepresentation();
                if (!nextOperationStringRepresentation.equals(originalOperation.stringRepresentation()) && nextOperationStringRepresentation.size() > 2) {
                    for (UMLOperation removedOperation : this.removedOperations) {
                        if (!removedOperation.stringRepresentation().equals(nextOperationStringRepresentation) || this.containCallToOperation(removedOperation, originalOperation)) continue;
                        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, nextOperation, (UMLAbstractClassDiff)this);
                        this.addOperationBodyMapper(operationBodyMapper);
                        if (!(removedOperation.getName().equals(nextOperation.getName()) || removedOperation.isConstructor() && nextOperation.isConstructor())) {
                            RenameOperationRefactoring rename = new RenameOperationRefactoring(operationBodyMapper, new HashSet<MethodInvocationReplacement>());
                            this.refactorings.add(rename);
                        }
                        removedOperationsToBeRemoved.add(removedOperation);
                        if (!this.removedOperations.contains(originalOperation)) {
                            this.removedOperations.add(originalOperation);
                        }
                        matchFound = true;
                        break;
                    }
                }
                if (matchFound) continue;
                UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(originalOperation, nextOperation, (UMLAbstractClassDiff)this);
                this.addOperationBodyMapper(operationBodyMapper);
            }
        }
        for (UMLOperation operation : this.originalClass.getOperations()) {
            int index = this.nextClass.getOperations().indexOf(operation);
            if (this.containsMapperForOperation1(operation) || index == -1 || this.removedOperations.contains(operation) || this.differentParameterNames(operation, this.nextClass.getOperations().get(index))) continue;
            int lastIndex = this.nextClass.getOperations().lastIndexOf(operation);
            int finalIndex = index;
            if (index != lastIndex) {
                if (this.containsMapperForOperation2(this.nextClass.getOperations().get(index))) {
                    finalIndex = lastIndex;
                } else if (!operation.isConstructor()) {
                    double d1 = operation.getReturnParameter().getType().normalizedNameDistance(this.nextClass.getOperations().get(index).getReturnParameter().getType());
                    double d2 = operation.getReturnParameter().getType().normalizedNameDistance(this.nextClass.getOperations().get(lastIndex).getReturnParameter().getType());
                    if (d2 < d1) {
                        finalIndex = lastIndex;
                    }
                }
            }
            UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(operation, this.nextClass.getOperations().get(finalIndex), (UMLAbstractClassDiff)this);
            this.addOperationBodyMapper(operationBodyMapper);
        }
        for (UMLOperation removedOperation : this.removedOperations) {
            for (UMLOperation addedOperation : this.addedOperations) {
                UMLOperationBodyMapper operationBodyMapper;
                if (removedOperation.equalsIgnoringVisibility(addedOperation) && !this.differentParameterNames(removedOperation, addedOperation)) {
                    operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)this);
                    this.addOperationBodyMapper(operationBodyMapper);
                    removedOperationsToBeRemoved.add(removedOperation);
                    addedOperationsToBeRemoved.add(addedOperation);
                    continue;
                }
                if (removedOperation.equalsIgnoringAbstraction(addedOperation) && !this.differentParameterNames(removedOperation, addedOperation) && !this.containsMapperForOperation1(removedOperation)) {
                    operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)this);
                    this.addOperationBodyMapper(operationBodyMapper);
                    continue;
                }
                if (removedOperation.equalsIgnoringNameCase(addedOperation) && !this.differentParameterNames(removedOperation, addedOperation)) {
                    operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)this);
                    if (!(removedOperation.getName().equals(addedOperation.getName()) || removedOperation.isConstructor() && addedOperation.isConstructor())) {
                        RenameOperationRefactoring rename = new RenameOperationRefactoring(operationBodyMapper, new HashSet<MethodInvocationReplacement>());
                        this.refactorings.add(rename);
                    }
                    this.addOperationBodyMapper(operationBodyMapper);
                    removedOperationsToBeRemoved.add(removedOperation);
                    addedOperationsToBeRemoved.add(addedOperation);
                    continue;
                }
                if (removedOperation.equalsIgoringTypeParameters(addedOperation) && !this.differentParameterNames(removedOperation, addedOperation) && this.removedOperations.size() == this.addedOperations.size()) {
                    operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)this);
                    this.addOperationBodyMapper(operationBodyMapper);
                    removedOperationsToBeRemoved.add(removedOperation);
                    addedOperationsToBeRemoved.add(addedOperation);
                    continue;
                }
                if (!removedOperation.equalSignatureWithIdenticalNameIgnoringChangedTypesToFromObject(addedOperation) || this.differentParameterNames(removedOperation, addedOperation) || this.removedOperations.size() != this.addedOperations.size() || this.mapperListContainsOperation(removedOperation, addedOperation)) continue;
                operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)this);
                this.addOperationBodyMapper(operationBodyMapper);
                removedOperationsToBeRemoved.add(removedOperation);
                addedOperationsToBeRemoved.add(addedOperation);
            }
        }
        this.removedOperations.removeAll(removedOperationsToBeRemoved);
        this.addedOperations.removeAll(addedOperationsToBeRemoved);
    }

    @Override
    protected void checkForAttributeChanges() throws RefactoringMinerTimedOutException {
        Iterator removedAttributeIterator = this.removedAttributes.iterator();
        block0: while (removedAttributeIterator.hasNext()) {
            UMLAttribute removedAttribute = (UMLAttribute)removedAttributeIterator.next();
            Iterator addedAttributeIterator = this.addedAttributes.iterator();
            while (addedAttributeIterator.hasNext()) {
                UMLAttribute addedAttribute = (UMLAttribute)addedAttributeIterator.next();
                if (!removedAttribute.getName().equals(addedAttribute.getName())) continue;
                UMLAttributeDiff attributeDiff = new UMLAttributeDiff(removedAttribute, addedAttribute, this, this.modelDiff);
                this.refactorings.addAll(attributeDiff.getRefactorings());
                addedAttributeIterator.remove();
                removedAttributeIterator.remove();
                if (this.attributeDiffList.contains(attributeDiff)) continue block0;
                this.attributeDiffList.add(attributeDiff);
                continue block0;
            }
        }
    }

    @Override
    protected boolean containsMapperForOperation1(UMLOperation operation) {
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            if (mapper.getOperation1() == null || !mapper.getOperation1().equalsQualified(operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean containsMapperForOperation2(UMLOperation operation) {
        for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
            if (mapper.getOperation2() == null || !mapper.getOperation2().equalsQualified(operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(String className) {
        return this.className.equals(className);
    }

    @Override
    public boolean matches(UMLType type) {
        return this.className.endsWith("." + type.getClassType());
    }
}

