/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.AddAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.CandidateAttributeRefactoring;
import gr.uom.java.xmi.diff.ModifyAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.RenameAttributeRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnnotationDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import gr.uom.java.xmi.diff.UMLAnonymousClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class UMLEnumConstantDiff {
    private UMLEnumConstant removedEnumConstant;
    private UMLEnumConstant addedEnumConstant;
    private boolean renamed;
    private boolean argumentsChanged;
    private UMLAnnotationListDiff annotationListDiff;
    private UMLAnonymousClassDiff anonymousClassDiff;
    private Set<Refactoring> refactorings = new LinkedHashSet<Refactoring>();

    public UMLEnumConstantDiff(UMLEnumConstant removedEnumConstant, UMLEnumConstant addedEnumConstant, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) throws RefactoringMinerTimedOutException {
        this.removedEnumConstant = removedEnumConstant;
        this.addedEnumConstant = addedEnumConstant;
        if (!removedEnumConstant.getName().equals(addedEnumConstant.getName())) {
            this.renamed = true;
        }
        if (!removedEnumConstant.getArguments().equals(addedEnumConstant.getArguments())) {
            this.argumentsChanged = true;
        }
        this.annotationListDiff = new UMLAnnotationListDiff(removedEnumConstant.getAnnotations(), addedEnumConstant.getAnnotations());
        if (removedEnumConstant.getAnonymousClassList().size() == 1 && addedEnumConstant.getAnonymousClassList().size() == 1) {
            UMLAnonymousClass anonymousClass1 = removedEnumConstant.getAnonymousClassList().get(0);
            UMLAnonymousClass anonymousClass2 = addedEnumConstant.getAnonymousClassList().get(0);
            this.anonymousClassDiff = new UMLAnonymousClassDiff(anonymousClass1, anonymousClass2, classDiff, modelDiff);
            this.anonymousClassDiff.process();
            List<UMLOperationBodyMapper> matchedOperationMappers = this.anonymousClassDiff.getOperationBodyMapperList();
            if (matchedOperationMappers.size() > 0) {
                this.refactorings.addAll(this.anonymousClassDiff.getRefactorings());
                if (classDiff != null && classDiff.getRemovedAnonymousClasses().contains(anonymousClass1)) {
                    classDiff.getRemovedAnonymousClasses().remove(anonymousClass1);
                }
                if (classDiff != null && classDiff.getAddedAnonymousClasses().contains(anonymousClass2)) {
                    classDiff.getAddedAnonymousClasses().remove(anonymousClass2);
                }
            }
        }
    }

    public UMLEnumConstant getRemovedEnumConstant() {
        return this.removedEnumConstant;
    }

    public UMLEnumConstant getAddedEnumConstant() {
        return this.addedEnumConstant;
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isArgumentsChanged() {
        return this.argumentsChanged;
    }

    public Optional<UMLAnonymousClassDiff> getAnonymousClassDiff() {
        return Optional.ofNullable(this.anonymousClassDiff);
    }

    public boolean isEmpty() {
        boolean emptyAnonymousDiff = true;
        if (this.anonymousClassDiff != null) {
            emptyAnonymousDiff = this.anonymousClassDiff.isEmpty();
        }
        return !this.renamed && !this.argumentsChanged && this.annotationListDiff.isEmpty() && emptyAnonymousDiff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append("\t").append(this.removedEnumConstant).append("\n");
        }
        if (this.renamed) {
            sb.append("\t").append("renamed from " + this.removedEnumConstant.getName() + " to " + this.addedEnumConstant.getName()).append("\n");
        }
        if (this.argumentsChanged) {
            sb.append("\t").append("arguments changed from " + this.removedEnumConstant.getArguments() + " to " + this.addedEnumConstant.getArguments()).append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " removed").append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            sb.append("\t").append("annotation " + annotation + " added").append("\n");
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            sb.append("\t").append("annotation " + annotationDiff.getRemovedAnnotation() + " modified to " + annotationDiff.getAddedAnnotation()).append("\n");
        }
        return sb.toString();
    }

    private Set<Refactoring> getAnnotationRefactorings() {
        Refactoring refactoring;
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddAttributeAnnotationRefactoring(annotation, this.removedEnumConstant, this.addedEnumConstant);
            refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveAttributeAnnotationRefactoring(annotation, this.removedEnumConstant, this.addedEnumConstant);
            refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffs()) {
            refactoring = new ModifyAttributeAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), this.removedEnumConstant, this.addedEnumConstant);
            refactorings.add(refactoring);
        }
        return refactorings;
    }

    public Set<Refactoring> getRefactorings(Set<CandidateAttributeRefactoring> set) {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        RenameAttributeRefactoring rename = null;
        if (this.isRenamed()) {
            rename = new RenameAttributeRefactoring(this.removedEnumConstant, this.addedEnumConstant, set);
            refactorings.add(rename);
        }
        refactorings.addAll(this.refactorings);
        refactorings.addAll(this.getAnnotationRefactorings());
        return refactorings;
    }

    public Set<Refactoring> getRefactorings() {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        refactorings.addAll(this.refactorings);
        refactorings.addAll(this.getAnnotationRefactorings());
        return refactorings;
    }
}

