/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLImport;
import gr.uom.java.xmi.UMLType;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class UMLImportListDiff {
    private Set<UMLImport> removedImports;
    private Set<UMLImport> addedImports;
    private Set<Pair<UMLImport, UMLImport>> commonImports;
    private Set<Pair<UMLImport, UMLImport>> changedImports = new LinkedHashSet<Pair<UMLImport, UMLImport>>();
    private Map<Set<UMLImport>, UMLImport> groupedImports;
    private Map<UMLImport, Set<UMLImport>> unGroupedImports;

    public UMLImportListDiff(List<UMLImport> oldImports, List<UMLImport> newImports) {
        LinkedHashSet<UMLImport> oldImportSet = new LinkedHashSet<UMLImport>(oldImports);
        LinkedHashSet<UMLImport> newImportSet = new LinkedHashSet<UMLImport>(newImports);
        LinkedHashSet<UMLImport> intersection = new LinkedHashSet<UMLImport>();
        intersection.addAll(oldImportSet);
        intersection.retainAll(newImportSet);
        this.commonImports = new LinkedHashSet<Pair<UMLImport, UMLImport>>();
        for (UMLImport uMLImport : intersection) {
            UMLImport oldImport = oldImports.get(oldImports.indexOf(uMLImport));
            UMLImport newImport = newImports.get(newImports.indexOf(uMLImport));
            Pair pair = Pair.of((Object)oldImport, (Object)newImport);
            this.commonImports.add((Pair<UMLImport, UMLImport>)pair);
        }
        oldImportSet.removeAll(intersection);
        this.removedImports = oldImportSet;
        newImportSet.removeAll(intersection);
        this.addedImports = newImportSet;
        this.groupedImports = new HashMap<Set<UMLImport>, UMLImport>();
        Map<String, Set<UMLImport>> groupedRemovedImportsByPrefix = this.groupImportsByPrefix(this.removedImports);
        for (String key : groupedRemovedImportsByPrefix.keySet()) {
            UMLImport matchingImport = this.findMatchingImport(this.addedImports, key);
            if (matchingImport == null) continue;
            Set<UMLImport> value = groupedRemovedImportsByPrefix.get(key);
            this.groupedImports.put(value, matchingImport);
            this.addedImports.remove(matchingImport);
            this.removedImports.removeAll(value);
        }
        this.unGroupedImports = new HashMap<UMLImport, Set<UMLImport>>();
        Map<String, Set<UMLImport>> map = this.groupImportsByPrefix(this.addedImports);
        for (String key : map.keySet()) {
            UMLImport matchingImport = this.findMatchingImport(this.removedImports, key);
            if (matchingImport == null) continue;
            Set<UMLImport> value = map.get(key);
            this.unGroupedImports.put(matchingImport, value);
            this.removedImports.remove(matchingImport);
            this.addedImports.removeAll(value);
        }
    }

    private UMLImport findMatchingImport(Set<UMLImport> imports, String name) {
        for (UMLImport imported : imports) {
            if (!imported.getName().equals(name)) continue;
            return imported;
        }
        return null;
    }

    private UMLImport findMatchingImport(Set<UMLImport> imports, UMLType type) {
        for (UMLImport imported : imports) {
            if (!imported.getName().endsWith("." + type.getClassType())) continue;
            return imported;
        }
        return null;
    }

    private Map<String, Set<UMLImport>> groupImportsByPrefix(Set<UMLImport> imports) {
        HashMap<String, Set<UMLImport>> groupedImportsByPrefix = new HashMap<String, Set<UMLImport>>();
        for (UMLImport imported : imports) {
            String importString = imported.getName();
            if (!importString.contains(".")) continue;
            String prefix = importString.substring(0, importString.lastIndexOf("."));
            if (groupedImportsByPrefix.containsKey(prefix)) {
                ((Set)groupedImportsByPrefix.get(prefix)).add(imported);
                continue;
            }
            LinkedHashSet<UMLImport> set = new LinkedHashSet<UMLImport>();
            set.add(imported);
            groupedImportsByPrefix.put(prefix, set);
        }
        return groupedImportsByPrefix;
    }

    public void findImportChanges(String nameBefore, String nameAfter) {
        UMLImport removedImport = this.findMatchingImport(this.removedImports, nameBefore);
        UMLImport addedImport = this.findMatchingImport(this.addedImports, nameAfter);
        if (removedImport != null && addedImport != null) {
            Pair pair = Pair.of((Object)removedImport, (Object)addedImport);
            this.changedImports.add((Pair<UMLImport, UMLImport>)pair);
            this.removedImports.remove(removedImport);
            this.addedImports.remove(addedImport);
        }
        LinkedHashSet<UMLImport> matchedRemovedStaticImports = new LinkedHashSet<UMLImport>();
        for (UMLImport removed : this.removedImports) {
            if (!removed.getName().startsWith(nameBefore + ".")) continue;
            matchedRemovedStaticImports.add(removed);
        }
        LinkedHashSet<UMLImport> matchedAddedStaticImports = new LinkedHashSet<UMLImport>();
        for (UMLImport added : this.addedImports) {
            if (!added.getName().startsWith(nameAfter + ".")) continue;
            matchedAddedStaticImports.add(added);
        }
        block2: for (UMLImport removed : matchedRemovedStaticImports) {
            for (UMLImport added : matchedAddedStaticImports) {
                String suffix2;
                String suffix1 = removed.getName().substring(nameBefore.length());
                if (!suffix1.equals(suffix2 = added.getName().substring(nameAfter.length()))) continue;
                Pair pair = Pair.of((Object)removed, (Object)added);
                this.changedImports.add((Pair<UMLImport, UMLImport>)pair);
                this.removedImports.remove(removed);
                this.addedImports.remove(added);
                continue block2;
            }
        }
    }

    public void findImportChanges(UMLType typeBefore, UMLType typeAfter) {
        UMLImport removedImport = this.findMatchingImport(this.removedImports, typeBefore);
        UMLImport addedImport = this.findMatchingImport(this.addedImports, typeAfter);
        if (removedImport != null && addedImport != null) {
            Pair pair = Pair.of((Object)removedImport, (Object)addedImport);
            this.changedImports.add((Pair<UMLImport, UMLImport>)pair);
            this.removedImports.remove(removedImport);
            this.addedImports.remove(addedImport);
        }
    }

    public Set<UMLImport> getRemovedImports() {
        return this.removedImports;
    }

    public Set<UMLImport> getAddedImports() {
        return this.addedImports;
    }

    public Set<Pair<UMLImport, UMLImport>> getCommonImports() {
        return this.commonImports;
    }

    public Set<Pair<UMLImport, UMLImport>> getChangedImports() {
        return this.changedImports;
    }

    public Map<Set<UMLImport>, UMLImport> getGroupedImports() {
        return this.groupedImports;
    }

    public Map<UMLImport, Set<UMLImport>> getUnGroupedImports() {
        return this.unGroupedImports;
    }
}

