/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.LeafType;
import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLClassMatcher;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLGeneralization;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLRealization;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.UMLTypeParameter;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObjectMapping;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapperComparator;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.ClassInstanceCreationWithMethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.MergeVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationWithClassInstanceCreationReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.VariableReplacementWithMethodInvocation;
import gr.uom.java.xmi.diff.AddAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.AddAttributeModifierRefactoring;
import gr.uom.java.xmi.diff.AddParameterRefactoring;
import gr.uom.java.xmi.diff.CandidateAttributeRefactoring;
import gr.uom.java.xmi.diff.CandidateExtractClassRefactoring;
import gr.uom.java.xmi.diff.CandidateMergeVariableRefactoring;
import gr.uom.java.xmi.diff.ChangeAttributeAccessModifierRefactoring;
import gr.uom.java.xmi.diff.ChangeAttributeTypeRefactoring;
import gr.uom.java.xmi.diff.ChangeReturnTypeRefactoring;
import gr.uom.java.xmi.diff.ChangeVariableTypeRefactoring;
import gr.uom.java.xmi.diff.ClassMoveComparator;
import gr.uom.java.xmi.diff.ClassRenameComparator;
import gr.uom.java.xmi.diff.CollapseHierarchyRefactoring;
import gr.uom.java.xmi.diff.ExtractClassRefactoring;
import gr.uom.java.xmi.diff.ExtractOperationDetection;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.ExtractSuperclassRefactoring;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.MappingOptimizer;
import gr.uom.java.xmi.diff.MergeAttributeRefactoring;
import gr.uom.java.xmi.diff.MergeClassRefactoring;
import gr.uom.java.xmi.diff.MergePackageRefactoring;
import gr.uom.java.xmi.diff.MoveAndRenameAttributeRefactoring;
import gr.uom.java.xmi.diff.MoveAndRenameClassRefactoring;
import gr.uom.java.xmi.diff.MoveAttributeRefactoring;
import gr.uom.java.xmi.diff.MoveClassRefactoring;
import gr.uom.java.xmi.diff.MoveOperationRefactoring;
import gr.uom.java.xmi.diff.MoveSourceFolderRefactoring;
import gr.uom.java.xmi.diff.MovedClassToAnotherSourceFolder;
import gr.uom.java.xmi.diff.PackageLevelRefactoring;
import gr.uom.java.xmi.diff.PullUpAttributeRefactoring;
import gr.uom.java.xmi.diff.PullUpOperationRefactoring;
import gr.uom.java.xmi.diff.PushDownAttributeRefactoring;
import gr.uom.java.xmi.diff.PushDownOperationRefactoring;
import gr.uom.java.xmi.diff.RemoveAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.RemoveAttributeModifierRefactoring;
import gr.uom.java.xmi.diff.RemoveParameterRefactoring;
import gr.uom.java.xmi.diff.RenameAttributeRefactoring;
import gr.uom.java.xmi.diff.RenameClassRefactoring;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import gr.uom.java.xmi.diff.RenamePackageRefactoring;
import gr.uom.java.xmi.diff.RenamePattern;
import gr.uom.java.xmi.diff.RenameVariableRefactoring;
import gr.uom.java.xmi.diff.ReplaceAnonymousWithClassRefactoring;
import gr.uom.java.xmi.diff.ReplaceAttributeRefactoring;
import gr.uom.java.xmi.diff.SplitClassRefactoring;
import gr.uom.java.xmi.diff.SplitPackageRefactoring;
import gr.uom.java.xmi.diff.StringDistance;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnonymousToClassDiff;
import gr.uom.java.xmi.diff.UMLAttributeDiff;
import gr.uom.java.xmi.diff.UMLClassBaseDiff;
import gr.uom.java.xmi.diff.UMLClassDiff;
import gr.uom.java.xmi.diff.UMLClassMergeDiff;
import gr.uom.java.xmi.diff.UMLClassMoveDiff;
import gr.uom.java.xmi.diff.UMLClassRenameDiff;
import gr.uom.java.xmi.diff.UMLClassSplitDiff;
import gr.uom.java.xmi.diff.UMLEnumConstantDiff;
import gr.uom.java.xmi.diff.UMLGeneralizationDiff;
import gr.uom.java.xmi.diff.UMLOperationDiff;
import gr.uom.java.xmi.diff.UMLRealizationDiff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.util.PrefixSuffixUtils;

public class UMLModelDiff {
    private static final Pattern RETURN_NUMBER_LITERAL = Pattern.compile("return \\d+;\n");
    private final int MAXIMUM_NUMBER_OF_COMPARED_METHODS;
    private UMLModel parentModel;
    private UMLModel childModel;
    private List<UMLClass> addedClasses;
    private List<UMLClass> removedClasses;
    private List<UMLGeneralization> addedGeneralizations;
    private List<UMLGeneralization> removedGeneralizations;
    private List<UMLGeneralizationDiff> generalizationDiffList;
    private List<UMLRealization> addedRealizations;
    private List<UMLRealization> removedRealizations;
    private List<UMLRealizationDiff> realizationDiffList;
    private List<UMLClassDiff> commonClassDiffList;
    private List<UMLClassMoveDiff> classMoveDiffList;
    private List<UMLClassMoveDiff> innerClassMoveDiffList;
    private List<UMLClassRenameDiff> classRenameDiffList;
    private List<UMLClassMergeDiff> classMergeDiffList;
    private List<UMLClassSplitDiff> classSplitDiffList;
    private List<UMLAttributeDiff> movedAttributeDiffList;
    private List<Refactoring> refactorings;
    private Set<Refactoring> moveRenameClassRefactorings;
    private Set<String> deletedFolderPaths;
    private Set<Pair<VariableDeclarationContainer, VariableDeclarationContainer>> processedOperationPairs = new HashSet<Pair<VariableDeclarationContainer, VariableDeclarationContainer>>();
    private Set<Pair<UMLClass, UMLClass>> processedClassPairs = new HashSet<Pair<UMLClass, UMLClass>>();

    public UMLModelDiff(UMLModel parentModel, UMLModel childModel) {
        this.parentModel = parentModel;
        this.childModel = childModel;
        this.MAXIMUM_NUMBER_OF_COMPARED_METHODS = this.partialModel() ? 500 : 200;
        this.addedClasses = new ArrayList<UMLClass>();
        this.removedClasses = new ArrayList<UMLClass>();
        this.addedGeneralizations = new ArrayList<UMLGeneralization>();
        this.removedGeneralizations = new ArrayList<UMLGeneralization>();
        this.generalizationDiffList = new ArrayList<UMLGeneralizationDiff>();
        this.realizationDiffList = new ArrayList<UMLRealizationDiff>();
        this.addedRealizations = new ArrayList<UMLRealization>();
        this.removedRealizations = new ArrayList<UMLRealization>();
        this.commonClassDiffList = new ArrayList<UMLClassDiff>();
        this.classMoveDiffList = new ArrayList<UMLClassMoveDiff>();
        this.innerClassMoveDiffList = new ArrayList<UMLClassMoveDiff>();
        this.classRenameDiffList = new ArrayList<UMLClassRenameDiff>();
        this.classMergeDiffList = new ArrayList<UMLClassMergeDiff>();
        this.classSplitDiffList = new ArrayList<UMLClassSplitDiff>();
        this.movedAttributeDiffList = new ArrayList<UMLAttributeDiff>();
        this.refactorings = new ArrayList<Refactoring>();
        this.deletedFolderPaths = new LinkedHashSet<String>();
    }

    public UMLModel getParentModel() {
        return this.parentModel;
    }

    public UMLModel getChildModel() {
        return this.childModel;
    }

    public UMLAbstractClass findClassInParentModel(String className) {
        for (UMLClass umlClass : this.parentModel.getClassList()) {
            if (!umlClass.getName().equals(className)) continue;
            return umlClass;
        }
        for (UMLClass umlClass : this.parentModel.getClassList()) {
            if (!umlClass.getName().endsWith("." + className)) continue;
            return umlClass;
        }
        return null;
    }

    public UMLAbstractClass findClassInChildModel(String className) {
        for (UMLClass umlClass : this.childModel.getClassList()) {
            if (!umlClass.getName().equals(className)) continue;
            return umlClass;
        }
        for (UMLClass umlClass : this.childModel.getClassList()) {
            if (!umlClass.getName().endsWith("." + className)) continue;
            return umlClass;
        }
        return null;
    }

    public void reportAddedClass(UMLClass umlClass) {
        if (!this.addedClasses.contains(umlClass)) {
            this.addedClasses.add(umlClass);
        }
    }

    public List<UMLClass> getAddedClasses() {
        return this.addedClasses;
    }

    public void reportRemovedClass(UMLClass umlClass) {
        if (!this.removedClasses.contains(umlClass)) {
            this.removedClasses.add(umlClass);
        }
    }

    public List<UMLClass> getRemovedClasses() {
        return this.removedClasses;
    }

    public void reportAddedGeneralization(UMLGeneralization umlGeneralization) {
        this.addedGeneralizations.add(umlGeneralization);
    }

    public void reportRemovedGeneralization(UMLGeneralization umlGeneralization) {
        this.removedGeneralizations.add(umlGeneralization);
    }

    public void reportAddedRealization(UMLRealization umlRealization) {
        this.addedRealizations.add(umlRealization);
    }

    public void reportRemovedRealization(UMLRealization umlRealization) {
        this.removedRealizations.add(umlRealization);
    }

    public void addUMLClassDiff(UMLClassDiff classDiff) {
        this.commonClassDiffList.add(classDiff);
    }

    public List<UMLClassDiff> getCommonClassDiffList() {
        return this.commonClassDiffList;
    }

    public List<UMLClassMoveDiff> getClassMoveDiffList() {
        return this.classMoveDiffList;
    }

    public List<UMLClassMoveDiff> getInnerClassMoveDiffList() {
        return this.innerClassMoveDiffList;
    }

    public List<UMLClassRenameDiff> getClassRenameDiffList() {
        return this.classRenameDiffList;
    }

    public List<UMLAttributeDiff> getMovedAttributeDiffList() {
        return this.movedAttributeDiffList;
    }

    public boolean commonlyImplementedOperations(UMLOperation operation1, UMLOperation operation2, UMLClassBaseDiff classDiff2) {
        UMLClassBaseDiff classDiff1 = this.getUMLClassDiff(operation1.getClassName());
        if (classDiff1 != null) {
            Set<UMLType> commonInterfaces = classDiff1.nextClassCommonInterfaces(classDiff2);
            for (UMLType commonInterface : commonInterfaces) {
                UMLClassBaseDiff interfaceDiff = this.getUMLClassDiff(commonInterface);
                if (interfaceDiff == null || !interfaceDiff.containsOperationWithTheSameSignatureInOriginalClass(operation1) || !interfaceDiff.containsOperationWithTheSameSignatureInNextClass(operation2)) continue;
                return true;
            }
        }
        return false;
    }

    public UMLClassBaseDiff getUMLClassDiff(String className) {
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (!uMLClassDiff.matches(className)) continue;
            return uMLClassDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (!uMLClassMoveDiff.matches(className)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (!uMLClassMoveDiff.matches(className)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (!uMLClassRenameDiff.matches(className)) continue;
            return uMLClassRenameDiff;
        }
        return null;
    }

    public UMLClassBaseDiff getUMLClassDiff(UMLType type) {
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (!uMLClassDiff.matches(type)) continue;
            return uMLClassDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (!uMLClassMoveDiff.matches(type)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (!uMLClassMoveDiff.matches(type)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (!uMLClassRenameDiff.matches(type)) continue;
            return uMLClassRenameDiff;
        }
        return null;
    }

    private UMLClassBaseDiff getUMLClassDiffWithAttribute(Replacement pattern) {
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (uMLClassDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (uMLClassRenameDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassRenameDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassRenameDiff;
        }
        return null;
    }

    private List<UMLClassBaseDiff> getUMLClassDiffWithExistingAttributeAfter(Replacement pattern) {
        ArrayList<UMLClassBaseDiff> classDiffs = new ArrayList<UMLClassBaseDiff>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (uMLClassDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (uMLClassRenameDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassRenameDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassRenameDiff);
        }
        return classDiffs;
    }

    private List<UMLClassBaseDiff> getUMLClassDiffWithNewAttributeAfter(Replacement pattern) {
        ArrayList<UMLClassBaseDiff> classDiffs = new ArrayList<UMLClassBaseDiff>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (uMLClassDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (uMLClassRenameDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassRenameDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassRenameDiff);
        }
        return classDiffs;
    }

    public boolean isSubclassOf(String subclass, String finalSuperclass) {
        return this.isSubclassOf(subclass, finalSuperclass, new LinkedHashSet<String>());
    }

    private boolean isSubclassOf(String subclass, String finalSuperclass, Set<String> visitedClasses) {
        UMLClass removedClass;
        UMLClass addedClass;
        if (visitedClasses.contains(subclass)) {
            return false;
        }
        visitedClasses.add(subclass);
        UMLClassBaseDiff subclassDiff = this.getUMLClassDiff(subclass);
        if (subclassDiff == null) {
            subclassDiff = this.getUMLClassDiff(UMLType.extractTypeObject(subclass));
        }
        if (subclassDiff != null) {
            UMLType superclass = subclassDiff.getSuperclass();
            if (superclass != null) {
                if (this.checkInheritanceRelationship(superclass, finalSuperclass, visitedClasses)) {
                    return true;
                }
            } else if (subclassDiff.getOldSuperclass() != null && subclassDiff.getNewSuperclass() != null && !subclassDiff.getOldSuperclass().equals(subclassDiff.getNewSuperclass()) && this.looksLikeAddedClass(subclassDiff.getNewSuperclass()) != null) {
                UMLClass addedClass2 = this.looksLikeAddedClass(subclassDiff.getNewSuperclass());
                if (addedClass2.getSuperclass() != null) {
                    return this.checkInheritanceRelationship(addedClass2.getSuperclass(), finalSuperclass, visitedClasses);
                }
            } else if (subclassDiff.getOldSuperclass() == null && subclassDiff.getNewSuperclass() != null && this.looksLikeAddedClass(subclassDiff.getNewSuperclass()) != null) {
                UMLClass addedClass2 = this.looksLikeAddedClass(subclassDiff.getNewSuperclass());
                return this.checkInheritanceRelationship(UMLType.extractTypeObject(addedClass2.getName()), finalSuperclass, visitedClasses);
            }
            for (UMLType uMLType : subclassDiff.getAddedImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(uMLType, finalSuperclass, visitedClasses)) continue;
                return true;
            }
            for (UMLType uMLType : subclassDiff.getNextClass().getImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(uMLType, finalSuperclass, visitedClasses)) continue;
                return true;
            }
        }
        if ((addedClass = this.getAddedClass(subclass)) == null) {
            addedClass = this.looksLikeAddedClass(UMLType.extractTypeObject(subclass));
        }
        if (addedClass != null) {
            UMLType superclass = addedClass.getSuperclass();
            if (superclass != null) {
                return this.checkInheritanceRelationship(superclass, finalSuperclass, visitedClasses);
            }
            for (UMLType implementedInterface : addedClass.getImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(implementedInterface, finalSuperclass, visitedClasses)) continue;
                return true;
            }
        }
        if ((removedClass = this.getRemovedClass(subclass)) == null) {
            removedClass = this.looksLikeRemovedClass(UMLType.extractTypeObject(subclass));
        }
        if (removedClass != null) {
            UMLType uMLType = removedClass.getSuperclass();
            if (uMLType != null) {
                return this.checkInheritanceRelationship(uMLType, finalSuperclass, visitedClasses);
            }
            for (UMLType implementedInterface : removedClass.getImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(implementedInterface, finalSuperclass, visitedClasses)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkInheritanceRelationship(UMLType superclass, String finalSuperclass, Set<String> visitedClasses) {
        if (UMLModelDiff.looksLikeSameType(superclass.getClassType(), finalSuperclass)) {
            return true;
        }
        return this.isSubclassOf(superclass.getClassType(), finalSuperclass, visitedClasses);
    }

    private UMLClass looksLikeAddedClass(UMLType type) {
        for (UMLClass umlClass : this.addedClasses) {
            if (!umlClass.getName().endsWith("." + type.getClassType())) continue;
            return umlClass;
        }
        return null;
    }

    private UMLClass looksLikeRemovedClass(UMLType type) {
        for (UMLClass umlClass : this.removedClasses) {
            if (!umlClass.getName().endsWith("." + type.getClassType())) continue;
            return umlClass;
        }
        return null;
    }

    public UMLOperation findOperationInAddedClasses(AbstractCall operationInvocation, VariableDeclarationContainer callerOperation, UMLAbstractClassDiff classDiff) {
        for (UMLClass umlClass : this.addedClasses) {
            String expression = operationInvocation.getExpression();
            if (expression == null || !umlClass.getNonQualifiedName().equalsIgnoreCase(expression)) continue;
            for (UMLOperation operation : umlClass.getOperations()) {
                if (!operationInvocation.matchesOperation(operation, callerOperation, classDiff, this)) continue;
                return operation;
            }
        }
        return null;
    }

    public UMLClass getAddedClass(String className) {
        for (UMLClass umlClass : this.addedClasses) {
            if (!umlClass.getName().equals(className)) continue;
            return umlClass;
        }
        return null;
    }

    public UMLClass getRemovedClass(String className) {
        for (UMLClass umlClass : this.removedClasses) {
            if (!umlClass.getName().equals(className)) continue;
            return umlClass;
        }
        return null;
    }

    private String isRenamedClass(UMLClass umlClass) {
        for (UMLClassRenameDiff renameDiff : this.classRenameDiffList) {
            if (!renameDiff.getOriginalClass().equals(umlClass)) continue;
            return renameDiff.getRenamedClass().getName();
        }
        return null;
    }

    private String isMovedClass(UMLClass umlClass) {
        for (UMLClassMoveDiff moveDiff : this.classMoveDiffList) {
            if (!moveDiff.getOriginalClass().equals(umlClass)) continue;
            return moveDiff.getMovedClass().getName();
        }
        return null;
    }

    public void checkForGeneralizationChanges() {
        Iterator<UMLGeneralization> removedGeneralizationIterator = this.removedGeneralizations.iterator();
        block0: while (removedGeneralizationIterator.hasNext()) {
            UMLGeneralization removedGeneralization = removedGeneralizationIterator.next();
            Iterator<UMLGeneralization> addedGeneralizationIterator = this.addedGeneralizations.iterator();
            while (addedGeneralizationIterator.hasNext()) {
                UMLGeneralizationDiff generalizationDiff;
                UMLGeneralization addedGeneralization = addedGeneralizationIterator.next();
                String renamedChild = this.isRenamedClass(removedGeneralization.getChild());
                String movedChild = this.isMovedClass(removedGeneralization.getChild());
                if (removedGeneralization.getChild().equals(addedGeneralization.getChild())) {
                    generalizationDiff = new UMLGeneralizationDiff(removedGeneralization, addedGeneralization);
                    addedGeneralizationIterator.remove();
                    removedGeneralizationIterator.remove();
                    this.generalizationDiffList.add(generalizationDiff);
                    continue block0;
                }
                if ((renamedChild == null || !renamedChild.equals(addedGeneralization.getChild().getName())) && (movedChild == null || !movedChild.equals(addedGeneralization.getChild().getName()))) continue;
                generalizationDiff = new UMLGeneralizationDiff(removedGeneralization, addedGeneralization);
                addedGeneralizationIterator.remove();
                removedGeneralizationIterator.remove();
                this.generalizationDiffList.add(generalizationDiff);
                continue block0;
            }
        }
    }

    public void checkForRealizationChanges() {
        Iterator<UMLRealization> removedRealizationIterator = this.removedRealizations.iterator();
        block0: while (removedRealizationIterator.hasNext()) {
            UMLRealization removedRealization = removedRealizationIterator.next();
            Iterator<UMLRealization> addedRealizationIterator = this.addedRealizations.iterator();
            while (addedRealizationIterator.hasNext()) {
                UMLRealization addedRealization = addedRealizationIterator.next();
                String renamedChild = this.isRenamedClass(removedRealization.getClient());
                String movedChild = this.isMovedClass(removedRealization.getClient());
                if ((renamedChild == null || !renamedChild.equals(addedRealization.getClient().getName())) && (movedChild == null || !movedChild.equals(addedRealization.getClient().getName()))) continue;
                UMLRealizationDiff realizationDiff = new UMLRealizationDiff(removedRealization, addedRealization);
                addedRealizationIterator.remove();
                removedRealizationIterator.remove();
                this.realizationDiffList.add(realizationDiff);
                continue block0;
            }
        }
    }

    public void checkForMovedClasses(Set<String> repositoryDirectories, UMLClassMatcher matcher) throws RefactoringMinerTimedOutException {
        if (this.removedClasses.size() <= this.addedClasses.size()) {
            Iterator<UMLClass> removedClassIterator = this.removedClasses.iterator();
            while (removedClassIterator.hasNext()) {
                UMLClass removedClass = removedClassIterator.next();
                diffSet = new TreeSet<UMLClassMoveDiff>(new ClassMoveComparator());
                for (UMLClass addedClass : this.addedClasses) {
                    UMLClassMatcher.MatchResult matchResult;
                    removedClassSourceFile = removedClass.getSourceFile();
                    String removedClassSourceFolder = "";
                    if (removedClassSourceFile.contains("/")) {
                        removedClassSourceFolder = removedClassSourceFile.substring(0, removedClassSourceFile.lastIndexOf("/"));
                    }
                    if (!repositoryDirectories.contains(removedClassSourceFolder)) {
                        this.deletedFolderPaths.add(removedClassSourceFolder);
                        String subDirectory = new String(removedClassSourceFolder);
                        while (subDirectory.contains("/")) {
                            if (repositoryDirectories.contains(subDirectory = subDirectory.substring(0, subDirectory.lastIndexOf("/")))) continue;
                            this.deletedFolderPaths.add(subDirectory);
                        }
                    }
                    if (!(matchResult = matcher.match(removedClass, addedClass)).isMatch() || this.conflictingMoveOfTopLevelClass(removedClass, addedClass)) continue;
                    classMoveDiff = new UMLClassMoveDiff(removedClass, addedClass, this, matchResult);
                    diffSet.add(classMoveDiff);
                }
                if (diffSet.isEmpty()) continue;
                minClassMoveDiff = diffSet.first();
                renameDiffSet = new TreeSet();
                if (matcher instanceof UMLClassMatcher.RelaxedMove) {
                    renameDiffSet = this.findRenameMatchesForRemovedClass(removedClass, new UMLClassMatcher.RelaxedRename());
                }
                if (!(renameDiffSet.isEmpty() || ((UMLClassRenameDiff)renameDiffSet.first()).getOriginalClass().equals(minClassMoveDiff.getOriginalClass()) && ((UMLClassRenameDiff)renameDiffSet.first()).getRenamedClass().equals(minClassMoveDiff.getMovedClass()))) {
                    minClassRenameDiff = (UMLClassRenameDiff)renameDiffSet.first();
                    int matchedMembers1 = minClassMoveDiff.getMatchResult().getMatchedOperations() + minClassMoveDiff.getMatchResult().getMatchedAttributes();
                    int matchedMembers2 = minClassRenameDiff.getMatchResult().getMatchedOperations() + minClassRenameDiff.getMatchResult().getMatchedAttributes();
                    if (matchedMembers2 > matchedMembers1) {
                        minClassRenameDiff.process();
                        this.classRenameDiffList.add(minClassRenameDiff);
                        this.addedClasses.remove(minClassRenameDiff.getRenamedClass());
                        removedClassIterator.remove();
                        continue;
                    }
                    minClassMoveDiff.process();
                    this.classMoveDiffList.add(minClassMoveDiff);
                    this.addedClasses.remove(minClassMoveDiff.getMovedClass());
                    removedClassIterator.remove();
                    continue;
                }
                minClassMoveDiff.process();
                this.classMoveDiffList.add(minClassMoveDiff);
                this.addedClasses.remove(minClassMoveDiff.getMovedClass());
                removedClassIterator.remove();
            }
        } else {
            Iterator<UMLClass> addedClassIterator = this.addedClasses.iterator();
            while (addedClassIterator.hasNext()) {
                UMLClass addedClass = addedClassIterator.next();
                diffSet = new TreeSet<UMLClassMoveDiff>(new ClassMoveComparator());
                for (UMLClass removedClass : this.removedClasses) {
                    UMLClassMatcher.MatchResult matchResult;
                    removedClassSourceFile = removedClass.getSourceFile();
                    String removedClassSourceFolder = "";
                    if (removedClassSourceFile.contains("/")) {
                        removedClassSourceFolder = removedClassSourceFile.substring(0, removedClassSourceFile.lastIndexOf("/"));
                    }
                    if (!repositoryDirectories.contains(removedClassSourceFolder)) {
                        this.deletedFolderPaths.add(removedClassSourceFolder);
                        String subDirectory = new String(removedClassSourceFolder);
                        while (subDirectory.contains("/")) {
                            if (repositoryDirectories.contains(subDirectory = subDirectory.substring(0, subDirectory.lastIndexOf("/")))) continue;
                            this.deletedFolderPaths.add(subDirectory);
                        }
                    }
                    if (!(matchResult = matcher.match(removedClass, addedClass)).isMatch() || this.conflictingMoveOfTopLevelClass(removedClass, addedClass)) continue;
                    classMoveDiff = new UMLClassMoveDiff(removedClass, addedClass, this, matchResult);
                    diffSet.add(classMoveDiff);
                }
                if (diffSet.isEmpty()) continue;
                minClassMoveDiff = diffSet.first();
                renameDiffSet = new TreeSet();
                if (matcher instanceof UMLClassMatcher.RelaxedMove) {
                    renameDiffSet = this.findRenameMatchesForAddedClass(addedClass, new UMLClassMatcher.RelaxedRename());
                }
                if (!(renameDiffSet.isEmpty() || ((UMLClassRenameDiff)renameDiffSet.first()).getOriginalClass().equals(minClassMoveDiff.getOriginalClass()) && ((UMLClassRenameDiff)renameDiffSet.first()).getRenamedClass().equals(minClassMoveDiff.getMovedClass()))) {
                    minClassRenameDiff = (UMLClassRenameDiff)renameDiffSet.first();
                    int matchedMembers1 = minClassMoveDiff.getMatchResult().getMatchedOperations() + minClassMoveDiff.getMatchResult().getMatchedAttributes();
                    int matchedMembers2 = minClassRenameDiff.getMatchResult().getMatchedOperations() + minClassRenameDiff.getMatchResult().getMatchedAttributes();
                    if (matchedMembers2 > matchedMembers1) {
                        minClassRenameDiff.process();
                        this.classRenameDiffList.add(minClassRenameDiff);
                        this.removedClasses.remove(minClassRenameDiff.getOriginalClass());
                        addedClassIterator.remove();
                        continue;
                    }
                    minClassMoveDiff.process();
                    this.classMoveDiffList.add(minClassMoveDiff);
                    this.removedClasses.remove(minClassMoveDiff.getOriginalClass());
                    addedClassIterator.remove();
                    continue;
                }
                minClassMoveDiff.process();
                this.classMoveDiffList.add(minClassMoveDiff);
                this.removedClasses.remove(minClassMoveDiff.getOriginalClass());
                addedClassIterator.remove();
            }
        }
        ArrayList<UMLClassMoveDiff> allClassMoves = new ArrayList<UMLClassMoveDiff>(this.classMoveDiffList);
        Collections.sort(allClassMoves);
        for (int i = 0; i < allClassMoves.size(); ++i) {
            UMLClassMoveDiff classMoveI = (UMLClassMoveDiff)allClassMoves.get(i);
            for (int j = i + 1; j < allClassMoves.size(); ++j) {
                UMLClassMoveDiff classMoveJ = (UMLClassMoveDiff)allClassMoves.get(j);
                if (!classMoveI.isInnerClassMove(classMoveJ)) continue;
                this.innerClassMoveDiffList.add(classMoveJ);
            }
        }
        this.classMoveDiffList.removeAll(this.innerClassMoveDiffList);
    }

    private boolean conflictingMoveOfTopLevelClass(UMLClass removedClass, UMLClass addedClass) {
        if (!removedClass.isTopLevel() && !addedClass.isTopLevel()) {
            for (UMLClassMoveDiff diff : this.classMoveDiffList) {
                if ((!diff.getOriginalClass().getName().startsWith(removedClass.getPackageName()) || diff.getMovedClass().getName().startsWith(addedClass.getPackageName())) && (diff.getOriginalClass().getName().startsWith(removedClass.getPackageName()) || !diff.getMovedClass().getName().startsWith(addedClass.getPackageName()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sameRenamedClass(Set<UMLClassRenameDiff> union) {
        if (union.size() > 1) {
            UMLClass renamedClass = null;
            for (UMLClassRenameDiff renameDiff : union) {
                if (renamedClass == null) {
                    renamedClass = renameDiff.getRenamedClass();
                    continue;
                }
                if (renamedClass.equals(renameDiff.getRenamedClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean sameOriginalClass(Set<UMLClassRenameDiff> union) {
        if (union.size() > 1) {
            UMLClass originalClass = null;
            for (UMLClassRenameDiff renameDiff : union) {
                if (originalClass == null) {
                    originalClass = renameDiff.getOriginalClass();
                    continue;
                }
                if (originalClass.equals(renameDiff.getOriginalClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean inheritanceRelationshipBetweenMergedClasses(Set<UMLClassRenameDiff> union) {
        if (union.size() > 1) {
            UMLClass originalClass = null;
            for (UMLClassRenameDiff renameDiff : union) {
                if (originalClass == null) {
                    originalClass = renameDiff.getOriginalClass();
                    continue;
                }
                if (!this.isSubclassOf(originalClass.getName(), renameDiff.getOriginalClass().getName()) && !this.isSubclassOf(renameDiff.getOriginalClass().getName(), originalClass.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean inheritanceRelationshipBetweenSplitClasses(Set<UMLClassRenameDiff> union) {
        if (union.size() > 1) {
            UMLClass renamedClass = null;
            for (UMLClassRenameDiff renameDiff : union) {
                if (renamedClass == null) {
                    renamedClass = renameDiff.getRenamedClass();
                    continue;
                }
                if (!this.isSubclassOf(renamedClass.getName(), renameDiff.getRenamedClass().getName()) && !this.isSubclassOf(renameDiff.getRenamedClass().getName(), renamedClass.getName()) && !renamedClass.hasCommonOperationWithTheSameSignature(renameDiff.getRenamedClass()).isMatch()) continue;
                return true;
            }
        }
        return false;
    }

    public void checkForRenamedClasses(UMLClassMatcher matcher) throws RefactoringMinerTimedOutException {
        if (this.removedClasses.size() <= this.addedClasses.size()) {
            HashSet<UMLClass> mergedClassesToBeRemoved = new HashSet<UMLClass>();
            Iterator<UMLClass> removedClassIterator = this.removedClasses.iterator();
            while (removedClassIterator.hasNext()) {
                UMLClass removedClass = removedClassIterator.next();
                TreeSet<UMLClassRenameDiff> diffSet = this.findRenameMatchesForRemovedClass(removedClass, matcher);
                if (diffSet.isEmpty()) continue;
                UMLClassRenameDiff minClassRenameDiff = diffSet.first();
                boolean mergeFound = false;
                boolean splitFound = false;
                boolean conflictFound = false;
                TreeSet<UMLClassRenameDiff> renameDiffSet = this.findRenameMatchesForAddedClass(minClassRenameDiff.getRenamedClass(), matcher);
                TreeSet<UMLClassRenameDiff> union = new TreeSet<UMLClassRenameDiff>();
                union.addAll(diffSet);
                union.addAll(renameDiffSet);
                if (matcher instanceof UMLClassMatcher.RelaxedRename) {
                    if (this.sameRenamedClass(union) && !this.inheritanceRelationshipBetweenMergedClasses(union) && !this.partialModel()) {
                        UMLClassMergeDiff mergeDiff = new UMLClassMergeDiff(union);
                        this.classMergeDiffList.add(mergeDiff);
                        for (UMLClassRenameDiff renameDiff : union) {
                            this.addedClasses.remove(renameDiff.getRenamedClass());
                            mergedClassesToBeRemoved.add(renameDiff.getOriginalClass());
                        }
                        removedClassIterator.remove();
                        mergeFound = true;
                    } else if (this.sameOriginalClass(union) && !this.inheritanceRelationshipBetweenSplitClasses(union) && !this.partialModel()) {
                        UMLClassSplitDiff splitDiff = new UMLClassSplitDiff(union);
                        this.classSplitDiffList.add(splitDiff);
                        for (UMLClassRenameDiff renameDiff : union) {
                            this.addedClasses.remove(renameDiff.getRenamedClass());
                            mergedClassesToBeRemoved.add(renameDiff.getOriginalClass());
                        }
                        removedClassIterator.remove();
                        splitFound = true;
                    }
                } else if (matcher instanceof UMLClassMatcher.Rename && (union.size() > 2 && this.sameRenamedClass(union) || renameDiffSet.size() > 2 && this.sameRenamedClass(renameDiffSet))) {
                    for (UMLClassRenameDiff renameDiff : union) {
                        this.addedClasses.remove(renameDiff.getRenamedClass());
                        mergedClassesToBeRemoved.add(renameDiff.getOriginalClass());
                    }
                    removedClassIterator.remove();
                    conflictFound = true;
                }
                if (mergeFound || splitFound || conflictFound) continue;
                if (!(renameDiffSet.isEmpty() || renameDiffSet.first().getOriginalClass().equals(minClassRenameDiff.getOriginalClass()) && renameDiffSet.first().getRenamedClass().equals(minClassRenameDiff.getRenamedClass()))) {
                    UMLClassRenameDiff minClassRenameDiff2 = renameDiffSet.first();
                    int matchedMembers1 = minClassRenameDiff.getMatchResult().getMatchedOperations() + minClassRenameDiff.getMatchResult().getMatchedAttributes();
                    int matchedMembers2 = minClassRenameDiff2.getMatchResult().getMatchedOperations() + minClassRenameDiff2.getMatchResult().getMatchedAttributes();
                    if (matchedMembers2 > matchedMembers1) {
                        minClassRenameDiff2.process();
                        this.classRenameDiffList.add(minClassRenameDiff2);
                        this.addedClasses.remove(minClassRenameDiff2.getRenamedClass());
                        removedClassIterator.remove();
                        continue;
                    }
                    minClassRenameDiff.process();
                    this.classRenameDiffList.add(minClassRenameDiff);
                    this.addedClasses.remove(minClassRenameDiff.getRenamedClass());
                    removedClassIterator.remove();
                    continue;
                }
                minClassRenameDiff.process();
                this.classRenameDiffList.add(minClassRenameDiff);
                this.addedClasses.remove(minClassRenameDiff.getRenamedClass());
                removedClassIterator.remove();
            }
            this.removedClasses.removeAll(mergedClassesToBeRemoved);
        } else {
            Iterator<UMLClass> addedClassIterator = this.addedClasses.iterator();
            while (addedClassIterator.hasNext()) {
                UMLClass addedClass = addedClassIterator.next();
                TreeSet<UMLClassRenameDiff> diffSet = this.findRenameMatchesForAddedClass(addedClass, matcher);
                if (diffSet.isEmpty()) continue;
                UMLClassRenameDiff minClassRenameDiff = diffSet.first();
                boolean mergeFound = false;
                boolean splitFound = false;
                boolean conflictFound = false;
                TreeSet<UMLClassRenameDiff> renameDiffSet = this.findRenameMatchesForRemovedClass(minClassRenameDiff.getOriginalClass(), matcher);
                TreeSet<UMLClassRenameDiff> union = new TreeSet<UMLClassRenameDiff>();
                union.addAll(diffSet);
                union.addAll(renameDiffSet);
                if (matcher instanceof UMLClassMatcher.RelaxedRename) {
                    if (this.sameRenamedClass(union) && !this.inheritanceRelationshipBetweenMergedClasses(union) && !this.partialModel()) {
                        UMLClassMergeDiff mergeDiff = new UMLClassMergeDiff(union);
                        this.classMergeDiffList.add(mergeDiff);
                        for (UMLClassRenameDiff renameDiff : union) {
                            this.removedClasses.remove(renameDiff.getOriginalClass());
                        }
                        addedClassIterator.remove();
                        mergeFound = true;
                    } else if (this.sameOriginalClass(union) && !this.inheritanceRelationshipBetweenSplitClasses(union) && !this.partialModel()) {
                        UMLClassSplitDiff splitDiff = new UMLClassSplitDiff(union);
                        this.classSplitDiffList.add(splitDiff);
                        for (UMLClassRenameDiff renameDiff : union) {
                            this.removedClasses.remove(renameDiff.getOriginalClass());
                        }
                        addedClassIterator.remove();
                        splitFound = true;
                    }
                } else if (matcher instanceof UMLClassMatcher.Rename && (union.size() > 2 && this.sameRenamedClass(union) || renameDiffSet.size() > 2 && this.sameRenamedClass(renameDiffSet))) {
                    for (UMLClassRenameDiff renameDiff : union) {
                        this.removedClasses.remove(renameDiff.getOriginalClass());
                    }
                    addedClassIterator.remove();
                    conflictFound = true;
                }
                if (mergeFound || splitFound || conflictFound) continue;
                if (!(renameDiffSet.isEmpty() || renameDiffSet.first().getOriginalClass().equals(minClassRenameDiff.getOriginalClass()) && renameDiffSet.first().getRenamedClass().equals(minClassRenameDiff.getRenamedClass()))) {
                    UMLClassRenameDiff minClassRenameDiff2 = renameDiffSet.first();
                    int matchedMembers1 = minClassRenameDiff.getMatchResult().getMatchedOperations() + minClassRenameDiff.getMatchResult().getMatchedAttributes();
                    int matchedMembers2 = minClassRenameDiff2.getMatchResult().getMatchedOperations() + minClassRenameDiff2.getMatchResult().getMatchedAttributes();
                    if (matchedMembers2 > matchedMembers1) {
                        minClassRenameDiff2.process();
                        this.classRenameDiffList.add(minClassRenameDiff2);
                        this.removedClasses.remove(minClassRenameDiff2.getOriginalClass());
                        addedClassIterator.remove();
                        continue;
                    }
                    minClassRenameDiff.process();
                    this.classRenameDiffList.add(minClassRenameDiff);
                    this.removedClasses.remove(minClassRenameDiff.getOriginalClass());
                    addedClassIterator.remove();
                    continue;
                }
                minClassRenameDiff.process();
                this.classRenameDiffList.add(minClassRenameDiff);
                this.removedClasses.remove(minClassRenameDiff.getOriginalClass());
                addedClassIterator.remove();
            }
        }
        ArrayList<UMLClassMoveDiff> allClassMoves = new ArrayList<UMLClassMoveDiff>(this.classMoveDiffList);
        Collections.sort(allClassMoves);
        for (UMLClassRenameDiff classRename : this.classRenameDiffList) {
            for (UMLClassMoveDiff classMove : allClassMoves) {
                if (!classRename.isInnerClassMove(classMove)) continue;
                this.innerClassMoveDiffList.add(classMove);
            }
        }
        this.classMoveDiffList.removeAll(this.innerClassMoveDiffList);
    }

    private TreeSet<UMLClassRenameDiff> findRenameMatchesForRemovedClass(UMLClass removedClass, UMLClassMatcher matcher) {
        TreeSet<UMLClassRenameDiff> diffSet = new TreeSet<UMLClassRenameDiff>(new ClassRenameComparator());
        for (UMLClass addedClass : this.addedClasses) {
            UMLClassMatcher.MatchResult matchResult;
            if (matcher instanceof UMLClassMatcher.RelaxedRename) {
                Pair pair = Pair.of((Object)removedClass, (Object)addedClass);
                if (this.processedClassPairs.contains(pair)) continue;
                this.processedClassPairs.add((Pair<UMLClass, UMLClass>)pair);
            }
            if (!(matchResult = matcher.match(removedClass, addedClass)).isMatch() || this.conflictingMoveOfTopLevelClass(removedClass, addedClass) || this.innerClassWithTheSameName(removedClass, addedClass)) continue;
            UMLClassRenameDiff classRenameDiff = new UMLClassRenameDiff(removedClass, addedClass, this, matchResult);
            diffSet.add(classRenameDiff);
        }
        return diffSet;
    }

    private TreeSet<UMLClassRenameDiff> findRenameMatchesForAddedClass(UMLClass addedClass, UMLClassMatcher matcher) {
        TreeSet<UMLClassRenameDiff> diffSet = new TreeSet<UMLClassRenameDiff>(new ClassRenameComparator());
        for (UMLClass removedClass : this.removedClasses) {
            UMLClassMatcher.MatchResult matchResult;
            if (matcher instanceof UMLClassMatcher.RelaxedRename) {
                Pair pair = Pair.of((Object)removedClass, (Object)addedClass);
                if (this.processedClassPairs.contains(pair)) continue;
                this.processedClassPairs.add((Pair<UMLClass, UMLClass>)pair);
            }
            if (!(matchResult = matcher.match(removedClass, addedClass)).isMatch() || this.conflictingMoveOfTopLevelClass(removedClass, addedClass) || this.innerClassWithTheSameName(removedClass, addedClass)) continue;
            UMLClassRenameDiff classRenameDiff = new UMLClassRenameDiff(removedClass, addedClass, this, matchResult);
            diffSet.add(classRenameDiff);
        }
        return diffSet;
    }

    private boolean innerClassWithTheSameName(UMLClass removedClass, UMLClass addedClass) {
        String addedClassName;
        String addedName;
        String removedClassName;
        String removedName;
        return !removedClass.isTopLevel() && !addedClass.isTopLevel() && (removedName = (removedClassName = removedClass.getName()).substring(removedClassName.lastIndexOf(".") + 1, removedClassName.length())).equals(addedName = (addedClassName = addedClass.getName()).substring(addedClassName.lastIndexOf(".") + 1, addedClassName.length()));
    }

    public List<UMLGeneralization> getAddedGeneralizations() {
        return this.addedGeneralizations;
    }

    public List<UMLRealization> getAddedRealizations() {
        return this.addedRealizations;
    }

    private List<MoveAttributeRefactoring> checkForAttributeMovesIncludingRemovedClasses(Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap, Set<Refactoring> refactorings) throws RefactoringMinerTimedOutException {
        List<UMLAttribute> addedAttributes = this.getAddedAttributesInCommonClasses();
        List<UMLAttribute> removedAttributes = this.getRemovedAttributesInCommonClasses();
        for (UMLClass removedClass : this.removedClasses) {
            removedAttributes.addAll(removedClass.getAttributes());
        }
        return this.checkForAttributeMoves(addedAttributes, removedAttributes, renameMap, refactorings);
    }

    private List<MoveAttributeRefactoring> checkForAttributeMovesIncludingAddedClasses(Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap, Set<Refactoring> refactorings) throws RefactoringMinerTimedOutException {
        List<UMLAttribute> addedAttributes = this.getAddedAttributesInCommonClasses();
        for (UMLClass addedClass : this.addedClasses) {
            addedAttributes.addAll(addedClass.getAttributes());
        }
        List<UMLAttribute> removedAttributes = this.getRemovedAttributesInCommonClasses();
        return this.checkForAttributeMoves(addedAttributes, removedAttributes, renameMap, refactorings);
    }

    private List<MoveAttributeRefactoring> checkForAttributeMovesBetweenCommonClasses(Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap, Set<Refactoring> refactorings) throws RefactoringMinerTimedOutException {
        List<UMLAttribute> addedAttributes = this.getAddedAttributesInCommonClasses();
        List<UMLAttribute> removedAttributes = this.getRemovedAttributesInCommonClasses();
        return this.checkForAttributeMoves(addedAttributes, removedAttributes, renameMap, refactorings);
    }

    private List<MoveAttributeRefactoring> checkForAttributeMovesBetweenRemovedAndAddedClasses(Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap, Set<Refactoring> refactorings) throws RefactoringMinerTimedOutException {
        ArrayList<UMLAttribute> addedAttributes = new ArrayList<UMLAttribute>();
        for (UMLClass addedClass : this.addedClasses) {
            addedAttributes.addAll(addedClass.getAttributes());
        }
        ArrayList<UMLAttribute> removedAttributes = new ArrayList<UMLAttribute>();
        for (UMLClass removedClass : this.removedClasses) {
            removedAttributes.addAll(removedClass.getAttributes());
        }
        return this.checkForAttributeMoves(addedAttributes, removedAttributes, renameMap, refactorings);
    }

    private List<MoveAttributeRefactoring> checkForAttributeMoves(List<UMLAttribute> addedAttributes, List<UMLAttribute> removedAttributes, Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap, Set<Refactoring> pastRefactorings) throws RefactoringMinerTimedOutException {
        ArrayList<MoveAttributeRefactoring> refactorings = new ArrayList<MoveAttributeRefactoring>();
        if (addedAttributes.size() <= removedAttributes.size()) {
            for (UMLAttribute addedAttribute : addedAttributes) {
                ArrayList<MoveAttributeRefactoring> candidates = new ArrayList<MoveAttributeRefactoring>();
                for (UMLAttribute removedAttribute : removedAttributes) {
                    MoveAttributeRefactoring candidate = this.processPairOfAttributes(addedAttribute, removedAttribute, renameMap, pastRefactorings);
                    if (candidate == null) continue;
                    candidates.add(candidate);
                }
                this.processCandidates(candidates, refactorings, pastRefactorings);
            }
        } else {
            for (UMLAttribute removedAttribute : removedAttributes) {
                ArrayList<MoveAttributeRefactoring> candidates = new ArrayList<MoveAttributeRefactoring>();
                for (UMLAttribute addedAttribute : addedAttributes) {
                    MoveAttributeRefactoring candidate = this.processPairOfAttributes(addedAttribute, removedAttribute, renameMap, pastRefactorings);
                    if (candidate == null) continue;
                    candidates.add(candidate);
                }
                this.processCandidates(candidates, refactorings, pastRefactorings);
            }
        }
        return refactorings;
    }

    private List<Refactoring> filterOutDuplicateRefactorings(Set<Refactoring> refactorings) {
        List<Refactoring> refs;
        ArrayList<Refactoring> filtered = new ArrayList<Refactoring>();
        LinkedHashMap<String, List<Refactoring>> map = new LinkedHashMap<String, List<Refactoring>>();
        for (Refactoring ref : refactorings) {
            if (map.containsKey(ref.toString())) {
                ((List)map.get(ref.toString())).add(ref);
                continue;
            }
            refs = new ArrayList<Refactoring>();
            refs.add(ref);
            map.put(ref.toString(), refs);
        }
        for (String key : map.keySet()) {
            refs = (List)map.get(key);
            if (refs.size() == 1) {
                filtered.addAll(refs);
                continue;
            }
            filtered.addAll(this.filterOutBasedOnFilePath(refs));
        }
        return filtered;
    }

    private List<Refactoring> filterOutBasedOnFilePath(List<Refactoring> refs) {
        ArrayList<Refactoring> filtered = new ArrayList<Refactoring>();
        LinkedHashMap groupBySourceFilePath = new LinkedHashMap();
        for (Refactoring ref : refs) {
            String sourceFilePath = (String)ref.getInvolvedClassesBeforeRefactoring().iterator().next().getLeft();
            if (groupBySourceFilePath.containsKey(sourceFilePath)) {
                ((List)groupBySourceFilePath.get(sourceFilePath)).add(ref);
                continue;
            }
            ArrayList<Refactoring> refs2 = new ArrayList<Refactoring>();
            refs2.add(ref);
            groupBySourceFilePath.put(sourceFilePath, refs2);
        }
        for (String sourceFilePath : groupBySourceFilePath.keySet()) {
            List sourceFilePathGroup = (List)groupBySourceFilePath.get(sourceFilePath);
            TreeMap groupByLongestCommonSourceFilePath = new TreeMap();
            for (Refactoring ref : sourceFilePathGroup) {
                String longestCommonFilePathPrefix = PrefixSuffixUtils.longestCommonPrefix((String)ref.getInvolvedClassesBeforeRefactoring().iterator().next().getLeft(), (String)ref.getInvolvedClassesAfterRefactoring().iterator().next().getLeft());
                int length = longestCommonFilePathPrefix.length();
                if (groupByLongestCommonSourceFilePath.containsKey(length)) {
                    ((List)groupByLongestCommonSourceFilePath.get(length)).add(ref);
                    continue;
                }
                ArrayList<Refactoring> refs2 = new ArrayList<Refactoring>();
                refs2.add(ref);
                groupByLongestCommonSourceFilePath.put(length, refs2);
            }
            filtered.addAll((Collection)groupByLongestCommonSourceFilePath.lastEntry().getValue());
        }
        return filtered;
    }

    private void processCandidates(List<MoveAttributeRefactoring> candidates, List<MoveAttributeRefactoring> refactorings, Set<Refactoring> pastRefactorings) throws RefactoringMinerTimedOutException {
        block7: {
            block6: {
                if (candidates.size() <= 1) break block6;
                TreeMap map = new TreeMap();
                for (MoveAttributeRefactoring moveAttributeRefactoring : candidates) {
                    int compatibility = this.computeCompatibility(moveAttributeRefactoring);
                    if (map.containsKey(compatibility)) {
                        ((List)map.get(compatibility)).add(moveAttributeRefactoring);
                        continue;
                    }
                    ArrayList<MoveAttributeRefactoring> refs = new ArrayList<MoveAttributeRefactoring>();
                    refs.add(moveAttributeRefactoring);
                    map.put(compatibility, refs);
                }
                int maxCompatibility = (Integer)map.lastKey();
                refactorings.addAll((Collection)map.get(maxCompatibility));
                for (MoveAttributeRefactoring moveAttributeRefactoring : (List)map.get(maxCompatibility)) {
                    UMLAttributeDiff attributeDiff = new UMLAttributeDiff(moveAttributeRefactoring.getOriginalAttribute(), moveAttributeRefactoring.getMovedAttribute(), Collections.emptyList());
                    if (!this.movedAttributeDiffList.contains(attributeDiff)) {
                        this.movedAttributeDiffList.add(attributeDiff);
                    }
                    pastRefactorings.addAll(attributeDiff.getRefactorings());
                }
                break block7;
            }
            if (candidates.size() != 1) break block7;
            refactorings.addAll(candidates);
            for (MoveAttributeRefactoring moveAttributeRefactoring : candidates) {
                UMLAttributeDiff uMLAttributeDiff = new UMLAttributeDiff(moveAttributeRefactoring.getOriginalAttribute(), moveAttributeRefactoring.getMovedAttribute(), Collections.emptyList());
                if (!this.movedAttributeDiffList.contains(uMLAttributeDiff)) {
                    this.movedAttributeDiffList.add(uMLAttributeDiff);
                }
                pastRefactorings.addAll(uMLAttributeDiff.getRefactorings());
            }
        }
    }

    private MoveAttributeRefactoring processPairOfAttributes(UMLAttribute addedAttribute, UMLAttribute removedAttribute, Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap, Set<Refactoring> pastRefactorings) throws RefactoringMinerTimedOutException {
        Replacement rename;
        if (!removedAttribute.getName().equals(addedAttribute.getName()) && this.movedAttributeRenamed(removedAttribute.getVariableDeclaration(), addedAttribute.getVariableDeclaration(), pastRefactorings).size() > 0) {
            return null;
        }
        if (addedAttribute.getName().equals(removedAttribute.getName()) && addedAttribute.getType().equals(removedAttribute.getType())) {
            if (this.isSubclassOf(removedAttribute.getClassName(), addedAttribute.getClassName())) {
                UMLAttributeDiff attributeDiff = new UMLAttributeDiff(removedAttribute, addedAttribute, Collections.emptyList());
                if (!this.movedAttributeDiffList.contains(attributeDiff)) {
                    this.movedAttributeDiffList.add(attributeDiff);
                }
                PullUpAttributeRefactoring pullUpAttribute = new PullUpAttributeRefactoring(removedAttribute, addedAttribute);
                return pullUpAttribute;
            }
            if (this.isSubclassOf(addedAttribute.getClassName(), removedAttribute.getClassName())) {
                UMLAttributeDiff attributeDiff = new UMLAttributeDiff(removedAttribute, addedAttribute, Collections.emptyList());
                if (!this.movedAttributeDiffList.contains(attributeDiff)) {
                    this.movedAttributeDiffList.add(attributeDiff);
                }
                PushDownAttributeRefactoring pushDownAttribute = new PushDownAttributeRefactoring(removedAttribute, addedAttribute);
                return pushDownAttribute;
            }
            if ((this.sourceClassImportsTargetClass(removedAttribute.getClassName(), addedAttribute.getClassName()) || this.targetClassImportsSourceClass(removedAttribute.getClassName(), addedAttribute.getClassName())) && !this.initializerContainsTypeLiteral(addedAttribute, removedAttribute)) {
                UMLAttributeDiff attributeDiff = new UMLAttributeDiff(removedAttribute, addedAttribute, Collections.emptyList());
                if (!this.movedAttributeDiffList.contains(attributeDiff)) {
                    this.movedAttributeDiffList.add(attributeDiff);
                }
                MoveAttributeRefactoring moveAttribute = new MoveAttributeRefactoring(removedAttribute, addedAttribute);
                return moveAttribute;
            }
        }
        if (!removedAttribute.getClassName().equals(addedAttribute.getClassName()) && addedAttribute.getType().equals(removedAttribute.getType()) && renameMap.containsKey(rename = new Replacement(removedAttribute.getName(), addedAttribute.getName(), Replacement.ReplacementType.VARIABLE_NAME))) {
            UMLAttributeDiff attributeDiff = new UMLAttributeDiff(removedAttribute, addedAttribute, Collections.emptyList());
            if (!this.movedAttributeDiffList.contains(attributeDiff)) {
                this.movedAttributeDiffList.add(attributeDiff);
            }
            Set<CandidateAttributeRefactoring> candidates = renameMap.get(rename);
            MoveAndRenameAttributeRefactoring moveAttribute = new MoveAndRenameAttributeRefactoring(removedAttribute, addedAttribute, candidates);
            return moveAttribute;
        }
        return null;
    }

    private boolean initializerContainsTypeLiteral(UMLAttribute addedAttribute, UMLAttribute removedAttribute) {
        VariableDeclaration v1 = addedAttribute.getVariableDeclaration();
        VariableDeclaration v2 = removedAttribute.getVariableDeclaration();
        if (v1.getInitializer() != null && v2.getInitializer() != null) {
            ArrayList<String> typeLiterals1 = new ArrayList<String>();
            for (LeafExpression leafExpression : v1.getInitializer().getTypeLiterals()) {
                typeLiterals1.add(leafExpression.getString());
            }
            ArrayList<String> typeLiterals2 = new ArrayList<String>();
            for (LeafExpression expression : v2.getInitializer().getTypeLiterals()) {
                typeLiterals2.add(expression.getString());
            }
            String string = addedAttribute.getNonQualifiedClassName();
            String className2 = removedAttribute.getNonQualifiedClassName();
            if (typeLiterals1.contains(string + ".class") && typeLiterals2.contains(className2 + ".class") && addedAttribute.getType().getClassType().endsWith("Logger") && removedAttribute.getType().getClassType().endsWith("Logger")) {
                return true;
            }
        }
        return false;
    }

    private int computeCompatibility(MoveAttributeRefactoring candidate) {
        int count = 0;
        for (Refactoring ref : this.refactorings) {
            MoveOperationRefactoring moveRef;
            if (!(ref instanceof MoveOperationRefactoring) || !(moveRef = (MoveOperationRefactoring)ref).compatibleWith(candidate)) continue;
            ++count;
        }
        UMLClassBaseDiff sourceClassDiff = this.getUMLClassDiff(candidate.getSourceClassName());
        UMLClassBaseDiff targetClassDiff = this.getUMLClassDiff(candidate.getTargetClassName());
        if (sourceClassDiff != null) {
            UMLType targetSuperclass = null;
            if (targetClassDiff != null) {
                targetSuperclass = targetClassDiff.getSuperclass();
            }
            List<UMLAttribute> addedAttributes = sourceClassDiff.getAddedAttributes();
            for (UMLAttribute addedAttribute : addedAttributes) {
                if (UMLModelDiff.looksLikeSameType(addedAttribute.getType().getClassType(), candidate.getTargetClassName())) {
                    ++count;
                }
                if (targetSuperclass == null || !UMLModelDiff.looksLikeSameType(addedAttribute.getType().getClassType(), targetSuperclass.getClassType())) continue;
                ++count;
            }
            List<UMLAttribute> originalAttributes = sourceClassDiff.originalClassAttributesOfType(candidate.getTargetClassName());
            List<UMLAttribute> nextAttributes = sourceClassDiff.nextClassAttributesOfType(candidate.getTargetClassName());
            if (targetSuperclass != null) {
                originalAttributes.addAll(sourceClassDiff.originalClassAttributesOfType(targetSuperclass.getClassType()));
                nextAttributes.addAll(sourceClassDiff.nextClassAttributesOfType(targetSuperclass.getClassType()));
            }
            LinkedHashSet<UMLAttribute> intersection = new LinkedHashSet<UMLAttribute>(originalAttributes);
            intersection.retainAll(nextAttributes);
            if (!intersection.isEmpty()) {
                ++count;
            }
        }
        return count;
    }

    private boolean sourceClassImportsSuperclassOfTargetClass(String sourceClassName, String targetClassName) {
        UMLClassBaseDiff superclassOfTargetClassDiff;
        UMLClassBaseDiff targetClassDiff = this.getUMLClassDiff(targetClassName);
        if (targetClassDiff != null && targetClassDiff.getSuperclass() != null && (superclassOfTargetClassDiff = this.getUMLClassDiff(targetClassDiff.getSuperclass())) != null) {
            return this.sourceClassImportsTargetClass(sourceClassName, superclassOfTargetClassDiff.getNextClassName());
        }
        return false;
    }

    private boolean sourceClassImportsTargetClass(String sourceClassName, String targetClassName) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(sourceClassName);
        if (classDiff == null) {
            classDiff = this.getUMLClassDiff(UMLType.extractTypeObject(sourceClassName));
        }
        if (classDiff != null) {
            return classDiff.nextClassImportsType(targetClassName) || classDiff.originalClassImportsType(targetClassName);
        }
        UMLClass removedClass = this.getRemovedClass(sourceClassName);
        if (removedClass == null) {
            removedClass = this.looksLikeRemovedClass(UMLType.extractTypeObject(sourceClassName));
        }
        if (removedClass != null) {
            return removedClass.importsType(targetClassName);
        }
        return false;
    }

    private boolean targetClassImportsSourceClass(String sourceClassName, String targetClassName) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(targetClassName);
        if (classDiff == null) {
            classDiff = this.getUMLClassDiff(UMLType.extractTypeObject(targetClassName));
        }
        if (classDiff != null) {
            return classDiff.originalClassImportsType(sourceClassName) || classDiff.nextClassImportsType(sourceClassName);
        }
        UMLClass addedClass = this.getAddedClass(targetClassName);
        if (addedClass == null) {
            addedClass = this.looksLikeAddedClass(UMLType.extractTypeObject(targetClassName));
        }
        if (addedClass != null) {
            return addedClass.importsType(sourceClassName);
        }
        return false;
    }

    private List<UMLAttribute> getAddedAttributesInCommonClasses() {
        ArrayList<UMLAttribute> addedAttributes = new ArrayList<UMLAttribute>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            addedAttributes.addAll(classDiff.getAddedAttributes());
        }
        return addedAttributes;
    }

    private List<UMLAttribute> getRemovedAttributesInCommonClasses() {
        ArrayList<UMLAttribute> removedAttributes = new ArrayList<UMLAttribute>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            removedAttributes.addAll(classDiff.getRemovedAttributes());
        }
        return removedAttributes;
    }

    private List<UMLOperation> getAddedOperationsInCommonClasses() {
        ArrayList<UMLOperation> addedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            addedOperations.addAll(classDiff.getAddedOperations());
        }
        return addedOperations;
    }

    private List<UMLOperation> getAddedAndExtractedOperationsInCommonClasses() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> addedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            addedOperations.addAll(classDiff.getAddedOperations());
            for (Refactoring ref : classDiff.getRefactoringsBeforePostProcessing()) {
                if (!(ref instanceof ExtractOperationRefactoring)) continue;
                ExtractOperationRefactoring extractRef = (ExtractOperationRefactoring)ref;
                addedOperations.add(extractRef.getExtractedOperation());
            }
        }
        return addedOperations;
    }

    private List<UMLOperation> getAddedOperationsInMovedAndRenamedClasses() {
        ArrayList<UMLOperation> addedOperations = new ArrayList<UMLOperation>();
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            addedOperations.addAll(uMLClassMoveDiff.getAddedOperations());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            addedOperations.addAll(uMLClassMoveDiff.getAddedOperations());
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            addedOperations.addAll(uMLClassRenameDiff.getAddedOperations());
        }
        return addedOperations;
    }

    private List<UMLOperation> getRemovedOperationsInCommonClasses() {
        ArrayList<UMLOperation> removedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            removedOperations.addAll(classDiff.getRemovedOperations());
        }
        return removedOperations;
    }

    private List<UMLOperation> getRemovedOperationsInCommonMovedRenamedClasses() {
        ArrayList<UMLOperation> removedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            removedOperations.addAll(uMLClassDiff.getRemovedOperations());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            removedOperations.addAll(uMLClassMoveDiff.getRemovedOperations());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            removedOperations.addAll(uMLClassMoveDiff.getRemovedOperations());
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            removedOperations.addAll(uMLClassRenameDiff.getRemovedOperations());
        }
        return removedOperations;
    }

    private List<UMLOperation> getRemovedAndInlinedOperationsInCommonClasses() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> removedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            removedOperations.addAll(classDiff.getRemovedOperations());
            for (Refactoring ref : classDiff.getRefactoringsBeforePostProcessing()) {
                if (!(ref instanceof InlineOperationRefactoring)) continue;
                InlineOperationRefactoring extractRef = (InlineOperationRefactoring)ref;
                removedOperations.add(extractRef.getInlinedOperation());
            }
        }
        return removedOperations;
    }

    private List<UMLOperationBodyMapper> getOperationBodyMappersInCommonClasses() {
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            mappers.addAll(classDiff.getOperationBodyMapperList());
        }
        return mappers;
    }

    private List<UMLOperationBodyMapper> getOperationBodyMappersInMovedAndRenamedClasses() {
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            mappers.addAll(uMLClassMoveDiff.getOperationBodyMapperList());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            mappers.addAll(uMLClassMoveDiff.getOperationBodyMapperList());
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            mappers.addAll(uMLClassRenameDiff.getOperationBodyMapperList());
        }
        return mappers;
    }

    private List<ExtractClassRefactoring> identifyExtractClassRefactorings(List<? extends UMLClassBaseDiff> classDiffs) throws RefactoringMinerTimedOutException {
        ArrayList<ExtractClassRefactoring> refactorings = new ArrayList<ExtractClassRefactoring>();
        for (UMLClass addedClass : this.addedClasses) {
            TreeSet<CandidateExtractClassRefactoring> candidates = new TreeSet<CandidateExtractClassRefactoring>();
            UMLType addedClassSuperType = addedClass.getSuperclass();
            if (!addedClass.isInterface()) {
                for (UMLClassBaseDiff uMLClassBaseDiff : classDiffs) {
                    ExtractClassRefactoring refactoring;
                    boolean isTestClass;
                    UMLType classDiffSuperType = uMLClassBaseDiff.getNewSuperclass();
                    boolean commonSuperType = addedClassSuperType != null && classDiffSuperType != null && addedClassSuperType.getClassType().equals(classDiffSuperType.getClassType());
                    boolean commonInterface = false;
                    for (UMLType addedClassInterface : addedClass.getImplementedInterfaces()) {
                        for (UMLType classDiffInterface : uMLClassBaseDiff.getNextClass().getImplementedInterfaces()) {
                            if (!addedClassInterface.getClassType().equals(classDiffInterface.getClassType())) continue;
                            commonInterface = true;
                            break;
                        }
                        if (!commonInterface) continue;
                        break;
                    }
                    boolean extendsAddedClass = uMLClassBaseDiff.getNewSuperclass() != null && addedClass.getName().endsWith("." + uMLClassBaseDiff.getNewSuperclass().getClassType());
                    UMLAttribute attributeOfExtractedClassType = this.attributeOfExtractedClassType(addedClass, uMLClassBaseDiff);
                    boolean bl = isTestClass = addedClass.isTestClass() && uMLClassBaseDiff.getOriginalClass().isTestClass();
                    if ((commonSuperType || commonInterface || extendsAddedClass) && attributeOfExtractedClassType == null && !isTestClass || (refactoring = this.atLeastOneCommonAttributeOrOperation(addedClass, uMLClassBaseDiff, attributeOfExtractedClassType)) == null) continue;
                    CandidateExtractClassRefactoring candidate = new CandidateExtractClassRefactoring(uMLClassBaseDiff, refactoring);
                    candidates.add(candidate);
                }
            }
            if (candidates.isEmpty()) continue;
            CandidateExtractClassRefactoring firstCandidate = (CandidateExtractClassRefactoring)candidates.first();
            if (firstCandidate.innerClassExtract() || firstCandidate.subclassExtract()) {
                this.detectSubRefactorings(firstCandidate.getClassDiff(), firstCandidate.getRefactoring().getExtractedClass(), firstCandidate.getRefactoring().getRefactoringType());
                refactorings.add(firstCandidate.getRefactoring());
                continue;
            }
            for (CandidateExtractClassRefactoring candidate : candidates) {
                this.detectSubRefactorings(candidate.getClassDiff(), candidate.getRefactoring().getExtractedClass(), candidate.getRefactoring().getRefactoringType());
                refactorings.add(candidate.getRefactoring());
            }
        }
        return refactorings;
    }

    private UMLAttribute attributeOfExtractedClassType(UMLClass umlClass, UMLClassBaseDiff classDiff) {
        List<UMLAttribute> addedAttributes = classDiff.getAddedAttributes();
        for (UMLAttribute addedAttribute : addedAttributes) {
            if (!umlClass.getName().endsWith("." + addedAttribute.getType().getClassType())) continue;
            return addedAttribute;
        }
        return null;
    }

    private ExtractClassRefactoring atLeastOneCommonAttributeOrOperation(UMLClass umlClass, UMLClassBaseDiff classDiff, UMLAttribute attributeOfExtractedClassType) {
        int n;
        LinkedHashMap<UMLOperation, UMLOperation> commonOperations = new LinkedHashMap<UMLOperation, UMLOperation>();
        for (UMLOperation uMLOperation : classDiff.getRemovedOperations()) {
            UMLOperation matchedOperation;
            if (uMLOperation.isConstructor() || uMLOperation.overridesObject() || (matchedOperation = umlClass.operationWithTheSameSignatureIgnoringChangedTypes(uMLOperation)) == null) continue;
            commonOperations.put(uMLOperation, matchedOperation);
        }
        LinkedHashMap<UMLAttribute, UMLAttribute> commonAttributes = new LinkedHashMap<UMLAttribute, UMLAttribute>();
        for (UMLAttribute attribute : classDiff.getRemovedAttributes()) {
            UMLAttribute matchedAttribute = umlClass.attributeWithTheSameNameIgnoringChangedType(attribute);
            if (matchedAttribute == null) continue;
            commonAttributes.put(attribute, matchedAttribute);
        }
        boolean bl = true;
        if (attributeOfExtractedClassType != null || classDiff.getNextClass().isInnerClass(umlClass)) {
            n = 0;
        }
        if (commonOperations.size() > n || commonAttributes.size() > n) {
            ExtractClassRefactoring extractClassRefactoring = new ExtractClassRefactoring(umlClass, classDiff, commonOperations, commonAttributes, attributeOfExtractedClassType);
            LinkedHashSet<UMLAttributeDiff> diffsToBeRemoved = new LinkedHashSet<UMLAttributeDiff>();
            for (UMLAttributeDiff diff : classDiff.getAttributeDiffList()) {
                if (!diff.getAddedAttribute().equals(extractClassRefactoring.getAttributeOfExtractedClassTypeInOriginalClass()) || !extractClassRefactoring.getExtractedAttributes().keySet().contains(diff.getRemovedAttribute())) continue;
                diffsToBeRemoved.add(diff);
            }
            for (UMLAttributeDiff diff : diffsToBeRemoved) {
                classDiff.getAttributeDiffList().remove(diff);
                classDiff.getAddedAttributes().add(diff.getAddedAttribute());
                classDiff.getRemovedAttributes().add(diff.getRemovedAttribute());
            }
            return extractClassRefactoring;
        }
        return null;
    }

    private List<CollapseHierarchyRefactoring> identifyCollapseHierarchyRefactorings() throws RefactoringMinerTimedOutException {
        ArrayList<CollapseHierarchyRefactoring> refactorings = new ArrayList<CollapseHierarchyRefactoring>();
        for (UMLClass removedClass : this.removedClasses) {
            for (UMLRealization removedRealization : this.removedRealizations) {
                UMLClass client = removedRealization.getClient();
                UMLClassBaseDiff supplierClassDiff = this.getUMLClassDiff(UMLType.extractTypeObject(removedRealization.getSupplier()));
                if (!removedClass.equals(client) || supplierClassDiff == null) continue;
                int commonOperations = 0;
                for (UMLOperation operation : removedClass.getOperations()) {
                    if (!supplierClassDiff.containsConcreteOperationWithTheSameSignatureInNextClass(operation)) continue;
                    ++commonOperations;
                }
                if (commonOperations <= 0) continue;
                CollapseHierarchyRefactoring refactoring = new CollapseHierarchyRefactoring(removedClass, supplierClassDiff.getNextClass());
                refactorings.add(refactoring);
                for (UMLOperation removedOperation : removedClass.getOperations()) {
                    UMLOperation addedOperation = supplierClassDiff.containsAddedOperationWithTheSameSignature(removedOperation);
                    if (addedOperation == null) continue;
                    supplierClassDiff.getAddedOperations().remove(addedOperation);
                    UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)supplierClassDiff);
                    PullUpOperationRefactoring ref = new PullUpOperationRefactoring(mapper);
                    this.refactorings.add(ref);
                    this.refactorings.addAll(mapper.getRefactorings());
                    this.checkForExtractedOperationsWithinMovedMethod(mapper, supplierClassDiff.getRemovedOperations(), supplierClassDiff.getNextClass(), supplierClassDiff);
                }
                for (UMLAttribute removedAttribute : removedClass.getAttributes()) {
                    UMLAttribute addedAttribute = supplierClassDiff.containsAddedAttributeWithTheSameSignature(removedAttribute);
                    if (addedAttribute == null) continue;
                    supplierClassDiff.getAddedAttributes().remove(addedAttribute);
                    PullUpAttributeRefactoring ref = new PullUpAttributeRefactoring(removedAttribute, addedAttribute);
                    this.refactorings.add(ref);
                }
            }
        }
        return refactorings;
    }

    private List<ExtractSuperclassRefactoring> identifyExtractSuperclassRefactorings() throws RefactoringMinerTimedOutException {
        ArrayList<ExtractSuperclassRefactoring> refactorings = new ArrayList<ExtractSuperclassRefactoring>();
        for (UMLClass addedClass : this.addedClasses) {
            LinkedHashSet<UMLClass> subclassSetBefore = new LinkedHashSet<UMLClass>();
            LinkedHashSet<UMLClass> subclassSetAfter = new LinkedHashSet<UMLClass>();
            String addedClassName = addedClass.getName();
            for (UMLGeneralization addedGeneralization : this.addedGeneralizations) {
                this.processAddedGeneralization(addedClass, subclassSetBefore, subclassSetAfter, addedGeneralization);
            }
            for (UMLGeneralizationDiff generalizationDiff : this.generalizationDiffList) {
                UMLGeneralization addedGeneralization = generalizationDiff.getAddedGeneralization();
                UMLGeneralization removedGeneralization = generalizationDiff.getRemovedGeneralization();
                if (addedGeneralization.getParent().equals(removedGeneralization.getParent())) continue;
                this.processAddedGeneralization(addedClass, subclassSetBefore, subclassSetAfter, addedGeneralization);
            }
            for (UMLRealization addedRealization : this.addedRealizations) {
                String supplier = addedRealization.getSupplier();
                if (!UMLModelDiff.looksLikeSameType(supplier, addedClassName) || !this.topLevelOrSameOuterClass(addedClass, addedRealization.getClient()) || this.getAddedClass(addedRealization.getClient().getName()) != null) continue;
                UMLClassBaseDiff clientClassDiff = this.getUMLClassDiff(addedRealization.getClient().getName());
                int implementedInterfaceOperations = 0;
                boolean clientImplementsSupplier = false;
                if (clientClassDiff != null) {
                    for (UMLOperation interfaceOperation : addedClass.getOperations()) {
                        if (!clientClassDiff.containsOperationWithTheSameSignatureInOriginalClass(interfaceOperation)) continue;
                        ++implementedInterfaceOperations;
                    }
                    clientImplementsSupplier = clientClassDiff.getOriginalClass().getImplementedInterfaces().contains(UMLType.extractTypeObject(supplier));
                }
                if (implementedInterfaceOperations <= 0 && addedClass.getOperations().size() != 0 || clientImplementsSupplier || clientClassDiff == null) continue;
                subclassSetBefore.add(clientClassDiff.getOriginalClass());
                subclassSetAfter.add(clientClassDiff.getNextClass());
            }
            if (subclassSetBefore.size() <= 0) continue;
            ExtractSuperclassRefactoring extractSuperclassRefactoring = new ExtractSuperclassRefactoring(addedClass, subclassSetBefore, subclassSetAfter);
            refactorings.add(extractSuperclassRefactoring);
        }
        return refactorings;
    }

    private void processAddedGeneralization(UMLClass addedClass, Set<UMLClass> subclassSetBefore, Set<UMLClass> subclassSetAfter, UMLGeneralization addedGeneralization) throws RefactoringMinerTimedOutException {
        UMLClassBaseDiff subclassDiff;
        String parent = addedGeneralization.getParent();
        UMLClass subclass = addedGeneralization.getChild();
        if (UMLModelDiff.looksLikeSameType(parent, addedClass.getName()) && this.topLevelOrSameOuterClass(addedClass, subclass) && this.getAddedClass(subclass.getName()) == null && (subclassDiff = this.getUMLClassDiff(subclass.getName())) != null) {
            this.detectSubRefactorings(subclassDiff, addedClass, RefactoringType.EXTRACT_SUPERCLASS);
            subclassSetBefore.add(subclassDiff.getOriginalClass());
            subclassSetAfter.add(subclassDiff.getNextClass());
        }
    }

    private void detectSubRefactorings(UMLClassBaseDiff classDiff, UMLClass addedClass, RefactoringType parentType) throws RefactoringMinerTimedOutException {
        for (UMLOperation addedOperation : addedClass.getOperations()) {
            UMLOperation removedOperation = classDiff.containsRemovedOperationWithTheSameSignature(addedOperation);
            if (parentType.equals((Object)RefactoringType.MERGE_CLASS) && removedOperation == null) {
                removedOperation = classDiff.getOriginalClass().operationWithTheSameSignature(addedOperation);
                if (addedOperation.isConstructor() && removedOperation == null) {
                    RenamePattern renamePattern = new RenamePattern(classDiff.getOriginalClass().getNonQualifiedName(), classDiff.getNextClass().getNonQualifiedName());
                    removedOperation = classDiff.getOriginalClass().operationWithTheSameRenamePattern(addedOperation, renamePattern);
                }
            }
            List<UMLOperation> removedOperationsWithSameName = classDiff.removedOperationWithTheSameName(addedOperation);
            if (removedOperation == null && removedOperationsWithSameName.size() == 1) {
                removedOperation = removedOperationsWithSameName.get(0);
            }
            if (removedOperation == null) continue;
            UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)classDiff);
            int mappings = mapper.mappingsWithoutBlocks();
            if (!removedOperation.equalSignature(addedOperation) && (mappings <= 0 || !this.mappedElementsMoreThanNonMappedT1AndT2(mappings, mapper))) continue;
            classDiff.getRemovedOperations().remove(removedOperation);
            MoveOperationRefactoring ref = null;
            if (parentType.equals((Object)RefactoringType.EXTRACT_SUPERCLASS)) {
                ref = new PullUpOperationRefactoring(mapper);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_CLASS) || parentType.equals((Object)RefactoringType.MERGE_CLASS)) {
                ref = new MoveOperationRefactoring(mapper);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_SUBCLASS)) {
                ref = new PushDownOperationRefactoring(mapper);
            }
            this.refactorings.add(ref);
            this.refactorings.addAll(mapper.getRefactorings());
        }
        for (Refactoring r : new ArrayList<Refactoring>(this.refactorings)) {
            if (!(r instanceof MoveOperationRefactoring)) continue;
            MoveOperationRefactoring moveRefactoring = (MoveOperationRefactoring)r;
            this.checkForExtractedOperationsWithinMovedMethod(moveRefactoring.getBodyMapper(), classDiff.getRemovedOperations(), addedClass, classDiff);
        }
        for (UMLAttribute addedAttribute : addedClass.getAttributes()) {
            UMLAttribute removedAttribute = classDiff.containsRemovedAttributeWithTheSameSignature(addedAttribute);
            if (parentType.equals((Object)RefactoringType.MERGE_CLASS) && removedAttribute == null) {
                removedAttribute = classDiff.getOriginalClass().attributeWithTheSameSignature(addedAttribute);
            }
            if (removedAttribute == null) continue;
            classDiff.getRemovedAttributes().remove(removedAttribute);
            MoveAttributeRefactoring ref = null;
            if (parentType.equals((Object)RefactoringType.EXTRACT_SUPERCLASS)) {
                ref = new PullUpAttributeRefactoring(removedAttribute, addedAttribute);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_CLASS) || parentType.equals((Object)RefactoringType.MERGE_CLASS)) {
                ref = new MoveAttributeRefactoring(removedAttribute, addedAttribute);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_SUBCLASS)) {
                ref = new PushDownAttributeRefactoring(removedAttribute, addedAttribute);
            }
            this.refactorings.add(ref);
            UMLAttributeDiff attributeDiff = new UMLAttributeDiff(removedAttribute, addedAttribute, Collections.emptyList());
            if (!this.movedAttributeDiffList.contains(attributeDiff)) {
                this.movedAttributeDiffList.add(attributeDiff);
            }
            this.refactorings.addAll(attributeDiff.getRefactorings());
        }
    }

    private void checkForExtractedOperationsWithinMovedMethod(UMLOperationBodyMapper movedMethodMapper, List<UMLOperation> potentiallyMovedOperations, UMLClass addedClass, UMLAbstractClassDiff classDiff) throws RefactoringMinerTimedOutException {
        VariableDeclarationContainer removedOperation = movedMethodMapper.getContainer1();
        VariableDeclarationContainer addedOperation = movedMethodMapper.getContainer2();
        List<AbstractCall> removedInvocations = removedOperation.getAllOperationInvocations();
        List<AbstractCall> addedInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(removedInvocations);
        intersection.retainAll(addedInvocations);
        LinkedHashSet<AbstractCall> newInvocations = new LinkedHashSet<AbstractCall>(addedInvocations);
        newInvocations.removeAll(intersection);
        for (AbstractCall newInvocation : newInvocations) {
            for (UMLOperation operation : addedClass.getOperations()) {
                if (operation.isAbstract() || operation.hasEmptyBody() || this.refactoringListContainsAnotherMoveRefactoringWithTheSameAddedOperation(operation) || !newInvocation.matchesOperation(operation, addedOperation, classDiff, this)) continue;
                ExtractOperationDetection detection = new ExtractOperationDetection(movedMethodMapper, potentiallyMovedOperations, addedClass.getOperations(), this.getUMLClassDiff(operation.getClassName()), this);
                List<ExtractOperationRefactoring> refs = detection.check(operation);
                for (ExtractOperationRefactoring extractRefactoring : refs) {
                    if (this.refactoringListContainsAnotherMoveRefactoringWithTheSameAddedOperation(extractRefactoring.getExtractedOperation())) continue;
                    this.refactorings.add(extractRefactoring);
                    this.refactorings.addAll(extractRefactoring.getBodyMapper().getRefactorings());
                }
            }
        }
    }

    private boolean topLevelOrSameOuterClass(UMLClass class1, UMLClass class2) {
        if (!class1.isTopLevel() && !class2.isTopLevel()) {
            return class1.getPackageName().equals(class2.getPackageName());
        }
        return true;
    }

    public static boolean looksLikeSameType(String parent, String addedClassName) {
        if (addedClassName.contains(".") && !parent.contains(".")) {
            return parent.equals(addedClassName.substring(addedClassName.lastIndexOf(".") + 1));
        }
        if (parent.contains(".") && !addedClassName.contains(".")) {
            return addedClassName.equals(parent.substring(parent.lastIndexOf(".") + 1));
        }
        if (parent.contains(".") && addedClassName.contains(".")) {
            return UMLType.extractTypeObject(parent).equalClassType(UMLType.extractTypeObject(addedClassName));
        }
        return parent.equals(addedClassName);
    }

    private List<Refactoring> identifyConvertAnonymousClassToTypeRefactorings() throws RefactoringMinerTimedOutException {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            for (UMLAnonymousClass anonymousClass : classDiff.getRemovedAnonymousClasses()) {
                ArrayList<UMLAnonymousToClassDiff> matchingDiffs = new ArrayList<UMLAnonymousToClassDiff>();
                for (UMLClass addedClass : this.addedClasses) {
                    UMLClassMatcher.MatchResult matchResult = anonymousClass.hasSameAttributesAndOperations(addedClass);
                    if (matchResult.getMatchedOperations() <= 0 && matchResult.getMatchedAttributes() <= 0) continue;
                    UMLAnonymousToClassDiff diff = new UMLAnonymousToClassDiff(anonymousClass, addedClass, this);
                    diff.process();
                    List<UMLOperationBodyMapper> matchedOperationMappers = diff.getOperationBodyMapperList();
                    if (matchedOperationMappers.size() <= 0) continue;
                    matchingDiffs.add(diff);
                }
                if (matchingDiffs.size() == 1) {
                    UMLAnonymousToClassDiff diff = (UMLAnonymousToClassDiff)matchingDiffs.get(0);
                    if (!diff.containsStatementMappings() || !this.constructorCallFound(classDiff, diff)) continue;
                    List<Refactoring> anonymousClassDiffRefactorings = diff.getRefactorings();
                    ReplaceAnonymousWithClassRefactoring refactoring = new ReplaceAnonymousWithClassRefactoring(anonymousClass, diff.getNextClass(), diff);
                    refactorings.addAll(anonymousClassDiffRefactorings);
                    refactorings.add(refactoring);
                    continue;
                }
                if (matchingDiffs.size() <= 1) continue;
                for (UMLAnonymousToClassDiff diff : matchingDiffs) {
                    if (!this.nameCompatibility(diff) || !diff.containsStatementMappings() || !this.constructorCallFound(classDiff, diff)) continue;
                    List<Refactoring> anonymousClassDiffRefactorings = diff.getRefactorings();
                    ReplaceAnonymousWithClassRefactoring refactoring = new ReplaceAnonymousWithClassRefactoring(anonymousClass, diff.getNextClass(), diff);
                    refactorings.addAll(anonymousClassDiffRefactorings);
                    refactorings.add(refactoring);
                }
            }
        }
        return refactorings;
    }

    private boolean nameCompatibility(UMLAnonymousToClassDiff anonymousToClassDiff) {
        VariableDeclarationContainer container = anonymousToClassDiff.getOriginalClass().getParentContainers().iterator().next();
        if (anonymousToClassDiff.getNextClassName().startsWith(container.getClassName())) {
            return true;
        }
        String[] tokens1 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(container.getClassName());
        String[] tokens2 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(anonymousToClassDiff.getNextClassName());
        int commonTokens = 0;
        for (String token1 : tokens1) {
            for (String token2 : tokens2) {
                if (!token1.equals(token2)) continue;
                ++commonTokens;
            }
        }
        return commonTokens == Math.min(tokens1.length, tokens2.length);
    }

    private boolean constructorCallFound(UMLClassDiff classDiff, UMLAnonymousToClassDiff anonymousToClassDiff) {
        String creationName;
        List<AbstractCall> creations;
        VariableDeclarationContainer container2;
        VariableDeclarationContainer container = anonymousToClassDiff.getOriginalClass().getParentContainers().iterator().next();
        for (UMLOperationBodyMapper mapper : classDiff.getOperationBodyMapperList()) {
            if (mapper.getContainer1().equals(container)) {
                container2 = mapper.getContainer2();
                creations = container2.getAllCreations();
                for (AbstractCall creation : creations) {
                    creationName = creation.getName();
                    if (creationName.contains("<") && creationName.contains(">")) {
                        creationName = creationName.substring(0, creationName.indexOf("<"));
                    }
                    if (!anonymousToClassDiff.getNextClass().getNonQualifiedName().equals(creationName)) continue;
                    return true;
                }
            }
            if (!mapper.getContainer1().isConstructor() || !mapper.getContainer2().isConstructor()) continue;
            if (mapper.getContainer1().getAllVariables().contains(container.getName()) && mapper.getContainer2().getAllVariables().contains(anonymousToClassDiff.getNextClass().getNonQualifiedName())) {
                return true;
            }
            container2 = mapper.getContainer2();
            creations = container2.getAllCreations();
            for (AbstractCall creation : creations) {
                creationName = creation.getName();
                if (creationName.contains("<") && creationName.contains(">")) {
                    creationName = creationName.substring(0, creationName.indexOf("<"));
                }
                if (!anonymousToClassDiff.getNextClass().getNonQualifiedName().equals(creationName)) continue;
                return true;
            }
        }
        for (UMLAttributeDiff attributeDiff : classDiff.getAttributeDiffList()) {
            if (!attributeDiff.getRemovedAttribute().equals(container)) continue;
            container2 = attributeDiff.getAddedAttribute();
            creations = container2.getAllCreations();
            for (AbstractCall creation : creations) {
                creationName = creation.getName();
                if (creationName.contains("<") && creationName.contains(">")) {
                    creationName = creationName.substring(0, creationName.indexOf("<"));
                }
                if (!anonymousToClassDiff.getNextClass().getNonQualifiedName().equals(creationName)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Refactoring> getMoveClassRefactorings() {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        ArrayList<RenamePackageRefactoring> renamePackageRefactorings = new ArrayList<RenamePackageRefactoring>();
        ArrayList<MoveSourceFolderRefactoring> moveSourceFolderRefactorings = new ArrayList<MoveSourceFolderRefactoring>();
        for (UMLClassMoveDiff classMoveDiff : this.classMoveDiffList) {
            RenamePattern renamePattern;
            Object refactoring;
            UMLClass originalClass = classMoveDiff.getOriginalClass();
            String originalName = originalClass.getName();
            UMLClass movedClass = classMoveDiff.getMovedClass();
            String movedName = movedClass.getName();
            String originalPath = originalClass.getSourceFile();
            String movedPath = movedClass.getSourceFile();
            String originalPathPrefix = "";
            if (originalPath.contains("/")) {
                originalPathPrefix = originalPath.substring(0, originalPath.lastIndexOf(47));
            }
            String movedPathPrefix = "";
            if (movedPath.contains("/")) {
                movedPathPrefix = movedPath.substring(0, movedPath.lastIndexOf(47));
            }
            if (!originalName.equals(movedName)) {
                refactoring = new MoveClassRefactoring(originalClass, movedClass);
                renamePattern = ((MoveClassRefactoring)refactoring).getRenamePattern();
                if (renamePattern.getBefore().contains(renamePattern.getAfter()) || renamePattern.getAfter().contains(renamePattern.getBefore()) || !originalClass.isTopLevel() || !movedClass.isTopLevel()) {
                    refactorings.add((Refactoring)refactoring);
                    continue;
                }
                boolean foundInMatchingRenamePackageRefactoring = false;
                for (RenamePackageRefactoring renamePackageRefactoring : renamePackageRefactorings) {
                    if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                    renamePackageRefactoring.addMoveClassRefactoring((PackageLevelRefactoring)refactoring);
                    foundInMatchingRenamePackageRefactoring = true;
                    break;
                }
                if (foundInMatchingRenamePackageRefactoring) continue;
                renamePackageRefactorings.add(new RenamePackageRefactoring((PackageLevelRefactoring)refactoring));
                continue;
            }
            if (originalPathPrefix.equals(movedPathPrefix)) continue;
            refactoring = new MovedClassToAnotherSourceFolder(originalClass, movedClass, originalPathPrefix, movedPathPrefix);
            renamePattern = ((MovedClassToAnotherSourceFolder)refactoring).getRenamePattern();
            boolean foundInMatchingMoveSourceFolderRefactoring = false;
            for (MoveSourceFolderRefactoring moveSourceFolderRefactoring : moveSourceFolderRefactorings) {
                if (!moveSourceFolderRefactoring.getPattern().equals(renamePattern)) continue;
                moveSourceFolderRefactoring.addMovedClassToAnotherSourceFolder((MovedClassToAnotherSourceFolder)refactoring);
                foundInMatchingMoveSourceFolderRefactoring = true;
                break;
            }
            if (foundInMatchingMoveSourceFolderRefactoring) continue;
            moveSourceFolderRefactorings.add(new MoveSourceFolderRefactoring((MovedClassToAnotherSourceFolder)refactoring));
        }
        for (RenamePackageRefactoring renamePackageRefactoring : renamePackageRefactorings) {
            List<PackageLevelRefactoring> moveClassRefactorings = renamePackageRefactoring.getMoveClassRefactorings();
            if (moveClassRefactorings.size() >= 1 && this.isSourcePackageDeleted(renamePackageRefactoring)) {
                refactorings.add(renamePackageRefactoring);
            }
            refactorings.addAll(moveClassRefactorings);
        }
        refactorings.addAll(moveSourceFolderRefactorings);
        return refactorings;
    }

    private boolean isSourcePackageDeleted(RenamePackageRefactoring renamePackageRefactoring) {
        for (String deletedFolderPath : this.deletedFolderPaths) {
            String originalPath;
            String trimmedOriginalPath;
            String convertedPackageToFilePath;
            if (!deletedFolderPath.endsWith(convertedPackageToFilePath = (trimmedOriginalPath = (originalPath = renamePackageRefactoring.getPattern().getBefore()).endsWith(".") ? originalPath.substring(0, originalPath.length() - 1) : originalPath).replaceAll("\\.", "/"))) continue;
            return true;
        }
        return false;
    }

    private List<Refactoring> getRenameClassRefactorings(List<RenamePackageRefactoring> previousRenamePackageRefactorings) {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        ArrayList<RenamePackageRefactoring> newRenamePackageRefactorings = new ArrayList<RenamePackageRefactoring>();
        for (UMLClassRenameDiff classRenameDiff : this.classRenameDiffList) {
            Refactoring refactoring;
            if (classRenameDiff.samePackage()) {
                refactoring = new RenameClassRefactoring(classRenameDiff.getOriginalClass(), classRenameDiff.getRenamedClass());
                refactorings.add(refactoring);
                continue;
            }
            refactoring = new MoveAndRenameClassRefactoring(classRenameDiff.getOriginalClass(), classRenameDiff.getRenamedClass());
            RenamePattern renamePattern = ((MoveAndRenameClassRefactoring)refactoring).getRenamePattern();
            boolean foundInMatchingRenamePackageRefactoring = false;
            for (RenamePackageRefactoring renamePackageRefactoring : previousRenamePackageRefactorings) {
                if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                renamePackageRefactoring.addMoveClassRefactoring((PackageLevelRefactoring)refactoring);
                foundInMatchingRenamePackageRefactoring = true;
                break;
            }
            for (RenamePackageRefactoring renamePackageRefactoring : newRenamePackageRefactorings) {
                if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                renamePackageRefactoring.addMoveClassRefactoring((PackageLevelRefactoring)refactoring);
                foundInMatchingRenamePackageRefactoring = true;
                break;
            }
            if (!foundInMatchingRenamePackageRefactoring) {
                newRenamePackageRefactorings.add(new RenamePackageRefactoring((PackageLevelRefactoring)refactoring));
            }
            refactorings.add(refactoring);
        }
        for (RenamePackageRefactoring renamePackageRefactoring : newRenamePackageRefactorings) {
            List<PackageLevelRefactoring> moveClassRefactorings = renamePackageRefactoring.getMoveClassRefactorings();
            if (moveClassRefactorings.size() < 1 || !this.isSourcePackageDeleted(renamePackageRefactoring)) continue;
            refactorings.add(renamePackageRefactoring);
            previousRenamePackageRefactorings.add(renamePackageRefactoring);
        }
        return refactorings;
    }

    private List<Refactoring> getMergeClassRefactorings(List<RenamePackageRefactoring> previousRenamePackageRefactorings) throws RefactoringMinerTimedOutException {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        ArrayList<RenamePackageRefactoring> newRenamePackageRefactorings = new ArrayList<RenamePackageRefactoring>();
        for (UMLClassMergeDiff classMergeDiff : this.classMergeDiffList) {
            MergeClassRefactoring refactoring = new MergeClassRefactoring(classMergeDiff);
            for (UMLClassRenameDiff renameDiff : classMergeDiff.getClassRenameDiffs()) {
                this.detectSubRefactorings(renameDiff, renameDiff.getRenamedClass(), refactoring.getRefactoringType());
            }
            if (!classMergeDiff.samePackage()) {
                RenamePattern renamePattern = refactoring.getRenamePattern();
                boolean foundInMatchingRenamePackageRefactoring = false;
                for (RenamePackageRefactoring renamePackageRefactoring : previousRenamePackageRefactorings) {
                    if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                    renamePackageRefactoring.addMoveClassRefactoring(refactoring);
                    foundInMatchingRenamePackageRefactoring = true;
                    break;
                }
                for (RenamePackageRefactoring renamePackageRefactoring : newRenamePackageRefactorings) {
                    if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                    renamePackageRefactoring.addMoveClassRefactoring(refactoring);
                    foundInMatchingRenamePackageRefactoring = true;
                    break;
                }
                if (!foundInMatchingRenamePackageRefactoring) {
                    newRenamePackageRefactorings.add(new RenamePackageRefactoring(refactoring));
                }
            }
            refactorings.add(refactoring);
        }
        for (RenamePackageRefactoring renamePackageRefactoring : newRenamePackageRefactorings) {
            List<PackageLevelRefactoring> moveClassRefactorings = renamePackageRefactoring.getMoveClassRefactorings();
            if (moveClassRefactorings.size() < 1 || !this.isSourcePackageDeleted(renamePackageRefactoring)) continue;
            refactorings.add(renamePackageRefactoring);
            previousRenamePackageRefactorings.add(renamePackageRefactoring);
        }
        return refactorings;
    }

    private List<Refactoring> getSplitClassRefactorings(List<RenamePackageRefactoring> previousRenamePackageRefactorings) throws RefactoringMinerTimedOutException {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        ArrayList<RenamePackageRefactoring> newRenamePackageRefactorings = new ArrayList<RenamePackageRefactoring>();
        for (UMLClassSplitDiff classSplitDiff : this.classSplitDiffList) {
            SplitClassRefactoring refactoring = new SplitClassRefactoring(classSplitDiff);
            for (UMLClassRenameDiff renameDiff : classSplitDiff.getClassRenameDiffs()) {
                this.detectSubRefactorings(renameDiff, renameDiff.getRenamedClass(), refactoring.getRefactoringType());
            }
            if (!classSplitDiff.samePackage()) {
                RenamePattern renamePattern = refactoring.getRenamePattern();
                boolean foundInMatchingRenamePackageRefactoring = false;
                for (RenamePackageRefactoring renamePackageRefactoring : previousRenamePackageRefactorings) {
                    if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                    renamePackageRefactoring.addMoveClassRefactoring(refactoring);
                    foundInMatchingRenamePackageRefactoring = true;
                    break;
                }
                for (RenamePackageRefactoring renamePackageRefactoring : newRenamePackageRefactorings) {
                    if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                    renamePackageRefactoring.addMoveClassRefactoring(refactoring);
                    foundInMatchingRenamePackageRefactoring = true;
                    break;
                }
                if (!foundInMatchingRenamePackageRefactoring) {
                    newRenamePackageRefactorings.add(new RenamePackageRefactoring(refactoring));
                }
            }
            refactorings.add(refactoring);
        }
        for (RenamePackageRefactoring renamePackageRefactoring : newRenamePackageRefactorings) {
            List<PackageLevelRefactoring> moveClassRefactorings = renamePackageRefactoring.getMoveClassRefactorings();
            if (moveClassRefactorings.size() < 1 || !this.isSourcePackageDeleted(renamePackageRefactoring)) continue;
            refactorings.add(renamePackageRefactoring);
            previousRenamePackageRefactorings.add(renamePackageRefactoring);
        }
        return refactorings;
    }

    private void postProcessRenamedPackages(List<RenamePackageRefactoring> renamePackageRefactorings, Set<Refactoring> allRefactorings) {
        Refactoring refactoring;
        Set value;
        LinkedHashMap groupBasedOnOriginalPackage = new LinkedHashMap();
        LinkedHashMap groupBasedOnNewPackage = new LinkedHashMap();
        for (RenamePackageRefactoring refactoring2 : renamePackageRefactorings) {
            LinkedHashSet<RenamePackageRefactoring> initialRenamePackageRefactorings;
            RenamePattern pattern = refactoring2.getPattern();
            String before = pattern.getBefore();
            String after = pattern.getAfter();
            if (groupBasedOnOriginalPackage.containsKey(before)) {
                ((Set)groupBasedOnOriginalPackage.get(before)).add(refactoring2);
            } else {
                initialRenamePackageRefactorings = new LinkedHashSet<RenamePackageRefactoring>();
                initialRenamePackageRefactorings.add(refactoring2);
                groupBasedOnOriginalPackage.put(before, initialRenamePackageRefactorings);
            }
            if (groupBasedOnNewPackage.containsKey(after)) {
                ((Set)groupBasedOnNewPackage.get(after)).add(refactoring2);
                continue;
            }
            initialRenamePackageRefactorings = new LinkedHashSet();
            initialRenamePackageRefactorings.add(refactoring2);
            groupBasedOnNewPackage.put(after, initialRenamePackageRefactorings);
        }
        for (String key : groupBasedOnOriginalPackage.keySet()) {
            value = (Set)groupBasedOnOriginalPackage.get(key);
            if (value.size() <= 1) continue;
            refactoring = new SplitPackageRefactoring(value);
            allRefactorings.add(refactoring);
            allRefactorings.removeAll(value);
        }
        for (String key : groupBasedOnNewPackage.keySet()) {
            value = (Set)groupBasedOnNewPackage.get(key);
            if (value.size() <= 1) continue;
            refactoring = new MergePackageRefactoring(value);
            allRefactorings.add(refactoring);
            allRefactorings.removeAll(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Refactoring> getRefactorings() throws RefactoringMinerTimedOutException {
        List<UMLOperation> removedAndInlinedOperationsInCommonClasses;
        Set<Refactoring> conflictingRefactorings;
        UMLClassBaseDiff diff;
        Set<Refactoring> refactorings = this.getMoveRenameClassRefactorings();
        refactorings.addAll(this.identifyConvertAnonymousClassToTypeRefactorings());
        LinkedHashMap<Replacement, Set<CandidateAttributeRefactoring>> renameMap = new LinkedHashMap<Replacement, Set<CandidateAttributeRefactoring>>();
        LinkedHashMap<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>> mergeMap = new LinkedHashMap<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            List<Refactoring> list = uMLClassDiff.getRefactorings();
            refactorings.addAll(list);
            this.detectImportDeclarationChangesBasedOnTypeChanges(uMLClassDiff, list);
            this.extractMergePatterns(uMLClassDiff, mergeMap);
            this.extractRenamePatterns(uMLClassDiff, renameMap);
            this.checkForExtractedAndMovedOperationsToInnerClasses(uMLClassDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            List<Refactoring> list = uMLClassMoveDiff.getRefactorings();
            refactorings.addAll(list);
            this.detectImportDeclarationChangesBasedOnTypeChanges(uMLClassMoveDiff, list);
            this.extractMergePatterns(uMLClassMoveDiff, mergeMap);
            this.extractRenamePatterns(uMLClassMoveDiff, renameMap);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            List<Refactoring> list = uMLClassMoveDiff.getRefactorings();
            refactorings.addAll(list);
            this.detectImportDeclarationChangesBasedOnTypeChanges(uMLClassMoveDiff, list);
            this.extractMergePatterns(uMLClassMoveDiff, mergeMap);
            this.extractRenamePatterns(uMLClassMoveDiff, renameMap);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            List<Refactoring> list = uMLClassRenameDiff.getRefactorings();
            refactorings.addAll(list);
            this.detectImportDeclarationChangesBasedOnTypeChanges(uMLClassRenameDiff, list);
            this.extractMergePatterns(uMLClassRenameDiff, mergeMap);
            this.extractRenamePatterns(uMLClassRenameDiff, renameMap);
        }
        Map<RenamePattern, Integer> typeRenamePatternMap = this.typeRenamePatternMap(refactorings);
        for (RenamePattern renamePattern : typeRenamePatternMap.keySet()) {
            if (typeRenamePatternMap.get(renamePattern) <= 1) continue;
            UMLClass removedClass = this.looksLikeRemovedClass(UMLType.extractTypeObject(renamePattern.getBefore()));
            UMLClass addedClass = this.looksLikeAddedClass(UMLType.extractTypeObject(renamePattern.getAfter()));
            if (removedClass == null || addedClass == null) continue;
            UMLClassRenameDiff renameDiff = new UMLClassRenameDiff(removedClass, addedClass, this, new UMLClassMatcher.Rename().match(removedClass, addedClass));
            renameDiff.process();
            refactorings.addAll(renameDiff.getRefactorings());
            this.extractMergePatterns(renameDiff, mergeMap);
            this.extractRenamePatterns(renameDiff, renameMap);
            this.classRenameDiffList.add(renameDiff);
            Refactoring refactoring = null;
            refactoring = renameDiff.samePackage() ? new RenameClassRefactoring(renameDiff.getOriginalClass(), renameDiff.getRenamedClass()) : new MoveAndRenameClassRefactoring(renameDiff.getOriginalClass(), renameDiff.getRenamedClass());
            refactorings.add(refactoring);
            this.removedClasses.remove(removedClass);
            this.addedClasses.remove(addedClass);
        }
        for (MergeVariableReplacement mergeVariableReplacement : mergeMap.keySet()) {
            MergeAttributeRefactoring mergeAttributeRefactoring;
            int movedAttributeCount;
            diff = null;
            for (String mergedVariable : mergeVariableReplacement.getMergedVariables()) {
                Replacement replacement = new Replacement(mergedVariable, mergeVariableReplacement.getAfter(), Replacement.ReplacementType.VARIABLE_NAME);
                diff = this.getUMLClassDiffWithAttribute(replacement);
            }
            if (diff == null) continue;
            LinkedHashSet<UMLAttribute> mergedAttributes = new LinkedHashSet<UMLAttribute>();
            LinkedHashSet mergedVariables = new LinkedHashSet();
            for (String mergedVariable : mergeVariableReplacement.getMergedVariables()) {
                UMLAttribute a1 = diff.findAttributeInOriginalClass(mergedVariable);
                if (a1 == null) continue;
                mergedAttributes.add(a1);
                mergedVariables.add(a1.getVariableDeclaration());
            }
            UMLAttribute a2 = diff.findAttributeInNextClass(mergeVariableReplacement.getAfter());
            Set set = (Set)mergeMap.get(mergeVariableReplacement);
            if (mergedVariables.size() <= 1 || mergedVariables.size() != mergeVariableReplacement.getMergedVariables().size() || a2 == null || (movedAttributeCount = diff.movedAttributeCount((CandidateMergeVariableRefactoring)set.iterator().next())) == mergedAttributes.size() || refactorings.contains(mergeAttributeRefactoring = new MergeAttributeRefactoring(mergedAttributes, a2, diff.getOriginalClassName(), diff.getNextClassName(), set))) continue;
            refactorings.add(mergeAttributeRefactoring);
            conflictingRefactorings = this.attributeRenamed(mergedVariables, a2.getVariableDeclaration(), refactorings);
            if (conflictingRefactorings.isEmpty()) continue;
            refactorings.removeAll(conflictingRefactorings);
        }
        block8: for (Replacement replacement : renameMap.keySet()) {
            diff = this.getUMLClassDiffWithAttribute(replacement);
            Set set = (Set)renameMap.get(replacement);
            for (Object candidate : set) {
                void var13_50;
                Refactoring ref;
                Object a2;
                UMLClassBaseDiff originalClassDiff;
                if (((CandidateAttributeRefactoring)candidate).getOriginalVariableDeclaration() == null && ((CandidateAttributeRefactoring)candidate).getRenamedVariableDeclaration() == null) {
                    Set<Refactoring> attributeDiffRefactorings;
                    if (diff == null) continue;
                    UMLAttribute a1 = diff.findAttributeInOriginalClass(replacement.getBefore());
                    UMLAttribute a22 = diff.findAttributeInNextClass(replacement.getAfter());
                    if (diff.getOriginalClass().containsAttributeWithName(replacement.getAfter()) || diff.getNextClass().containsAttributeWithName(replacement.getBefore()) || this.attributeMerged(a1, a22, refactorings)) continue;
                    if (this.innerClassMoveDiffList.contains(diff)) {
                        if (a1 instanceof UMLEnumConstant && a22 instanceof UMLEnumConstant) {
                            Set<Refactoring> enumConstantDiffRefactorings;
                            UMLEnumConstantDiff uMLEnumConstantDiff = new UMLEnumConstantDiff((UMLEnumConstant)a1, (UMLEnumConstant)a22, diff, this);
                            if (!diff.getEnumConstantDiffList().contains(uMLEnumConstantDiff)) {
                                diff.getEnumConstantDiffList().add(uMLEnumConstantDiff);
                            }
                            if (refactorings.containsAll(enumConstantDiffRefactorings = uMLEnumConstantDiff.getRefactorings(set))) continue;
                            refactorings.addAll(enumConstantDiffRefactorings);
                            continue block8;
                        }
                        UMLAttributeDiff uMLAttributeDiff = new UMLAttributeDiff(a1, a22, diff, this);
                        if (!diff.getAttributeDiffList().contains(uMLAttributeDiff)) {
                            diff.getAttributeDiffList().add(uMLAttributeDiff);
                        }
                        if (refactorings.containsAll(attributeDiffRefactorings = uMLAttributeDiff.getRefactorings(set))) continue;
                        refactorings.addAll(attributeDiffRefactorings);
                        continue block8;
                    }
                    UMLAttributeDiff uMLAttributeDiff = new UMLAttributeDiff(a1, a22, diff, this);
                    if (!this.movedAttributeDiffList.contains(uMLAttributeDiff) && !a1.getClassName().equals(a22.getClassName())) {
                        this.movedAttributeDiffList.add(uMLAttributeDiff);
                    }
                    if (refactorings.containsAll(attributeDiffRefactorings = uMLAttributeDiff.getRefactorings(set))) continue;
                    refactorings.addAll(attributeDiffRefactorings);
                    continue block8;
                }
                if (((CandidateAttributeRefactoring)candidate).getOriginalVariableDeclaration() == null) continue;
                List<UMLClassBaseDiff> diffs1 = this.getUMLClassDiffWithExistingAttributeAfter(replacement);
                List<UMLClassBaseDiff> diffs2 = this.getUMLClassDiffWithNewAttributeAfter(replacement);
                if (!diffs1.isEmpty()) {
                    void var13_47;
                    UMLClassBaseDiff uMLClassBaseDiff = diffs1.get(0);
                    originalClassDiff = null;
                    originalClassDiff = ((CandidateAttributeRefactoring)candidate).getOriginalAttribute() != null ? this.getUMLClassDiff(((CandidateAttributeRefactoring)candidate).getOriginalAttribute().getClassName()) : this.getUMLClassDiff(((CandidateAttributeRefactoring)candidate).getOperationBefore().getClassName());
                    if (diffs1.size() > 1) {
                        for (UMLClassBaseDiff classDiff : diffs1) {
                            if (!this.isSubclassOf(originalClassDiff.nextClass.getName(), classDiff.nextClass.getName())) continue;
                            UMLClassBaseDiff uMLClassBaseDiff2 = classDiff;
                            break;
                        }
                    }
                    if ((a2 = var13_47.findAttributeInNextClass(replacement.getAfter())) == null) continue;
                    if (((CandidateAttributeRefactoring)candidate).getOriginalVariableDeclaration().isAttribute()) {
                        if (originalClassDiff == null || !originalClassDiff.removedAttributes.contains(((CandidateAttributeRefactoring)candidate).getOriginalAttribute()) || refactorings.contains(ref = new ReplaceAttributeRefactoring(((CandidateAttributeRefactoring)candidate).getOriginalAttribute(), (UMLAttribute)a2, set))) continue;
                        refactorings.add(ref);
                        continue block8;
                    }
                    ref = new RenameVariableRefactoring(((CandidateAttributeRefactoring)candidate).getOriginalVariableDeclaration(), ((UMLAttribute)a2).getVariableDeclaration(), ((CandidateAttributeRefactoring)candidate).getOperationBefore(), ((CandidateAttributeRefactoring)candidate).getOperationAfter(), ((CandidateAttributeRefactoring)candidate).getReferences(), false);
                    if (refactorings.contains(ref)) continue;
                    refactorings.add(ref);
                    continue block8;
                }
                if (diffs2.isEmpty()) continue;
                UMLClassBaseDiff uMLClassBaseDiff = diffs2.get(0);
                originalClassDiff = null;
                originalClassDiff = ((CandidateAttributeRefactoring)candidate).getOriginalAttribute() != null ? this.getUMLClassDiff(((CandidateAttributeRefactoring)candidate).getOriginalAttribute().getClassName()) : this.getUMLClassDiff(((CandidateAttributeRefactoring)candidate).getOperationBefore().getClassName());
                if (diffs2.size() > 1) {
                    a2 = diffs2.iterator();
                    while (a2.hasNext()) {
                        UMLClassBaseDiff classDiff;
                        classDiff = (UMLClassBaseDiff)a2.next();
                        if (!this.isSubclassOf(originalClassDiff.nextClass.getName(), classDiff.nextClass.getName())) continue;
                        UMLClassBaseDiff uMLClassBaseDiff3 = classDiff;
                        break;
                    }
                }
                if ((a2 = var13_50.findAttributeInNextClass(replacement.getAfter())) == null) continue;
                if (((CandidateAttributeRefactoring)candidate).getOriginalVariableDeclaration().isAttribute()) {
                    MoveAndRenameAttributeRefactoring ref2;
                    if (originalClassDiff == null || !originalClassDiff.removedAttributes.contains(((CandidateAttributeRefactoring)candidate).getOriginalAttribute())) continue;
                    UMLAttributeDiff attributeDiff = new UMLAttributeDiff(((CandidateAttributeRefactoring)candidate).getOriginalAttribute(), (UMLAttribute)a2, (UMLAbstractClassDiff)var13_50, this);
                    if (!this.movedAttributeDiffList.contains(attributeDiff)) {
                        this.movedAttributeDiffList.add(attributeDiff);
                    }
                    if (refactorings.contains(ref2 = new MoveAndRenameAttributeRefactoring(((CandidateAttributeRefactoring)candidate).getOriginalAttribute(), (UMLAttribute)a2, set))) continue;
                    refactorings.add(ref2);
                    continue block8;
                }
                ref = new RenameVariableRefactoring(((CandidateAttributeRefactoring)candidate).getOriginalVariableDeclaration(), ((UMLAttribute)a2).getVariableDeclaration(), ((CandidateAttributeRefactoring)candidate).getOperationBefore(), ((CandidateAttributeRefactoring)candidate).getOperationAfter(), ((CandidateAttributeRefactoring)candidate).getReferences(), false);
                if (refactorings.contains(ref)) continue;
                refactorings.add(ref);
                continue block8;
            }
        }
        refactorings.addAll(this.identifyExtractSuperclassRefactorings());
        refactorings.addAll(this.identifyCollapseHierarchyRefactorings());
        refactorings.addAll(this.identifyExtractClassRefactorings(this.commonClassDiffList));
        refactorings.addAll(this.identifyExtractClassRefactorings(this.classMoveDiffList));
        refactorings.addAll(this.identifyExtractClassRefactorings(this.innerClassMoveDiffList));
        refactorings.addAll(this.identifyExtractClassRefactorings(this.classRenameDiffList));
        this.checkForOperationMovesBetweenCommonClasses();
        this.checkForOperationMovesIncludingRemovedAndAddedClasses();
        List<UMLOperation> list = this.getAddedAndExtractedOperationsInCommonClasses();
        List<UMLOperation> list2 = this.getAddedOperationsInMovedAndRenamedClasses();
        ArrayList<UMLOperation> allAddedOperations = new ArrayList<UMLOperation>(list);
        allAddedOperations.addAll(list2);
        if (list.size() <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS) {
            this.checkForExtractedAndMovedOperations(this.getOperationBodyMappersInCommonClasses(), allAddedOperations);
        }
        if (list2.size() <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS) {
            this.checkForExtractedAndMovedOperations(this.getOperationBodyMappersInMovedAndRenamedClasses(), allAddedOperations);
        }
        if ((removedAndInlinedOperationsInCommonClasses = this.getRemovedAndInlinedOperationsInCommonClasses()).size() <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS) {
            this.checkForMovedAndInlinedOperations(this.getOperationBodyMappersInCommonClasses(), removedAndInlinedOperationsInCommonClasses);
        }
        ArrayList<MoveAttributeRefactoring> moveAttributeRefactorings = new ArrayList<MoveAttributeRefactoring>();
        moveAttributeRefactorings.addAll(this.checkForAttributeMovesBetweenCommonClasses(renameMap, refactorings));
        moveAttributeRefactorings.addAll(this.checkForAttributeMovesIncludingAddedClasses(renameMap, refactorings));
        moveAttributeRefactorings.addAll(this.checkForAttributeMovesIncludingRemovedClasses(renameMap, refactorings));
        refactorings.addAll(moveAttributeRefactorings);
        for (MoveAttributeRefactoring moveAttributeRefactoring : moveAttributeRefactorings) {
            UMLAttribute originalAttribute = moveAttributeRefactoring.getOriginalAttribute();
            UMLAttribute uMLAttribute = moveAttributeRefactoring.getMovedAttribute();
            conflictingRefactorings = this.movedAttributeRenamed(originalAttribute.getVariableDeclaration(), uMLAttribute.getVariableDeclaration(), refactorings);
            if (!conflictingRefactorings.isEmpty()) {
                refactorings.removeAll(conflictingRefactorings);
            }
            UMLAttributeDiff attributeDiff = new UMLAttributeDiff(originalAttribute, uMLAttribute, Collections.emptyList());
            refactorings.addAll(attributeDiff.getRefactorings());
        }
        refactorings.addAll(this.refactorings);
        Set<Refactoring> packageRefactorings = this.filterPackageRefactorings(refactorings);
        LinkedHashMap<Pair<UMLOperation, UMLOperation>, Set<MethodInvocationReplacement>> map = new LinkedHashMap<Pair<UMLOperation, UMLOperation>, Set<MethodInvocationReplacement>>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassDiff, refactorings, map);
            this.detectImportDeclarationChanges(uMLClassDiff, packageRefactorings);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassMoveDiff, refactorings, map);
            this.detectImportDeclarationChanges(uMLClassMoveDiff, packageRefactorings);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassMoveDiff, refactorings, map);
            this.detectImportDeclarationChanges(uMLClassMoveDiff, packageRefactorings);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassRenameDiff, refactorings, map);
            this.detectImportDeclarationChanges(uMLClassRenameDiff, packageRefactorings);
        }
        for (Refactoring refactoring : refactorings) {
            UMLOperationBodyMapper bodyMapper = null;
            if (refactoring.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_RENAME_OPERATION) || refactoring.getRefactoringType().equals((Object)RefactoringType.MOVE_OPERATION)) {
                MoveOperationRefactoring move = (MoveOperationRefactoring)refactoring;
                bodyMapper = move.getBodyMapper();
            } else if (refactoring.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
                ExtractOperationRefactoring extract = (ExtractOperationRefactoring)refactoring;
                bodyMapper = extract.getBodyMapper();
            }
            if (bodyMapper == null || bodyMapper.getNonMappedLeavesT1().size() <= 0 || bodyMapper.getNonMappedLeavesT2().size() <= 0) continue;
            for (AbstractCodeFragment fragment1 : bodyMapper.getNonMappedLeavesT1()) {
                AbstractCall invocation1 = fragment1.invocationCoveringEntireFragment();
                if (invocation1 == null) continue;
                block19: for (AbstractCodeFragment fragment2 : bodyMapper.getNonMappedLeavesT2()) {
                    AbstractCall invocation2 = fragment2.invocationCoveringEntireFragment();
                    if (invocation2 == null) continue;
                    for (Refactoring r2 : refactorings) {
                        LeafMapping mapping;
                        if (!r2.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_RENAME_OPERATION)) continue;
                        MoveOperationRefactoring move2 = (MoveOperationRefactoring)r2;
                        boolean matchesOperation1 = invocation1.matchesOperation(move2.getOriginalOperation(), bodyMapper.getContainer1(), bodyMapper.getClassDiff(), this);
                        boolean matchesOperation2 = invocation2.matchesOperation(move2.getMovedOperation(), bodyMapper.getContainer2(), bodyMapper.getClassDiff(), this);
                        if (!matchesOperation1 || !matchesOperation2 || !bodyMapper.containsParentMapping(mapping = new LeafMapping(fragment1, fragment2, bodyMapper.getContainer1(), bodyMapper.getContainer2())) && !bodyMapper.parentIsContainerBody(mapping)) continue;
                        bodyMapper.addMapping(mapping);
                        continue block19;
                    }
                }
            }
        }
        return this.filterOutDuplicateRefactorings(refactorings);
    }

    public Set<Refactoring> getMoveRenameClassRefactorings() throws RefactoringMinerTimedOutException {
        if (this.moveRenameClassRefactorings != null) {
            return this.moveRenameClassRefactorings;
        }
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        refactorings.addAll(this.getMoveClassRefactorings());
        ArrayList<RenamePackageRefactoring> renamePackageRefactorings = new ArrayList<RenamePackageRefactoring>();
        for (Refactoring r : refactorings) {
            if (!(r instanceof RenamePackageRefactoring)) continue;
            renamePackageRefactorings.add((RenamePackageRefactoring)r);
        }
        refactorings.addAll(this.getRenameClassRefactorings(renamePackageRefactorings));
        refactorings.addAll(this.getMergeClassRefactorings(renamePackageRefactorings));
        refactorings.addAll(this.getSplitClassRefactorings(renamePackageRefactorings));
        this.postProcessRenamedPackages(renamePackageRefactorings, refactorings);
        this.moveRenameClassRefactorings = refactorings;
        return refactorings;
    }

    private Map<RenamePattern, Integer> typeRenamePatternMap(Set<Refactoring> refactorings) {
        LinkedHashMap<RenamePattern, Integer> typeRenamePatternMap = new LinkedHashMap<RenamePattern, Integer>();
        for (Refactoring ref : refactorings) {
            RenamePattern pattern;
            Refactoring refactoring;
            if (ref instanceof ChangeVariableTypeRefactoring) {
                refactoring = (ChangeVariableTypeRefactoring)ref;
                if (((ChangeVariableTypeRefactoring)refactoring).getOriginalVariable().getType() == null || ((ChangeVariableTypeRefactoring)refactoring).getChangedTypeVariable().getType() == null) continue;
                pattern = new RenamePattern(((ChangeVariableTypeRefactoring)refactoring).getOriginalVariable().getType().toString(), ((ChangeVariableTypeRefactoring)refactoring).getChangedTypeVariable().getType().toString());
                if (typeRenamePatternMap.containsKey(pattern)) {
                    typeRenamePatternMap.put(pattern, (Integer)typeRenamePatternMap.get(pattern) + 1);
                    continue;
                }
                typeRenamePatternMap.put(pattern, 1);
                continue;
            }
            if (ref instanceof ChangeAttributeTypeRefactoring) {
                refactoring = (ChangeAttributeTypeRefactoring)ref;
                if (((ChangeAttributeTypeRefactoring)refactoring).getOriginalAttribute().getType() == null || ((ChangeAttributeTypeRefactoring)refactoring).getChangedTypeAttribute().getType() == null) continue;
                pattern = new RenamePattern(((ChangeAttributeTypeRefactoring)refactoring).getOriginalAttribute().getType().toString(), ((ChangeAttributeTypeRefactoring)refactoring).getChangedTypeAttribute().getType().toString());
                if (typeRenamePatternMap.containsKey(pattern)) {
                    typeRenamePatternMap.put(pattern, (Integer)typeRenamePatternMap.get(pattern) + 1);
                    continue;
                }
                typeRenamePatternMap.put(pattern, 1);
                continue;
            }
            if (!(ref instanceof ChangeReturnTypeRefactoring) || ((ChangeReturnTypeRefactoring)(refactoring = (ChangeReturnTypeRefactoring)ref)).getOriginalType() == null || ((ChangeReturnTypeRefactoring)refactoring).getChangedType() == null) continue;
            pattern = new RenamePattern(((ChangeReturnTypeRefactoring)refactoring).getOriginalType().toString(), ((ChangeReturnTypeRefactoring)refactoring).getChangedType().toString());
            if (typeRenamePatternMap.containsKey(pattern)) {
                typeRenamePatternMap.put(pattern, (Integer)typeRenamePatternMap.get(pattern) + 1);
                continue;
            }
            typeRenamePatternMap.put(pattern, 1);
        }
        return typeRenamePatternMap;
    }

    private Set<Refactoring> filterPackageRefactorings(Set<Refactoring> refactoringsAtRevision) {
        HashSet<RefactoringType> refactoringTypesToConsider = new HashSet<RefactoringType>();
        refactoringTypesToConsider.add(RefactoringType.MOVE_CLASS);
        refactoringTypesToConsider.add(RefactoringType.RENAME_CLASS);
        refactoringTypesToConsider.add(RefactoringType.MOVE_RENAME_CLASS);
        refactoringTypesToConsider.add(RefactoringType.RENAME_PACKAGE);
        refactoringTypesToConsider.add(RefactoringType.MOVE_PACKAGE);
        refactoringTypesToConsider.add(RefactoringType.SPLIT_PACKAGE);
        refactoringTypesToConsider.add(RefactoringType.MERGE_PACKAGE);
        LinkedHashSet<Refactoring> filtered = new LinkedHashSet<Refactoring>();
        for (Refactoring ref : refactoringsAtRevision) {
            if (!refactoringTypesToConsider.contains((Object)ref.getRefactoringType())) continue;
            filtered.add(ref);
        }
        return filtered;
    }

    private void detectImportDeclarationChanges(UMLClassBaseDiff classDiff, Set<Refactoring> refactorings) {
        if (classDiff.hasBothAddedAndRemovedImports()) {
            for (Refactoring ref : refactorings) {
                PackageLevelRefactoring move;
                if (ref instanceof RenameClassRefactoring) {
                    RenameClassRefactoring rename = (RenameClassRefactoring)ref;
                    classDiff.findImportChanges(rename.getOriginalClassName(), rename.getRenamedClassName());
                    continue;
                }
                if (ref instanceof MoveClassRefactoring) {
                    move = (MoveClassRefactoring)ref;
                    classDiff.findImportChanges(((MoveClassRefactoring)move).getOriginalClassName(), ((MoveClassRefactoring)move).getMovedClassName());
                    continue;
                }
                if (!(ref instanceof MoveAndRenameClassRefactoring)) continue;
                move = (MoveAndRenameClassRefactoring)ref;
                classDiff.findImportChanges(((MoveAndRenameClassRefactoring)move).getOriginalClassName(), ((MoveAndRenameClassRefactoring)move).getMovedClassName());
            }
        }
    }

    private void detectImportDeclarationChangesBasedOnTypeChanges(UMLClassBaseDiff classDiff, List<Refactoring> refactorings) {
        if (classDiff.hasBothAddedAndRemovedImports()) {
            for (Refactoring ref : refactorings) {
                if (ref instanceof ChangeReturnTypeRefactoring) {
                    ChangeReturnTypeRefactoring changeReturnType = (ChangeReturnTypeRefactoring)ref;
                    classDiff.findImportChanges(changeReturnType.getOriginalType(), changeReturnType.getChangedType());
                    continue;
                }
                if (ref instanceof ChangeAttributeTypeRefactoring) {
                    ChangeAttributeTypeRefactoring changeAttributeType = (ChangeAttributeTypeRefactoring)ref;
                    classDiff.findImportChanges(changeAttributeType.getOriginalAttribute().getType(), changeAttributeType.getChangedTypeAttribute().getType());
                    if (!changeAttributeType.getAttributeDiff().getInitializerMapper().isPresent()) continue;
                    UMLOperationBodyMapper initializerMapper = changeAttributeType.getAttributeDiff().getInitializerMapper().get();
                    for (Replacement r : initializerMapper.getReplacements()) {
                        if (!r.getType().equals((Object)Replacement.ReplacementType.TYPE)) continue;
                        classDiff.findImportChanges(UMLType.extractTypeObject(r.getBefore()), UMLType.extractTypeObject(r.getAfter()));
                    }
                    continue;
                }
                if (!(ref instanceof ChangeVariableTypeRefactoring)) continue;
                ChangeVariableTypeRefactoring changeVariableType = (ChangeVariableTypeRefactoring)ref;
                classDiff.findImportChanges(changeVariableType.getOriginalVariable().getType(), changeVariableType.getChangedTypeVariable().getType());
            }
            Set<Replacement> replacements = classDiff.getReplacementsOfType(Replacement.ReplacementType.TYPE);
            for (Replacement r : replacements) {
                if (!r.getType().equals((Object)Replacement.ReplacementType.TYPE)) continue;
                classDiff.findImportChanges(UMLType.extractTypeObject(r.getBefore()), UMLType.extractTypeObject(r.getAfter()));
            }
        }
    }

    private void inferMethodSignatureRelatedRefactorings(UMLClassBaseDiff classDiff, Set<Refactoring> refactorings, Map<Pair<UMLOperation, UMLOperation>, Set<MethodInvocationReplacement>> map) throws RefactoringMinerTimedOutException {
        for (UMLOperation uMLOperation : classDiff.getRemovedOperations()) {
            for (UMLOperation addedOperation : classDiff.getAddedOperations()) {
                if (!this.allowInference(classDiff, uMLOperation, addedOperation)) continue;
                List<UMLOperationBodyMapper> mappers = this.findMappersWithMatchingSignatures(uMLOperation, addedOperation);
                if (!mappers.isEmpty()) {
                    UMLOperationBodyMapper bodyMapper = new UMLOperationBodyMapper(uMLOperation, addedOperation, (UMLAbstractClassDiff)classDiff);
                    if (classDiff.getOperationBodyMapperList().contains(bodyMapper)) continue;
                    classDiff.addOperationBodyMapper(bodyMapper);
                    bodyMapper.computeRefactoringsWithinBody();
                    refactorings.addAll(bodyMapper.getRefactoringsAfterPostProcessing());
                    UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(uMLOperation, addedOperation, classDiff);
                    if (operationSignatureDiff.isOperationRenamed()) {
                        RenameOperationRefactoring refactoring = new RenameOperationRefactoring(uMLOperation, addedOperation);
                        refactorings.add(refactoring);
                    }
                    Set<Refactoring> signatureRefactorings = operationSignatureDiff.getRefactorings();
                    refactorings.addAll(signatureRefactorings);
                    if (!signatureRefactorings.isEmpty()) continue;
                    this.inferRefactoringsFromMatchingMappers(mappers, operationSignatureDiff, refactorings);
                    continue;
                }
                Set<MethodInvocationReplacement> replacements = this.findMethodInvocationReplacementWithMatchingSignatures(uMLOperation, addedOperation);
                if (!this.exactMatchingMethodInvocationReplacements(replacements, uMLOperation, addedOperation)) continue;
                LinkedHashSet<Pair<UMLOperation, UMLOperation>> conflictingPairs = new LinkedHashSet<Pair<UMLOperation, UMLOperation>>();
                for (Pair<UMLOperation, UMLOperation> pair : map.keySet()) {
                    if (!((UMLOperation)pair.getLeft()).equals(uMLOperation) && !((UMLOperation)pair.getRight()).equals(addedOperation)) continue;
                    conflictingPairs.add(pair);
                }
                if (conflictingPairs.isEmpty()) {
                    boolean conflictFound = false;
                    for (UMLOperationBodyMapper bodyMapper : classDiff.getOperationBodyMapperList()) {
                        if (!bodyMapper.getContainer1().equals(uMLOperation) && !bodyMapper.getContainer2().equals(addedOperation)) continue;
                        conflictFound = true;
                        break;
                    }
                    if (conflictFound) continue;
                    map.put((Pair<UMLOperation, UMLOperation>)Pair.of((Object)uMLOperation, (Object)addedOperation), replacements);
                    continue;
                }
                for (Pair pair : conflictingPairs) {
                    map.remove(pair);
                }
            }
        }
        for (Pair pair : map.keySet()) {
            UMLOperation addedOperation;
            UMLOperation removedOperation = (UMLOperation)pair.getLeft();
            addedOperation = (UMLOperation)pair.getRight();
            UMLOperationBodyMapper bodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)classDiff);
            if (classDiff.getOperationBodyMapperList().contains(bodyMapper)) continue;
            classDiff.addOperationBodyMapper(bodyMapper);
            bodyMapper.computeRefactoringsWithinBody();
            refactorings.addAll(bodyMapper.getRefactoringsAfterPostProcessing());
            UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, classDiff);
            if (operationSignatureDiff.isOperationRenamed()) {
                RenameOperationRefactoring refactoring = new RenameOperationRefactoring(removedOperation, addedOperation);
                refactorings.add(refactoring);
            }
            Set<Refactoring> signatureRefactorings = operationSignatureDiff.getRefactorings();
            refactorings.addAll(signatureRefactorings);
        }
    }

    private boolean exactMatchingMethodInvocationReplacements(Set<MethodInvocationReplacement> replacements, UMLOperation removedOperation, UMLOperation addedOperation) {
        if (!replacements.isEmpty()) {
            int count = 0;
            for (MethodInvocationReplacement r : replacements) {
                AbstractCall invocationBefore = r.getInvokedOperationBefore();
                AbstractCall invocationAfter = r.getInvokedOperationAfter();
                if (!invocationBefore.getName().equals(removedOperation.getName()) || invocationBefore.arguments().size() != removedOperation.getParametersWithoutReturnType().size() || !invocationAfter.getName().equals(addedOperation.getName()) || invocationAfter.arguments().size() != addedOperation.getParametersWithoutReturnType().size()) continue;
                ++count;
            }
            return count == replacements.size();
        }
        return false;
    }

    private boolean allowInference(UMLClassBaseDiff classDiff, UMLOperation removedOperation, UMLOperation addedOperation) {
        return removedOperation.isAbstract() == addedOperation.isAbstract();
    }

    private void inferRefactoringsFromMatchingMappers(List<UMLOperationBodyMapper> mappers, UMLOperationDiff operationSignatureDiff, Set<Refactoring> refactorings) {
        HashSet<Object> refactoringsToBeAdded = new HashSet<Object>();
        for (UMLOperationBodyMapper mapper : mappers) {
            for (Refactoring refactoring : refactorings) {
                Object matchingAddedParameter;
                UMLParameter matchingRemovedParameter;
                if (refactoring instanceof RenameVariableRefactoring) {
                    RenameVariableRefactoring rename = (RenameVariableRefactoring)refactoring;
                    if (!mapper.getContainer1().equals(rename.getOperationBefore()) || !mapper.getContainer2().equals(rename.getOperationAfter())) continue;
                    matchingRemovedParameter = null;
                    for (UMLParameter uMLParameter : operationSignatureDiff.getRemovedParameters()) {
                        if (!uMLParameter.getName().equals(rename.getOriginalVariable().getVariableName()) || !uMLParameter.getVariableDeclaration().equalType(rename.getOriginalVariable())) continue;
                        matchingRemovedParameter = uMLParameter;
                        break;
                    }
                    matchingAddedParameter = null;
                    for (UMLParameter parameter : operationSignatureDiff.getAddedParameters()) {
                        if (!parameter.getName().equals(rename.getRenamedVariable().getVariableName()) || !parameter.getVariableDeclaration().equalType(rename.getRenamedVariable())) continue;
                        matchingAddedParameter = parameter;
                        break;
                    }
                    if (matchingRemovedParameter == null || matchingAddedParameter == null) continue;
                    RenameVariableRefactoring renameVariableRefactoring = new RenameVariableRefactoring(matchingRemovedParameter.getVariableDeclaration(), ((UMLParameter)matchingAddedParameter).getVariableDeclaration(), operationSignatureDiff.getRemovedOperation(), operationSignatureDiff.getAddedOperation(), new LinkedHashSet<AbstractCodeMapping>(), false);
                    refactoringsToBeAdded.add(renameVariableRefactoring);
                    continue;
                }
                if (refactoring instanceof ChangeVariableTypeRefactoring) {
                    ChangeVariableTypeRefactoring changeType = (ChangeVariableTypeRefactoring)refactoring;
                    if (!mapper.getContainer1().equals(changeType.getOperationBefore()) || !mapper.getContainer2().equals(changeType.getOperationAfter())) continue;
                    matchingRemovedParameter = null;
                    for (UMLParameter uMLParameter : operationSignatureDiff.getRemovedParameters()) {
                        if (!uMLParameter.getName().equals(changeType.getOriginalVariable().getVariableName()) || !uMLParameter.getVariableDeclaration().equalType(changeType.getOriginalVariable())) continue;
                        matchingRemovedParameter = uMLParameter;
                        break;
                    }
                    matchingAddedParameter = null;
                    for (UMLParameter parameter : operationSignatureDiff.getAddedParameters()) {
                        if (!parameter.getName().equals(changeType.getChangedTypeVariable().getVariableName()) || !parameter.getVariableDeclaration().equalType(changeType.getChangedTypeVariable())) continue;
                        matchingAddedParameter = parameter;
                        break;
                    }
                    if (matchingRemovedParameter == null || matchingAddedParameter == null) continue;
                    ChangeVariableTypeRefactoring changeVariableTypeRefactoring = new ChangeVariableTypeRefactoring(matchingRemovedParameter.getVariableDeclaration(), ((UMLParameter)matchingAddedParameter).getVariableDeclaration(), operationSignatureDiff.getRemovedOperation(), operationSignatureDiff.getAddedOperation(), new LinkedHashSet<AbstractCodeMapping>(), false);
                    refactoringsToBeAdded.add(changeVariableTypeRefactoring);
                    continue;
                }
                if (refactoring instanceof AddParameterRefactoring) {
                    AddParameterRefactoring addParameter = (AddParameterRefactoring)refactoring;
                    if (!mapper.getContainer1().equals(addParameter.getOperationBefore()) || !mapper.getContainer2().equals(addParameter.getOperationAfter())) continue;
                    UMLParameter matchingAddedParameter2 = null;
                    for (UMLParameter uMLParameter : operationSignatureDiff.getAddedParameters()) {
                        if (!uMLParameter.getName().equals(addParameter.getParameter().getName()) || !uMLParameter.getType().equals(addParameter.getParameter().getType())) continue;
                        matchingAddedParameter2 = uMLParameter;
                        break;
                    }
                    if (matchingAddedParameter2 == null) continue;
                    AddParameterRefactoring newAddParameter = new AddParameterRefactoring(matchingAddedParameter2, operationSignatureDiff.getRemovedOperation(), operationSignatureDiff.getAddedOperation());
                    refactoringsToBeAdded.add(newAddParameter);
                    continue;
                }
                if (!(refactoring instanceof RemoveParameterRefactoring)) continue;
                RemoveParameterRefactoring removeParameter = (RemoveParameterRefactoring)refactoring;
                if (!mapper.getContainer1().equals(removeParameter.getOperationBefore()) || !mapper.getContainer2().equals(removeParameter.getOperationAfter())) continue;
                matchingRemovedParameter = null;
                for (UMLParameter uMLParameter : operationSignatureDiff.getRemovedParameters()) {
                    if (!uMLParameter.getName().equals(removeParameter.getParameter().getName()) || !uMLParameter.getType().equals(removeParameter.getParameter().getType())) continue;
                    matchingRemovedParameter = uMLParameter;
                    break;
                }
                if (matchingRemovedParameter == null) continue;
                RemoveParameterRefactoring newRemovedParameter = new RemoveParameterRefactoring(matchingRemovedParameter, operationSignatureDiff.getRemovedOperation(), operationSignatureDiff.getAddedOperation());
                refactoringsToBeAdded.add(newRemovedParameter);
            }
        }
        refactorings.addAll(refactoringsToBeAdded);
    }

    private Set<MethodInvocationReplacement> findMethodInvocationReplacementWithMatchingSignatures(UMLOperation operation1, UMLOperation operation2) {
        LinkedHashSet<MethodInvocationReplacement> replacements = new LinkedHashSet<MethodInvocationReplacement>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            replacements.addAll(uMLClassDiff.findMethodInvocationReplacementWithMatchingSignatures(operation1, operation2));
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            replacements.addAll(uMLClassMoveDiff.findMethodInvocationReplacementWithMatchingSignatures(operation1, operation2));
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            replacements.addAll(uMLClassMoveDiff.findMethodInvocationReplacementWithMatchingSignatures(operation1, operation2));
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            replacements.addAll(uMLClassRenameDiff.findMethodInvocationReplacementWithMatchingSignatures(operation1, operation2));
        }
        return replacements;
    }

    private List<UMLOperationBodyMapper> findMappersWithMatchingSignatures(UMLOperation operation1, UMLOperation operation2) {
        UMLOperationBodyMapper mapper;
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            mapper = uMLClassDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            mapper = uMLClassRenameDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        return mappers;
    }

    public List<UMLOperationBodyMapper> findMappersWithMatchingSignature2(UMLOperation operation2) {
        UMLOperationBodyMapper mapper;
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            mapper = uMLClassDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            mapper = uMLClassRenameDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        return mappers;
    }

    private void extractMergePatterns(UMLClassBaseDiff classDiff, Map<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>> mergeMap) {
        for (CandidateMergeVariableRefactoring candidate : classDiff.getCandidateAttributeMerges()) {
            LinkedHashSet<String> before = new LinkedHashSet<String>();
            for (String mergedVariable : candidate.getMergedVariables()) {
                before.add(PrefixSuffixUtils.normalize(mergedVariable));
            }
            String after = PrefixSuffixUtils.normalize(candidate.getNewVariable());
            MergeVariableReplacement merge = new MergeVariableReplacement(before, after);
            if (mergeMap.containsKey(merge)) {
                mergeMap.get(merge).add(candidate);
                continue;
            }
            LinkedHashSet<CandidateMergeVariableRefactoring> set = new LinkedHashSet<CandidateMergeVariableRefactoring>();
            set.add(candidate);
            mergeMap.put(merge, set);
        }
    }

    private void extractRenamePatterns(UMLClassBaseDiff classDiff, Map<Replacement, Set<CandidateAttributeRefactoring>> map) {
        for (CandidateAttributeRefactoring candidate : classDiff.getCandidateAttributeRenames()) {
            Replacement renamePattern;
            String prefix2;
            String prefix1;
            String before = PrefixSuffixUtils.normalize(candidate.getOriginalVariableName());
            String after = PrefixSuffixUtils.normalize(candidate.getRenamedVariableName());
            if (before.contains(".") && after.contains(".") && (prefix1 = before.substring(0, before.lastIndexOf(".") + 1)).equals(prefix2 = after.substring(0, after.lastIndexOf(".") + 1))) {
                before = before.substring(prefix1.length(), before.length());
                after = after.substring(prefix2.length(), after.length());
            }
            if (map.containsKey(renamePattern = new Replacement(before, after, Replacement.ReplacementType.VARIABLE_NAME))) {
                map.get(renamePattern).add(candidate);
                continue;
            }
            LinkedHashSet<CandidateAttributeRefactoring> set = new LinkedHashSet<CandidateAttributeRefactoring>();
            set.add(candidate);
            map.put(renamePattern, set);
        }
    }

    private void checkForMovedAndInlinedOperations(List<UMLOperationBodyMapper> mappers, List<UMLOperation> removedOperations) throws RefactoringMinerTimedOutException {
        for (UMLOperation removedOperation : removedOperations) {
            for (UMLOperationBodyMapper mapper : mappers) {
                if (mapper.nonMappedElementsT2() <= 0 && !this.includesReplacementInvolvingRemovedMethod(mapper.getReplacementsInvolvingMethodInvocation(), removedOperation, mapper.getContainer1(), mapper.getClassDiff()) || mapper.containsInlineOperationRefactoring(removedOperation)) continue;
                List<AbstractCall> operationInvocations = mapper.getContainer1().getAllOperationInvocations();
                ArrayList<AbstractCall> removedOperationInvocations = new ArrayList<AbstractCall>();
                for (AbstractCall invocation : operationInvocations) {
                    if (!invocation.matchesOperation(removedOperation, mapper.getContainer1(), mapper.getClassDiff(), this)) continue;
                    removedOperationInvocations.add(invocation);
                }
                if (removedOperationInvocations.size() <= 0) continue;
                for (AbstractCall removedOperationInvocation : removedOperationInvocations) {
                    UMLOperationBodyMapper operationBodyMapper;
                    if (this.invocationMatchesWithAddedOperation(removedOperationInvocation, mapper.getContainer1(), mapper.getClassDiff(), mapper.getContainer2().getAllOperationInvocations())) continue;
                    List<String> arguments = removedOperationInvocation.arguments();
                    List<String> parameters = removedOperation.getParameterNameList();
                    LinkedHashMap<String, String> parameterToArgumentMap1 = new LinkedHashMap<String, String>();
                    int size = Math.min(arguments.size(), parameters.size());
                    for (int i = 0; i < size; ++i) {
                        parameterToArgumentMap1.put(parameters.get(i), arguments.get(i));
                    }
                    LinkedHashMap<String, String> parameterToArgumentMap2 = new LinkedHashMap<String, String>();
                    String expression = removedOperationInvocation.getExpression();
                    if (expression != null && !removedOperation.getClassName().endsWith("." + expression)) {
                        parameterToArgumentMap2.put(expression + ".", "");
                        parameterToArgumentMap1.put("this.", "");
                    }
                    if (this.moveAndInlineMatchCondition(operationBodyMapper = new UMLOperationBodyMapper(removedOperation, mapper, parameterToArgumentMap1, parameterToArgumentMap2, (UMLAbstractClassDiff)this.getUMLClassDiff(removedOperation.getClassName()), removedOperationInvocation, false), mapper)) {
                        InlineOperationRefactoring inlineOperationRefactoring = new InlineOperationRefactoring(operationBodyMapper, mapper.getContainer1(), removedOperationInvocations);
                        LinkedHashSet<InlineOperationRefactoring> refactoringsToBeRemoved = new LinkedHashSet<InlineOperationRefactoring>();
                        boolean skip = false;
                        for (Refactoring r : this.refactorings) {
                            InlineOperationRefactoring inline;
                            if (!(r instanceof InlineOperationRefactoring) || !(inline = (InlineOperationRefactoring)r).getBodyMapper().identicalMappings(operationBodyMapper)) continue;
                            if (inlineOperationRefactoring.getRefactoringType().equals((Object)RefactoringType.INLINE_OPERATION) && inline.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_INLINE_OPERATION)) {
                                refactoringsToBeRemoved.add(inline);
                                continue;
                            }
                            if (!inlineOperationRefactoring.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_INLINE_OPERATION) || !inline.getRefactoringType().equals((Object)RefactoringType.INLINE_OPERATION)) continue;
                            skip = true;
                        }
                        this.refactorings.removeAll(refactoringsToBeRemoved);
                        if (skip) continue;
                        this.refactorings.add(inlineOperationRefactoring);
                        this.deleteRemovedOperation(removedOperation);
                        mapper.addChildMapper(operationBodyMapper);
                        MappingOptimizer optimizer = new MappingOptimizer(mapper.getClassDiff());
                        optimizer.optimizeDuplicateMappingsForInline(mapper, this.refactorings);
                        continue;
                    }
                    for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
                        AbstractCodeFragment fragment2 = mapping.getFragment2();
                        if (mapping instanceof LeafMapping && !mapper.getNonMappedLeavesT2().contains(fragment2) && fragment2 instanceof StatementObject) {
                            mapper.getNonMappedLeavesT2().add((StatementObject)fragment2);
                            continue;
                        }
                        if (!(mapping instanceof CompositeStatementObjectMapping) || mapper.getNonMappedInnerNodesT2().contains(fragment2) || !(fragment2 instanceof CompositeStatementObject)) continue;
                        mapper.getNonMappedInnerNodesT2().add((CompositeStatementObject)fragment2);
                    }
                }
            }
        }
    }

    private boolean includesReplacementInvolvingRemovedMethod(Set<Replacement> replacements, UMLOperation removedOperation, VariableDeclarationContainer caller, UMLAbstractClassDiff classDiff) {
        for (Replacement replacement : replacements) {
            Replacement r;
            if (replacement instanceof MethodInvocationWithClassInstanceCreationReplacement) {
                r = (MethodInvocationWithClassInstanceCreationReplacement)replacement;
                if (!((MethodInvocationWithClassInstanceCreationReplacement)r).getInvokedOperationBefore().matchesOperation(removedOperation, caller, classDiff, this)) continue;
                return true;
            }
            if (replacement instanceof MethodInvocationReplacement) {
                r = (MethodInvocationReplacement)replacement;
                if (((MethodInvocationReplacement)r).getInvokedOperationBefore().matchesOperation(removedOperation, caller, classDiff, this)) {
                    return true;
                }
                String[] tokens1 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(((MethodInvocationReplacement)r).getInvokedOperationBefore().getName());
                String[] tokens2 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(removedOperation.getNonQualifiedClassName());
                int commonTokens = 0;
                for (String token1 : tokens1) {
                    for (String token2 : tokens2) {
                        if (!token1.equals(token2)) continue;
                        ++commonTokens;
                    }
                }
                if (commonTokens <= 0 || commonTokens < Math.min(tokens1.length, tokens2.length) - 1) continue;
                return true;
            }
            if (!(replacement instanceof VariableReplacementWithMethodInvocation ? ((VariableReplacementWithMethodInvocation)(r = (VariableReplacementWithMethodInvocation)replacement)).getDirection().equals((Object)VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE) && ((VariableReplacementWithMethodInvocation)r).getInvokedOperation().matchesOperation(removedOperation, caller, classDiff, this) : replacement.getBefore().equals(removedOperation.getNonQualifiedClassName()))) continue;
            return true;
        }
        return false;
    }

    private boolean moveAndInlineMatchCondition(UMLOperationBodyMapper operationBodyMapper, UMLOperationBodyMapper parentMapper) {
        ArrayList<AbstractCodeMapping> mappingList = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        if ((operationBodyMapper.getContainer1().isGetter() || operationBodyMapper.getContainer1().isDelegate() != null) && mappingList.size() == 1) {
            ArrayList<AbstractCodeMapping> parentMappingList = new ArrayList<AbstractCodeMapping>(parentMapper.getMappings());
            for (AbstractCodeMapping mapping : parentMappingList) {
                if (mapping.getFragment2().equals(((AbstractCodeMapping)mappingList.get(0)).getFragment2())) {
                    return false;
                }
                if (!(mapping instanceof CompositeStatementObjectMapping)) continue;
                CompositeStatementObjectMapping compositeMapping = (CompositeStatementObjectMapping)mapping;
                CompositeStatementObject fragment2 = (CompositeStatementObject)compositeMapping.getFragment2();
                for (AbstractExpression expression : fragment2.getExpressions()) {
                    if (!expression.equals(((AbstractCodeMapping)mappingList.get(0)).getFragment2())) continue;
                    return false;
                }
            }
        }
        int delegateStatements = 0;
        for (AbstractCodeFragment statement : operationBodyMapper.getNonMappedLeavesT1()) {
            AbstractCall invocation = statement.invocationCoveringEntireFragment();
            if (invocation == null || !invocation.matchesOperation(operationBodyMapper.getContainer1(), parentMapper.getContainer1(), parentMapper.getClassDiff(), this)) continue;
            ++delegateStatements;
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1() - delegateStatements;
        List<AbstractCodeMapping> exactMatchList = operationBodyMapper.getExactMatches();
        List<AbstractCodeMapping> exactMatchListWithoutMatchesInNestedContainers = operationBodyMapper.getExactMatchesWithoutMatchesInNestedContainers();
        int exactMatches = exactMatchList.size();
        int exactMatchesWithoutMatchesInNestedContainers = exactMatchListWithoutMatchesInNestedContainers.size();
        return mappings > 0 && (mappings > nonMappedElementsT1 || exactMatchesWithoutMatchesInNestedContainers == 1 && !exactMatchListWithoutMatchesInNestedContainers.get(0).getFragment1().throwsNewException() && nonMappedElementsT1 - exactMatchesWithoutMatchesInNestedContainers < 10 || exactMatches > 1 && nonMappedElementsT1 - exactMatches < 20);
    }

    private boolean invocationMatchesWithAddedOperation(AbstractCall removedOperationInvocation, VariableDeclarationContainer callerOperation, UMLAbstractClassDiff classDiff, List<AbstractCall> operationInvocationsInNewMethod) {
        if (operationInvocationsInNewMethod.contains(removedOperationInvocation)) {
            for (UMLOperation addedOperation : this.getAddedOperationsInCommonClasses()) {
                if (!removedOperationInvocation.matchesOperation(addedOperation, callerOperation, classDiff, this)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getterOrSetterCorrespondingToRenamedAttribute(UMLOperation addedOperation) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(addedOperation.getClassName());
        return classDiff != null && classDiff.matchesCandidateAttributeRename(addedOperation);
    }

    private boolean includesReplacementInvolvingAddedMethod(Set<Replacement> replacements, UMLOperation addedOperation, VariableDeclarationContainer caller, UMLAbstractClassDiff classDiff) {
        for (Replacement replacement : replacements) {
            Replacement r;
            if (replacement instanceof ClassInstanceCreationWithMethodInvocationReplacement) {
                r = (ClassInstanceCreationWithMethodInvocationReplacement)replacement;
                if (!((ClassInstanceCreationWithMethodInvocationReplacement)r).getInvokedOperationAfter().matchesOperation(addedOperation, caller, classDiff, this)) continue;
                return true;
            }
            if (replacement instanceof MethodInvocationReplacement) {
                r = (MethodInvocationReplacement)replacement;
                if (((MethodInvocationReplacement)r).getInvokedOperationAfter().matchesOperation(addedOperation, caller, classDiff, this)) {
                    return true;
                }
                String[] tokens1 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(((MethodInvocationReplacement)r).getInvokedOperationAfter().getName());
                String[] tokens2 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(addedOperation.getNonQualifiedClassName());
                int commonTokens = 0;
                for (String token1 : tokens1) {
                    for (String token2 : tokens2) {
                        if (!token1.equals(token2)) continue;
                        ++commonTokens;
                    }
                }
                if (commonTokens <= 0 || commonTokens < Math.min(tokens1.length, tokens2.length) - 1) continue;
                return true;
            }
            if (!(replacement instanceof VariableReplacementWithMethodInvocation ? ((VariableReplacementWithMethodInvocation)(r = (VariableReplacementWithMethodInvocation)replacement)).getDirection().equals((Object)VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION) && ((VariableReplacementWithMethodInvocation)r).getInvokedOperation().matchesOperation(addedOperation, caller, classDiff, this) : replacement.getAfter().equals(addedOperation.getNonQualifiedClassName()))) continue;
            return true;
        }
        return false;
    }

    private void checkForExtractedAndMovedOperationsToInnerClasses(UMLClassBaseDiff classDiff) throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> addedOperations = new ArrayList<UMLOperation>();
        for (UMLClass addedClass : this.addedClasses) {
            if (addedClass.getName().startsWith(classDiff.getNextClassName() + ".")) {
                addedOperations.addAll(addedClass.getOperations());
                continue;
            }
            if (addedClass.isTopLevel() || classDiff.getNextClass().isTopLevel() || !addedClass.getName().contains(".") || !classDiff.getNextClassName().contains(".") || !addedClass.getName().substring(0, addedClass.getName().lastIndexOf(".")).equals(classDiff.getNextClassName().substring(0, classDiff.getNextClassName().lastIndexOf(".")))) continue;
            addedOperations.addAll(addedClass.getOperations());
        }
        if (addedOperations.size() > 0) {
            this.checkForExtractedAndMovedOperations(classDiff.getOperationBodyMapperList(), addedOperations);
        }
    }

    private void checkForExtractedAndMovedOperations(List<UMLOperationBodyMapper> mappers, List<UMLOperation> addedOperations) throws RefactoringMinerTimedOutException {
        for (UMLOperation addedOperation : addedOperations) {
            if (this.getterOrSetterCorrespondingToRenamedAttribute(addedOperation)) continue;
            for (UMLOperationBodyMapper mapper : mappers) {
                Pair pair = Pair.of((Object)mapper.getContainer1(), (Object)addedOperation);
                String className = mapper.getContainer2().getClassName();
                if (className.equals(addedOperation.getClassName()) || mapper.nonMappedElementsT1() <= 0 && !this.includesReplacementInvolvingAddedMethod(mapper.getReplacementsInvolvingMethodInvocation(), addedOperation, mapper.getContainer2(), mapper.getClassDiff()) || mapper.containsExtractOperationRefactoring(addedOperation) || this.processedOperationPairs.contains(pair)) continue;
                this.processedOperationPairs.add((Pair<VariableDeclarationContainer, VariableDeclarationContainer>)pair);
                List<AbstractCall> operationInvocations = ExtractOperationDetection.getInvocationsInSourceOperationAfterExtraction(mapper);
                ArrayList<AbstractCall> addedOperationInvocations = new ArrayList<AbstractCall>();
                for (AbstractCall invocation : operationInvocations) {
                    if (!invocation.matchesOperation(addedOperation, mapper.getContainer2(), mapper.getClassDiff(), this)) continue;
                    addedOperationInvocations.add(invocation);
                }
                if (addedOperationInvocations.size() <= 0) continue;
                AbstractCall addedOperationInvocation = (AbstractCall)addedOperationInvocations.get(0);
                List<String> arguments = addedOperationInvocation.arguments();
                List<String> parameters = addedOperation.getParameterNameList();
                LinkedHashMap<String, String> parameterToArgumentMap2 = new LinkedHashMap<String, String>();
                int size = Math.min(arguments.size(), parameters.size());
                for (int i = 0; i < size; ++i) {
                    parameterToArgumentMap2.put(parameters.get(i), arguments.get(i));
                }
                ArrayList<UMLAttribute> attributes = new ArrayList<UMLAttribute>();
                if (className.contains(".") && this.isAnonymousClassName(className)) {
                    String token;
                    String[] tokens = className.split("\\.");
                    Object anonymousID = "";
                    for (int i = tokens.length - 1; i >= 0 && (StringDistance.isNumeric(token = tokens[i]) || Character.isLowerCase(token.charAt(0))); --i) {
                        anonymousID = "." + token + anonymousID;
                    }
                    UMLClassBaseDiff umlClassDiff = this.getUMLClassDiff(className);
                    if (umlClassDiff == null) {
                        Iterator<UMLAnonymousClass> enclosingClassName = className.substring(0, className.indexOf((String)anonymousID));
                        umlClassDiff = this.getUMLClassDiff((String)((Object)enclosingClassName));
                    }
                    attributes.addAll(umlClassDiff.originalClassAttributesOfType(addedOperation.getClassName()));
                    for (UMLAnonymousClass anonymousClass : umlClassDiff.getOriginalClass().getAnonymousClassList()) {
                        if (!className.equals(anonymousClass.getCodePath())) continue;
                        attributes.addAll(anonymousClass.attributesOfType(addedOperation.getClassName()));
                        break;
                    }
                } else {
                    UMLClassBaseDiff umlClassDiff = this.getUMLClassDiff(className);
                    if (umlClassDiff == null) {
                        for (UMLClassDiff classDiff : this.commonClassDiffList) {
                            for (UMLAnonymousClass anonymousClass : classDiff.getAddedAnonymousClasses()) {
                                if (!className.equals(anonymousClass.getCodePath())) continue;
                                umlClassDiff = classDiff;
                                attributes.addAll(anonymousClass.attributesOfType(addedOperation.getClassName()));
                                break;
                            }
                            if (umlClassDiff == null) continue;
                            break;
                        }
                    }
                    attributes.addAll(umlClassDiff.originalClassAttributesOfType(addedOperation.getClassName()));
                }
                LinkedHashMap<String, String> parameterToArgumentMap1 = new LinkedHashMap<String, String>();
                for (UMLAttribute attribute : attributes) {
                    parameterToArgumentMap1.put(attribute.getName() + ".", "");
                    parameterToArgumentMap2.put("this.", "");
                }
                if (addedOperationInvocation.getExpression() != null) {
                    parameterToArgumentMap1.put(addedOperationInvocation.getExpression() + ".", "");
                    parameterToArgumentMap2.put("this.", "");
                }
                UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(mapper, addedOperation, parameterToArgumentMap1, parameterToArgumentMap2, (UMLAbstractClassDiff)this.getUMLClassDiff(addedOperation.getClassName()), addedOperationInvocation, false);
                if (!this.anotherAddedMethodExistsWithBetterMatchingInvocationExpression(addedOperationInvocation, addedOperation, addedOperations) && !this.conflictingExpression(addedOperationInvocation, addedOperation, mapper.getContainer2().variableDeclarationMap()) && this.extractAndMoveMatchCondition(operationBodyMapper, mapper, addedOperationInvocation)) {
                    MappingOptimizer optimizer;
                    ExtractOperationRefactoring extractOperationRefactoring;
                    if (className.equals(addedOperation.getClassName())) {
                        extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getContainer2(), addedOperationInvocations);
                        this.refactorings.add(extractOperationRefactoring);
                        this.refactorings.addAll(operationBodyMapper.getRefactorings());
                        this.deleteAddedOperation(addedOperation);
                        mapper.addChildMapper(operationBodyMapper);
                        optimizer = new MappingOptimizer(mapper.getClassDiff());
                        optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
                        continue;
                    }
                    if (this.isSubclassOf(className, addedOperation.getClassName())) {
                        extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getContainer2(), addedOperationInvocations);
                        this.refactorings.add(extractOperationRefactoring);
                        this.refactorings.addAll(operationBodyMapper.getRefactorings());
                        this.deleteAddedOperation(addedOperation);
                        mapper.addChildMapper(operationBodyMapper);
                        optimizer = new MappingOptimizer(mapper.getClassDiff());
                        optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
                        continue;
                    }
                    if (this.isSubclassOf(addedOperation.getClassName(), className)) {
                        extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getContainer2(), addedOperationInvocations);
                        this.refactorings.add(extractOperationRefactoring);
                        this.refactorings.addAll(operationBodyMapper.getRefactorings());
                        this.deleteAddedOperation(addedOperation);
                        mapper.addChildMapper(operationBodyMapper);
                        optimizer = new MappingOptimizer(mapper.getClassDiff());
                        optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
                        continue;
                    }
                    if (addedOperation.getClassName().startsWith(className + ".")) {
                        extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getContainer2(), addedOperationInvocations);
                        this.refactorings.add(extractOperationRefactoring);
                        this.refactorings.addAll(operationBodyMapper.getRefactorings());
                        this.deleteAddedOperation(addedOperation);
                        mapper.addChildMapper(operationBodyMapper);
                        optimizer = new MappingOptimizer(mapper.getClassDiff());
                        optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
                        continue;
                    }
                    if (className.startsWith(addedOperation.getClassName() + ".")) {
                        extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getContainer2(), addedOperationInvocations);
                        this.refactorings.add(extractOperationRefactoring);
                        this.refactorings.addAll(operationBodyMapper.getRefactorings());
                        this.deleteAddedOperation(addedOperation);
                        mapper.addChildMapper(operationBodyMapper);
                        optimizer = new MappingOptimizer(mapper.getClassDiff());
                        optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
                        continue;
                    }
                    if (!this.sourceClassImportsTargetClass(className, addedOperation.getClassName()) && !this.sourceClassImportsSuperclassOfTargetClass(className, addedOperation.getClassName()) && !this.targetClassImportsSourceClass(className, addedOperation.getClassName())) continue;
                    extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getContainer2(), addedOperationInvocations);
                    this.refactorings.add(extractOperationRefactoring);
                    this.refactorings.addAll(operationBodyMapper.getRefactorings());
                    this.deleteAddedOperation(addedOperation);
                    mapper.addChildMapper(operationBodyMapper);
                    optimizer = new MappingOptimizer(mapper.getClassDiff());
                    optimizer.optimizeDuplicateMappingsForExtract(mapper, this.refactorings);
                    continue;
                }
                for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
                    AbstractCodeFragment fragment1 = mapping.getFragment1();
                    if (mapping instanceof LeafMapping && !mapper.getNonMappedLeavesT1().contains(fragment1) && fragment1 instanceof StatementObject) {
                        mapper.getNonMappedLeavesT1().add((StatementObject)fragment1);
                        continue;
                    }
                    if (!(mapping instanceof CompositeStatementObjectMapping) || mapper.getNonMappedInnerNodesT1().contains(fragment1) || !(fragment1 instanceof CompositeStatementObject)) continue;
                    mapper.getNonMappedInnerNodesT1().add((CompositeStatementObject)fragment1);
                }
            }
        }
    }

    private boolean isAnonymousClassName(String className) {
        String anonymousID = className.substring(className.lastIndexOf(".") + 1, className.length());
        return StringDistance.isNumeric(anonymousID) || Character.isLowerCase(anonymousID.charAt(0));
    }

    private boolean conflictingExpression(AbstractCall invocation, UMLOperation addedOperation, Map<String, Set<VariableDeclaration>> variableDeclarationMap) {
        String expression = invocation.getExpression();
        if (expression != null && variableDeclarationMap.containsKey(expression)) {
            Set<VariableDeclaration> variableDeclarations = variableDeclarationMap.get(expression);
            UMLClassBaseDiff classDiff = this.getUMLClassDiff(addedOperation.getClassName());
            boolean superclassRelationship = false;
            for (VariableDeclaration variableDeclaration : variableDeclarations) {
                UMLType type = variableDeclaration.getType();
                if (classDiff != null && type != null && classDiff.getNewSuperclass() != null && classDiff.getNewSuperclass().equals(type)) {
                    superclassRelationship = true;
                }
                if (type == null || addedOperation.getNonQualifiedClassName().equals(type.getClassType()) || superclassRelationship) continue;
                return true;
            }
        }
        return false;
    }

    private boolean anotherAddedMethodExistsWithBetterMatchingInvocationExpression(AbstractCall invocation, UMLOperation addedOperation, List<UMLOperation> addedOperations) {
        String expression = invocation.getExpression();
        if (expression != null) {
            for (UMLOperation operation : addedOperations) {
                boolean isInterface;
                UMLClassBaseDiff classDiff = this.getUMLClassDiff(operation.getClassName());
                boolean bl = isInterface = classDiff != null ? classDiff.nextClass.isInterface() : false;
                if (operation.equals(addedOperation) || !addedOperation.equalSignature(operation) || operation.isAbstract() || isInterface || !expression.equals(operation.getNonQualifiedClassName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean extractAndMoveMatchCondition(UMLOperationBodyMapper operationBodyMapper, UMLOperationBodyMapper parentMapper, AbstractCall addedOperationInvocation) {
        AbstractExpression expression;
        AbstractCall call;
        ArrayList<AbstractCodeMapping> mappingList = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        if (operationBodyMapper.getContainer2().isGetter() && mappingList.size() == 1) {
            UMLOperation extractedOperation;
            ArrayList<AbstractCodeMapping> parentMappingList = new ArrayList<AbstractCodeMapping>(parentMapper.getMappings());
            for (AbstractCodeMapping mapping : parentMappingList) {
                if (mapping.getFragment1().equals(((AbstractCodeMapping)mappingList.get(0)).getFragment1()) && mapping.isExact()) {
                    return false;
                }
                if (!(mapping instanceof CompositeStatementObjectMapping)) continue;
                CompositeStatementObjectMapping compositeMapping = (CompositeStatementObjectMapping)mapping;
                CompositeStatementObject fragment1 = (CompositeStatementObject)compositeMapping.getFragment1();
                for (AbstractExpression expression2 : fragment1.getExpressions()) {
                    if (!expression2.equals(((AbstractCodeMapping)mappingList.get(0)).getFragment1())) continue;
                    return false;
                }
            }
            String fragment1 = ((AbstractCodeMapping)mappingList.get(0)).getFragment1().getString();
            String fragment2 = ((AbstractCodeMapping)mappingList.get(0)).getFragment2().getString();
            if (operationBodyMapper.getContainer1().isGetter() && (fragment1.startsWith("return this;") || fragment2.startsWith("return this;"))) {
                return false;
            }
            if (fragment1.startsWith("return ") && fragment2.startsWith("return ") && (extractedOperation = operationBodyMapper.getOperation2()) != null) {
                UMLType returnType = extractedOperation.getReturnParameter().getType();
                String fragment1VariableName = fragment1.substring(7, fragment1.indexOf(";\n"));
                VariableDeclaration fragment1VariableDeclaration = operationBodyMapper.getContainer1().getVariableDeclaration(fragment1VariableName);
                if (fragment1VariableDeclaration != null && !returnType.equals(fragment1VariableDeclaration.getType())) {
                    return false;
                }
            }
        }
        if (mappingList.size() == 1 && ((AbstractCodeMapping)mappingList.get(0)).getFragment1() instanceof AbstractExpression && (call = (expression = (AbstractExpression)((AbstractCodeMapping)mappingList.get(0)).getFragment1()).invocationCoveringEntireFragment()) != null && call.identicalName(addedOperationInvocation) && call.equalArguments(addedOperationInvocation)) {
            return false;
        }
        if (mappingList.size() == 1 && ((AbstractCodeMapping)mappingList.get(0)).getFragment1() instanceof StatementObject) {
            AbstractCall invocation1 = ((AbstractCodeMapping)mappingList.get(0)).getFragment1().invocationCoveringEntireFragment();
            AbstractCall invocation2 = ((AbstractCodeMapping)mappingList.get(0)).getFragment2().invocationCoveringEntireFragment();
            if (invocation1 != null && invocation2 != null && invocation1.getExpression() != null && invocation2.getExpression() != null) {
                String expression1 = invocation1.getExpression();
                String expression2 = invocation2.getExpression();
                if (expression1.startsWith("this.")) {
                    expression1 = expression1.substring(5);
                }
                if (expression2.startsWith("this.")) {
                    expression2 = expression2.substring(5);
                }
                if (!expression1.equals(expression2) && operationBodyMapper.getClassDiff() != null) {
                    UMLAttribute attr1 = operationBodyMapper.getClassDiff().findAttributeInNextClass(expression1);
                    UMLAttribute attr2 = operationBodyMapper.getClassDiff().findAttributeInNextClass(expression2);
                    if (attr1 != null && attr2 != null) {
                        boolean matchFound = false;
                        for (UMLAttributeDiff diff : operationBodyMapper.getClassDiff().getAttributeDiffList()) {
                            if (!diff.getRemovedAttribute().equals(attr1) || !diff.getAddedAttribute().equals(attr2)) continue;
                            matchFound = true;
                            break;
                        }
                        if (!matchFound) {
                            return false;
                        }
                    }
                }
            }
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        List<AbstractCodeMapping> exactMatchList = operationBodyMapper.getExactMatches();
        List<AbstractCodeMapping> exactMatchListWithoutMatchesInNestedContainers = operationBodyMapper.getExactMatchesWithoutMatchesInNestedContainers();
        int exactMatches = exactMatchList.size();
        int exactMatchesWithoutMatchesInNestedContainers = exactMatchListWithoutMatchesInNestedContainers.size();
        return mappings > 0 && (mappings > nonMappedElementsT2 || mappings > 1 && mappings >= nonMappedElementsT2 || exactMatches == mappings && nonMappedElementsT1 == 0 || exactMatchesWithoutMatchesInNestedContainers == 1 && !exactMatchListWithoutMatchesInNestedContainers.get(0).getFragment1().throwsNewException() && nonMappedElementsT2 - exactMatchesWithoutMatchesInNestedContainers <= 10 || exactMatches > 1 && nonMappedElementsT2 - exactMatches < 20 || mappings == 1 && mappings > operationBodyMapper.nonMappedLeafElementsT2());
    }

    private void checkForOperationMovesIncludingRemovedAndAddedClasses() throws RefactoringMinerTimedOutException {
        LinkedHashSet<UMLType> interfacesImplementedByAddedClasses = new LinkedHashSet<UMLType>();
        for (UMLClass uMLClass : this.addedClasses) {
            interfacesImplementedByAddedClasses.addAll(uMLClass.getImplementedInterfaces());
            UMLType superclass = uMLClass.getSuperclass();
            if (superclass == null || !superclass.getClassType().startsWith("Abstract")) continue;
            interfacesImplementedByAddedClasses.add(superclass);
        }
        LinkedHashSet<UMLType> interfacesImplementedByRemovedClasses = new LinkedHashSet<UMLType>();
        for (UMLClass removedClass : this.removedClasses) {
            interfacesImplementedByRemovedClasses.addAll(removedClass.getImplementedInterfaces());
            UMLType superclass = removedClass.getSuperclass();
            if (superclass == null || !superclass.getClassType().startsWith("Abstract")) continue;
            interfacesImplementedByRemovedClasses.add(superclass);
        }
        LinkedHashSet<UMLType> linkedHashSet = new LinkedHashSet<UMLType>(interfacesImplementedByAddedClasses);
        linkedHashSet.retainAll(interfacesImplementedByRemovedClasses);
        List<UMLOperation> addedOperations = this.getAddedAndExtractedOperationsInCommonClasses();
        addedOperations.addAll(this.getAddedOperationsInMovedAndRenamedClasses());
        for (UMLClass uMLClass : this.addedClasses) {
            if (!(uMLClass.implementsInterface(linkedHashSet) || uMLClass.extendsSuperclass(linkedHashSet) || this.outerClassMovedOrRenamed(uMLClass))) {
                addedOperations.addAll(uMLClass.getOperations());
                continue;
            }
            if (addedOperations.size() > this.MAXIMUM_NUMBER_OF_COMPARED_METHODS || uMLClass.getOperationsWithOverrideAnnotation().size() <= 0) continue;
            addedOperations.addAll(uMLClass.getOperationsWithoutOverrideAnnotation());
        }
        ArrayList<UMLOperation> removedOperations = new ArrayList<UMLOperation>();
        for (UMLClass removedClass : this.removedClasses) {
            if (!(removedClass.implementsInterface(linkedHashSet) || removedClass.extendsSuperclass(linkedHashSet) || this.outerClassMovedOrRenamed(removedClass))) {
                removedOperations.addAll(removedClass.getOperations());
                continue;
            }
            if (addedOperations.size() > this.MAXIMUM_NUMBER_OF_COMPARED_METHODS || removedOperations.size() > this.MAXIMUM_NUMBER_OF_COMPARED_METHODS || removedClass.getOperationsWithOverrideAnnotation().size() <= 0) continue;
            removedOperations.addAll(removedClass.getOperationsWithoutOverrideAnnotation());
        }
        List<UMLOperation> list = this.getRemovedOperationsInCommonClasses();
        List<UMLOperation> removedOperations2 = this.getRemovedOperationsInCommonMovedRenamedClasses();
        if (this.condition(addedOperations.size(), removedOperations.size() + removedOperations2.size())) {
            for (UMLOperation operation : removedOperations2) {
                if (list.contains(operation)) {
                    removedOperations.add(operation);
                    continue;
                }
                if (operation.isGetter() || operation.isSetter() || operation.isMultiSetter()) continue;
                removedOperations.add(operation);
            }
        } else {
            removedOperations.addAll(list);
        }
        if (this.condition(addedOperations.size(), removedOperations.size())) {
            this.checkForOperationMoves(addedOperations, removedOperations);
        }
    }

    private void checkForOperationMovesBetweenCommonClasses() throws RefactoringMinerTimedOutException {
        List<UMLOperation> addedOperations = this.getAddedAndExtractedOperationsInCommonClasses();
        addedOperations.addAll(this.getAddedOperationsInMovedAndRenamedClasses());
        List<UMLOperation> removedOperations = this.getRemovedOperationsInCommonMovedRenamedClasses();
        if (this.condition(addedOperations.size(), removedOperations.size())) {
            this.checkForOperationMoves(addedOperations, removedOperations);
        }
    }

    private boolean condition(int size1, int size2) {
        if (this.partialModel()) {
            return size1 <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS && size2 <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS;
        }
        return (size1 <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS || size2 <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS) && size1 * size2 <= this.MAXIMUM_NUMBER_OF_COMPARED_METHODS * this.MAXIMUM_NUMBER_OF_COMPARED_METHODS;
    }

    public boolean partialModel() {
        return this.childModel.isPartial() || this.parentModel.isPartial();
    }

    private boolean outerClassMovedOrRenamed(UMLClass umlClass) {
        if (!umlClass.isTopLevel()) {
            String nestedClassExpectedName;
            for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
                if (uMLClassMoveDiff.getOriginalClass().getName().equals(umlClass.getPackageName())) {
                    nestedClassExpectedName = uMLClassMoveDiff.getMovedClass().getName() + umlClass.getName().substring(uMLClassMoveDiff.getOriginalClass().getName().length(), umlClass.getName().length());
                    for (UMLClass addedClass : this.addedClasses) {
                        if (!addedClass.getName().equals(nestedClassExpectedName)) continue;
                        return true;
                    }
                    for (UMLClassMoveDiff innerClassDiff : this.innerClassMoveDiffList) {
                        if (!innerClassDiff.getNextClassName().equals(nestedClassExpectedName)) continue;
                        return true;
                    }
                    continue;
                }
                if (!uMLClassMoveDiff.getMovedClass().getName().equals(umlClass.getPackageName())) continue;
                nestedClassExpectedName = uMLClassMoveDiff.getOriginalClass().getName() + umlClass.getName().substring(uMLClassMoveDiff.getMovedClass().getName().length(), umlClass.getName().length());
                for (UMLClass removedClass : this.removedClasses) {
                    if (!removedClass.getName().equals(nestedClassExpectedName)) continue;
                    return true;
                }
                for (UMLClassMoveDiff innerClassDiff : this.innerClassMoveDiffList) {
                    if (!innerClassDiff.getOriginalClassName().equals(nestedClassExpectedName)) continue;
                    return true;
                }
            }
            for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
                if (uMLClassRenameDiff.getOriginalClass().getName().equals(umlClass.getPackageName())) {
                    nestedClassExpectedName = uMLClassRenameDiff.getRenamedClass().getName() + umlClass.getName().substring(uMLClassRenameDiff.getOriginalClass().getName().length(), umlClass.getName().length());
                    for (UMLClass addedClass : this.addedClasses) {
                        if (!addedClass.getName().equals(nestedClassExpectedName)) continue;
                        return true;
                    }
                    for (UMLClassMoveDiff innerClassDiff : this.innerClassMoveDiffList) {
                        if (!innerClassDiff.getNextClassName().equals(nestedClassExpectedName)) continue;
                        return true;
                    }
                    continue;
                }
                if (!uMLClassRenameDiff.getRenamedClass().getName().equals(umlClass.getPackageName())) continue;
                nestedClassExpectedName = uMLClassRenameDiff.getOriginalClass().getName() + umlClass.getName().substring(uMLClassRenameDiff.getRenamedClass().getName().length(), umlClass.getName().length());
                for (UMLClass removedClass : this.removedClasses) {
                    if (!removedClass.getName().equals(nestedClassExpectedName)) continue;
                    return true;
                }
                for (UMLClassMoveDiff innerClassDiff : this.innerClassMoveDiffList) {
                    if (!innerClassDiff.getOriginalClassName().equals(nestedClassExpectedName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void checkForOperationMoves(List<UMLOperation> addedOperations, List<UMLOperation> removedOperations) throws RefactoringMinerTimedOutException {
        if (addedOperations.size() <= removedOperations.size()) {
            Iterator<UMLOperation> addedOperationIterator = addedOperations.iterator();
            while (addedOperationIterator.hasNext()) {
                UMLOperation addedOperation = addedOperationIterator.next();
                TreeMap<Integer, List<UMLOperationBodyMapper>> operationBodyMapperMap = new TreeMap<Integer, List<UMLOperationBodyMapper>>();
                for (UMLOperation removedOperation : removedOperations) {
                    Object mapperList;
                    Pair pair = Pair.of((Object)removedOperation, (Object)addedOperation);
                    if (this.processedOperationPairs.contains(pair) || !removedOperation.testMethodCheck(addedOperation) || removedOperation.getClassName().equals(addedOperation.getClassName())) continue;
                    UMLClassBaseDiff umlClassDiff = this.getUMLClassDiff(removedOperation.getClassName());
                    if (umlClassDiff == null) {
                        umlClassDiff = this.getUMLClassDiff(addedOperation.getClassName());
                    }
                    UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)umlClassDiff);
                    this.processedOperationPairs.add((Pair<VariableDeclarationContainer, VariableDeclarationContainer>)pair);
                    int mappings = operationBodyMapper.mappingsWithoutBlocks();
                    if ((mappings <= 0 || !this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper)) && !addedOperation.equalSignatureForAbstractMethods(removedOperation) && (mappings <= 0 || !this.isPartOfMethodExtracted(removedOperation, addedOperation, addedOperations, umlClassDiff))) continue;
                    int exactMatches = operationBodyMapper.exactMatches();
                    List<AbstractCodeMapping> exactMappings = operationBodyMapper.getExactMatches();
                    for (AbstractCodeMapping mapping : exactMappings) {
                        String fragment1 = mapping.getFragment1().getString();
                        if (!RETURN_NUMBER_LITERAL.matcher(fragment1).matches()) continue;
                        --exactMatches;
                    }
                    if (operationBodyMapperMap.containsKey(exactMatches)) {
                        mapperList = operationBodyMapperMap.get(exactMatches);
                        mapperList.add(operationBodyMapper);
                        continue;
                    }
                    mapperList = new ArrayList<UMLOperationBodyMapper>();
                    mapperList.add(operationBodyMapper);
                    operationBodyMapperMap.put(exactMatches, (List<UMLOperationBodyMapper>)mapperList);
                }
                if (operationBodyMapperMap.isEmpty()) continue;
                List<UMLOperationBodyMapper> firstMappers = this.firstMappers(operationBodyMapperMap);
                Collections.sort(firstMappers, new UMLOperationBodyMapperComparator());
                addedOperationIterator.remove();
                boolean sameSourceAndTargetClass = this.sameSourceAndTargetClass(firstMappers);
                if (sameSourceAndTargetClass) {
                    TreeSet<UMLOperationBodyMapper> set = null;
                    set = this.allRenamedOperations(firstMappers) ? new TreeSet() : new TreeSet<UMLOperationBodyMapper>(new UMLOperationBodyMapperComparator());
                    set.addAll(firstMappers);
                    UMLOperationBodyMapper bestMapper = set.first();
                    firstMappers.clear();
                    firstMappers.add(bestMapper);
                }
                for (UMLOperationBodyMapper firstMapper : firstMappers) {
                    UMLOperation removedOperation = firstMapper.getOperation1();
                    if (sameSourceAndTargetClass) {
                        removedOperations.remove(removedOperation);
                    }
                    MoveOperationRefactoring refactoring = null;
                    if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(removedOperation.getClassName(), addedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation, this.typeParameterToTypeArgumentMap(removedOperation.getClassName(), addedOperation.getClassName())) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation, addedOperation)) {
                        AbstractCodeMapping mapping;
                        boolean singleSuperConstructorInvocationMatch = false;
                        if (removedOperation.isConstructor() && addedOperation.isConstructor() && firstMapper.getMappings().size() == 1 && (mapping = firstMapper.getMappings().iterator().next()).getFragment1().getString().startsWith("super(") && mapping.getFragment2().getString().startsWith("super(")) {
                            singleSuperConstructorInvocationMatch = true;
                        }
                        if (!singleSuperConstructorInvocationMatch) {
                            refactoring = new PullUpOperationRefactoring(firstMapper);
                        }
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(addedOperation.getClassName(), removedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation, this.typeParameterToTypeArgumentMap(addedOperation.getClassName(), removedOperation.getClassName()))) {
                        AbstractCodeMapping mapping;
                        boolean singleSuperConstructorInvocationMatch = false;
                        if (removedOperation.isConstructor() && addedOperation.isConstructor() && firstMapper.getMappings().size() == 1 && (mapping = firstMapper.getMappings().iterator().next()).getFragment1().getString().startsWith("super(") && mapping.getFragment2().getString().startsWith("super(")) {
                            singleSuperConstructorInvocationMatch = true;
                        }
                        if (!singleSuperConstructorInvocationMatch) {
                            refactoring = new PushDownOperationRefactoring(firstMapper);
                        }
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.movedMethodSignature(removedOperation, addedOperation, firstMapper, firstMappers.size() > 1) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation, addedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.movedAndRenamedMethodSignature(removedOperation, addedOperation, firstMapper, firstMappers.size() > 1) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation, addedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    }
                    if (refactoring == null) continue;
                    this.deleteRemovedOperation(removedOperation);
                    this.deleteAddedOperation(addedOperation);
                    LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
                    boolean skip = false;
                    for (Refactoring r : this.refactorings) {
                        int firstMapperNonMapped;
                        int movedMapperNonMapped;
                        UMLOperationBodyMapper movedBodyMapper;
                        MoveOperationRefactoring move;
                        if (r instanceof ExtractOperationRefactoring) {
                            ExtractOperationRefactoring extract = (ExtractOperationRefactoring)r;
                            if (!extract.getExtractedOperation().equals(addedOperation) || firstMapper.getMappings().size() <= extract.getBodyMapper().getMappings().size()) continue;
                            refactoringsToBeRemoved.add(r);
                            refactoringsToBeRemoved.addAll(extract.getBodyMapper().getRefactoringsAfterPostProcessing());
                            continue;
                        }
                        if (!(r instanceof MoveOperationRefactoring) || !(move = (MoveOperationRefactoring)r).getMovedOperation().equals(addedOperation) || !move.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_RENAME_OPERATION) || !refactoring.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_RENAME_OPERATION) || (movedBodyMapper = move.getBodyMapper()).getMappings().size() < firstMapper.getMappings().size() || (movedMapperNonMapped = movedBodyMapper.getNonMappedLeavesT1().size() + movedBodyMapper.getNonMappedLeavesT2().size() + movedBodyMapper.getNonMappedInnerNodesT1().size() + movedBodyMapper.getNonMappedInnerNodesT2().size()) >= (firstMapperNonMapped = firstMapper.getNonMappedLeavesT1().size() + firstMapper.getNonMappedLeavesT2().size() + firstMapper.getNonMappedInnerNodesT1().size() + firstMapper.getNonMappedInnerNodesT2().size()) || movedMapperNonMapped != 0) continue;
                        skip = true;
                    }
                    this.refactorings.removeAll(refactoringsToBeRemoved);
                    if (skip) continue;
                    this.refactorings.addAll(firstMapper.getRefactorings());
                    this.refactorings.add(refactoring);
                    UMLClass addedClass = this.getAddedClass(addedOperation.getClassName());
                    if (addedClass == null) continue;
                    ArrayList<UMLOperation> potentiallyMovedOperations = new ArrayList<UMLOperation>();
                    UMLClassBaseDiff removedClassDiff = this.getUMLClassDiff(removedOperation.getClassName());
                    if (removedClassDiff != null) {
                        potentiallyMovedOperations.addAll(removedClassDiff.getRemovedOperations());
                    } else {
                        UMLClass removedClass = this.getRemovedClass(removedOperation.getClassName());
                        if (removedClass != null) {
                            potentiallyMovedOperations.addAll(removedClass.getOperations());
                        }
                    }
                    this.checkForExtractedOperationsWithinMovedMethod(firstMapper, potentiallyMovedOperations, addedClass, firstMapper.getClassDiff());
                    if (removedClassDiff == null) continue;
                    this.checkForExtractedOperationsWithinMovedMethod(firstMapper, potentiallyMovedOperations, removedClassDiff.getNextClass(), firstMapper.getClassDiff());
                }
            }
        } else {
            Iterator<UMLOperation> removedOperationIterator = removedOperations.iterator();
            while (removedOperationIterator.hasNext()) {
                UMLOperation removedOperation = removedOperationIterator.next();
                TreeMap<Integer, List<UMLOperationBodyMapper>> operationBodyMapperMap = new TreeMap<Integer, List<UMLOperationBodyMapper>>();
                for (UMLOperation addedOperation : addedOperations) {
                    Object mapperList;
                    Pair pair = Pair.of((Object)removedOperation, (Object)addedOperation);
                    if (this.processedOperationPairs.contains(pair) || !removedOperation.testMethodCheck(addedOperation) || removedOperation.getClassName().equals(addedOperation.getClassName())) continue;
                    UMLClassBaseDiff umlClassDiff = this.getUMLClassDiff(removedOperation.getClassName());
                    if (umlClassDiff == null) {
                        umlClassDiff = this.getUMLClassDiff(addedOperation.getClassName());
                    }
                    UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, (UMLAbstractClassDiff)umlClassDiff);
                    this.processedOperationPairs.add((Pair<VariableDeclarationContainer, VariableDeclarationContainer>)pair);
                    int mappings = operationBodyMapper.mappingsWithoutBlocks();
                    if ((mappings <= 0 || !this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper)) && !removedOperation.equalSignatureForAbstractMethods(addedOperation) && (mappings <= 0 || !this.isPartOfMethodExtracted(removedOperation, addedOperation, addedOperations, umlClassDiff))) continue;
                    int exactMatches = operationBodyMapper.exactMatches();
                    List<AbstractCodeMapping> exactMappings = operationBodyMapper.getExactMatches();
                    for (AbstractCodeMapping mapping : exactMappings) {
                        String fragment1 = mapping.getFragment1().getString();
                        if (!RETURN_NUMBER_LITERAL.matcher(fragment1).matches()) continue;
                        --exactMatches;
                    }
                    if (operationBodyMapperMap.containsKey(exactMatches)) {
                        mapperList = operationBodyMapperMap.get(exactMatches);
                        mapperList.add(operationBodyMapper);
                        continue;
                    }
                    mapperList = new ArrayList<UMLOperationBodyMapper>();
                    mapperList.add(operationBodyMapper);
                    operationBodyMapperMap.put(exactMatches, (List<UMLOperationBodyMapper>)mapperList);
                }
                if (operationBodyMapperMap.isEmpty()) continue;
                List<UMLOperationBodyMapper> firstMappers = this.firstMappers(operationBodyMapperMap);
                Collections.sort(firstMappers, new UMLOperationBodyMapperComparator());
                removedOperationIterator.remove();
                boolean sameSourceAndTargetClass = this.sameSourceAndTargetClass(firstMappers);
                if (sameSourceAndTargetClass) {
                    TreeSet<Object> set = null;
                    set = this.allRenamedOperations(firstMappers) ? new TreeSet<UMLOperationBodyMapper>() : new TreeSet<UMLOperationBodyMapper>(new UMLOperationBodyMapperComparator());
                    set.addAll(firstMappers);
                    UMLOperationBodyMapper bestMapper = (UMLOperationBodyMapper)set.first();
                    firstMappers.clear();
                    firstMappers.add(bestMapper);
                }
                for (UMLOperationBodyMapper firstMapper : firstMappers) {
                    UMLOperation addedOperation = firstMapper.getOperation2();
                    if (sameSourceAndTargetClass) {
                        addedOperations.remove(addedOperation);
                    }
                    MoveOperationRefactoring refactoring = null;
                    if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(removedOperation.getClassName(), addedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation, this.typeParameterToTypeArgumentMap(removedOperation.getClassName(), addedOperation.getClassName())) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation, addedOperation)) {
                        AbstractCodeMapping mapping;
                        boolean singleSuperConstructorInvocationMatch = false;
                        if (removedOperation.isConstructor() && addedOperation.isConstructor() && firstMapper.getMappings().size() == 1 && (mapping = firstMapper.getMappings().iterator().next()).getFragment1().getString().startsWith("super(") && mapping.getFragment2().getString().startsWith("super(")) {
                            singleSuperConstructorInvocationMatch = true;
                        }
                        if (!singleSuperConstructorInvocationMatch) {
                            refactoring = new PullUpOperationRefactoring(firstMapper);
                        }
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(addedOperation.getClassName(), removedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation, this.typeParameterToTypeArgumentMap(addedOperation.getClassName(), removedOperation.getClassName()))) {
                        AbstractCodeMapping mapping;
                        boolean singleSuperConstructorInvocationMatch = false;
                        if (removedOperation.isConstructor() && addedOperation.isConstructor() && firstMapper.getMappings().size() == 1 && (mapping = firstMapper.getMappings().iterator().next()).getFragment1().getString().startsWith("super(") && mapping.getFragment2().getString().startsWith("super(")) {
                            singleSuperConstructorInvocationMatch = true;
                        }
                        if (!singleSuperConstructorInvocationMatch) {
                            refactoring = new PushDownOperationRefactoring(firstMapper);
                        }
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.movedMethodSignature(removedOperation, addedOperation, firstMapper, firstMappers.size() > 1) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation, addedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.movedAndRenamedMethodSignature(removedOperation, addedOperation, firstMapper, firstMappers.size() > 1) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation, addedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    }
                    if (refactoring == null) continue;
                    this.deleteRemovedOperation(removedOperation);
                    this.deleteAddedOperation(addedOperation);
                    LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
                    boolean skip = false;
                    for (Refactoring r : this.refactorings) {
                        int firstMapperNonMapped;
                        int movedMapperNonMapped;
                        UMLOperationBodyMapper movedBodyMapper;
                        MoveOperationRefactoring move;
                        if (r instanceof ExtractOperationRefactoring) {
                            ExtractOperationRefactoring extract = (ExtractOperationRefactoring)r;
                            if (!extract.getExtractedOperation().equals(addedOperation) || firstMapper.getMappings().size() <= extract.getBodyMapper().getMappings().size()) continue;
                            refactoringsToBeRemoved.add(r);
                            refactoringsToBeRemoved.addAll(extract.getBodyMapper().getRefactoringsAfterPostProcessing());
                            continue;
                        }
                        if (!(r instanceof MoveOperationRefactoring) || !(move = (MoveOperationRefactoring)r).getMovedOperation().equals(addedOperation) || !move.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_RENAME_OPERATION) || !refactoring.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_RENAME_OPERATION) || (movedBodyMapper = move.getBodyMapper()).getMappings().size() < firstMapper.getMappings().size() || (movedMapperNonMapped = movedBodyMapper.getNonMappedLeavesT1().size() + movedBodyMapper.getNonMappedLeavesT2().size() + movedBodyMapper.getNonMappedInnerNodesT1().size() + movedBodyMapper.getNonMappedInnerNodesT2().size()) >= (firstMapperNonMapped = firstMapper.getNonMappedLeavesT1().size() + firstMapper.getNonMappedLeavesT2().size() + firstMapper.getNonMappedInnerNodesT1().size() + firstMapper.getNonMappedInnerNodesT2().size()) || movedMapperNonMapped != 0) continue;
                        skip = true;
                    }
                    this.refactorings.removeAll(refactoringsToBeRemoved);
                    if (skip) continue;
                    this.refactorings.addAll(firstMapper.getRefactorings());
                    this.refactorings.add(refactoring);
                    UMLClass addedClass = this.getAddedClass(addedOperation.getClassName());
                    if (addedClass == null) continue;
                    ArrayList<UMLOperation> potentiallyMovedOperations = new ArrayList<UMLOperation>();
                    UMLClassBaseDiff removedClassDiff = this.getUMLClassDiff(removedOperation.getClassName());
                    if (removedClassDiff != null) {
                        potentiallyMovedOperations.addAll(removedClassDiff.getRemovedOperations());
                    } else {
                        UMLClass removedClass = this.getRemovedClass(removedOperation.getClassName());
                        if (removedClass != null) {
                            potentiallyMovedOperations.addAll(removedClass.getOperations());
                        }
                    }
                    this.checkForExtractedOperationsWithinMovedMethod(firstMapper, potentiallyMovedOperations, addedClass, firstMapper.getClassDiff());
                    if (removedClassDiff == null) continue;
                    this.checkForExtractedOperationsWithinMovedMethod(firstMapper, potentiallyMovedOperations, removedClassDiff.getNextClass(), firstMapper.getClassDiff());
                }
            }
        }
    }

    private Map<UMLTypeParameter, UMLType> typeParameterToTypeArgumentMap(String subclass, String superclass) {
        UMLClassBaseDiff superclassDiff;
        UMLType superclassType;
        LinkedHashMap<UMLTypeParameter, UMLType> typeParameterToTypeArgumentMap = new LinkedHashMap<UMLTypeParameter, UMLType>();
        UMLClassBaseDiff subclassDiff = this.getUMLClassDiff(subclass);
        if (subclassDiff != null && (superclassType = subclassDiff.getNewSuperclass()) != null && (superclassDiff = this.getUMLClassDiff(superclass)) != null) {
            List<UMLTypeParameter> typeParameters = superclassDiff.getNextClass().getTypeParameters();
            List<UMLType> typeArguments = superclassType.getTypeArguments();
            if (typeParameters.size() == typeArguments.size()) {
                for (int i = 0; i < typeParameters.size(); ++i) {
                    typeParameterToTypeArgumentMap.put(typeParameters.get(i), typeArguments.get(i));
                }
            }
        }
        return typeParameterToTypeArgumentMap;
    }

    private List<UMLOperationBodyMapper> firstMappers(TreeMap<Integer, List<UMLOperationBodyMapper>> operationBodyMapperMap) {
        ArrayList<UMLOperationBodyMapper> firstMappers = new ArrayList<UMLOperationBodyMapper>((Collection)operationBodyMapperMap.get(operationBodyMapperMap.lastKey()));
        List<UMLOperationBodyMapper> extraMappers = operationBodyMapperMap.get(0);
        if (extraMappers != null && operationBodyMapperMap.lastKey() != 0) {
            block0: for (UMLOperationBodyMapper extraMapper : extraMappers) {
                Set<Replacement> replacements;
                ArrayList<AbstractCodeMapping> mappings;
                UMLOperation operation2;
                UMLOperation operation1 = extraMapper.getOperation1();
                if (!operation1.equalSignature(operation2 = extraMapper.getOperation2()) || (mappings = new ArrayList<AbstractCodeMapping>(extraMapper.getMappings())).size() != 1 || (replacements = ((AbstractCodeMapping)mappings.get(0)).getReplacements()).size() != 1) continue;
                Replacement replacement = replacements.iterator().next();
                List<String> parameterNames1 = operation1.getParameterNameList();
                List<String> parameterNames2 = operation2.getParameterNameList();
                for (int i = 0; i < parameterNames1.size(); ++i) {
                    String parameterName1 = parameterNames1.get(i);
                    String parameterName2 = parameterNames2.get(i);
                    if (!replacement.getBefore().equals(parameterName1) || !replacement.getAfter().equals(parameterName2)) continue;
                    firstMappers.add(extraMapper);
                    continue block0;
                }
            }
        }
        return firstMappers;
    }

    private boolean allRenamedOperations(List<UMLOperationBodyMapper> mappers) {
        for (UMLOperationBodyMapper mapper : mappers) {
            if (!mapper.getContainer1().getName().equals(mapper.getContainer2().getName())) continue;
            return false;
        }
        return true;
    }

    private boolean sameSourceAndTargetClass(List<UMLOperationBodyMapper> mappers) {
        if (mappers.size() == 1) {
            return false;
        }
        String sourceClassName = null;
        String targetClassName = null;
        for (UMLOperationBodyMapper mapper : mappers) {
            String mapperSourceClassName = mapper.getContainer1().getClassName();
            if (sourceClassName == null) {
                sourceClassName = mapperSourceClassName;
            } else if (!mapperSourceClassName.equals(sourceClassName)) {
                return false;
            }
            String mapperTargetClassName = mapper.getContainer2().getClassName();
            if (targetClassName == null) {
                targetClassName = mapperTargetClassName;
                continue;
            }
            if (mapperTargetClassName.equals(targetClassName)) continue;
            return false;
        }
        return true;
    }

    private boolean mappedElementsMoreThanNonMappedT1AndT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        UMLClass addedClass = this.getAddedClass(operationBodyMapper.getContainer2().getClassName());
        int nonMappedStatementsDeclaringSameVariable = 0;
        ListIterator<AbstractCodeFragment> leafIterator1 = operationBodyMapper.getNonMappedLeavesT1().listIterator();
        block0: while (leafIterator1.hasNext()) {
            Object variableInitializer;
            AbstractCodeFragment s1 = leafIterator1.next();
            for (AbstractCodeFragment abstractCodeFragment : operationBodyMapper.getNonMappedLeavesT2()) {
                if (s1.getVariableDeclarations().size() != 1 || abstractCodeFragment.getVariableDeclarations().size() != 1) continue;
                VariableDeclaration v1 = s1.getVariableDeclarations().get(0);
                VariableDeclaration v2 = abstractCodeFragment.getVariableDeclarations().get(0);
                if (!v1.getVariableName().equals(v2.getVariableName()) || !v1.equalType(v2)) continue;
                ++nonMappedStatementsDeclaringSameVariable;
            }
            if (addedClass != null && s1.getVariableDeclarations().size() == 1) {
                Iterator<UMLAttribute> v1 = s1.getVariableDeclarations().get(0);
                for (UMLAttribute attribute : addedClass.getAttributes()) {
                    String attributeInitializer;
                    VariableDeclaration attributeDeclaration = attribute.getVariableDeclaration();
                    if (attributeDeclaration.getInitializer() == null || ((VariableDeclaration)((Object)v1)).getInitializer() == null || !(attributeInitializer = attributeDeclaration.getInitializer().getString()).equals(variableInitializer = ((VariableDeclaration)((Object)v1)).getInitializer().getString()) || !attributeDeclaration.equalType((VariableDeclaration)((Object)v1)) || !attribute.getName().equals(((VariableDeclaration)((Object)v1)).getVariableName()) && !attribute.getName().toLowerCase().contains(((VariableDeclaration)((Object)v1)).getVariableName().toLowerCase()) && !((VariableDeclaration)((Object)v1)).getVariableName().toLowerCase().contains(attribute.getName().toLowerCase())) continue;
                    ++nonMappedStatementsDeclaringSameVariable;
                    leafIterator1.remove();
                    LeafMapping mapping = new LeafMapping(((VariableDeclaration)((Object)v1)).getInitializer(), attributeDeclaration.getInitializer(), operationBodyMapper.getContainer1(), operationBodyMapper.getContainer2());
                    operationBodyMapper.addMapping(mapping);
                    ++mappings;
                    continue block0;
                }
                continue;
            }
            if (addedClass == null || !s1.getString().contains("=")) continue;
            for (UMLAttribute uMLAttribute : addedClass.getAttributes()) {
                VariableDeclaration attributeDeclaration = uMLAttribute.getVariableDeclaration();
                if (attributeDeclaration.getInitializer() == null) continue;
                String attributeInitializer = attributeDeclaration.getInitializer().getString();
                List<LeafExpression> matchingExpressions = s1.findExpression(attributeInitializer);
                variableInitializer = matchingExpressions.iterator();
                while (variableInitializer.hasNext()) {
                    LeafExpression expression = (LeafExpression)variableInitializer.next();
                    LeafMapping mapping = new LeafMapping(expression, attributeDeclaration.getInitializer(), operationBodyMapper.getContainer1(), operationBodyMapper.getContainer2());
                    operationBodyMapper.addMapping(mapping);
                }
                if (matchingExpressions.size() <= 0) continue;
                ++nonMappedStatementsDeclaringSameVariable;
                leafIterator1.remove();
                ++mappings;
                continue block0;
            }
        }
        HashSet<AbstractCodeMapping> mappingsToBeRemoved = new HashSet<AbstractCodeMapping>();
        HashSet<LeafMapping> mappingsToBeAdded = new HashSet<LeafMapping>();
        block5: for (AbstractCodeMapping abstractCodeMapping : operationBodyMapper.getMappings()) {
            AbstractCodeFragment s1 = abstractCodeMapping.getFragment1();
            if (addedClass != null && s1.getVariableDeclarations().size() == 1) {
                Iterator<CompositeStatementObject> v1 = s1.getVariableDeclarations().get(0);
                for (UMLAttribute attribute : addedClass.getAttributes()) {
                    String variableInitializer;
                    String attributeInitializer;
                    VariableDeclaration attributeDeclaration = attribute.getVariableDeclaration();
                    if (attributeDeclaration.getInitializer() == null || ((VariableDeclaration)((Object)v1)).getInitializer() == null || !(attributeInitializer = attributeDeclaration.getInitializer().getString()).equals(variableInitializer = ((VariableDeclaration)((Object)v1)).getInitializer().getString()) || !attributeDeclaration.equalType((VariableDeclaration)((Object)v1)) || !attribute.getName().equals(((VariableDeclaration)((Object)v1)).getVariableName()) && !attribute.getName().toLowerCase().contains(((VariableDeclaration)((Object)v1)).getVariableName().toLowerCase()) && !((VariableDeclaration)((Object)v1)).getVariableName().toLowerCase().contains(attribute.getName().toLowerCase())) continue;
                    LeafMapping newMapping = new LeafMapping(((VariableDeclaration)((Object)v1)).getInitializer(), attributeDeclaration.getInitializer(), operationBodyMapper.getContainer1(), operationBodyMapper.getContainer2());
                    mappingsToBeAdded.add(newMapping);
                    ++nonMappedStatementsDeclaringSameVariable;
                    mappingsToBeRemoved.add(abstractCodeMapping);
                    continue block5;
                }
                continue;
            }
            if (addedClass == null || !s1.getString().contains("=") || s1.getString().contains("==") || s1.getString().contains("!=")) continue;
            for (UMLAttribute attribute : addedClass.getAttributes()) {
                VariableDeclaration attributeDeclaration = attribute.getVariableDeclaration();
                if (attributeDeclaration.getInitializer() == null) continue;
                String attributeInitializer = attributeDeclaration.getInitializer().getString();
                List<LeafExpression> matchingExpressions = s1.findExpression(attributeInitializer);
                for (LeafExpression expression : matchingExpressions) {
                    LeafMapping newMapping = new LeafMapping(expression, attributeDeclaration.getInitializer(), operationBodyMapper.getContainer1(), operationBodyMapper.getContainer2());
                    mappingsToBeAdded.add(newMapping);
                }
                if (matchingExpressions.size() <= 0) continue;
                ++nonMappedStatementsDeclaringSameVariable;
                mappingsToBeRemoved.add(abstractCodeMapping);
                continue block5;
            }
        }
        for (AbstractCodeMapping abstractCodeMapping : mappingsToBeRemoved) {
            operationBodyMapper.removeMapping(abstractCodeMapping);
        }
        for (AbstractCodeMapping abstractCodeMapping : mappingsToBeAdded) {
            operationBodyMapper.addMapping(abstractCodeMapping);
        }
        int nonMappedLoopsIteratingOverSameVariable = 0;
        for (CompositeStatementObject c1 : operationBodyMapper.getNonMappedInnerNodesT1()) {
            if (!c1.isLoop()) continue;
            for (CompositeStatementObject c2 : operationBodyMapper.getNonMappedInnerNodesT2()) {
                if (!c2.isLoop()) continue;
                Set<String> intersection = UMLModelDiff.convertToStringSet(c1.getVariables());
                intersection.retainAll(UMLModelDiff.convertToStringSet(c2.getVariables()));
                if (intersection.isEmpty()) continue;
                ++nonMappedLoopsIteratingOverSameVariable;
            }
        }
        UMLOperation uMLOperation = operationBodyMapper.getOperation1();
        UMLOperation operation2 = operationBodyMapper.getOperation2();
        boolean identicalJavadoc = false;
        if (uMLOperation != null && operation2 != null && uMLOperation.getJavadoc() != null && operation2.getJavadoc() != null && uMLOperation.getJavadoc().equalText(operation2.getJavadoc())) {
            identicalJavadoc = true;
        }
        return mappings > nonMappedElementsT1 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable && mappings > nonMappedElementsT2 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable || mappings > 10 && mappings >= nonMappedElementsT1 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable && mappings >= nonMappedElementsT2 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable || nonMappedElementsT1 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable <= 0 && (double)mappings > Math.floor((double)nonMappedElementsT2 / 2.0) || nonMappedElementsT2 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable <= 0 && (double)mappings > Math.floor((double)nonMappedElementsT1 / 2.0) || (double)mappings > Math.floor((double)nonMappedElementsT2 / 2.0) && (double)mappings > Math.floor((double)nonMappedElementsT1 / 2.0) && identicalJavadoc;
    }

    private static Set<String> convertToStringSet(List<? extends LeafExpression> expressions) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (LeafExpression leafExpression : expressions) {
            set.add(leafExpression.getString());
        }
        return set;
    }

    private boolean isPartOfMethodExtracted(UMLOperation removedOperation, UMLOperation addedOperation, List<UMLOperation> addedOperations, UMLAbstractClassDiff classDiff) {
        int numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations;
        ArrayList<UMLOperation> filteredAddedOperations = new ArrayList<UMLOperation>();
        for (UMLOperation operation : addedOperations) {
            if (!operation.getClassName().equals(addedOperation.getClassName())) continue;
            filteredAddedOperations.add(operation);
        }
        List<AbstractCall> removedOperationInvocations = removedOperation.getAllOperationInvocations();
        List<AbstractCall> addedOperationInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<AbstractCall> intersection = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
        intersection.retainAll(addedOperationInvocations);
        int numberOfInvocationsMissingFromRemovedOperation = new LinkedHashSet<AbstractCall>(removedOperationInvocations).size() - intersection.size();
        LinkedHashSet<AbstractCall> operationInvocationsInMethodsCalledByAddedOperation = new LinkedHashSet<AbstractCall>();
        for (AbstractCall addedOperationInvocation : addedOperationInvocations) {
            if (intersection.contains(addedOperationInvocation)) continue;
            for (UMLOperation operation : filteredAddedOperations) {
                if (operation.equals(addedOperation) || operation.getBody() == null || !addedOperationInvocation.matchesOperation(operation, addedOperation, classDiff, this)) continue;
                operationInvocationsInMethodsCalledByAddedOperation.addAll(operation.getAllOperationInvocations());
            }
        }
        LinkedHashSet<AbstractCall> newIntersection = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
        newIntersection.retainAll(operationInvocationsInMethodsCalledByAddedOperation);
        LinkedHashSet<AbstractCall> removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted = new LinkedHashSet<AbstractCall>(removedOperationInvocations);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(intersection);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(newIntersection);
        Iterator operationInvocationIterator = removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.iterator();
        while (operationInvocationIterator.hasNext()) {
            AbstractCall invocation = (AbstractCall)operationInvocationIterator.next();
            if (!invocation.getName().startsWith("get")) continue;
            operationInvocationIterator.remove();
        }
        int numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations = newIntersection.size();
        return numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > (numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations = numberOfInvocationsMissingFromRemovedOperation - numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations) || numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.size();
    }

    private boolean movedAndRenamedMethodSignature(UMLOperation removedOperation, UMLOperation addedOperation, UMLOperationBodyMapper mapper, boolean multipleMappers) {
        UMLClassBaseDiff removedOperationClassDiff;
        UMLClassBaseDiff addedOperationClassDiff = this.getUMLClassDiff(addedOperation.getClassName());
        if (addedOperationClassDiff != null) {
            for (Refactoring r : addedOperationClassDiff.getRefactoringsBeforePostProcessing()) {
                Object extractRefactoring;
                if (!(r instanceof ExtractOperationRefactoring) || !((ExtractOperationRefactoring)(extractRefactoring = (ExtractOperationRefactoring)r)).getExtractedOperation().equals(addedOperation)) continue;
                return false;
            }
        }
        if ((removedOperationClassDiff = this.getUMLClassDiff(removedOperation.getClassName())) != null && removedOperationClassDiff.containsOperationWithTheSameSignatureInNextClass(removedOperation)) {
            return false;
        }
        if ((removedOperation.isGetter() || removedOperation.isSetter() || addedOperation.isGetter() || addedOperation.isSetter()) && mapper.mappingsWithoutBlocks() == 1 && mapper.getMappings().size() == 1 && (!mapper.getMappings().iterator().next().isExact() || multipleMappers)) {
            return false;
        }
        if ((removedOperation.isConstructor() || addedOperation.isConstructor()) && mapper.mappingsWithoutBlocks() > 0) {
            if (!mapper.allMappingsAreExactMatches() || mapper.nonMappedElementsT1() != 0 || mapper.nonMappedElementsT2() != 0) {
                return false;
            }
            if (mapper.mappingsWithoutBlocks() == 1 && mapper.getMappings().size() == 1 && mapper.exactMatches() == 1 && multipleMappers) {
                return false;
            }
        }
        int exactLeafMappings = 0;
        for (AbstractCodeMapping mapping : mapper.getMappings()) {
            if (!(mapping instanceof LeafMapping) || !mapping.isExact() || mapping.getFragment1().getString().startsWith("return ")) continue;
            ++exactLeafMappings;
        }
        double normalizedEditDistance = mapper.normalizedEditDistance();
        if (exactLeafMappings == 0 && normalizedEditDistance > 0.24) {
            return false;
        }
        if (exactLeafMappings == 1 && normalizedEditDistance > 0.51 && (mapper.nonMappedElementsT1() > 0 || mapper.nonMappedElementsT2() > 0)) {
            return false;
        }
        if (mapper.mappingsWithoutBlocks() == 1) {
            for (AbstractCodeMapping mapping : mapper.getMappings()) {
                String fragment1 = mapping.getFragment1().getString();
                String fragment2 = mapping.getFragment2().getString();
                if (!fragment1.startsWith("return true;") && !fragment1.startsWith("return false;") && !fragment1.startsWith("return this;") && !fragment1.startsWith("return null;") && !fragment1.startsWith("return;") && !fragment2.startsWith("return true;") && !fragment2.startsWith("return false;") && !fragment2.startsWith("return this;") && !fragment2.startsWith("return null;") && !fragment2.startsWith("return;")) continue;
                return false;
            }
        }
        if (addedOperation.isAbstract() == removedOperation.isAbstract() && addedOperation.getTypeParameters().equals(removedOperation.getTypeParameters())) {
            List<UMLType> removedOperationParameterTypeList;
            List<UMLType> addedOperationParameterTypeList = addedOperation.getParameterTypeList();
            if (addedOperationParameterTypeList.equals(removedOperationParameterTypeList = removedOperation.getParameterTypeList()) && addedOperationParameterTypeList.size() > 0) {
                return true;
            }
            ArrayList<UMLParameter> oldParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> oldParameterNames = new LinkedHashSet<String>();
            for (UMLParameter oldParameter : removedOperation.getParameters()) {
                if (oldParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                oldParameters.add(oldParameter);
                oldParameterNames.add(oldParameter.getName());
            }
            ArrayList<UMLParameter> newParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> newParameterNames = new LinkedHashSet<String>();
            for (UMLParameter newParameter : addedOperation.getParameters()) {
                if (newParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                newParameters.add(newParameter);
                newParameterNames.add(newParameter.getName());
            }
            LinkedHashSet intersection = new LinkedHashSet(oldParameterNames);
            intersection.retainAll(newParameterNames);
            boolean parameterMatch = oldParameters.equals(newParameters) || oldParameters.containsAll(newParameters) || newParameters.containsAll(oldParameters) || intersection.size() > 0 || removedOperation.isStatic() || addedOperation.isStatic();
            return parameterMatch && oldParameters.size() > 0 && newParameters.size() > 0 || parameterMatch && addedOperation.equalReturnParameter(removedOperation) && (oldParameters.size() == 0 || newParameters.size() == 0);
        }
        return false;
    }

    private boolean movedMethodSignature(UMLOperation removedOperation, UMLOperation addedOperation, UMLOperationBodyMapper mapper, boolean multipleMappers) {
        if ((removedOperation.isGetter() || removedOperation.isSetter() || addedOperation.isGetter() || addedOperation.isSetter()) && mapper.mappingsWithoutBlocks() == 1 && mapper.getMappings().size() == 1 && (!mapper.getMappings().iterator().next().isExact() || multipleMappers)) {
            return false;
        }
        if (addedOperation.getName().equals(removedOperation.getName()) && addedOperation.equalReturnParameter(removedOperation) && addedOperation.isAbstract() == removedOperation.isAbstract() && addedOperation.getTypeParameters().equals(removedOperation.getTypeParameters())) {
            if (addedOperation.getParameters().equals(removedOperation.getParameters())) {
                return true;
            }
            ArrayList<UMLParameter> oldParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> oldParameterNames = new LinkedHashSet<String>();
            for (UMLParameter oldParameter : removedOperation.getParameters()) {
                if (oldParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                oldParameters.add(oldParameter);
                oldParameterNames.add(oldParameter.getName());
            }
            ArrayList<UMLParameter> newParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> newParameterNames = new LinkedHashSet<String>();
            for (UMLParameter newParameter : addedOperation.getParameters()) {
                if (newParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                newParameters.add(newParameter);
                newParameterNames.add(newParameter.getName());
            }
            LinkedHashSet intersection = new LinkedHashSet(oldParameterNames);
            intersection.retainAll(newParameterNames);
            return oldParameters.equals(newParameters) || oldParameters.containsAll(newParameters) || newParameters.containsAll(oldParameters) || intersection.size() > 0 || removedOperation.isStatic() || addedOperation.isStatic();
        }
        return false;
    }

    private boolean refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(UMLOperation removedOperation, UMLOperation addedOperation) {
        for (Refactoring refactoring : this.refactorings) {
            MoveOperationRefactoring moveRefactoring;
            if (!(refactoring instanceof MoveOperationRefactoring) || !(moveRefactoring = (MoveOperationRefactoring)refactoring).getOriginalOperation().equals(removedOperation) || addedOperation.getClassName().startsWith(removedOperation.getClassName() + ".")) continue;
            return true;
        }
        return false;
    }

    public boolean refactoringListContainsAnotherMoveRefactoringWithTheSameAddedOperation(UMLOperation addedOperation) {
        for (Refactoring refactoring : this.refactorings) {
            MoveOperationRefactoring moveRefactoring;
            if (!(refactoring instanceof MoveOperationRefactoring) || !(moveRefactoring = (MoveOperationRefactoring)refactoring).getMovedOperation().equals(addedOperation)) continue;
            return true;
        }
        return false;
    }

    private boolean attributeMerged(UMLAttribute a1, UMLAttribute a2, Set<Refactoring> refactorings) {
        for (Refactoring refactoring : refactorings) {
            MergeAttributeRefactoring merge;
            if (!(refactoring instanceof MergeAttributeRefactoring) || !(merge = (MergeAttributeRefactoring)refactoring).getMergedVariables().contains(a1.getVariableDeclaration()) || !merge.getNewAttribute().getVariableDeclaration().equals(a2.getVariableDeclaration())) continue;
            return true;
        }
        return false;
    }

    private Set<Refactoring> movedAttributeRenamed(VariableDeclaration a1, VariableDeclaration a2, Set<Refactoring> refactorings) {
        HashSet<Refactoring> matchingRefactorings = new HashSet<Refactoring>();
        boolean renameFound = false;
        for (Refactoring refactoring : refactorings) {
            RemoveAttributeAnnotationRefactoring removeAnnotation;
            if (refactoring instanceof RenameAttributeRefactoring) {
                RenameAttributeRefactoring rename = (RenameAttributeRefactoring)refactoring;
                if (!a1.equals(rename.getOriginalAttribute().getVariableDeclaration()) && !a2.equals(rename.getRenamedAttribute().getVariableDeclaration())) continue;
                matchingRefactorings.add(rename);
                renameFound = true;
                continue;
            }
            if (refactoring instanceof ChangeAttributeTypeRefactoring) {
                ChangeAttributeTypeRefactoring changeType = (ChangeAttributeTypeRefactoring)refactoring;
                if (!a1.equals(changeType.getOriginalAttribute().getVariableDeclaration()) && !a2.equals(changeType.getChangedTypeAttribute().getVariableDeclaration())) continue;
                matchingRefactorings.add(changeType);
                continue;
            }
            if (refactoring instanceof ChangeAttributeAccessModifierRefactoring) {
                ChangeAttributeAccessModifierRefactoring changeAccessModifer = (ChangeAttributeAccessModifierRefactoring)refactoring;
                if (!a1.equals(changeAccessModifer.getAttributeBefore().getVariableDeclaration()) && !a2.equals(changeAccessModifer.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(changeAccessModifer);
                continue;
            }
            if (refactoring instanceof AddAttributeModifierRefactoring) {
                AddAttributeModifierRefactoring addModifer = (AddAttributeModifierRefactoring)refactoring;
                if (!a1.equals(addModifer.getAttributeBefore().getVariableDeclaration()) && !a2.equals(addModifer.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(addModifer);
                continue;
            }
            if (refactoring instanceof RemoveAttributeModifierRefactoring) {
                RemoveAttributeModifierRefactoring removeModifer = (RemoveAttributeModifierRefactoring)refactoring;
                if (!a1.equals(removeModifer.getAttributeBefore().getVariableDeclaration()) && !a2.equals(removeModifer.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(removeModifer);
                continue;
            }
            if (refactoring instanceof AddAttributeAnnotationRefactoring) {
                AddAttributeAnnotationRefactoring addAnnotation = (AddAttributeAnnotationRefactoring)refactoring;
                if (!a1.equals(addAnnotation.getAttributeBefore().getVariableDeclaration()) && !a2.equals(addAnnotation.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(addAnnotation);
                continue;
            }
            if (!(refactoring instanceof RemoveAttributeAnnotationRefactoring) || !a1.equals((removeAnnotation = (RemoveAttributeAnnotationRefactoring)refactoring).getAttributeBefore().getVariableDeclaration()) && !a2.equals(removeAnnotation.getAttributeAfter().getVariableDeclaration())) continue;
            matchingRefactorings.add(removeAnnotation);
        }
        if (renameFound) {
            return matchingRefactorings;
        }
        return Collections.emptySet();
    }

    private Set<Refactoring> attributeRenamed(Set<VariableDeclaration> mergedAttributes, VariableDeclaration a2, Set<Refactoring> refactorings) {
        HashSet<Refactoring> matchingRefactorings = new HashSet<Refactoring>();
        boolean renameFound = false;
        for (Refactoring refactoring : refactorings) {
            RemoveAttributeAnnotationRefactoring removeAnnotation;
            if (refactoring instanceof RenameAttributeRefactoring) {
                RenameAttributeRefactoring rename = (RenameAttributeRefactoring)refactoring;
                if (!mergedAttributes.contains(rename.getOriginalAttribute().getVariableDeclaration()) || !a2.equals(rename.getRenamedAttribute().getVariableDeclaration())) continue;
                matchingRefactorings.add(rename);
                renameFound = true;
                continue;
            }
            if (refactoring instanceof ChangeAttributeTypeRefactoring) {
                ChangeAttributeTypeRefactoring changeType = (ChangeAttributeTypeRefactoring)refactoring;
                if (!mergedAttributes.contains(changeType.getOriginalAttribute().getVariableDeclaration()) || !a2.equals(changeType.getChangedTypeAttribute().getVariableDeclaration())) continue;
                matchingRefactorings.add(changeType);
                continue;
            }
            if (refactoring instanceof ChangeAttributeAccessModifierRefactoring) {
                ChangeAttributeAccessModifierRefactoring changeAccessModifer = (ChangeAttributeAccessModifierRefactoring)refactoring;
                if (!mergedAttributes.contains(changeAccessModifer.getAttributeBefore().getVariableDeclaration()) || !a2.equals(changeAccessModifer.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(changeAccessModifer);
                continue;
            }
            if (refactoring instanceof AddAttributeModifierRefactoring) {
                AddAttributeModifierRefactoring addModifer = (AddAttributeModifierRefactoring)refactoring;
                if (!mergedAttributes.contains(addModifer.getAttributeBefore().getVariableDeclaration()) || !a2.equals(addModifer.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(addModifer);
                continue;
            }
            if (refactoring instanceof RemoveAttributeModifierRefactoring) {
                RemoveAttributeModifierRefactoring removeModifer = (RemoveAttributeModifierRefactoring)refactoring;
                if (!mergedAttributes.contains(removeModifer.getAttributeBefore().getVariableDeclaration()) || !a2.equals(removeModifer.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(removeModifer);
                continue;
            }
            if (refactoring instanceof AddAttributeAnnotationRefactoring) {
                AddAttributeAnnotationRefactoring addAnnotation = (AddAttributeAnnotationRefactoring)refactoring;
                if (!mergedAttributes.contains(addAnnotation.getAttributeBefore().getVariableDeclaration()) || !a2.equals(addAnnotation.getAttributeAfter().getVariableDeclaration())) continue;
                matchingRefactorings.add(addAnnotation);
                continue;
            }
            if (!(refactoring instanceof RemoveAttributeAnnotationRefactoring) || !mergedAttributes.contains((removeAnnotation = (RemoveAttributeAnnotationRefactoring)refactoring).getAttributeBefore().getVariableDeclaration()) || !a2.equals(removeAnnotation.getAttributeAfter().getVariableDeclaration())) continue;
            matchingRefactorings.add(removeAnnotation);
        }
        if (renameFound) {
            return matchingRefactorings;
        }
        return Collections.emptySet();
    }

    private void deleteRemovedOperation(UMLOperation operation) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(operation.getClassName());
        if (classDiff != null) {
            classDiff.getRemovedOperations().remove(operation);
        }
    }

    private void deleteAddedOperation(UMLOperation operation) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(operation.getClassName());
        if (classDiff != null) {
            classDiff.getAddedOperations().remove(operation);
        }
    }
}

