/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLRealization;

public class UMLRealizationDiff
implements Comparable<UMLRealizationDiff> {
    private UMLRealization removedRealization;
    private UMLRealization addedRealization;
    private boolean parentChanged;
    private boolean childChanged;

    public UMLRealizationDiff(UMLRealization removedRealization, UMLRealization addedRealization) {
        this.removedRealization = removedRealization;
        this.addedRealization = addedRealization;
        this.parentChanged = false;
        this.childChanged = false;
        if (!removedRealization.getSupplier().equals(addedRealization.getSupplier())) {
            this.parentChanged = true;
        }
        if (!removedRealization.getClient().equals(addedRealization.getClient())) {
            this.childChanged = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parentChanged || this.childChanged) {
            sb.append("realization ").append(this.removedRealization).append(":").append("\n");
        }
        if (this.childChanged) {
            sb.append("\t").append("child changed from " + this.removedRealization.getClient() + " to " + this.addedRealization.getClient()).append("\n");
        }
        if (this.parentChanged) {
            sb.append("\t").append("parent changed from " + this.removedRealization.getSupplier() + " to " + this.addedRealization.getSupplier()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(UMLRealizationDiff generalizationDiff) {
        int compare = this.removedRealization.compareTo(generalizationDiff.removedRealization);
        if (compare == 0) {
            return this.addedRealization.compareTo(generalizationDiff.addedRealization);
        }
        return compare;
    }
}

