/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLTypeParameter;
import java.util.Objects;

public class UMLTypeParameterDiff {
    private UMLTypeParameter removedTypeParameter;
    private UMLTypeParameter addedTypeParameter;
    private boolean nameChanged;
    private boolean typeBoundsChanged;

    public UMLTypeParameterDiff(UMLTypeParameter removedTypeParameter, UMLTypeParameter addedTypeParameter) {
        this.removedTypeParameter = removedTypeParameter;
        this.addedTypeParameter = addedTypeParameter;
        if (!removedTypeParameter.getName().equals(addedTypeParameter.getName())) {
            this.nameChanged = true;
        }
        if (!removedTypeParameter.getTypeBounds().equals(addedTypeParameter.getTypeBounds())) {
            this.typeBoundsChanged = true;
        }
    }

    public UMLTypeParameter getRemovedTypeParameter() {
        return this.removedTypeParameter;
    }

    public UMLTypeParameter getAddedTypeParameter() {
        return this.addedTypeParameter;
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public boolean isTypeBoundsChanged() {
        return this.typeBoundsChanged;
    }

    public boolean isEmpty() {
        return !this.nameChanged && !this.typeBoundsChanged;
    }

    public int hashCode() {
        return Objects.hash(this.addedTypeParameter, this.removedTypeParameter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLTypeParameterDiff other = (UMLTypeParameterDiff)obj;
        return Objects.equals(this.addedTypeParameter, other.addedTypeParameter) && Objects.equals(this.removedTypeParameter, other.removedTypeParameter);
    }

    public String toString() {
        return this.removedTypeParameter + "\t->\t" + this.addedTypeParameter;
    }
}

