/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLTypeParameter;
import gr.uom.java.xmi.diff.UMLTypeParameterDiff;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class UMLTypeParameterListDiff {
    private Set<UMLTypeParameter> removedTypeParameters = new LinkedHashSet<UMLTypeParameter>();
    private Set<UMLTypeParameter> addedTypeParameters = new LinkedHashSet<UMLTypeParameter>();
    private Set<UMLTypeParameterDiff> typeParameterDiffs = new LinkedHashSet<UMLTypeParameterDiff>();
    private Set<Pair<UMLTypeParameter, UMLTypeParameter>> commonTypeParameters = new LinkedHashSet<Pair<UMLTypeParameter, UMLTypeParameter>>();

    public UMLTypeParameterListDiff(List<UMLTypeParameter> typeParameters1, List<UMLTypeParameter> typeParameters2) {
        boolean found;
        LinkedHashSet<Pair> matchedTypeParameters = new LinkedHashSet<Pair>();
        for (UMLTypeParameter typeParameter1 : typeParameters1) {
            found = false;
            for (UMLTypeParameter typeParameter2 : typeParameters2) {
                if (!typeParameter1.equals(typeParameter2)) continue;
                matchedTypeParameters.add(Pair.of((Object)typeParameter1, (Object)typeParameter2));
                found = true;
                break;
            }
            if (!found) {
                for (UMLTypeParameter typeParameter2 : typeParameters2) {
                    if (!typeParameter1.getName().equals(typeParameter2.getName())) continue;
                    matchedTypeParameters.add(Pair.of((Object)typeParameter1, (Object)typeParameter2));
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.removedTypeParameters.add(typeParameter1);
        }
        for (UMLTypeParameter typeParameter2 : typeParameters2) {
            found = false;
            for (UMLTypeParameter typeParameter1 : typeParameters1) {
                if (!typeParameter1.equals(typeParameter2)) continue;
                matchedTypeParameters.add(Pair.of((Object)typeParameter1, (Object)typeParameter2));
                found = true;
                break;
            }
            if (!found) {
                for (UMLTypeParameter typeParameter1 : typeParameters1) {
                    if (!typeParameter1.getName().equals(typeParameter2.getName())) continue;
                    matchedTypeParameters.add(Pair.of((Object)typeParameter1, (Object)typeParameter2));
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.addedTypeParameters.add(typeParameter2);
        }
        for (Pair pair : matchedTypeParameters) {
            UMLTypeParameterDiff typeParameterDiff = new UMLTypeParameterDiff((UMLTypeParameter)pair.getLeft(), (UMLTypeParameter)pair.getRight());
            if (!typeParameterDiff.isEmpty() && !this.typeParameterDiffs.contains(typeParameterDiff)) {
                this.typeParameterDiffs.add(typeParameterDiff);
                continue;
            }
            if (this.commonTypeParameters.contains(pair)) continue;
            this.commonTypeParameters.add((Pair<UMLTypeParameter, UMLTypeParameter>)pair);
        }
        if (this.removedTypeParameters.size() == this.addedTypeParameters.size()) {
            Iterator<UMLTypeParameter> removedTypeParameterIterator = this.removedTypeParameters.iterator();
            Iterator<UMLTypeParameter> addedTypeParameterIterator = this.addedTypeParameters.iterator();
            while (removedTypeParameterIterator.hasNext() && addedTypeParameterIterator.hasNext()) {
                UMLTypeParameter removedTypeParameter = removedTypeParameterIterator.next();
                UMLTypeParameter addedTypeParameter = addedTypeParameterIterator.next();
                UMLTypeParameterDiff typeParameterDiff = new UMLTypeParameterDiff(removedTypeParameter, addedTypeParameter);
                this.typeParameterDiffs.add(typeParameterDiff);
                removedTypeParameterIterator.remove();
                addedTypeParameterIterator.remove();
            }
        }
    }

    public boolean isEmpty() {
        return this.removedTypeParameters.isEmpty() && this.addedTypeParameters.isEmpty() && this.typeParameterDiffs.isEmpty();
    }

    public Set<UMLTypeParameter> getRemovedTypeParameters() {
        return this.removedTypeParameters;
    }

    public Set<UMLTypeParameter> getAddedTypeParameters() {
        return this.addedTypeParameters;
    }

    public Set<UMLTypeParameterDiff> getTypeParameterDiffs() {
        return this.typeParameterDiffs;
    }

    public Set<Pair<UMLTypeParameter, UMLTypeParameter>> getCommonTypeParameters() {
        return this.commonTypeParameters;
    }
}

