/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.List;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.Requester;

public class GHRepositoryWrapper {
    private final GHRepository ghRepository;

    public GHRepositoryWrapper(GHRepository ghRepository) {
        this.ghRepository = ghRepository;
    }

    public GHCommit getCommit(String sha1, List<GHCommit.File> files) throws IOException {
        String[] link;
        String[] links;
        String linkHeaderField;
        GitHubResponse<GHCommit> ghCommitGitHubResponse = this.getGhCommitGitHubResponse(String.format("/repos/%s/%s/commits/%s", this.ghRepository.getOwnerName(), this.ghRepository.getName(), sha1));
        GHCommit ghCommit = ((GHCommit)ghCommitGitHubResponse.body()).wrapUp(this.ghRepository);
        files.addAll(ghCommit.getFiles());
        if (ghCommitGitHubResponse.headers().containsKey("Link") && (linkHeaderField = ghCommitGitHubResponse.headerField("Link")) != null && (links = linkHeaderField.split(",")).length == 2 && (link = links[1].split(";")).length == 2) {
            Object url = link[0];
            String[] urlParts = ((String)(url = ((String)url).replaceFirst("<", "").replaceFirst(">", ""))).split("=");
            if (urlParts.length == 2) {
                url = urlParts[0] + "=";
                url = ((String)url).trim();
                int lastPage = Integer.valueOf(urlParts[1]);
                for (int page = 2; page <= lastPage; ++page) {
                    files.addAll(((GHCommit)this.getGhCommitGitHubResponse((String)url + page).body()).getFiles());
                }
            }
        }
        return ghCommit;
    }

    private GitHubResponse<GHCommit> getGhCommitGitHubResponse(String url) throws IOException {
        Requester requester = (Requester)this.ghRepository.root().createRequest().withUrlPath(url, new String[0]);
        GitHubResponse ghCommitGitHubResponse = requester.client.sendRequest((GitHubRequest.Builder)requester, responseInfo -> (GHCommit)GitHubResponse.parseBody((GitHubResponse.ResponseInfo)responseInfo, GHCommit.class));
        return ghCommitGitHubResponse;
    }
}

