/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.actions;

import com.github.gumtreediff.actions.Diff;
import com.github.gumtreediff.actions.EditScript;
import com.github.gumtreediff.actions.TreeClassifier;
import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.refactoringminer.astDiff.actions.ExtendedOnlyRootsClassifier;
import org.refactoringminer.astDiff.actions.MultiMoveActionGenerator;
import org.refactoringminer.astDiff.actions.SimplifiedChawatheScriptGenerator;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;

public class ASTDiff
extends Diff {
    private String srcPath;
    private String dstPath;
    private ExtendedMultiMappingStore mappings;
    private ExtendedOnlyRootsClassifier classifier;

    public ASTDiff(String srcPath, String dstPath, TreeContext src, TreeContext dst, ExtendedMultiMappingStore mappings) {
        super(src, dst, new MappingStore(src.getRoot(), dst.getRoot()), new EditScript());
        this.srcPath = srcPath;
        this.dstPath = dstPath;
        this.mappings = mappings;
    }

    @Deprecated(forRemoval=true)
    public ExtendedMultiMappingStore getMappings() {
        return this.getAllMappings();
    }

    public ExtendedMultiMappingStore getAllMappings() {
        return this.mappings;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public String getDstPath() {
        return this.dstPath;
    }

    public Set<Tree> getDeletedSrcTrees() {
        return this.classifier.getDeletedSrcs();
    }

    public Set<Tree> getAddedDstTrees() {
        return this.classifier.getInsertedDsts();
    }

    public void computeEditScript(Map<String, TreeContext> parentContextMap, Map<String, TreeContext> childContextMap) {
        EditScript newEditScript = new SimplifiedChawatheScriptGenerator().computeActions(this.mappings, parentContextMap, childContextMap);
        ASTDiff.processMultiMappings(this.mappings, newEditScript);
        for (Action action : newEditScript) {
            this.editScript.add(action);
        }
        this.classifier = new ExtendedOnlyRootsClassifier(this);
        this.classifier.classify();
    }

    private static void processMultiMappings(ExtendedMultiMappingStore mappings, EditScript editScript) {
        Map<Tree, Set<Tree>> dstToSrcMultis = mappings.dstToSrcMultis();
        MultiMoveActionGenerator multiMoveActionGenerator = new MultiMoveActionGenerator();
        for (Map.Entry<Tree, Set<Tree>> entry : dstToSrcMultis.entrySet()) {
            Set<Tree> srcTrees = entry.getValue();
            Set dstTrees = mappings.getDsts(srcTrees.iterator().next());
            multiMoveActionGenerator.addMapping(srcTrees, dstTrees);
        }
        for (Action action : multiMoveActionGenerator.generate()) {
            editScript.add(action);
        }
    }

    public TreeClassifier createRootNodesClassifier() {
        return this.classifier;
    }

    public int hashCode() {
        return Objects.hash(this.dstPath, this.srcPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ASTDiff other = (ASTDiff)((Object)obj);
        return Objects.equals(this.dstPath, other.dstPath) && Objects.equals(this.srcPath, other.srcPath);
    }
}

