/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.actions;

import com.github.gumtreediff.actions.EditScript;
import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.actions.model.Delete;
import com.github.gumtreediff.actions.model.Insert;
import com.github.gumtreediff.actions.model.Move;
import com.github.gumtreediff.actions.model.Update;
import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.tree.FakeTree;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import com.github.gumtreediff.tree.TreeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.refactoringminer.astDiff.actions.EditScriptGenerator;
import org.refactoringminer.astDiff.actions.model.MoveIn;
import org.refactoringminer.astDiff.actions.model.MoveOut;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class ChawatheScriptGenerator
implements EditScriptGenerator {
    private Tree origSrc;
    private Tree cpySrc;
    private Tree origDst;
    private MappingStore origMappings;
    private MappingStore cpyMappings;
    private Set<Tree> dstInOrder;
    private Set<Tree> srcInOrder;
    private EditScript actions;
    private Map<Tree, Tree> origToCopy;
    private Map<Tree, Tree> copyToOrig;
    private ExtendedMultiMappingStore multiMappingStore;
    private Map<String, TreeContext> childContextMap;
    private Map<String, TreeContext> parentContextMap;

    @Override
    public EditScript computeActions(ExtendedMultiMappingStore ms, Map<String, TreeContext> parentContextMap, Map<String, TreeContext> childContextMap) {
        this.parentContextMap = parentContextMap;
        this.childContextMap = childContextMap;
        this.multiMappingStore = ms;
        this.initWith(ms.getMonoMappingStore());
        this.generate();
        return this.actions;
    }

    public void initWith(MappingStore ms) {
        this.origSrc = ms.src;
        this.cpySrc = this.origSrc.deepCopy();
        this.origDst = ms.dst;
        this.origMappings = ms;
        this.origToCopy = new HashMap<Tree, Tree>();
        this.copyToOrig = new HashMap<Tree, Tree>();
        Iterator cpyTreeIterator = TreeUtils.preOrderIterator((Tree)this.cpySrc);
        for (Tree origTree : TreeUtils.preOrder((Tree)this.origSrc)) {
            Tree cpyTree = (Tree)cpyTreeIterator.next();
            this.origToCopy.put(origTree, cpyTree);
            this.copyToOrig.put(cpyTree, origTree);
        }
        this.cpyMappings = new MappingStore(ms.src, ms.dst);
        for (Mapping m : this.origMappings) {
            this.cpyMappings.addMapping(this.origToCopy.get(m.first), (Tree)m.second);
        }
    }

    public EditScript generate() {
        FakeTree srcFakeRoot = new FakeTree(new Tree[]{this.cpySrc});
        FakeTree dstFakeRoot = new FakeTree(new Tree[]{this.origDst});
        this.cpySrc.setParent((Tree)srcFakeRoot);
        this.origDst.setParent((Tree)dstFakeRoot);
        this.actions = new EditScript();
        this.dstInOrder = new HashSet<Tree>();
        this.srcInOrder = new HashSet<Tree>();
        this.cpyMappings.addMapping((Tree)srcFakeRoot, (Tree)dstFakeRoot);
        List bfsDst = TreeUtils.breadthFirst((Tree)this.origDst);
        for (Tree x : bfsDst) {
            Tree w;
            Tree y = x.getParent();
            Tree z = this.cpyMappings.getSrcForDst(y);
            if (!this.cpyMappings.isDstMapped(x)) {
                if (this.multiMappingStore.isDstMultiMapped(x)) continue;
                int k = this.findPos(x);
                w = new FakeTree(new Tree[0]);
                Insert ins = new Insert(x, this.copyToOrig.get(z), k);
                this.actions.add((Action)ins);
                this.copyToOrig.put(w, x);
                this.cpyMappings.addMapping(w, x);
                if (z != null) {
                    z.insertChild(w, k);
                }
            } else {
                w = this.cpyMappings.getSrcForDst(x);
                if (w == null) {
                    if (!this.origMappings.getSrcForDst(x).equals(TreeUtilFunctions.getFakeTreeInstance())) {
                        TreeUtilFunctions.getFinalRoot(this.origMappings.getSrcForDst(x));
                        this.actions.add((Action)new MoveIn(this.origMappings.getSrcForDst(x), x, this.findNameByTree(this.parentContextMap, this.origMappings.getSrcForDst(x)), 1));
                    }
                } else if (!x.equals(this.origDst)) {
                    Tree v = w.getParent();
                    if (!w.getLabel().equals(x.getLabel())) {
                        this.actions.add((Action)new Update(this.copyToOrig.get(w), x.getLabel()));
                        w.setLabel(x.getLabel());
                    }
                    if (z != null) {
                        if (!z.equals(v)) {
                            int k = this.findPos(x);
                            mv = new Move(this.copyToOrig.get(w), this.copyToOrig.get(z), k);
                            this.actions.add((Action)mv);
                            int oldk = w.positionInParent();
                            w.getParent().getChildren().remove(oldk);
                            z.insertChild(w, k);
                        }
                    } else if (this.multiMappingStore.isDstMultiMapped(y)) {
                        int k = this.findPos(x);
                        mv = new Move(this.copyToOrig.get(w), null, k);
                        this.actions.add((Action)mv);
                    }
                }
            }
            if (w == null) continue;
            this.srcInOrder.add(w);
            this.dstInOrder.add(x);
            this.alignChildren(w, x);
        }
        for (Tree w : this.cpySrc.postOrder()) {
            if (!this.cpyMappings.isSrcMapped(w) && !this.multiMappingStore.isSrcMultiMapped(this.copyToOrig.get(w))) {
                this.actions.add((Action)new Delete(this.copyToOrig.get(w)));
                continue;
            }
            if (this.multiMappingStore.isSrcMultiMapped(this.copyToOrig.get(w)) || this.cpyMappings.getDstForSrc(w).equals(TreeUtilFunctions.getFakeTreeInstance()) || TreeUtilFunctions.getFinalRoot(this.cpyMappings.getDstForSrc(w)).equals(this.origDst)) continue;
            Tree a = this.cpyMappings.getDstForSrc(w);
            this.actions.add((Action)new MoveOut(this.copyToOrig.get(w), this.cpyMappings.getDstForSrc(w), this.findNameByTree(this.childContextMap, a), 1));
        }
        return this.actions;
    }

    private void alignChildren(Tree w, Tree x) {
        this.srcInOrder.removeAll(w.getChildren());
        this.dstInOrder.removeAll(x.getChildren());
        ArrayList<Tree> s1 = new ArrayList<Tree>();
        for (Object c : w.getChildren()) {
            if (!this.cpyMappings.isSrcMapped((Tree)c) || !x.getChildren().contains(this.cpyMappings.getDstForSrc((Tree)c))) continue;
            s1.add((Tree)c);
        }
        ArrayList<Tree> s2 = new ArrayList<Tree>();
        for (Tree c : x.getChildren()) {
            if (!this.cpyMappings.isDstMapped(c) || !w.getChildren().contains(this.cpyMappings.getSrcForDst(c))) continue;
            s2.add(c);
        }
        List<Mapping> lcs = this.lcs(s1, s2);
        for (Mapping m : lcs) {
            this.srcInOrder.add((Tree)m.first);
            this.dstInOrder.add((Tree)m.second);
        }
        for (Tree b : s2) {
            for (Tree a : s1) {
                if (!this.cpyMappings.has(a, b) || lcs.contains(new Mapping(a, b))) continue;
                a.getParent().getChildren().remove(a);
                int k = this.findPos(b);
                Move mv = new Move(this.copyToOrig.get(a), this.copyToOrig.get(w), k);
                this.actions.add((Action)mv);
                w.getChildren().add(k, a);
                a.setParent(w);
                this.srcInOrder.add(a);
                this.dstInOrder.add(b);
            }
        }
    }

    private int findPos(Tree x) {
        Tree y = x.getParent();
        List siblings = y.getChildren();
        for (Tree c : siblings) {
            if (!this.dstInOrder.contains(c)) continue;
            if (!c.equals(x)) break;
            return 0;
        }
        int xpos = x.positionInParent();
        Tree v = null;
        for (int i = 0; i < xpos; ++i) {
            Tree c = (Tree)siblings.get(i);
            if (!this.dstInOrder.contains(c)) continue;
            v = c;
        }
        if (v == null) {
            return 0;
        }
        Tree u = this.cpyMappings.getSrcForDst(v);
        int upos = u.positionInParent();
        return upos + 1;
    }

    private List<Mapping> lcs(List<Tree> x, List<Tree> y) {
        int j;
        int i;
        int m = x.size();
        int n = y.size();
        ArrayList<Mapping> lcs = new ArrayList<Mapping>();
        int[][] opt = new int[m + 1][n + 1];
        for (i = m - 1; i >= 0; --i) {
            for (j = n - 1; j >= 0; --j) {
                opt[i][j] = this.cpyMappings.getSrcForDst(y.get(j)).equals(x.get(i)) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < m && j < n) {
            if (this.cpyMappings.getSrcForDst(y.get(j)).equals(x.get(i))) {
                lcs.add(new Mapping(x.get(i), y.get(j)));
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
        return lcs;
    }

    public String findNameByTree(Map<String, TreeContext> contextMap, Tree t) {
        for (Map.Entry<String, TreeContext> stringTreeContextEntry : contextMap.entrySet()) {
            if (stringTreeContextEntry.getValue().getRoot() != TreeUtilFunctions.getFinalRoot(t)) continue;
            return stringTreeContextEntry.getKey();
        }
        return "";
    }
}

