/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.actions;

import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.actions.model.Delete;
import com.github.gumtreediff.actions.model.Insert;
import com.github.gumtreediff.actions.model.Move;
import com.github.gumtreediff.actions.model.TreeDelete;
import com.github.gumtreediff.actions.model.TreeInsert;
import com.github.gumtreediff.actions.model.Update;
import com.github.gumtreediff.tree.Tree;
import java.util.HashSet;
import org.refactoringminer.astDiff.actions.ASTDiff;
import org.refactoringminer.astDiff.actions.ExtendedAbstractITreeClassifier;
import org.refactoringminer.astDiff.actions.model.MoveIn;
import org.refactoringminer.astDiff.actions.model.MoveOut;
import org.refactoringminer.astDiff.actions.model.MultiMove;

public class ExtendedOnlyRootsClassifier
extends ExtendedAbstractITreeClassifier {
    public ExtendedOnlyRootsClassifier(ASTDiff diff) {
        super(diff);
    }

    @Override
    public void classify() {
        ASTDiff astDiff = (ASTDiff)this.diff;
        HashSet<Tree> insertedDsts = new HashSet<Tree>();
        for (Action a : this.diff.editScript) {
            if (!(a instanceof Insert)) continue;
            insertedDsts.add(a.getNode());
        }
        HashSet<Tree> deletedSrcs = new HashSet<Tree>();
        for (Action a : this.diff.editScript) {
            if (!(a instanceof Delete)) continue;
            deletedSrcs.add(a.getNode());
        }
        for (Action a : this.diff.editScript) {
            if (a instanceof TreeDelete) {
                this.srcDelTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Delete) {
                if (deletedSrcs.containsAll(a.getNode().getDescendants()) && deletedSrcs.contains(a.getNode().getParent())) continue;
                this.srcDelTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Insert) {
                if (insertedDsts.containsAll(a.getNode().getDescendants()) && insertedDsts.contains(a.getNode().getParent())) continue;
                this.dstAddTrees.add(a.getNode());
                continue;
            }
            if (a instanceof TreeInsert) {
                this.dstAddTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Update) {
                this.srcUpdTrees.add(a.getNode());
                this.dstUpdTrees.addAll(astDiff.getAllMappings().getDsts(a.getNode()));
                continue;
            }
            if (a instanceof Move) {
                this.srcMvTrees.add(a.getNode());
                this.dstMvTrees.addAll(astDiff.getAllMappings().getDsts(a.getNode()));
                continue;
            }
            if (a instanceof MultiMove) {
                this.srcMmTrees.put(a.getNode(), a);
                for (Tree tree : astDiff.getAllMappings().getDsts(a.getNode())) {
                    this.dstMmTrees.put(tree, a);
                }
                continue;
            }
            if (a instanceof MoveIn) {
                this.dstMoveInTreeMap.put(((MoveIn)a).getParent(), a);
                continue;
            }
            if (!(a instanceof MoveOut)) continue;
            this.srcMoveOutTreeMap.put(((MoveOut)a).getNode(), a);
        }
    }
}

