/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.actions;

import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.refactoringminer.astDiff.actions.model.MultiMove;

public class MultiMoveActionGenerator {
    private Map<Set<Tree>, Set<Tree>> fullMap;
    private Map<Tree, List<MultiMove>> actionMapSrc = new HashMap<Tree, List<MultiMove>>();
    private Map<Tree, List<MultiMove>> actionMapDst = new HashMap<Tree, List<MultiMove>>();
    ArrayList<Action> actions;
    private static int counter = 0;

    public MultiMoveActionGenerator() {
        this.fullMap = new LinkedHashMap<Set<Tree>, Set<Tree>>();
        this.actions = new ArrayList();
    }

    public ArrayList<Action> generate() {
        return this.simplify(this.actions);
    }

    private ArrayList<Action> simplify(ArrayList<Action> actions) {
        for (Tree t : this.actionMapSrc.keySet()) {
            if (this.actionMapSrc.containsKey(t.getParent()) && this.actionMapSrc.keySet().containsAll(t.getParent().getDescendants())) {
                this.removeActionsForThisTreeFromSrc(t);
                continue;
            }
            if (t.getChildren().size() > 0 && !this.actionMapSrc.keySet().containsAll(t.getDescendants())) continue;
        }
        for (Tree t : this.actionMapDst.keySet()) {
            if (this.actionMapDst.containsKey(t.getParent()) && this.actionMapDst.keySet().containsAll(t.getParent().getDescendants())) {
                this.removeActionsForThisTreeFromDst(t);
                continue;
            }
            if (t.getChildren().size() > 0 && !this.actionMapDst.keySet().containsAll(t.getDescendants())) continue;
        }
        return actions;
    }

    private void removeActionsForThisTreeFromSrc(Tree t) {
        List<MultiMove> mappedSrc = this.actionMapSrc.get(t);
        ArrayList<MultiMove> removable = new ArrayList<MultiMove>();
        boolean _flag = false;
        for (MultiMove action : mappedSrc) {
            if (action.isUpdated()) {
                _flag = true;
                break;
            }
            Tree actionSrc = action.getNode();
            Tree actionDst = action.getParent();
            if (this.actionMapSrc.containsKey(actionSrc.getParent()) && this.actionMapSrc.keySet().containsAll(actionSrc.getParent().getDescendants()) && this.actionMapDst.containsKey(actionDst.getParent()) && this.actionMapDst.keySet().containsAll(actionDst.getParent().getDescendants())) {
                removable.add(action);
                continue;
            }
            _flag = true;
            break;
        }
        if (!_flag) {
            this.actions.removeAll(removable);
        }
    }

    private void removeActionsForThisTreeFromDst(Tree t) {
        List<MultiMove> mappedDst = this.actionMapDst.get(t);
        ArrayList<MultiMove> removable = new ArrayList<MultiMove>();
        boolean _flag = false;
        for (MultiMove action : mappedDst) {
            if (action.isUpdated()) {
                _flag = true;
                break;
            }
            Tree actionSrc = action.getNode();
            Tree actionDst = action.getParent();
            if (this.actionMapSrc.containsKey(actionSrc.getParent()) && this.actionMapSrc.keySet().containsAll(actionSrc.getParent().getDescendants()) && this.actionMapDst.containsKey(actionDst.getParent()) && this.actionMapDst.keySet().containsAll(actionDst.getParent().getDescendants())) {
                removable.add(action);
                continue;
            }
            _flag = true;
            break;
        }
        if (_flag) {
            this.actions.removeAll(removable);
        }
    }

    public void addMapping(Set<Tree> srcTrees, Set<Tree> dstTrees) {
        this.fullMap.put(srcTrees, dstTrees);
        for (Tree srcTree : srcTrees) {
            if (srcTree == null) continue;
            for (Tree dstTree : dstTrees) {
                MultiMove action;
                if (dstTree == null) continue;
                boolean updated = false;
                if (srcTree.isLeaf() && dstTree.isLeaf()) {
                    boolean bl = updated = srcTree.getMetrics().hash != dstTree.getMetrics().hash;
                }
                if (this.actions.contains((Object)(action = new MultiMove(srcTree, dstTree, -1, counter + 1, updated)))) continue;
                this.actions.add((Action)action);
                if (!this.actionMapSrc.containsKey(srcTree)) {
                    this.actionMapSrc.put(srcTree, new ArrayList());
                }
                if (!this.actionMapDst.containsKey(dstTree)) {
                    this.actionMapDst.put(dstTree, new ArrayList());
                }
                this.actionMapSrc.get(srcTree).add(action);
                this.actionMapDst.get(dstTree).add(action);
            }
        }
        ++counter;
    }
}

