/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.actions;

import com.github.gumtreediff.actions.EditScript;
import com.github.gumtreediff.actions.model.Action;
import com.github.gumtreediff.actions.model.Delete;
import com.github.gumtreediff.actions.model.Insert;
import com.github.gumtreediff.actions.model.TreeDelete;
import com.github.gumtreediff.actions.model.TreeInsert;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import java.util.HashMap;
import java.util.Map;
import org.refactoringminer.astDiff.actions.ChawatheScriptGenerator;
import org.refactoringminer.astDiff.actions.EditScriptGenerator;
import org.refactoringminer.astDiff.actions.model.MoveIn;
import org.refactoringminer.astDiff.actions.model.MoveOut;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;

public class SimplifiedChawatheScriptGenerator
implements EditScriptGenerator {
    @Override
    public EditScript computeActions(ExtendedMultiMappingStore ms, Map<String, TreeContext> parentContextMap, Map<String, TreeContext> childContextMap) {
        EditScript actions = new ChawatheScriptGenerator().computeActions(ms, parentContextMap, childContextMap);
        return SimplifiedChawatheScriptGenerator.simplify(actions);
    }

    private static EditScript simplify(EditScript actions) {
        int index;
        TreeInsert ti;
        Insert originalAction;
        HashMap<Tree, Action> addedTrees = new HashMap<Tree, Action>();
        HashMap<Tree, Action> deletedTrees = new HashMap<Tree, Action>();
        HashMap<Tree, Action> MoveInTrees = new HashMap<Tree, Action>();
        HashMap<Tree, Action> MoveOutTrees = new HashMap<Tree, Action>();
        for (Action a : actions) {
            if (a instanceof Insert) {
                addedTrees.put(a.getNode(), a);
                continue;
            }
            if (a instanceof Delete) {
                deletedTrees.put(a.getNode(), a);
                continue;
            }
            if (a instanceof MoveIn) {
                MoveInTrees.put(a.getNode(), a);
                continue;
            }
            if (!(a instanceof MoveOut)) continue;
            MoveOutTrees.put(a.getNode(), a);
        }
        for (Tree t : addedTrees.keySet()) {
            if (addedTrees.containsKey(t.getParent()) && addedTrees.keySet().containsAll(t.getParent().getDescendants())) {
                actions.remove((Action)addedTrees.get(t));
                continue;
            }
            if (t.getChildren().size() <= 0 || !addedTrees.keySet().containsAll(t.getDescendants())) continue;
            originalAction = (Insert)addedTrees.get(t);
            ti = new TreeInsert(originalAction.getNode(), originalAction.getParent(), originalAction.getPosition());
            index = actions.lastIndexOf((Action)originalAction);
            actions.add(index, (Action)ti);
            actions.remove(index + 1);
        }
        for (Tree t : deletedTrees.keySet()) {
            if (deletedTrees.containsKey(t.getParent()) && deletedTrees.keySet().containsAll(t.getParent().getDescendants())) {
                actions.remove((Action)deletedTrees.get(t));
                continue;
            }
            if (t.getChildren().size() <= 0 || !deletedTrees.keySet().containsAll(t.getDescendants())) continue;
            originalAction = (Delete)deletedTrees.get(t);
            ti = new TreeDelete(originalAction.getNode());
            index = actions.lastIndexOf((Action)originalAction);
            actions.add(index, (Action)ti);
            actions.remove(index + 1);
        }
        return actions;
    }
}

