/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.utils.Pair;
import java.util.ArrayList;
import org.refactoringminer.astDiff.matchers.CustomBottomUpMatcher;
import org.refactoringminer.astDiff.matchers.CustomGreedy;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;
import org.refactoringminer.astDiff.matchers.TreeMatcher;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class BasicTreeMatcher
implements TreeMatcher {
    private int minP = 0;

    public void setMinP(int minP) {
        this.minP = minP;
    }

    public int getMinP() {
        return this.minP;
    }

    @Override
    public void match(Tree src, Tree dst, ExtendedMultiMappingStore mappingStore) {
        this.basicMatcher(src, dst, mappingStore);
    }

    private void basicMatcher(Tree src, Tree dst, ExtendedMultiMappingStore mappingStore) {
        mappingStore.add(this.process(src, dst));
    }

    public MappingStore process(Tree src, Tree dst) {
        MappingStore match = new CustomGreedy(this.minP).match(src, dst);
        CustomBottomUpMatcher customBottomUpMatcher = new CustomBottomUpMatcher();
        customBottomUpMatcher.match(src, dst, match);
        BasicTreeMatcher.optimizeMappings(match);
        return match;
    }

    private static void optimizeMappings(MappingStore match) {
        Tree dstMIR;
        Tree srcMIR;
        ArrayList<Pair> removeList = new ArrayList<Pair>();
        for (Mapping mapping : match) {
            if (!((Tree)mapping.first).getType().name.equals("MethodInvocation")) continue;
            Tree srcMethodName = TreeUtilFunctions.findChildByType((Tree)mapping.first, "SimpleName");
            Tree dstMethodName = TreeUtilFunctions.findChildByType((Tree)mapping.second, "SimpleName");
            if (srcMethodName == null || dstMethodName == null || srcMethodName.getLabel().equals(dstMethodName.getLabel())) continue;
            Tree srcMethodInvocationReceiver = TreeUtilFunctions.findChildByType((Tree)mapping.first, "METHOD_INVOCATION_RECEIVER");
            Tree dstMethodInvocationReceiver = TreeUtilFunctions.findChildByType((Tree)mapping.second, "METHOD_INVOCATION_RECEIVER");
            if ((srcMethodInvocationReceiver != null || dstMethodInvocationReceiver == null) && (srcMethodInvocationReceiver == null || dstMethodInvocationReceiver != null)) continue;
            Tree srcMethodInvocationArguments = TreeUtilFunctions.findChildByType((Tree)mapping.first, "METHOD_INVOCATION_ARGUMENTS");
            Tree dstMethodInvocationArguments = TreeUtilFunctions.findChildByType((Tree)mapping.second, "METHOD_INVOCATION_ARGUMENTS");
            boolean _notEmptyIsoStructuralArguments = false;
            if (srcMethodInvocationArguments != null && dstMethodInvocationArguments != null) {
                _notEmptyIsoStructuralArguments = srcMethodInvocationArguments.isIsoStructuralTo(dstMethodInvocationArguments);
            }
            if (_notEmptyIsoStructuralArguments) continue;
            removeList.add(new Pair((Object)((Tree)mapping.first), (Object)((Tree)mapping.second)));
            removeList.add(new Pair((Object)srcMethodName, (Object)dstMethodName));
        }
        for (Pair treeTreePair : removeList) {
            if (match.getDstForSrc((Tree)treeTreePair.first) == null || !match.getDstForSrc((Tree)treeTreePair.first).equals(treeTreePair.second)) continue;
            match.removeMapping((Tree)treeTreePair.first, (Tree)treeTreePair.second);
        }
        ArrayList<Pair> addList = new ArrayList<Pair>();
        for (Mapping mapping : match) {
            if (!((Tree)mapping.first).getType().name.equals("SimpleName") || !((Tree)mapping.first).getParent().getType().name.equals("MethodInvocation") || !((Tree)mapping.second).getParent().getType().name.equals("MethodInvocation") || match.getDstForSrc(((Tree)mapping.first).getParent()) == ((Tree)mapping.second).getParent()) continue;
            addList.add(new Pair((Object)((Tree)mapping.first).getParent(), (Object)((Tree)mapping.second).getParent()));
        }
        for (Pair treeTreePair : addList) {
            match.removeMapping((Tree)treeTreePair.first, match.getSrcForDst((Tree)treeTreePair.first));
            match.removeMapping(match.getSrcForDst((Tree)treeTreePair.second), (Tree)treeTreePair.second);
            srcMIR = TreeUtilFunctions.findChildByType((Tree)treeTreePair.first, "METHOD_INVOCATION_RECEIVER");
            dstMIR = TreeUtilFunctions.findChildByType((Tree)treeTreePair.second, "METHOD_INVOCATION_RECEIVER");
            if (match.isSrcMapped(srcMIR)) {
                match.removeMapping(srcMIR, match.getDstForSrc(srcMIR));
            }
            if (!match.isDstMapped(dstMIR)) continue;
            match.removeMapping(match.getSrcForDst(dstMIR), dstMIR);
        }
        for (Pair treeTreePair : addList) {
            match.addMapping((Tree)treeTreePair.first, (Tree)treeTreePair.second);
            srcMIR = TreeUtilFunctions.findChildByType((Tree)treeTreePair.first, "METHOD_INVOCATION_RECEIVER");
            dstMIR = TreeUtilFunctions.findChildByType((Tree)treeTreePair.second, "METHOD_INVOCATION_RECEIVER");
            if (srcMIR == null || dstMIR == null) continue;
            match.addMapping(srcMIR, dstMIR);
        }
    }
}

