/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.tree.DefaultTree;
import com.github.gumtreediff.tree.Tree;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObjectMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.refactoringminer.astDiff.matchers.BasicTreeMatcher;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;
import org.refactoringminer.astDiff.matchers.TreeMatcher;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class CompositeMatcher
extends BasicTreeMatcher
implements TreeMatcher {
    private final CompositeStatementObject fragment1;
    private final CompositeStatementObject fragment2;

    public CompositeMatcher(AbstractCodeMapping abstractCodeMapping) {
        CompositeStatementObjectMapping compositeStatementObjectMapping = (CompositeStatementObjectMapping)abstractCodeMapping;
        this.fragment1 = (CompositeStatementObject)compositeStatementObjectMapping.getFragment1();
        this.fragment2 = (CompositeStatementObject)compositeStatementObjectMapping.getFragment2();
    }

    public CompositeMatcher(CompositeStatementObject fragment1, CompositeStatementObject fragment2) {
        this.fragment1 = fragment1;
        this.fragment2 = fragment2;
    }

    @Override
    public void match(Tree src, Tree dst, ExtendedMultiMappingStore mappingStore) {
        String labeled = "LabeledStatement";
        if (src.getType().name.equals(labeled) && dst.getType().name.equals(labeled)) {
            mappingStore.addMapping(src.getChild(0), dst.getChild(0));
        } else {
            this.process(src, dst, mappingStore);
        }
    }

    private void process(Tree src, Tree dst, ExtendedMultiMappingStore mappingStore) {
        HashMap<Tree, Tree> cpyToSrc = new HashMap<Tree, Tree>();
        HashMap<Tree, Tree> cpyToDst = new HashMap<Tree, Tree>();
        Tree srcFakeTree = this.makeFakeTree(src, this.fragment1, cpyToSrc);
        Tree dstFakeTree = this.makeFakeTree(dst, this.fragment2, cpyToDst);
        ExtendedMultiMappingStore tempMapping = new ExtendedMultiMappingStore(null, null);
        super.match(srcFakeTree, dstFakeTree, tempMapping);
        this.postOptimizationForComposites(srcFakeTree, dstFakeTree, tempMapping);
        for (Mapping mapping : tempMapping) {
            if (mapping.first == srcFakeTree) continue;
            mappingStore.addMapping((Tree)cpyToSrc.get(mapping.first), (Tree)cpyToDst.get(mapping.second));
        }
    }

    private void postOptimizationForComposites(Tree srcFakeTree, Tree dstFakeTree, ExtendedMultiMappingStore mappingStore) {
        if (srcFakeTree.isIsoStructuralTo(dstFakeTree)) {
            return;
        }
        if (srcFakeTree.getType().name.equals("IfStatement") && dstFakeTree.getType().name.equals("IfStatement")) {
            this.findSoloMappedSimpleNameInCondition(srcFakeTree, dstFakeTree, mappingStore);
        }
    }

    private void findSoloMappedSimpleNameInCondition(Tree srcFakeTree, Tree dstFakeTree, ExtendedMultiMappingStore mappingStore) {
        ArrayList<Mapping> candidates = new ArrayList<Mapping>();
        for (Mapping mapping : mappingStore) {
            if (!((Tree)mapping.first).getType().name.equals("SimpleName")) continue;
            Tree p1 = this.getInfixParent((Tree)mapping.first);
            Tree p2 = this.getInfixParent((Tree)mapping.first);
            if (p1 == null || p2 == null) {
                return;
            }
            if (p1.getType().name.equals("SimpleName") || p2.getType().name.equals("SimpleName")) continue;
            int m1 = 0;
            int m2 = 0;
            for (Tree descendant : p1.getDescendants()) {
                if (!mappingStore.isSrcMapped(descendant)) continue;
                ++m1;
            }
            for (Tree descendant : p2.getDescendants()) {
                if (!mappingStore.isDstMapped(descendant)) continue;
                ++m2;
            }
            if (mappingStore.isSrcMapped(p1)) {
                ++m1;
            }
            if (mappingStore.isDstMapped(p2)) {
                ++m2;
            }
            if (m1 != 1 && m2 != 1) continue;
            candidates.add(mapping);
        }
        for (Mapping candidate : candidates) {
            mappingStore.removeMapping((Tree)candidate.first, (Tree)candidate.second);
        }
    }

    private Tree getInfixParent(Tree input) {
        Tree curr = input;
        while (curr.getParent() != null && !TreeUtilFunctions.isStatement(curr.getParent().getType().name)) {
            if (curr.getParent() == null) {
                return null;
            }
            if (curr.getParent().getType().name.equals("InfixExpression")) {
                return curr;
            }
            curr = curr.getParent();
        }
        return null;
    }

    private Tree makeFakeTree(Tree tree, CompositeStatementObject fragment, Map<Tree, Tree> cpyMap) {
        DefaultTree cpy = TreeUtilFunctions.makeDefaultTree(tree);
        cpyMap.put((Tree)cpy, tree);
        for (AbstractExpression abstractExpression : fragment.getExpressions()) {
            Tree expTree = TreeUtilFunctions.findByLocationInfo(tree, abstractExpression.getLocationInfo());
            Tree expCopy = TreeUtilFunctions.deepCopyWithMap(expTree, cpyMap);
            cpy.addChild(expCopy);
        }
        if (tree.getType().name.equals("ForStatement")) {
            return cpy;
        }
        for (VariableDeclaration variableDeclaration : fragment.getVariableDeclarations()) {
            Tree varTree = TreeUtilFunctions.findByLocationInfo(tree, variableDeclaration.getLocationInfo());
            Tree varCopy = TreeUtilFunctions.deepCopyWithMap(varTree, cpyMap);
            cpy.addChild(varCopy);
        }
        return cpy;
    }
}

