/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.matchers.Matcher;
import com.github.gumtreediff.matchers.SimilarityMetrics;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeUtils;
import com.github.gumtreediff.tree.Type;
import com.github.gumtreediff.utils.SequenceAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class CustomBottomUpMatcher
implements Matcher {
    public MappingStore match(Tree src, Tree dst, MappingStore mappings) {
        for (Tree t : src.postOrder()) {
            if (t.isRoot()) {
                if (t.getType().name.equals(dst.getType().name) && !mappings.isSrcMapped(t) && !mappings.isDstMapped(dst)) {
                    mappings.addMapping(t, dst);
                }
                this.lastChanceMatch(mappings, t, dst);
                break;
            }
            if (!mappings.isSrcMapped(t) && !t.isLeaf()) {
                List<Tree> candidates = this.getDstCandidates(mappings, t);
                Tree best = null;
                double max = -1.0;
                int tSize = t.getDescendants().size();
                for (Tree candidate : candidates) {
                    double threshold = 1.0 / (1.0 + Math.log(candidate.getDescendants().size() + tSize));
                    double sim = SimilarityMetrics.chawatheSimilarity((Tree)t, (Tree)candidate, (MappingStore)mappings);
                    if (!(sim > max) || !(sim >= threshold)) continue;
                    max = sim;
                    best = candidate;
                }
                if (best == null) continue;
                this.lastChanceMatch(mappings, t, best);
                boolean checkOperatorOfInfixExpression = CustomBottomUpMatcher.checkInfixExpression(mappings, t, best);
                if (!checkOperatorOfInfixExpression) continue;
                mappings.addMapping(t, best);
                continue;
            }
            if (!mappings.isSrcMapped(t) || !mappings.hasUnmappedSrcChildren(t) || !mappings.hasUnmappedDstChildren(mappings.getDstForSrc(t))) continue;
            this.lastChanceMatch(mappings, t, mappings.getDstForSrc(t));
        }
        return mappings;
    }

    private static boolean checkInfixExpression(MappingStore mappings, Tree t, Tree best) {
        boolean checkOperatorOfInfixExpression = true;
        if (t.getType().name.equals("InfixExpression")) {
            checkOperatorOfInfixExpression = false;
            Tree a = TreeUtilFunctions.findChildByType(t, "INFIX_EXPRESSION_OPERATOR");
            Tree b = TreeUtilFunctions.findChildByType(best, "INFIX_EXPRESSION_OPERATOR");
            if (mappings.getDstForSrc(a) == b) {
                checkOperatorOfInfixExpression = true;
            }
        }
        return checkOperatorOfInfixExpression;
    }

    protected List<Tree> getDstCandidates(MappingStore mappings, Tree src) {
        ArrayList<Tree> seeds = new ArrayList<Tree>();
        for (Tree c : src.getDescendants()) {
            Tree m = mappings.getDstForSrc(c);
            if (m == null) continue;
            seeds.add(m);
        }
        ArrayList<Tree> candidates = new ArrayList<Tree>();
        HashSet<Tree> visited = new HashSet<Tree>();
        for (Tree seed : seeds) {
            Tree parent;
            while (seed.getParent() != null && !visited.contains(parent = seed.getParent())) {
                visited.add(parent);
                if (parent.getType() == src.getType() && !mappings.isDstMapped(parent) && !parent.isRoot()) {
                    candidates.add(parent);
                }
                seed = parent;
            }
        }
        return candidates;
    }

    protected void lastChanceMatch(MappingStore mappings, Tree src, Tree dst) {
        this.lcsEqualMatching(mappings, src, dst);
        this.lcsStructureMatching(mappings, src, dst);
        this.histogramMatching(mappings, src, dst);
    }

    protected void lcsEqualMatching(MappingStore mappings, Tree src, Tree dst) {
        ArrayList<Object> unmappedSrcChildren = new ArrayList<Object>();
        for (Object c : src.getChildren()) {
            if (mappings.isSrcMapped((Tree)c)) continue;
            unmappedSrcChildren.add(c);
        }
        ArrayList<Tree> unmappedDstChildren = new ArrayList<Tree>();
        for (Tree c : dst.getChildren()) {
            if (mappings.isDstMapped(c)) continue;
            unmappedDstChildren.add(c);
        }
        List lcs = SequenceAlgorithms.longestCommonSubsequenceWithIsomorphism(unmappedSrcChildren, unmappedDstChildren);
        for (int[] x : lcs) {
            Tree t1 = (Tree)unmappedSrcChildren.get(x[0]);
            Tree t2 = (Tree)unmappedDstChildren.get(x[1]);
            if (!mappings.areSrcsUnmapped((Collection)TreeUtils.preOrder((Tree)t1)) || !mappings.areDstsUnmapped((Collection)TreeUtils.preOrder((Tree)t2))) continue;
            mappings.addMappingRecursively(t1, t2);
        }
    }

    protected void lcsStructureMatching(MappingStore mappings, Tree src, Tree dst) {
        ArrayList<Object> unmappedSrcChildren = new ArrayList<Object>();
        for (Object c : src.getChildren()) {
            if (mappings.isSrcMapped((Tree)c)) continue;
            unmappedSrcChildren.add(c);
        }
        ArrayList<Tree> unmappedDstChildren = new ArrayList<Tree>();
        for (Tree c : dst.getChildren()) {
            if (mappings.isDstMapped(c)) continue;
            unmappedDstChildren.add(c);
        }
        List lcs = SequenceAlgorithms.longestCommonSubsequenceWithIsostructure(unmappedSrcChildren, unmappedDstChildren);
        for (int[] x : lcs) {
            Tree t1 = (Tree)unmappedSrcChildren.get(x[0]);
            Tree t2 = (Tree)unmappedDstChildren.get(x[1]);
            if (!mappings.areSrcsUnmapped((Collection)TreeUtils.preOrder((Tree)t1)) || !mappings.areDstsUnmapped((Collection)TreeUtils.preOrder((Tree)t2))) continue;
            mappings.addMappingRecursively(t1, t2);
        }
    }

    protected void histogramMatching(MappingStore mappings, Tree src, Tree dst) {
        HashMap srcHistogram = new HashMap();
        for (Tree c : src.getChildren()) {
            if (mappings.isSrcMapped(c)) continue;
            srcHistogram.putIfAbsent(c.getType(), new ArrayList());
            ((List)srcHistogram.get(c.getType())).add(c);
        }
        HashMap dstHistogram = new HashMap();
        for (Tree c : dst.getChildren()) {
            if (mappings.isDstMapped(c)) continue;
            dstHistogram.putIfAbsent(c.getType(), new ArrayList());
            ((List)dstHistogram.get(c.getType())).add(c);
        }
        for (Type t : srcHistogram.keySet()) {
            if (!dstHistogram.containsKey(t) || ((List)srcHistogram.get(t)).size() != 1 || ((List)dstHistogram.get(t)).size() != 1) continue;
            Tree srcChild = (Tree)((List)srcHistogram.get(t)).get(0);
            Tree dstChild = (Tree)((List)dstHistogram.get(t)).get(0);
            mappings.addMapping(srcChild, dstChild);
            this.lastChanceMatch(mappings, srcChild, dstChild);
        }
    }
}

