/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.matchers.MultiMappingStore;
import com.github.gumtreediff.matchers.heuristic.gt.DefaultPriorityTreeQueue;
import com.github.gumtreediff.matchers.heuristic.gt.GreedySubtreeMatcher;
import com.github.gumtreediff.matchers.heuristic.gt.MappingComparators;
import com.github.gumtreediff.matchers.heuristic.gt.PriorityTreeQueue;
import com.github.gumtreediff.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class CustomGreedy
extends GreedySubtreeMatcher {
    public CustomGreedy(int minP) {
        this.setMinPriority(minP);
    }

    protected void retainBestMapping(List<Mapping> mappingList, Set<Tree> srcIgnored, Set<Tree> dstIgnored) {
        ArrayList<Mapping> verifiedList = new ArrayList<Mapping>();
        for (Mapping mapping : mappingList) {
            if (TreeUtilFunctions.areBothFromThisType(mapping, "SimpleName") || TreeUtilFunctions.areBothFromThisType(mapping, "QualifiedName")) {
                if (!CustomGreedy.isAcceptableMatch(mapping)) continue;
                verifiedList.add(mapping);
                continue;
            }
            verifiedList.add(mapping);
        }
        super.retainBestMapping(verifiedList, srcIgnored, dstIgnored);
    }

    private static boolean isAcceptableMatch(Mapping mapping) {
        Tree first = (Tree)mapping.first;
        Tree second = (Tree)mapping.second;
        if (CustomGreedy.isPartOfConditional(first) && CustomGreedy.isPartOfConditional(second) && !CustomGreedy.isSamePositionInConditional(first, second)) {
            return false;
        }
        if (CustomGreedy.isPartOfConditional(first) && CustomGreedy.getIndexInConditional(first) == 0 && !CustomGreedy.isPartOfConditional(second)) {
            return false;
        }
        if (CustomGreedy.isPartOfConditional(second) && CustomGreedy.getIndexInConditional(second) == 0 && !CustomGreedy.isPartOfConditional(first)) {
            return false;
        }
        return !(((Tree)mapping.first).getParent().getType().name.equals("MethodInvocation") && !((Tree)mapping.second).getParent().getType().name.equals("MethodInvocation") || ((Tree)mapping.second).getParent().getType().name.equals("MethodInvocation") && !((Tree)mapping.first).getParent().getType().name.equals("MethodInvocation"));
    }

    private static boolean isOnlyOneMethodInvocation(Tree input1, Tree input2) {
        if (input1 == null || input2 == null) {
            return false;
        }
        if (input1.getParent() == null || input2.getParent() == null) {
            return false;
        }
        if (input1.getParent().getType().name.equals("MethodInvocation") && !input2.getParent().getType().name.equals("MethodInvocation") && !input2.getParent().getType().name.equals("ExpressionMethodReference")) {
            return true;
        }
        return !input1.getParent().getType().name.equals("MethodInvocation") && !input1.getParent().getType().name.equals("ExpressionMethodReference") && input2.getParent().getType().name.equals("MethodInvocation");
    }

    private static boolean isPartOfConditional(Tree input) {
        if (input.getType().name.equals("ConditionalExpression")) {
            return true;
        }
        Tree parent = input.getParent();
        if (parent == null) {
            return false;
        }
        if (TreeUtilFunctions.isStatement(parent.getType().name)) {
            return false;
        }
        return CustomGreedy.isPartOfConditional(parent);
    }

    private static boolean isSamePositionInConditional(Tree input1, Tree input2) {
        int input2Index;
        int input1Index = CustomGreedy.getIndexInConditional(input1);
        return input1Index == (input2Index = CustomGreedy.getIndexInConditional(input2));
    }

    private static int getIndexInConditional(Tree input1) {
        int input1Index = 0;
        while (!input1.getParent().getType().name.equals("ConditionalExpression")) {
            input1 = input1.getParent();
        }
        boolean input2Index = false;
        input1Index = input1.positionInParent();
        return input1Index;
    }

    public MappingStore match(Tree src, Tree dst, MappingStore mappings) {
        this.src = src;
        this.dst = dst;
        this.mappings = mappings;
        MultiMappingStore multiMappings = new MultiMappingStore();
        DefaultPriorityTreeQueue srcTrees = new DefaultPriorityTreeQueue(src, this.minPriority, this.priorityCalculator);
        DefaultPriorityTreeQueue dstTrees = new DefaultPriorityTreeQueue(dst, this.minPriority, this.priorityCalculator);
        while (!srcTrees.isEmpty() && !dstTrees.isEmpty()) {
            PriorityTreeQueue.synchronize((PriorityTreeQueue)srcTrees, (PriorityTreeQueue)dstTrees);
            if (srcTrees.isEmpty() || dstTrees.isEmpty()) break;
            List currentPrioritySrcTrees = srcTrees.pop();
            List currentPriorityDstTrees = dstTrees.pop();
            for (Tree currentSrc : currentPrioritySrcTrees) {
                for (Tree currentDst : currentPriorityDstTrees) {
                    if (currentSrc.getMetrics().hash == currentDst.getMetrics().hash) {
                        if (!TreeUtilFunctions.isIsomorphicTo(currentSrc, currentDst) || CustomGreedy.isOnlyOneMethodInvocation(currentSrc, currentDst)) continue;
                        multiMappings.addMapping(currentSrc, currentDst);
                        continue;
                    }
                    if (!currentSrc.getLabel().equals(currentDst.getLabel())) continue;
                }
            }
            for (Tree t : currentPrioritySrcTrees) {
                if (multiMappings.hasSrc(t)) continue;
                srcTrees.open(t);
            }
            for (Tree t : currentPriorityDstTrees) {
                if (multiMappings.hasDst(t)) continue;
                dstTrees.open(t);
            }
        }
        this.filterMappings(multiMappings);
        return this.mappings;
    }

    public void filterMappings(MultiMappingStore multiMappings) {
        ArrayList<Mapping> ambiguousList = new ArrayList<Mapping>();
        HashSet ignored = new HashSet();
        for (Tree src : multiMappings.allMappedSrcs()) {
            Tree dst;
            boolean isMappingUnique = false;
            if (multiMappings.isSrcUnique(src) && multiMappings.isDstUnique(dst = (Tree)multiMappings.getDsts(src).stream().findAny().get())) {
                this.mappings.addMappingRecursively(src, dst);
                isMappingUnique = true;
            }
            if (ignored.contains(src) || isMappingUnique) continue;
            Set adsts = multiMappings.getDsts(src);
            Set asrcs = multiMappings.getSrcs((Tree)multiMappings.getDsts(src).iterator().next());
            for (Tree asrc : asrcs) {
                for (Tree adst : adsts) {
                    ambiguousList.add(new Mapping(asrc, adst));
                }
            }
            ignored.addAll(asrcs);
        }
        HashSet<Tree> srcIgnored = new HashSet<Tree>();
        HashSet<Tree> dstIgnored = new HashSet<Tree>();
        Collections.sort(ambiguousList, new ExtendedFullMappingComparator(this.mappings));
        if (ambiguousList.size() > 1) {
            this.ambiguousStringLiteralModification(ambiguousList, srcIgnored, dstIgnored);
        }
        this.retainBestMapping(ambiguousList, srcIgnored, dstIgnored);
    }

    private void ambiguousStringLiteralModification(List<Mapping> ambiguousList, Set<Tree> srcIgnored, Set<Tree> dstIgnored) {
        ArrayList<Mapping> ret = new ArrayList<Mapping>();
        for (Mapping mapping : ambiguousList) {
            int j;
            Tree asrc = (Tree)mapping.first;
            Tree adst = (Tree)mapping.second;
            if (!(asrc.getType().name.equals("StringLiteral") && adst.getType().name.equals("StringLiteral") || asrc.getType().name.equals("NumberLiteral") && adst.getType().name.equals("NumberLiteral") || asrc.getType().name.equals("PrefixExpression") && adst.getType().name.equals("PrefixExpression")) && (!asrc.getType().name.equals("BooleanLiteral") || !adst.getType().name.equals("BooleanLiteral"))) break;
            if (asrc.getParent() == null || adst.getParent() == null) continue;
            int i = asrc.positionInParent();
            if (i == (j = adst.positionInParent()) && asrc.getParent().getType().name.equals(adst.getParent().getType().name)) {
                ret.add(mapping);
                srcIgnored.add(asrc);
                dstIgnored.add(adst);
                continue;
            }
            if (i <= 0 || j <= 0) continue;
            Tree srcYoungerSibling = asrc.getParent().getChild(i - 1);
            Tree dstYoungerSibling = adst.getParent().getChild(j - 1);
            if (this.mappings.getSrcForDst(dstYoungerSibling) == null || !this.mappings.getSrcForDst(dstYoungerSibling).equals(srcYoungerSibling)) continue;
            ret.add(mapping);
            srcIgnored.add(asrc);
            dstIgnored.add(adst);
        }
    }

    public static class ExtendedFullMappingComparator
    implements Comparator<Mapping> {
        private final MappingComparators.FullMappingComparator fullMappingComparator;

        public ExtendedFullMappingComparator(MappingStore ms) {
            this.fullMappingComparator = new MappingComparators.FullMappingComparator(ms);
        }

        @Override
        public int compare(Mapping m1, Mapping m2) {
            int result = this.fullMappingComparator.compare(m1, m2);
            if (result != 0) {
                return result;
            }
            return new AbsoluteOffsetComparator().compare(m1, m2);
        }
    }

    public static class AbsoluteOffsetComparator
    implements Comparator<Mapping> {
        @Override
        public int compare(Mapping m1, Mapping m2) {
            int result = Integer.compare(((Tree)m1.first).getPos(), ((Tree)m2.first).getPos());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(((Tree)m1.second).getPos(), ((Tree)m2.second).getPos());
            return result;
        }
    }
}

