/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.matchers.MultiMappingStore;
import com.github.gumtreediff.tree.FakeTree;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.utils.Pair;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtendedMultiMappingStore
extends MultiMappingStore
implements Iterable<Mapping> {
    private final Tree src;
    private final Tree dst;

    public ExtendedMultiMappingStore(Tree srcTree, Tree dstTree) {
        this.src = srcTree;
        this.dst = dstTree;
    }

    public boolean isDstMultiMapped(Tree dstTree) {
        if (!this.hasDst(dstTree)) {
            return false;
        }
        if (this.getSrcs(dstTree) == null) {
            return false;
        }
        if (this.getSrcs(dstTree).size() > 1) {
            return true;
        }
        if (this.getSrcs(dstTree).size() == 0) {
            return false;
        }
        Tree mappedSrc = (Tree)this.getSrcs(dstTree).iterator().next();
        if (!this.hasSrc(mappedSrc)) {
            return false;
        }
        return this.getDsts(mappedSrc).size() > 1;
    }

    public boolean isSrcMultiMapped(Tree srcTree) {
        if (!this.hasSrc(srcTree)) {
            return false;
        }
        if (this.getDsts(srcTree) == null) {
            return false;
        }
        if (this.getDsts(srcTree).size() > 1) {
            return true;
        }
        if (this.getDsts(srcTree).size() == 0) {
            return false;
        }
        Tree mappedSrc = (Tree)this.getDsts(srcTree).iterator().next();
        if (!this.hasDst(mappedSrc)) {
            return false;
        }
        return this.getSrcs(mappedSrc).size() > 1;
    }

    private Map<Tree, Tree> getSrcToDstMono() {
        HashMap<Tree, Tree> monos = new HashMap<Tree, Tree>();
        for (Tree _src : this.allMappedSrcs()) {
            Tree _dst;
            Set dsts = this.getDsts(_src);
            if (dsts.size() > 1 || dsts.size() == 0 || this.getSrcs(_dst = (Tree)dsts.iterator().next()).size() > 1) continue;
            monos.put(_src, _dst);
        }
        return monos;
    }

    private Map<Tree, Tree> getDstToSrcMono() {
        HashMap<Tree, Tree> monos = new HashMap<Tree, Tree>();
        for (Tree _dst : this.allMappedDsts()) {
            Tree _src;
            if (this.getSrcs(_dst).size() > 1 || this.getDsts(_src = (Tree)this.getSrcs(_dst).iterator().next()).size() > 1) continue;
            monos.put(_dst, _src);
        }
        return monos;
    }

    public void mergeMappings(MultiMappingStore addon) {
        if (addon == null) {
            return;
        }
        for (Mapping m : addon.getMappings()) {
            this.addMapping((Tree)m.first, (Tree)m.second);
        }
    }

    public MappingStore getMonoMappingStore() {
        MappingStore monoStore = new MappingStore(this.src, this.dst);
        for (Map.Entry<Tree, Tree> entry : this.getSrcToDstMono().entrySet()) {
            monoStore.addMapping(entry.getKey(), entry.getValue());
        }
        return monoStore;
    }

    public Map<Tree, Set<Tree>> dstToSrcMultis() {
        HashMap<Tree, Set<Tree>> multis = new HashMap<Tree, Set<Tree>>();
        for (Tree _dst : this.allMappedDsts()) {
            Tree mappedSrc;
            if (this.getSrcs(_dst).size() > 1 && !(_dst instanceof FakeTree)) {
                multis.put(_dst, this.getSrcs(_dst));
                continue;
            }
            if (this.getSrcs(_dst).size() <= 0 || this.getDsts(mappedSrc = (Tree)this.getSrcs(_dst).iterator().next()).size() <= 1 || _dst instanceof FakeTree) continue;
            multis.put(_dst, this.getSrcs(_dst));
        }
        return multis;
    }

    public Map<Tree, Set<Tree>> srcToDstMultis() {
        HashMap<Tree, Set<Tree>> multis = new HashMap<Tree, Set<Tree>>();
        for (Tree _src : this.allMappedSrcs()) {
            Tree mappedSrc;
            if (this.getDsts(_src).size() > 1) {
                multis.put(_src, this.getDsts(_src));
                continue;
            }
            if (this.getDsts(_src).size() == 0 || this.getSrcs(mappedSrc = (Tree)this.getDsts(_src).iterator().next()).size() <= 1) continue;
            multis.put(_src, this.getDsts(_src));
        }
        return multis;
    }

    public void replaceMapping(Tree src, Tree dst) {
        if (this.getDsts(src) != null) {
            LinkedHashSet dstForSrcList = new LinkedHashSet(this.getDsts(src));
            for (Tree dstForSrc : dstForSrcList) {
                this.removeMapping(src, dstForSrc);
            }
        }
        if (this.getSrcs(dst) != null) {
            LinkedHashSet srcForDstList = new LinkedHashSet(this.getSrcs(dst));
            for (Tree srcForDst : srcForDstList) {
                this.removeMapping(srcForDst, dst);
            }
        }
        this.addMapping(src, dst);
    }

    public void addListOfMapping(List<Pair<Tree, Tree>> pairList) {
        if (pairList == null) {
            return;
        }
        for (Pair<Tree, Tree> pair : pairList) {
            this.addMapping((Tree)pair.first, (Tree)pair.second);
        }
    }

    public boolean isSrcMapped(Tree src) {
        return this.hasSrc(src) && this.getDsts(src) != null && this.getDsts(src).size() > 0;
    }

    public boolean isSrcMappedConsideringSubTrees(Tree src) {
        for (Tree tree : src.preOrder()) {
            if (!this.isSrcMapped(tree)) continue;
            return true;
        }
        return false;
    }

    public boolean isDstMappedConsideringSubTrees(Tree dst) {
        for (Tree tree : dst.preOrder()) {
            if (!this.isDstMapped(tree)) continue;
            return true;
        }
        return false;
    }

    public boolean isDstMapped(Tree dst) {
        return this.hasDst(dst) && this.getSrcs(dst) != null && this.getSrcs(dst).size() > 0;
    }

    public void addMappingRecursively(Tree src, Tree dst) {
        this.addMapping(src, dst);
        if (src.getChildren() != null) {
            for (int i = 0; i < src.getChildren().size(); ++i) {
                if (dst.getChildren().size() != src.getChildren().size()) continue;
                this.addMappingRecursively(src.getChild(i), dst.getChild(i));
            }
        }
    }

    public void add(MappingStore match) {
        for (Mapping mapping : match) {
            this.addMapping((Tree)mapping.first, (Tree)mapping.second);
        }
    }

    public void addWithMaps(MappingStore match, Map<Tree, Tree> srcCopy, Map<Tree, Tree> dstCopy) {
        for (Mapping mapping : match) {
            Tree realSrc = srcCopy.get(mapping.first);
            Tree realDst = dstCopy.get(mapping.second);
            if (realSrc == null || realDst == null) continue;
            this.addMapping(realSrc, realDst);
        }
    }

    public void replaceWithMaps(MappingStore match, Map<Tree, Tree> srcCopy, Map<Tree, Tree> dstCopy) {
        for (Mapping mapping : match) {
            Tree realSrc = srcCopy.get(mapping.first);
            Tree realDst = dstCopy.get(mapping.second);
            if (realSrc == null || realDst == null) continue;
            this.replaceMapping(realSrc, realDst);
        }
    }

    public void replaceWithOptimizedMappings(ExtendedMultiMappingStore optimizationMappings) {
        for (Mapping optimizationMapping : optimizationMappings) {
            Tree srcMapped = (Tree)optimizationMapping.first;
            Tree dstMapped = (Tree)optimizationMapping.second;
            if (this.getDsts(srcMapped) != null) {
                LinkedHashSet dstForSrcList = new LinkedHashSet(this.getDsts(srcMapped));
                for (Tree dstForSrc : dstForSrcList) {
                    this.removeMapping(srcMapped, dstForSrc);
                }
            }
            if (this.getSrcs(dstMapped) == null) continue;
            LinkedHashSet srcForDstList = new LinkedHashSet(this.getSrcs(dstMapped));
            for (Tree srcForDst : srcForDstList) {
                this.removeMapping(srcForDst, dstMapped);
            }
        }
        for (Mapping optimizationMapping : optimizationMappings) {
            this.addMapping((Tree)optimizationMapping.first, (Tree)optimizationMapping.second);
        }
    }
}

