/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.tree.Tree;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import org.refactoringminer.astDiff.matchers.BasicTreeMatcher;
import org.refactoringminer.astDiff.matchers.CompositeMatcher;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;
import org.refactoringminer.astDiff.matchers.LeafMatcher;
import org.refactoringminer.astDiff.matchers.TreeMatcher;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class GeneralMatcher
extends BasicTreeMatcher
implements TreeMatcher {
    AbstractCodeFragment st1;
    AbstractCodeFragment st2;

    public GeneralMatcher(AbstractCodeFragment st1, AbstractCodeFragment st2) {
        this.st1 = st1;
        this.st2 = st2;
    }

    @Override
    public void match(Tree src, Tree dst, ExtendedMultiMappingStore mappingStore) {
        if (this.st1 instanceof CompositeStatementObject && this.st2 instanceof CompositeStatementObject) {
            new CompositeMatcher((CompositeStatementObject)this.st1, (CompositeStatementObject)this.st2).match(src, dst, mappingStore);
            return;
        }
        if (!(this.st1 instanceof CompositeStatementObject) && this.st2 instanceof CompositeStatementObject) {
            CompositeStatementObject fragment2 = (CompositeStatementObject)this.st2;
            for (AbstractExpression expression : fragment2.getExpressions()) {
                Tree dstExpTree = TreeUtilFunctions.findByLocationInfo(dst, expression.getLocationInfo());
                new LeafMatcher().match(src, dstExpTree, mappingStore);
            }
        } else if (this.st1 instanceof CompositeStatementObject && !(this.st2 instanceof CompositeStatementObject)) {
            CompositeStatementObject fragment1 = (CompositeStatementObject)this.st1;
            for (AbstractExpression expression : fragment1.getExpressions()) {
                Tree srcExpTree = TreeUtilFunctions.findByLocationInfo(src, expression.getLocationInfo());
                new LeafMatcher().match(srcExpTree, dst, mappingStore);
            }
        } else {
            new LeafMatcher().match(src, dst, mappingStore);
        }
    }
}

