/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.matchers.CompositeMatchers;
import com.github.gumtreediff.matchers.MappingStore;
import com.github.gumtreediff.matchers.Matcher;
import com.github.gumtreediff.matchers.optimizations.CrossMoveMatcherThetaF;
import com.github.gumtreediff.matchers.optimizations.InnerNodesMatcherThetaD;
import com.github.gumtreediff.matchers.optimizations.LcsOptMatcherThetaB;
import com.github.gumtreediff.matchers.optimizations.LeafMoveMatcherThetaE;
import com.github.gumtreediff.matchers.optimizations.UnmappedLeavesMatcherThetaC;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.utils.Pair;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import java.util.HashMap;
import java.util.Map;
import org.refactoringminer.astDiff.matchers.BasicTreeMatcher;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;
import org.refactoringminer.astDiff.matchers.TreeMatcher;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class LeafMatcher
extends BasicTreeMatcher
implements TreeMatcher {
    private boolean overwrite = false;

    public LeafMatcher setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    @Override
    public void match(Tree src, Tree dst, ExtendedMultiMappingStore mappingStore) {
        if (src == null || dst == null) {
            return;
        }
        HashMap<Tree, Tree> srcCopy = new HashMap<Tree, Tree>();
        HashMap<Tree, Tree> dstCopy = new HashMap<Tree, Tree>();
        Pair<Tree, Tree> prunedPair = this.pruneTrees(src, dst, srcCopy, dstCopy);
        try {
            MappingStore match;
            if (((Tree)prunedPair.first).isIsoStructuralTo((Tree)prunedPair.second)) {
                if (!TreeUtilFunctions.isIsomorphicTo((Tree)prunedPair.first, (Tree)prunedPair.second)) {
                    match = new MoveOptimizedIsomorphic().match((Tree)prunedPair.first, (Tree)prunedPair.second);
                } else {
                    match = new MappingStore(src, dst);
                    match.addMappingRecursively((Tree)prunedPair.first, (Tree)prunedPair.second);
                }
            } else {
                match = this.process((Tree)prunedPair.first, (Tree)prunedPair.second);
            }
            if (!this.overwrite) {
                mappingStore.addWithMaps(match, srcCopy, dstCopy);
            } else {
                mappingStore.replaceWithMaps(match, srcCopy, dstCopy);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public Pair<Tree, Tree> pruneTrees(Tree src, Tree dst, Map<Tree, Tree> srcCopy, Map<Tree, Tree> dstCopy) {
        Tree prunedSrc = TreeUtilFunctions.deepCopyWithMapPruning(src, srcCopy);
        Tree prunedDst = TreeUtilFunctions.deepCopyWithMapPruning(dst, dstCopy);
        return new Pair((Object)prunedSrc, (Object)prunedDst);
    }

    private void specialCases(Tree src, Tree dst, AbstractCodeMapping abstractCodeMapping, ExtendedMultiMappingStore mappingStore) {
        boolean expFirst;
        Tree varTree;
        Tree expTree;
        String EXP_STATEMENT = "ExpressionStatement";
        String VAR_DEC_STATEMENT = "VariableDeclarationStatement";
        Tree assignment_operator = null;
        Tree varFrag = null;
        Tree assignment = null;
        if (src.getType().name.equals(EXP_STATEMENT) && dst.getType().name.equals(VAR_DEC_STATEMENT)) {
            expTree = src;
            varTree = dst;
            expFirst = true;
            if (varTree.getChildren().size() > 1) {
                varFrag = varTree.getChild(1);
            }
            if (expTree.getChildren().size() > 0 && expTree.getChild((int)0).getType().name.equals("Assignment")) {
                assignment = expTree.getChild(0);
                for (Tree child : assignment.getChildren()) {
                    if (!child.getType().name.equals("ASSIGNMENT_OPERATOR") || !child.getLabel().equals("=")) continue;
                    assignment_operator = child;
                    break;
                }
            }
        } else if (src.getType().name.equals(VAR_DEC_STATEMENT) && dst.getType().name.equals(EXP_STATEMENT)) {
            expTree = dst;
            varTree = src;
            expFirst = false;
            if (varTree.getChildren().size() > 1) {
                varFrag = varTree.getChild(1);
            }
            if (expTree.getChildren().size() > 0 && expTree.getChild((int)0).getType().name.equals("Assignment")) {
                assignment = expTree.getChild(0);
                for (Tree child : assignment.getChildren()) {
                    if (!child.getType().name.equals("ASSIGNMENT_OPERATOR") || !child.getLabel().equals("=")) continue;
                    assignment_operator = child;
                    break;
                }
            }
        } else {
            return;
        }
        if (expFirst) {
            mappingStore.addMapping(assignment, varFrag);
            mappingStore.addMapping(expTree, varTree);
            mappingStore.addMapping(assignment_operator, (Tree)TreeUtilFunctions.getFakeTreeInstance());
        } else {
            mappingStore.addMapping(varFrag, assignment);
            mappingStore.addMapping(varTree, expTree);
            mappingStore.addMapping((Tree)TreeUtilFunctions.getFakeTreeInstance(), assignment_operator);
        }
    }

    static class MoveOptimizedIsomorphic
    extends CompositeMatchers.CompositeMatcher {
        public MoveOptimizedIsomorphic() {
            super(new Matcher[]{(src, dst, mappings) -> {
                if (TreeUtilFunctions.isIsomorphicTo(src, dst)) {
                    mappings.addMappingRecursively(src, dst);
                }
                return mappings;
            }, new LcsOptMatcherThetaB(), new UnmappedLeavesMatcherThetaC(), new InnerNodesMatcherThetaD(), new LeafMoveMatcherThetaE(), new CrossMoveMatcherThetaF()});
        }
    }
}

