/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.matchers.MultiMappingStore;
import com.github.gumtreediff.matchers.heuristic.gt.DefaultPriorityTreeQueue;
import com.github.gumtreediff.matchers.heuristic.gt.GreedySubtreeMatcher;
import com.github.gumtreediff.matchers.heuristic.gt.MappingComparators;
import com.github.gumtreediff.matchers.heuristic.gt.PriorityTreeQueue;
import com.github.gumtreediff.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;
import org.refactoringminer.astDiff.matchers.TreeMatcher;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;

public class MissingIdenticalSubtree
extends GreedySubtreeMatcher
implements TreeMatcher {
    private static final boolean ONLY_JAVA_DOCS = false;
    private static final int DEFAULT_MIN_PRIORITY = 1;
    protected int minPriority = 1;
    private static final String DEFAULT_PRIORITY_CALCULATOR = "height";
    protected Function<Tree, Integer> priorityCalculator = PriorityTreeQueue.getPriorityCalculator((String)"height");
    protected Tree src;
    protected Tree dst;
    protected ExtendedMultiMappingStore mappings;

    @Override
    public void match(Tree src, Tree dst, ExtendedMultiMappingStore mappingStore) {
        this.src = src;
        this.dst = dst;
        this.mappings = mappingStore;
        MultiMappingStore multiMappings = new MultiMappingStore();
        DefaultPriorityTreeQueue srcTrees = new DefaultPriorityTreeQueue(src, this.minPriority, this.priorityCalculator);
        DefaultPriorityTreeQueue dstTrees = new DefaultPriorityTreeQueue(dst, this.minPriority, this.priorityCalculator);
        while (!srcTrees.isEmpty() && !dstTrees.isEmpty()) {
            PriorityTreeQueue.synchronize((PriorityTreeQueue)srcTrees, (PriorityTreeQueue)dstTrees);
            if (srcTrees.isEmpty() || dstTrees.isEmpty()) break;
            List currentPrioritySrcTrees = srcTrees.pop();
            List currentPriorityDstTrees = dstTrees.pop();
            for (Tree currentSrc : currentPrioritySrcTrees) {
                for (Tree currentDst : currentPriorityDstTrees) {
                    if (currentSrc.getMetrics().hash != currentDst.getMetrics().hash || !TreeUtilFunctions.isIsomorphicTo(currentSrc, currentDst) || mappingStore.isSrcMappedConsideringSubTrees(currentSrc) || mappingStore.isDstMappedConsideringSubTrees(currentDst)) continue;
                    multiMappings.addMapping(currentSrc, currentDst);
                }
            }
            for (Tree t : currentPrioritySrcTrees) {
                if (multiMappings.hasSrc(t)) continue;
                srcTrees.open(t);
            }
            for (Tree t : currentPriorityDstTrees) {
                if (multiMappings.hasDst(t)) continue;
                dstTrees.open(t);
            }
        }
        this.filterMappings(multiMappings);
    }

    public void filterMappings(MultiMappingStore multiMappings) {
        ArrayList<Mapping> ambiguousList = new ArrayList<Mapping>();
        HashSet ignored = new HashSet();
        for (Tree src : multiMappings.allMappedSrcs()) {
            Tree dst;
            boolean isMappingUnique = false;
            if (MissingIdenticalSubtree.tinyTrees(src, multiMappings, this.minPriority)) continue;
            if (multiMappings.isSrcUnique(src) && multiMappings.isDstUnique(dst = (Tree)multiMappings.getDsts(src).stream().findAny().get())) {
                if (this.isAcceptable(src, dst)) {
                    this.mappings.addMappingRecursively(src, dst);
                }
                isMappingUnique = true;
            }
            if (!(MissingIdenticalSubtree.tinyTrees(src, multiMappings, this.minPriority) || ignored.contains(src) || isMappingUnique)) {
                Set adsts = multiMappings.getDsts(src);
                Set asrcs = multiMappings.getSrcs((Tree)multiMappings.getDsts(src).iterator().next());
                for (Tree asrc : asrcs) {
                    for (Tree adst : adsts) {
                        ambiguousList.add(new Mapping(asrc, adst));
                    }
                }
                ignored.addAll(asrcs);
            }
            HashSet<Tree> srcIgnored = new HashSet<Tree>();
            HashSet<Tree> dstIgnored = new HashSet<Tree>();
            Collections.sort(ambiguousList, new MappingComparators.FullMappingComparator(this.mappings.getMonoMappingStore()));
            this.retainBestMapping(ambiguousList, srcIgnored, dstIgnored);
        }
    }

    private boolean isAcceptable(Tree src, Tree dst) {
        if (src.getType().name.equals("Javadoc")) {
            return true;
        }
        boolean ret = TreeUtilFunctions.isStatement(src.getType().name) && !src.getType().name.equals("Block") ? !src.getType().name.equals("ReturnStatement") || src.getMetrics().height > 2 : (src.getType().name.equals("MethodInvocation") ? (!src.getParent().getType().name.equals("METHOD_INVOCATION_RECEIVER") && dst.getParent().getType().name.equals("METHOD_INVOCATION_RECEIVER") ? false : (src.getParent().getType().name.equals("METHOD_INVOCATION_RECEIVER") && !dst.getParent().getType().name.equals("METHOD_INVOCATION_RECEIVER") ? true : true)) : (src.getType().name.equals("METHOD_INVOCATION_ARGUMENTS") ? true : (src.getType().name.equals("METHOD_INVOCATION_RECEIVER") ? true : (src.getType().name.equals("InfixExpression") ? true : (src.getType().name.equals("ClassInstanceCreation") ? true : src.getType().name.equals("ImportDeclaration"))))));
        if (!ret) {
            return false;
        }
        if (this.notBelongingToMethodWithTestAnnotation(src) && this.notBelongingToMethodWithTestAnnotation(dst)) {
            return ret;
        }
        return false;
    }

    private boolean notBelongingToMethodWithTestAnnotation(Tree src) {
        Tree methodDecl = TreeUtilFunctions.getParentUntilType(src, "MethodDeclaration");
        if (methodDecl == null) {
            return true;
        }
        for (Tree child : methodDecl.getChildren()) {
            if (!child.getType().name.equals("MarkerAnnotation") || child.getChildren().size() <= 0 || !child.getChild((int)0).getType().name.equals("SimpleName") || !child.getChild(0).getLabel().equals("Test")) continue;
            return false;
        }
        return true;
    }

    private static boolean tinyTrees(Tree src, MultiMappingStore multiMappings, int minP) {
        if (src.getMetrics().height <= minP) {
            if (src.getType().name.equals("METHOD_INVOCATION_RECEIVER")) {
                return true;
            }
            if (src.getType().name.equals("METHOD_INVOCATION_ARGUMENTS")) {
                return true;
            }
            if (src.getType().name.equals("SimpleType")) {
                return true;
            }
        }
        return src.getType().name.equals("METHOD_INVOCATION_RECEIVER");
    }

    protected void retainBestMapping(List<Mapping> mappingList, Set<Tree> srcIgnored, Set<Tree> dstIgnored) {
        ArrayList<Mapping> verifiedList = new ArrayList<Mapping>();
        for (Mapping mapping : mappingList) {
            if (!this.isAcceptable((Tree)mapping.first, (Tree)mapping.second)) continue;
            verifiedList.add(mapping);
        }
        while (verifiedList.size() > 0) {
            Mapping mapping = (Mapping)verifiedList.remove(0);
            if (srcIgnored.contains(mapping.first) || dstIgnored.contains(mapping.second)) continue;
            this.mappings.addMappingRecursively((Tree)mapping.first, (Tree)mapping.second);
            srcIgnored.add((Tree)mapping.first);
            srcIgnored.addAll(((Tree)mapping.first).getDescendants());
            dstIgnored.add((Tree)mapping.second);
            dstIgnored.addAll(((Tree)mapping.second).getDescendants());
        }
    }
}

