/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.matchers;

import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import com.github.gumtreediff.utils.Pair;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLImport;
import gr.uom.java.xmi.UMLInitializer;
import gr.uom.java.xmi.UMLJavadoc;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.UMLTypeParameter;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObjectMapping;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.AssertThrowsRefactoring;
import gr.uom.java.xmi.diff.ExtractAttributeRefactoring;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.ExtractVariableRefactoring;
import gr.uom.java.xmi.diff.InlineAttributeRefactoring;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.InlineVariableRefactoring;
import gr.uom.java.xmi.diff.MergeCatchRefactoring;
import gr.uom.java.xmi.diff.MergeConditionalRefactoring;
import gr.uom.java.xmi.diff.MergeOperationRefactoring;
import gr.uom.java.xmi.diff.MergeVariableRefactoring;
import gr.uom.java.xmi.diff.ModifyAttributeAnnotationRefactoring;
import gr.uom.java.xmi.diff.ModifyClassAnnotationRefactoring;
import gr.uom.java.xmi.diff.ModifyMethodAnnotationRefactoring;
import gr.uom.java.xmi.diff.ModifyVariableAnnotationRefactoring;
import gr.uom.java.xmi.diff.MoveAttributeRefactoring;
import gr.uom.java.xmi.diff.MoveCodeRefactoring;
import gr.uom.java.xmi.diff.MoveOperationRefactoring;
import gr.uom.java.xmi.diff.ParameterizeTestRefactoring;
import gr.uom.java.xmi.diff.RenameVariableRefactoring;
import gr.uom.java.xmi.diff.ReplaceAnonymousWithClassRefactoring;
import gr.uom.java.xmi.diff.ReplaceLoopWithPipelineRefactoring;
import gr.uom.java.xmi.diff.ReplacePipelineWithLoopRefactoring;
import gr.uom.java.xmi.diff.SplitConditionalRefactoring;
import gr.uom.java.xmi.diff.SplitOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnnotationListDiff;
import gr.uom.java.xmi.diff.UMLAnonymousClassDiff;
import gr.uom.java.xmi.diff.UMLAnonymousToClassDiff;
import gr.uom.java.xmi.diff.UMLAttributeDiff;
import gr.uom.java.xmi.diff.UMLClassBaseDiff;
import gr.uom.java.xmi.diff.UMLEnumConstantDiff;
import gr.uom.java.xmi.diff.UMLImportListDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import gr.uom.java.xmi.diff.UMLOperationDiff;
import gr.uom.java.xmi.diff.UMLTypeParameterListDiff;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.astDiff.actions.ASTDiff;
import org.refactoringminer.astDiff.actions.ProjectASTDiff;
import org.refactoringminer.astDiff.matchers.BasicTreeMatcher;
import org.refactoringminer.astDiff.matchers.CompositeMatcher;
import org.refactoringminer.astDiff.matchers.ExtendedMultiMappingStore;
import org.refactoringminer.astDiff.matchers.GeneralMatcher;
import org.refactoringminer.astDiff.matchers.LeafMatcher;
import org.refactoringminer.astDiff.matchers.MissingIdenticalSubtree;
import org.refactoringminer.astDiff.utils.TreeUtilFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectASTDiffer {
    private static final Logger logger = LoggerFactory.getLogger(ProjectASTDiffer.class);
    private final UMLModelDiff modelDiff;
    private List<AbstractCodeMapping> lastStepMappings;
    private ExtendedMultiMappingStore optimizationMappingStore;
    private List<Refactoring> modelDiffRefactorings;
    private final ProjectASTDiff projectASTDiff;
    private final Map<String, OptimizationData> optimizationDataMap = new HashMap<String, OptimizationData>();

    public ProjectASTDiffer(UMLModelDiff modelDiff, Map<String, String> fileContentsBefore, Map<String, String> fileContentsAfter) throws RefactoringMinerTimedOutException {
        this.modelDiff = modelDiff;
        this.projectASTDiff = new ProjectASTDiff(fileContentsBefore, fileContentsAfter);
        this.diff();
    }

    public ProjectASTDiff getProjectASTDiff() {
        return this.projectASTDiff;
    }

    public Set<ASTDiff> getDiffSet() {
        return this.projectASTDiff.getDiffSet();
    }

    private void diff() throws RefactoringMinerTimedOutException {
        long start = System.currentTimeMillis();
        this.modelDiffRefactorings = this.modelDiff.getRefactorings();
        long finish = System.currentTimeMillis();
        logger.info("ModelDiff.getRefactorings() execution time: " + (finish - start) / 1000L + " seconds");
        this.projectASTDiff.setRefactorings(this.modelDiffRefactorings);
        long diff_execution_started = System.currentTimeMillis();
        this.makeASTDiff(this.modelDiff.getCommonClassDiffList(), false);
        this.makeASTDiff(this.modelDiff.getClassRenameDiffList(), false);
        this.makeASTDiff(this.modelDiff.getClassMoveDiffList(), false);
        this.makeASTDiff(this.modelDiff.getInnerClassMoveDiffList(), true);
        this.makeASTDiff(this.getExtraDiffs(), true);
        long diff_execution_finished = System.currentTimeMillis();
        logger.info("Diff execution: " + (diff_execution_finished - diff_execution_started) / 1000L + " seconds");
        for (ASTDiff diff : this.projectASTDiff.getDiffSet()) {
            ProjectASTDiffer.processOptimization(diff, this.optimizationDataMap.get(diff.getSrcPath()));
        }
        for (ASTDiff diff : this.projectASTDiff.getDiffSet()) {
            new MissingIdenticalSubtree().match(diff.src.getRoot(), diff.dst.getRoot(), diff.getAllMappings());
        }
        this.computeAllEditScripts();
    }

    private List<? extends UMLAbstractClassDiff> getExtraDiffs() {
        ArrayList<UMLAnonymousToClassDiff> extraDiffs = new ArrayList<UMLAnonymousToClassDiff>();
        for (Refactoring modelDiffRefactoring : this.modelDiffRefactorings) {
            if (modelDiffRefactoring.getRefactoringType() != RefactoringType.REPLACE_ANONYMOUS_WITH_CLASS) continue;
            ReplaceAnonymousWithClassRefactoring replaceAnonymousWithClassRefactoring = (ReplaceAnonymousWithClassRefactoring)modelDiffRefactoring;
            extraDiffs.add(replaceAnonymousWithClassRefactoring.getDiff());
        }
        return extraDiffs;
    }

    private void computeAllEditScripts() {
        long editScript_start = System.currentTimeMillis();
        for (ASTDiff diff : this.projectASTDiff.getDiffSet()) {
            diff.computeEditScript(this.modelDiff.getParentModel().getTreeContextMap(), this.modelDiff.getChildModel().getTreeContextMap());
        }
        long editScript_end = System.currentTimeMillis();
        logger.info("EditScript execution: " + (editScript_end - editScript_start) / 1000L + " seconds");
    }

    private void makeASTDiff(List<? extends UMLAbstractClassDiff> umlClassBaseDiffList, boolean mergeFlag) {
        for (UMLAbstractClassDiff uMLAbstractClassDiff : umlClassBaseDiffList) {
            ASTDiff append = this.findAppend(uMLAbstractClassDiff);
            boolean decision = append != null || mergeFlag;
            ASTDiff classASTDiff = this.process(uMLAbstractClassDiff, this.findTreeContexts(uMLAbstractClassDiff), decision);
            if (append != null) {
                append.getAllMappings().mergeMappings(classASTDiff.getAllMappings());
                continue;
            }
            this.projectASTDiff.addASTDiff(classASTDiff);
        }
    }

    private ASTDiff findAppend(UMLAbstractClassDiff classBaseDiff) {
        for (ASTDiff existing : this.projectASTDiff.getDiffSet()) {
            if (existing.getSrcPath().equals(classBaseDiff.getOriginalClass().getSourceFile())) {
                return existing;
            }
            if (!existing.getDstPath().equals(classBaseDiff.getNextClass().getSourceFile())) continue;
            return existing;
        }
        return null;
    }

    private Pair<TreeContext, TreeContext> findTreeContexts(UMLAbstractClassDiff classDiff) {
        return new Pair((Object)this.modelDiff.getParentModel().getTreeContextMap().get(classDiff.getOriginalClass().getSourceFile()), (Object)this.modelDiff.getChildModel().getTreeContextMap().get(classDiff.getNextClass().getSourceFile()));
    }

    private ASTDiff process(UMLAbstractClassDiff classDiff, Pair<TreeContext, TreeContext> treeContextPair, boolean mergeFlag) {
        UMLClassBaseDiff baseClassDiff;
        boolean isBaseDiff;
        TreeContext srcTreeContext = (TreeContext)treeContextPair.first;
        TreeContext dstTreeContext = (TreeContext)treeContextPair.second;
        Tree srcTree = srcTreeContext.getRoot();
        Tree dstTree = dstTreeContext.getRoot();
        ExtendedMultiMappingStore mappingStore = new ExtendedMultiMappingStore(srcTree, dstTree);
        String key = classDiff.getOriginalClass().getLocationInfo().getFilePath();
        if (this.optimizationDataMap.containsKey(key)) {
            this.lastStepMappings = this.optimizationDataMap.get((Object)key).lastStepMappings;
            this.optimizationMappingStore = this.optimizationDataMap.get((Object)key).optimizationMappingStore;
        } else {
            this.lastStepMappings = new ArrayList<AbstractCodeMapping>();
            this.optimizationMappingStore = new ExtendedMultiMappingStore(srcTree, dstTree);
        }
        if (!mergeFlag) {
            mappingStore.addMapping(srcTree, dstTree);
            this.processPackageDeclaration(srcTree, dstTree, mappingStore);
        }
        if (isBaseDiff = classDiff instanceof UMLClassBaseDiff) {
            baseClassDiff = (UMLClassBaseDiff)classDiff;
            this.processImports(srcTree, dstTree, baseClassDiff.getImportDiffList(), mappingStore);
            this.processClassDeclarationMapping(srcTree, dstTree, baseClassDiff, mappingStore);
        }
        this.processClassAttributes(srcTree, dstTree, classDiff, mappingStore);
        this.processEnumConstants(srcTree, dstTree, classDiff.getCommonEnumConstants(), mappingStore);
        this.processAllMethods(srcTree, dstTree, classDiff.getOperationBodyMapperList(), mappingStore);
        this.processModelDiffRefactorings(classDiff, mappingStore);
        this.processMovedAttributes(classDiff, mappingStore);
        if (isBaseDiff) {
            baseClassDiff = (UMLClassBaseDiff)classDiff;
            this.processRefactorings(srcTree, dstTree, this.getClassDiffRefactorings(baseClassDiff), mappingStore);
        }
        this.optimizationDataMap.put(key, new OptimizationData(this.lastStepMappings, this.optimizationMappingStore));
        return new ASTDiff(classDiff.getOriginalClass().getLocationInfo().getFilePath(), classDiff.getNextClass().getLocationInfo().getFilePath(), (TreeContext)treeContextPair.first, (TreeContext)treeContextPair.second, mappingStore);
    }

    private List<Refactoring> getClassDiffRefactorings(UMLClassBaseDiff classDiff) {
        ArrayList<Refactoring> classDiffRefactorings = new ArrayList<Refactoring>();
        for (Refactoring modelDiffRefactoring : this.modelDiffRefactorings) {
            boolean bothInAnonymous;
            Set<ImmutablePair<String, String>> involvedClassesBeforeRefactoring = modelDiffRefactoring.getInvolvedClassesBeforeRefactoring();
            Set<ImmutablePair<String, String>> involvedClassesAfterRefactoring = modelDiffRefactoring.getInvolvedClassesAfterRefactoring();
            if (involvedClassesBeforeRefactoring.size() > 1 || involvedClassesAfterRefactoring.size() > 1) continue;
            UMLClass umlClassBefore = classDiff.getOriginalClass();
            UMLClass umlClassAfter = classDiff.getNextClass();
            ImmutablePair<String, String> refactoringClassBefore = involvedClassesBeforeRefactoring.iterator().next();
            ImmutablePair<String, String> refactoringClassAfter = involvedClassesAfterRefactoring.iterator().next();
            if (!umlClassBefore.getLocationInfo().getFilePath().equals(refactoringClassBefore.getLeft()) || !umlClassAfter.getLocationInfo().getFilePath().equals(refactoringClassAfter.getLeft())) continue;
            String refactoringClassNameBefore = (String)refactoringClassBefore.getRight();
            String refactoringClassNameAfter = (String)refactoringClassAfter.getRight();
            boolean isNameMatching = refactoringClassNameBefore.equals(umlClassBefore.getName()) || refactoringClassNameAfter.equals(umlClassAfter.getName());
            boolean bl = bothInAnonymous = refactoringClassNameBefore.contains(umlClassBefore.getName()) && refactoringClassNameAfter.contains(umlClassAfter.getName());
            if (!isNameMatching && !bothInAnonymous) continue;
            classDiffRefactorings.add(modelDiffRefactoring);
        }
        return classDiffRefactorings;
    }

    private void processMovedAttributes(UMLAbstractClassDiff classDiff, ExtendedMultiMappingStore mappingStore) {
        List<UMLAttributeDiff> movedAttributeDiffList = this.modelDiff.getMovedAttributeDiffList();
        for (UMLAttributeDiff umlAttributeDiff : movedAttributeDiffList) {
            UMLAttribute srcAttr = umlAttributeDiff.getRemovedAttribute();
            UMLAttribute dstAttr = umlAttributeDiff.getAddedAttribute();
            String srcAttrPath = srcAttr.getLocationInfo().getFilePath();
            String dstAttrPath = dstAttr.getLocationInfo().getFilePath();
            if (!classDiff.getOriginalClass().getLocationInfo().getFilePath().equals(srcAttrPath) || !classDiff.getNextClass().getLocationInfo().getFilePath().equals(dstAttrPath)) continue;
            Tree srcTotalTree = this.modelDiff.getParentModel().getTreeContextMap().get(srcAttrPath).getRoot();
            Tree dstTotalTree = this.modelDiff.getChildModel().getTreeContextMap().get(dstAttrPath).getRoot();
            this.processFieldDeclarationByAttrDiff(srcTotalTree, dstTotalTree, umlAttributeDiff, mappingStore);
        }
    }

    private static void processOptimization(ASTDiff input, OptimizationData optimizationData) {
        Tree srcTree = input.src.getRoot();
        Tree dstTree = input.dst.getRoot();
        ExtendedMultiMappingStore lastStepMappingStore = new ExtendedMultiMappingStore(srcTree, dstTree);
        for (AbstractCodeMapping lastStepMapping : optimizationData.lastStepMappings) {
            if (!lastStepMapping.getFragment1().getLocationInfo().getFilePath().equals(lastStepMapping.getFragment2().getLocationInfo().getFilePath())) continue;
            Tree srcExp = TreeUtilFunctions.findByLocationInfo(srcTree, lastStepMapping.getFragment1().getLocationInfo());
            Tree dstExp = TreeUtilFunctions.findByLocationInfo(dstTree, lastStepMapping.getFragment2().getLocationInfo());
            new LeafMatcher().match(srcExp, dstExp, lastStepMappingStore);
        }
        ExtendedMultiMappingStore allMappings = input.getAllMappings();
        allMappings.replaceWithOptimizedMappings(lastStepMappingStore);
        allMappings.replaceWithOptimizedMappings(optimizationData.optimizationMappingStore);
    }

    private void processEnumConstants(Tree srcTree, Tree dstTree, Set<org.apache.commons.lang3.tuple.Pair<UMLEnumConstant, UMLEnumConstant>> commonEnumConstants, ExtendedMultiMappingStore mappingStore) {
        for (org.apache.commons.lang3.tuple.Pair<UMLEnumConstant, UMLEnumConstant> commonEnumConstant : commonEnumConstants) {
            LocationInfo locationInfo1 = ((UMLEnumConstant)commonEnumConstant.getLeft()).getLocationInfo();
            LocationInfo locationInfo2 = ((UMLEnumConstant)commonEnumConstant.getRight()).getLocationInfo();
            Tree srcEnumConstant = TreeUtilFunctions.findByLocationInfo(srcTree, locationInfo1);
            Tree dstEnumConstant = TreeUtilFunctions.findByLocationInfo(dstTree, locationInfo2);
            new LeafMatcher().match(srcEnumConstant, dstEnumConstant, mappingStore);
        }
    }

    private void processModelDiffRefactorings(UMLAbstractClassDiff classDiff, ExtendedMultiMappingStore mappingStore) {
        for (Refactoring refactoring : this.modelDiffRefactorings) {
            Tree dstTotalTree;
            Tree srcTotalTree;
            String dstPath;
            String srcPath;
            List beforeRefactoringClasses = refactoring.getInvolvedClassesBeforeRefactoring().stream().map(ImmutablePair::getRight).collect(Collectors.toList());
            List afterRefactoringClasses = refactoring.getInvolvedClassesAfterRefactoring().stream().map(ImmutablePair::getRight).collect(Collectors.toList());
            if (refactoring instanceof MoveOperationRefactoring) {
                if (!afterRefactoringClasses.contains(classDiff.getNextClass().getName()) && !beforeRefactoringClasses.contains(classDiff.getOriginalClass().getName())) continue;
                MoveOperationRefactoring moveOperationRefactoring = (MoveOperationRefactoring)refactoring;
                if (this.isExtractedMethodRef(moveOperationRefactoring.getBodyMapper().getOperation2())) {
                    return;
                }
                srcPath = moveOperationRefactoring.getOriginalOperation().getLocationInfo().getFilePath();
                dstPath = moveOperationRefactoring.getMovedOperation().getLocationInfo().getFilePath();
                srcTotalTree = this.modelDiff.getParentModel().getTreeContextMap().get(srcPath).getRoot();
                dstTotalTree = this.modelDiff.getChildModel().getTreeContextMap().get(dstPath).getRoot();
                this.processMethod(srcTotalTree, dstTotalTree, moveOperationRefactoring.getBodyMapper(), mappingStore);
                continue;
            }
            if (refactoring instanceof MoveAttributeRefactoring) {
                if (!afterRefactoringClasses.contains(classDiff.getNextClass().getName()) && !beforeRefactoringClasses.contains(classDiff.getOriginalClass().getName())) continue;
                MoveAttributeRefactoring moveAttributeRefactoring = (MoveAttributeRefactoring)refactoring;
                srcPath = moveAttributeRefactoring.getOriginalAttribute().getLocationInfo().getFilePath();
                dstPath = moveAttributeRefactoring.getMovedAttribute().getLocationInfo().getFilePath();
                srcTotalTree = this.modelDiff.getParentModel().getTreeContextMap().get(srcPath).getRoot();
                dstTotalTree = this.modelDiff.getChildModel().getTreeContextMap().get(dstPath).getRoot();
                this.processFieldDeclaration(srcTotalTree, dstTotalTree, moveAttributeRefactoring.getOriginalAttribute(), moveAttributeRefactoring.getMovedAttribute(), mappingStore);
                continue;
            }
            if (refactoring.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
                if (!afterRefactoringClasses.contains(classDiff.getNextClass().getName()) && !beforeRefactoringClasses.contains(classDiff.getOriginalClass().getName())) continue;
                ExtractOperationRefactoring extractOperationRefactoring = (ExtractOperationRefactoring)refactoring;
                this.findTreeFromMapperAndProcessBodyMapper(extractOperationRefactoring.getBodyMapper(), mappingStore);
                continue;
            }
            if (!refactoring.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_INLINE_OPERATION) || !afterRefactoringClasses.contains(classDiff.getNextClass().getName()) && !beforeRefactoringClasses.contains(classDiff.getOriginalClass().getName())) continue;
            InlineOperationRefactoring inlineOperationRefactoring = (InlineOperationRefactoring)refactoring;
            this.findTreeFromMapperAndProcessBodyMapper(inlineOperationRefactoring.getBodyMapper(), mappingStore);
        }
    }

    private void findTreeFromMapperAndProcessBodyMapper(UMLOperationBodyMapper bodyMapper, ExtendedMultiMappingStore mappingStore) {
        String srcPath = bodyMapper.getOperation1().getLocationInfo().getFilePath();
        String dstPath = bodyMapper.getOperation2().getLocationInfo().getFilePath();
        Tree srcTotalTree = this.modelDiff.getParentModel().getTreeContextMap().get(srcPath).getRoot();
        Tree dstTotalTree = this.modelDiff.getChildModel().getTreeContextMap().get(dstPath).getRoot();
        this.processBodyMapper(srcTotalTree, dstTotalTree, bodyMapper, mappingStore, true);
    }

    private boolean isExtractedMethodRef(UMLOperation operation2) {
        for (Refactoring modelDiffRefactoring : this.modelDiffRefactorings) {
            if (!modelDiffRefactoring.getRefactoringType().equals((Object)RefactoringType.EXTRACT_OPERATION) || !((ExtractOperationRefactoring)modelDiffRefactoring).getExtractedOperation().equals(operation2)) continue;
            return true;
        }
        return false;
    }

    private void processAllMethods(Tree srcTree, Tree dstTree, List<UMLOperationBodyMapper> operationBodyMapperList, ExtendedMultiMappingStore mappingStore) {
        for (UMLOperationBodyMapper umlOperationBodyMapper : new ArrayList<UMLOperationBodyMapper>(operationBodyMapperList)) {
            this.processMethod(srcTree, dstTree, umlOperationBodyMapper, mappingStore);
        }
    }

    private void processMethod(Tree srcTree, Tree dstTree, UMLOperationBodyMapper umlOperationBodyMapper, ExtendedMultiMappingStore mappingStore) {
        Tree dstOperationNode;
        Tree srcOperationNode;
        if (umlOperationBodyMapper.getOperation1() != null & umlOperationBodyMapper.getOperation2() != null) {
            srcOperationNode = TreeUtilFunctions.findByLocationInfo(srcTree, umlOperationBodyMapper.getOperation1().getLocationInfo());
            dstOperationNode = TreeUtilFunctions.findByLocationInfo(dstTree, umlOperationBodyMapper.getOperation2().getLocationInfo());
            if (srcOperationNode == null || !srcOperationNode.getType().name.equals("MethodDeclaration")) {
                return;
            }
            if (dstOperationNode == null || !dstOperationNode.getType().name.equals("MethodDeclaration")) {
                return;
            }
            this.processJavaDocs(srcOperationNode, dstOperationNode, umlOperationBodyMapper.getOperation1().getJavadoc(), umlOperationBodyMapper.getOperation2().getJavadoc(), mappingStore);
            mappingStore.addMapping(srcOperationNode, dstOperationNode);
        } else {
            srcOperationNode = TreeUtilFunctions.findByLocationInfo(srcTree, umlOperationBodyMapper.getContainer1().getLocationInfo());
            if (srcOperationNode != null & (dstOperationNode = TreeUtilFunctions.findByLocationInfo(dstTree, umlOperationBodyMapper.getContainer2().getLocationInfo())) != null && srcOperationNode.getType().name.equals("Initializer") && dstOperationNode.getType().name.equals("Initializer")) {
                mappingStore.addMapping(srcOperationNode, dstOperationNode);
                if (umlOperationBodyMapper.getContainer1() instanceof UMLInitializer && umlOperationBodyMapper.getContainer2() instanceof UMLInitializer && ((UMLInitializer)umlOperationBodyMapper.getContainer1()).isStatic() && ((UMLInitializer)umlOperationBodyMapper.getContainer2()).isStatic()) {
                    Tree srcModifier = TreeUtilFunctions.findChildByType(srcOperationNode, "Modifier");
                    Tree dstModifier = TreeUtilFunctions.findChildByType(dstOperationNode, "Modifier");
                    if (srcModifier != null && dstModifier != null) {
                        mappingStore.addMapping(srcModifier, dstModifier);
                    }
                }
                Tree srcJavadoc = TreeUtilFunctions.findChildByType(srcOperationNode, "Javadoc");
                Tree dstJavadoc = TreeUtilFunctions.findChildByType(dstOperationNode, "Javadoc");
                if (srcJavadoc != null && dstJavadoc != null) {
                    new BasicTreeMatcher().match(srcJavadoc, dstJavadoc, mappingStore);
                }
            }
        }
        if (srcOperationNode != null && dstOperationNode != null) {
            this.processMethodSignature(srcOperationNode, dstOperationNode, umlOperationBodyMapper, mappingStore);
            this.processBodyMapper(srcOperationNode, dstOperationNode, umlOperationBodyMapper, mappingStore, false);
            this.processOperationDiff(srcOperationNode, dstOperationNode, umlOperationBodyMapper, mappingStore);
            this.processMethodParameters(srcOperationNode, dstOperationNode, umlOperationBodyMapper.getMatchedVariables(), mappingStore);
        }
    }

    private void processMethodParameters(Tree srcTree, Tree dstTree, Set<org.apache.commons.lang3.tuple.Pair<VariableDeclaration, VariableDeclaration>> matchedVariables, ExtendedMultiMappingStore mappingStore) {
        for (org.apache.commons.lang3.tuple.Pair<VariableDeclaration, VariableDeclaration> matchedPair : matchedVariables) {
            VariableDeclaration leftVarDecl = (VariableDeclaration)matchedPair.getLeft();
            VariableDeclaration rightVarDecl = (VariableDeclaration)matchedPair.getRight();
            Tree leftTree = TreeUtilFunctions.findByLocationInfo(srcTree, leftVarDecl.getLocationInfo());
            Tree rightTree = TreeUtilFunctions.findByLocationInfo(dstTree, rightVarDecl.getLocationInfo());
            if (leftTree == null || rightTree == null) {
                return;
            }
            if (!leftVarDecl.isParameter() || !rightVarDecl.isParameter()) continue;
            if (TreeUtilFunctions.isIsomorphicTo(rightTree, leftTree)) {
                mappingStore.addMappingRecursively(leftTree, rightTree);
                continue;
            }
            new LeafMatcher().match(leftTree, rightTree, mappingStore);
            mappingStore.addMapping(leftTree, rightTree);
        }
    }

    private void processBodyMapper(Tree srcTree, Tree dstTree, UMLOperationBodyMapper bodyMapper, ExtendedMultiMappingStore mappingStore, boolean isPartOfExtractedMethod) {
        if (bodyMapper.getAnonymousClassDiffs() != null) {
            for (UMLAnonymousClassDiff anonymousClassDiff : bodyMapper.getAnonymousClassDiffs()) {
                this.processClassAttributes(srcTree, dstTree, anonymousClassDiff, mappingStore);
                for (UMLOperationBodyMapper umlOperationBodyMapper : anonymousClassDiff.getOperationBodyMapperList()) {
                    this.processMethod(srcTree, dstTree, umlOperationBodyMapper, mappingStore);
                }
            }
        }
        Set<AbstractCodeMapping> mappingSet = bodyMapper.getMappings();
        ArrayList<AbstractCodeMapping> mappings = new ArrayList<AbstractCodeMapping>(mappingSet);
        for (AbstractCodeMapping abstractCodeMapping : mappings) {
            if (abstractCodeMapping instanceof LeafMapping) {
                this.processLeafMapping(srcTree, dstTree, abstractCodeMapping, mappingStore, isPartOfExtractedMethod);
                continue;
            }
            if (!(abstractCodeMapping instanceof CompositeStatementObjectMapping)) continue;
            this.processCompositeMapping(srcTree, dstTree, abstractCodeMapping, mappingStore);
        }
    }

    private void processCompositeMapping(Tree srcTree, Tree dstTree, AbstractCodeMapping abstractCodeMapping, ExtendedMultiMappingStore mappingStore) {
        CompositeStatementObjectMapping compositeStatementObjectMapping = (CompositeStatementObjectMapping)abstractCodeMapping;
        Tree srcStatementNode = TreeUtilFunctions.findByLocationInfo(srcTree, compositeStatementObjectMapping.getFragment1().getLocationInfo());
        Tree dstStatementNode = TreeUtilFunctions.findByLocationInfo(dstTree, compositeStatementObjectMapping.getFragment2().getLocationInfo());
        if (srcStatementNode == null || dstStatementNode == null) {
            return;
        }
        if (srcStatementNode.getType().name.equals(dstStatementNode.getType().name)) {
            mappingStore.addMapping(srcStatementNode, dstStatementNode);
        }
        if (srcStatementNode.getType().name.equals("TryStatement") && dstStatementNode.getType().name.equals("TryStatement") || srcStatementNode.getType().name.equals("CatchClause") && dstStatementNode.getType().name.equals("CatchClause")) {
            this.matchBlocks(srcStatementNode, dstStatementNode, mappingStore);
            new CompositeMatcher(abstractCodeMapping).match(srcStatementNode, dstStatementNode, mappingStore);
        } else if (!srcStatementNode.getType().name.equals("Block") && !dstStatementNode.getType().name.equals("Block")) {
            new CompositeMatcher(abstractCodeMapping).match(srcStatementNode, dstStatementNode, mappingStore);
        }
    }

    private void processLeafMapping(Tree srcTree, Tree dstTree, AbstractCodeMapping abstractCodeMapping, ExtendedMultiMappingStore mappingStore, boolean isPartOfExtractedMethod) {
        LeafMapping leafMapping = (LeafMapping)abstractCodeMapping;
        Tree srcStatementNode = TreeUtilFunctions.findByLocationInfo(srcTree, leafMapping.getFragment1().getLocationInfo());
        Tree dstStatementNode = TreeUtilFunctions.findByLocationInfo(dstTree, leafMapping.getFragment2().getLocationInfo());
        if (srcStatementNode == null || dstStatementNode == null) {
            System.err.println("Tree not found for " + abstractCodeMapping);
            return;
        }
        if (srcStatementNode.getType().name.equals(dstStatementNode.getType().name)) {
            mappingStore.addMapping(srcStatementNode, dstStatementNode);
        }
        boolean _abstractExp = abstractCodeMapping.getFragment1() instanceof AbstractExpression || abstractCodeMapping.getFragment2() instanceof AbstractExpression;
        boolean _leafExp = abstractCodeMapping.getFragment1() instanceof LeafExpression || abstractCodeMapping.getFragment2() instanceof LeafExpression;
        boolean _abstractExpWithNonCompositeOwner = _abstractExp;
        if (_abstractExp) {
            if (abstractCodeMapping.getFragment1() instanceof AbstractExpression && ((AbstractExpression)abstractCodeMapping.getFragment1()).getOwner() != null && ((AbstractExpression)abstractCodeMapping.getFragment1()).getOwner().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT)) {
                _abstractExpWithNonCompositeOwner = false;
            }
            if (abstractCodeMapping.getFragment2() instanceof AbstractExpression && ((AbstractExpression)abstractCodeMapping.getFragment2()).getOwner() != null && ((AbstractExpression)abstractCodeMapping.getFragment2()).getOwner().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT)) {
                _abstractExpWithNonCompositeOwner = false;
            }
        }
        if (_abstractExpWithNonCompositeOwner || _leafExp) {
            this.lastStepMappings.add(abstractCodeMapping);
        } else {
            new LeafMatcher().match(srcStatementNode, dstStatementNode, mappingStore);
            ProjectASTDiffer.additionallyMatchedStatements(srcTree, dstTree, srcStatementNode, dstStatementNode, abstractCodeMapping, mappingStore);
        }
        this.optimizeVariableDeclarations(abstractCodeMapping);
        if (!isPartOfExtractedMethod && srcStatementNode.getType().name.equals("ReturnStatement") && dstStatementNode.getType().name.equals("ReturnStatement")) {
            this.optimizationMappingStore.addMapping(srcStatementNode, dstStatementNode);
        }
        if (abstractCodeMapping.getRefactorings().size() > 0) {
            ProjectASTDiffer.leafMappingRefactoringAwareness(dstTree, abstractCodeMapping, mappingStore);
        }
    }

    private static void leafMappingRefactoringAwareness(Tree dstTree, AbstractCodeMapping abstractCodeMapping, ExtendedMultiMappingStore mappingStore) {
        for (Refactoring refactoring : abstractCodeMapping.getRefactorings()) {
            if (!(refactoring instanceof ExtractVariableRefactoring)) continue;
            ExtractVariableRefactoring extractVariableRefactoring = (ExtractVariableRefactoring)refactoring;
            for (AbstractCodeMapping reference : extractVariableRefactoring.getReferences()) {
                for (LeafExpression variable : reference.getFragment2().getVariables()) {
                    Tree referenceNode;
                    if (!variable.getString().equals(extractVariableRefactoring.getVariableDeclaration().getVariableName()) || (referenceNode = TreeUtilFunctions.findByLocationInfo(dstTree, variable.getLocationInfo())) == null) continue;
                    if (referenceNode.getChildren().size() > 0) {
                        referenceNode = referenceNode.getChild(0);
                    }
                    if (!mappingStore.isDstMapped(referenceNode) || mappingStore.isDstMultiMapped(referenceNode)) continue;
                    Tree tempSrc = (Tree)mappingStore.getSrcs(referenceNode).iterator().next();
                    mappingStore.removeMapping(tempSrc, referenceNode);
                }
            }
        }
    }

    private void optimizeVariableDeclarations(AbstractCodeMapping abstractCodeMapping) {
        List<VariableDeclaration> variableDeclarations1 = abstractCodeMapping.getFragment1().getVariableDeclarations();
        List<VariableDeclaration> variableDeclarations2 = abstractCodeMapping.getFragment2().getVariableDeclarations();
        if (variableDeclarations1.size() == 1 && variableDeclarations2.size() == 0 && variableDeclarations1.get(0).getInitializer() != null && abstractCodeMapping.getFragment2().toString().contains(variableDeclarations1.get(0).getInitializer().toString())) {
            this.lastStepMappings.add(new LeafMapping(variableDeclarations1.get(0).getInitializer(), abstractCodeMapping.getFragment2(), null, null));
        }
        if (variableDeclarations1.size() == 0 && variableDeclarations2.size() == 1 && variableDeclarations2.get(0).getInitializer() != null && abstractCodeMapping.getFragment1().toString().contains(variableDeclarations2.get(0).getInitializer().toString())) {
            this.lastStepMappings.add(new LeafMapping(abstractCodeMapping.getFragment1(), variableDeclarations2.get(0).getInitializer(), null, null));
        }
    }

    private static void additionallyMatchedStatements(Tree srcTree, Tree dstTree, Tree srcStatementNode, Tree dstStatementNode, AbstractCodeMapping abstractCodeMapping, ExtendedMultiMappingStore mappingStore) {
        if (abstractCodeMapping != null) {
            for (Replacement replacement : abstractCodeMapping.getReplacements()) {
                if (!(replacement instanceof CompositeReplacement)) continue;
                CompositeReplacement compositeReplacement = (CompositeReplacement)replacement;
                if (compositeReplacement.getAdditionallyMatchedStatements1().size() > 0) {
                    for (AbstractCodeFragment abstractCodeFragment : compositeReplacement.getAdditionallyMatchedStatements1()) {
                        Tree srcAdditionalTree = TreeUtilFunctions.findByLocationInfo(srcTree, abstractCodeFragment.getLocationInfo());
                        new LeafMatcher().match(srcAdditionalTree, dstStatementNode, mappingStore);
                    }
                    continue;
                }
                if (compositeReplacement.getAdditionallyMatchedStatements2().size() <= 0) continue;
                for (AbstractCodeFragment abstractCodeFragment : compositeReplacement.getAdditionallyMatchedStatements2()) {
                    Tree dstAdditionalTree = TreeUtilFunctions.findByLocationInfo(dstTree, abstractCodeFragment.getLocationInfo());
                    new LeafMatcher().match(srcStatementNode, dstAdditionalTree, mappingStore);
                }
            }
        }
    }

    private void processClassAnnotations(Tree srcTree, Tree dstTree, UMLAnnotationListDiff annotationListDiff, ExtendedMultiMappingStore mappingStore) {
        for (org.apache.commons.lang3.tuple.Pair<UMLAnnotation, UMLAnnotation> umlAnnotationUMLAnnotationPair : annotationListDiff.getCommonAnnotations()) {
            Tree srcClassAnnotationTree = TreeUtilFunctions.findByLocationInfo(srcTree, ((UMLAnnotation)umlAnnotationUMLAnnotationPair.getLeft()).getLocationInfo());
            Tree dstClassAnnotationTree = TreeUtilFunctions.findByLocationInfo(dstTree, ((UMLAnnotation)umlAnnotationUMLAnnotationPair.getRight()).getLocationInfo());
            if (srcClassAnnotationTree == null || dstClassAnnotationTree == null) {
                return;
            }
            if (!srcClassAnnotationTree.isIsoStructuralTo(dstClassAnnotationTree)) continue;
            mappingStore.addMappingRecursively(srcClassAnnotationTree, dstClassAnnotationTree);
        }
    }

    private void matchBlocks(Tree srcStatementNode, Tree dstStatementNode, ExtendedMultiMappingStore mappingStore) {
        String searchingType = "Block";
        Pair<Tree, Tree> matched = this.matchBasedOnType(srcStatementNode, dstStatementNode, searchingType);
        if (matched != null) {
            mappingStore.addMapping((Tree)matched.first, (Tree)matched.second);
        }
    }

    private void processJavaDocs(Tree srcTree, Tree dstTree, UMLJavadoc srcUMLJavaDoc, UMLJavadoc dstUMLJavaDoc, ExtendedMultiMappingStore mappingStore) {
        if (srcUMLJavaDoc != null && dstUMLJavaDoc != null) {
            Tree srcJavaDocNode = TreeUtilFunctions.findByLocationInfo(srcTree, srcUMLJavaDoc.getLocationInfo());
            Tree dstJavaDocNode = TreeUtilFunctions.findByLocationInfo(dstTree, dstUMLJavaDoc.getLocationInfo());
            if (srcJavaDocNode == null || dstJavaDocNode == null) {
                return;
            }
            if (srcUMLJavaDoc.equalText(dstUMLJavaDoc) && srcJavaDocNode.isIsoStructuralTo(dstJavaDocNode)) {
                mappingStore.addMappingRecursively(srcJavaDocNode, dstJavaDocNode);
            } else {
                new BasicTreeMatcher().match(srcJavaDocNode, dstJavaDocNode, mappingStore);
                mappingStore.addMapping(srcJavaDocNode, dstJavaDocNode);
            }
        }
    }

    private void processOperationDiff(Tree srcTree, Tree dstTree, UMLOperationBodyMapper umlOperationBodyMapper, ExtendedMultiMappingStore mappingStore) {
        AbstractMap.SimpleEntry<Set<UMLType>, Set<UMLType>> simpleEntry;
        UMLOperationDiff umlOperationDiff;
        UMLOperationDiff uMLOperationDiff = umlOperationDiff = umlOperationBodyMapper.getOperationSignatureDiff().isPresent() ? umlOperationBodyMapper.getOperationSignatureDiff().get() : null;
        if (umlOperationDiff == null) {
            return;
        }
        UMLTypeParameterListDiff umlTypeParameterListDiff = umlOperationDiff.getTypeParameterListDiff();
        for (org.apache.commons.lang3.tuple.Pair<UMLTypeParameter, UMLTypeParameter> pair : umlTypeParameterListDiff.getCommonTypeParameters()) {
            Tree tree = TreeUtilFunctions.findByLocationInfo(srcTree, ((UMLTypeParameter)pair.getLeft()).getLocationInfo());
            Tree dstTypeParam = TreeUtilFunctions.findByLocationInfo(dstTree, ((UMLTypeParameter)pair.getRight()).getLocationInfo());
            mappingStore.addMappingRecursively(tree, dstTypeParam);
        }
        for (org.apache.commons.lang3.tuple.Pair pair : umlOperationDiff.getAnnotationListDiff().getCommonAnnotations()) {
            Tree tree = TreeUtilFunctions.findByLocationInfo(srcTree, ((UMLAnnotation)pair.getLeft()).getLocationInfo());
            Tree dstClassAnnotationTree = TreeUtilFunctions.findByLocationInfo(dstTree, ((UMLAnnotation)pair.getRight()).getLocationInfo());
            mappingStore.addMappingRecursively(tree, dstClassAnnotationTree);
        }
        Set<org.apache.commons.lang3.tuple.Pair<UMLType, UMLType>> commonExceptionTypes = umlOperationDiff.getCommonExceptionTypes();
        if (commonExceptionTypes != null) {
            for (org.apache.commons.lang3.tuple.Pair<UMLType, UMLType> pair : commonExceptionTypes) {
                Tree srcExceptionNode = TreeUtilFunctions.findByLocationInfo(srcTree, ((UMLType)pair.getLeft()).getLocationInfo());
                Tree dstExceptionNode = TreeUtilFunctions.findByLocationInfo(dstTree, ((UMLType)pair.getRight()).getLocationInfo());
                mappingStore.addMappingRecursively(srcExceptionNode, dstExceptionNode);
            }
        }
        if ((simpleEntry = umlOperationDiff.getChangedExceptionTypes()) != null) {
            Iterator<UMLType> iterator = simpleEntry.getKey().iterator();
            Iterator<UMLType> values = simpleEntry.getValue().iterator();
            if (iterator.hasNext() && values.hasNext()) {
                Tree srcExceptionNode = TreeUtilFunctions.findByLocationInfo(srcTree, iterator.next().getLocationInfo());
                Tree dstExceptionNode = TreeUtilFunctions.findByLocationInfo(dstTree, values.next().getLocationInfo());
                mappingStore.addMappingRecursively(srcExceptionNode, dstExceptionNode);
            }
        }
        if (umlOperationDiff.getRemovedOperation().getReturnParameter() != null && umlOperationDiff.getAddedOperation().getReturnParameter() != null) {
            LocationInfo locationInfo = umlOperationDiff.getRemovedOperation().getReturnParameter().getType().getLocationInfo();
            LocationInfo dstLocationInfo = umlOperationDiff.getAddedOperation().getReturnParameter().getType().getLocationInfo();
            Tree srcNode = TreeUtilFunctions.findByLocationInfo(srcTree, locationInfo);
            Tree dstNode = TreeUtilFunctions.findByLocationInfo(dstTree, dstLocationInfo);
            if (srcNode == null || dstNode == null) {
                return;
            }
            if (srcNode.isIsoStructuralTo(dstNode)) {
                mappingStore.addMappingRecursively(srcNode, dstNode);
            } else {
                new LeafMatcher().match(srcNode, dstNode, mappingStore);
            }
        }
    }

    private static boolean multipleInstancesWithSameDescription(List<Refactoring> refactoringList, Refactoring refactoring) {
        int count = 0;
        for (Refactoring r : refactoringList) {
            if (!r.toString().equals(refactoring.toString())) continue;
            ++count;
        }
        return count > 1;
    }

    private void processRefactorings(Tree srcTree, Tree dstTree, List<Refactoring> refactoringList, ExtendedMultiMappingStore mappingStore) {
        block8: for (Refactoring refactoring : refactoringList) {
            Refactoring modifiedAnnotationRefactoring;
            UMLOperationBodyMapper bodyMapper;
            Iterator<LocationInfoProvider> srcSt;
            Tree dstNode;
            Tree srcNode;
            VariableDeclaration variableDeclaration;
            String variableName;
            LocationInfoProvider enhancedFor;
            Object next;
            Refactoring replaceLoopWithPipelineRefactoring;
            if (refactoring instanceof ReplaceLoopWithPipelineRefactoring) {
                replaceLoopWithPipelineRefactoring = (ReplaceLoopWithPipelineRefactoring)refactoring;
                if (((ReplaceLoopWithPipelineRefactoring)replaceLoopWithPipelineRefactoring).getCodeFragmentsAfter().size() != 1) continue;
                next = ((ReplaceLoopWithPipelineRefactoring)replaceLoopWithPipelineRefactoring).getCodeFragmentsAfter().iterator().next();
                List<LambdaExpressionObject> list = ((AbstractCodeFragment)next).getLambdas();
                enhancedFor = null;
                for (AbstractCodeFragment abstractCodeFragment : ((ReplaceLoopWithPipelineRefactoring)replaceLoopWithPipelineRefactoring).getCodeFragmentsBefore()) {
                    if (!(abstractCodeFragment instanceof CompositeStatementObject) || !((CompositeStatementObject)abstractCodeFragment).isLoop()) continue;
                    enhancedFor = abstractCodeFragment;
                    break;
                }
                if (enhancedFor == null) continue;
                for (LambdaExpressionObject lambda : list) {
                    for (VariableDeclaration parameter : lambda.getParameters()) {
                        variableName = parameter.getVariableName();
                        variableDeclaration = ((AbstractCodeFragment)enhancedFor).getVariableDeclaration(variableName);
                        if (variableDeclaration == null) continue;
                        srcNode = TreeUtilFunctions.findByLocationInfo(srcTree, variableDeclaration.getLocationInfo());
                        dstNode = TreeUtilFunctions.findByLocationInfo(dstTree, parameter.getLocationInfo());
                        new LeafMatcher().match(srcNode, dstNode, mappingStore);
                    }
                }
                srcSt = TreeUtilFunctions.findByLocationInfo(srcTree, enhancedFor.getLocationInfo());
                Tree dstSt = TreeUtilFunctions.findByLocationInfo(dstTree, next.getLocationInfo());
                if (srcSt == null || dstSt == null || !srcSt.getType().name.equals(dstSt.getType().name)) continue;
                mappingStore.addMapping((Tree)srcSt, dstSt);
                continue;
            }
            if (refactoring instanceof ReplacePipelineWithLoopRefactoring) {
                replaceLoopWithPipelineRefactoring = (ReplacePipelineWithLoopRefactoring)refactoring;
                if (((ReplacePipelineWithLoopRefactoring)replaceLoopWithPipelineRefactoring).getCodeFragmentsBefore().size() != 1) continue;
                next = ((ReplacePipelineWithLoopRefactoring)replaceLoopWithPipelineRefactoring).getCodeFragmentsBefore().iterator().next();
                List<LambdaExpressionObject> list = ((AbstractCodeFragment)next).getLambdas();
                enhancedFor = null;
                for (AbstractCodeFragment abstractCodeFragment : ((ReplacePipelineWithLoopRefactoring)replaceLoopWithPipelineRefactoring).getCodeFragmentsAfter()) {
                    if (!abstractCodeFragment.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT)) continue;
                    enhancedFor = abstractCodeFragment;
                    break;
                }
                if (enhancedFor == null) continue;
                for (LambdaExpressionObject lambda : list) {
                    for (VariableDeclaration parameter : lambda.getParameters()) {
                        variableName = parameter.getVariableName();
                        variableDeclaration = ((AbstractCodeFragment)enhancedFor).getVariableDeclaration(variableName);
                        if (variableDeclaration == null) continue;
                        srcNode = TreeUtilFunctions.findByLocationInfo(srcTree, parameter.getLocationInfo());
                        dstNode = TreeUtilFunctions.findByLocationInfo(dstTree, variableDeclaration.getLocationInfo());
                        new LeafMatcher().match(srcNode, dstNode, mappingStore);
                    }
                }
                srcSt = TreeUtilFunctions.findByLocationInfo(srcTree, next.getLocationInfo());
                Tree dstSt = TreeUtilFunctions.findByLocationInfo(dstTree, enhancedFor.getLocationInfo());
                if (dstSt == null || srcSt == null || !srcSt.getType().name.equals(dstSt.getType().name)) continue;
                mappingStore.addMapping((Tree)srcSt, dstSt);
                continue;
            }
            if (refactoring instanceof MergeOperationRefactoring) {
                MergeOperationRefactoring mergeOperationRefactoring = (MergeOperationRefactoring)refactoring;
                for (UMLOperationBodyMapper uMLOperationBodyMapper : mergeOperationRefactoring.getMappers()) {
                    this.processMethod(srcTree, dstTree, uMLOperationBodyMapper, mappingStore);
                }
                continue;
            }
            if (refactoring instanceof SplitOperationRefactoring) {
                SplitOperationRefactoring splitOperationRefactoring = (SplitOperationRefactoring)refactoring;
                for (UMLOperationBodyMapper uMLOperationBodyMapper : splitOperationRefactoring.getMappers()) {
                    this.processMethod(srcTree, dstTree, uMLOperationBodyMapper, mappingStore);
                }
                continue;
            }
            if (refactoring instanceof ExtractOperationRefactoring) {
                ExtractOperationRefactoring extractOperationRefactoring = (ExtractOperationRefactoring)refactoring;
                bodyMapper = extractOperationRefactoring.getBodyMapper();
                this.processBodyMapper(srcTree, dstTree, bodyMapper, mappingStore, true);
                this.processArgumentMappings(srcTree, dstTree, refactoringList, refactoring, extractOperationRefactoring.getArgumentMappings());
                continue;
            }
            if (refactoring instanceof InlineOperationRefactoring) {
                InlineOperationRefactoring inlineOperationRefactoring = (InlineOperationRefactoring)refactoring;
                bodyMapper = inlineOperationRefactoring.getBodyMapper();
                this.processBodyMapper(srcTree, dstTree, bodyMapper, mappingStore, false);
                this.processArgumentMappings(srcTree, dstTree, refactoringList, refactoring, inlineOperationRefactoring.getArgumentMappings());
                continue;
            }
            if (refactoring instanceof MoveCodeRefactoring) {
                MoveCodeRefactoring moveCodeRefactoring = (MoveCodeRefactoring)refactoring;
                bodyMapper = moveCodeRefactoring.getBodyMapper();
                this.processBodyMapper(srcTree, dstTree, bodyMapper, mappingStore, false);
                continue;
            }
            if (refactoring instanceof ParameterizeTestRefactoring) {
                ParameterizeTestRefactoring parameterizeTestRefactoring = (ParameterizeTestRefactoring)refactoring;
                bodyMapper = parameterizeTestRefactoring.getBodyMapper();
                this.processBodyMapper(srcTree, dstTree, bodyMapper, mappingStore, false);
                continue;
            }
            if (refactoring instanceof ExtractVariableRefactoring) {
                ExtractVariableRefactoring extractVariableRefactoring = (ExtractVariableRefactoring)refactoring;
                this.lastStepMappings.addAll(extractVariableRefactoring.getSubExpressionMappings());
                continue;
            }
            if (refactoring instanceof InlineVariableRefactoring) {
                InlineVariableRefactoring inlineVariableRefactoring = (InlineVariableRefactoring)refactoring;
                this.lastStepMappings.addAll(inlineVariableRefactoring.getSubExpressionMappings());
                continue;
            }
            if (refactoring instanceof AssertThrowsRefactoring) {
                AssertThrowsRefactoring assertThrowsRefactoring = (AssertThrowsRefactoring)refactoring;
                this.lastStepMappings.addAll(assertThrowsRefactoring.getSubExpressionMappings());
                continue;
            }
            if (refactoring instanceof InlineAttributeRefactoring) {
                InlineAttributeRefactoring inlineAttributeRefactoring = (InlineAttributeRefactoring)refactoring;
                Tree srcAttrDeclaration = TreeUtilFunctions.findByLocationInfo(srcTree, inlineAttributeRefactoring.getVariableDeclaration().getLocationInfo());
                for (AbstractCodeMapping reference : inlineAttributeRefactoring.getReferences()) {
                    Tree dstStatementTree = TreeUtilFunctions.findByLocationInfo(dstTree, reference.getFragment2().getLocationInfo());
                    new LeafMatcher().match(srcAttrDeclaration, dstStatementTree, mappingStore);
                }
                continue;
            }
            if (refactoring instanceof ExtractAttributeRefactoring) {
                ExtractAttributeRefactoring extractAttributeRefactoring = (ExtractAttributeRefactoring)refactoring;
                Tree dstAttrDeclaration = TreeUtilFunctions.findByLocationInfo(dstTree, extractAttributeRefactoring.getVariableDeclaration().getLocationInfo());
                for (AbstractCodeMapping reference : extractAttributeRefactoring.getReferences()) {
                    Tree srcStatementTree = TreeUtilFunctions.findByLocationInfo(srcTree, reference.getFragment1().getLocationInfo());
                    new LeafMatcher().match(srcStatementTree, dstAttrDeclaration, mappingStore);
                }
                for (UMLAnonymousClassDiff umlAnonymousClassDiff : extractAttributeRefactoring.getAnonymousClassDiffList()) {
                    this.processAnonymousClassDiff(srcTree, dstTree, umlAnonymousClassDiff, mappingStore);
                }
                continue;
            }
            if (refactoring instanceof MergeVariableRefactoring) {
                MergeVariableRefactoring mergeVariableRefactoring = (MergeVariableRefactoring)refactoring;
                Set<VariableDeclaration> mergedVariables = mergeVariableRefactoring.getMergedVariables();
                VariableDeclaration variableDeclaration2 = mergeVariableRefactoring.getNewVariable();
                Tree dstVariableDeclaration = TreeUtilFunctions.findByLocationInfo(dstTree, variableDeclaration2.getLocationInfo());
                if (dstVariableDeclaration == null) continue;
                List dstChildrenList = dstVariableDeclaration.getChildren();
                Tree dstVarName = (Tree)dstChildrenList.get(dstChildrenList.size() - 1);
                for (VariableDeclaration variableDeclaration22 : mergedVariables) {
                    Tree srcVariableDeclaration = TreeUtilFunctions.findByLocationInfo(srcTree, variableDeclaration22.getLocationInfo());
                    if (srcVariableDeclaration == null) continue;
                    List srcChildrenList = srcVariableDeclaration.getChildren();
                    Tree srcVarName = (Tree)srcChildrenList.get(srcChildrenList.size() - 1);
                    mappingStore.addMapping(srcVarName, dstVarName);
                }
                continue;
            }
            if (refactoring instanceof SplitConditionalRefactoring) {
                SplitConditionalRefactoring splitConditionalRefactoring = (SplitConditionalRefactoring)refactoring;
                this.lastStepMappings.addAll(splitConditionalRefactoring.getSubExpressionMappings());
                continue;
            }
            if (refactoring instanceof MergeConditionalRefactoring) {
                MergeConditionalRefactoring mergeConditionalRefactoring = (MergeConditionalRefactoring)refactoring;
                this.lastStepMappings.addAll(mergeConditionalRefactoring.getSubExpressionMappings());
                continue;
            }
            if (refactoring instanceof MergeCatchRefactoring) {
                MergeCatchRefactoring mergeCatchRefactoring = (MergeCatchRefactoring)refactoring;
                Tree dstSubTree = TreeUtilFunctions.findByLocationInfo(dstTree, mergeCatchRefactoring.getNewCatchBlock().getLocationInfo());
                for (AbstractCodeFragment eachMerged : mergeCatchRefactoring.getMergedCatchBlocks()) {
                    Tree srcSubTree = TreeUtilFunctions.findByLocationInfo(srcTree, eachMerged.getLocationInfo());
                    new GeneralMatcher(eachMerged, mergeCatchRefactoring.getNewCatchBlock()).match(srcSubTree, dstSubTree, mappingStore);
                }
                continue;
            }
            if (refactoring instanceof RenameVariableRefactoring) {
                RenameVariableRefactoring renameVariableRefactoring = (RenameVariableRefactoring)refactoring;
                VariableDeclaration originalVariable = renameVariableRefactoring.getOriginalVariable();
                VariableDeclaration variableDeclaration3 = renameVariableRefactoring.getRenamedVariable();
                Tree srcInput = TreeUtilFunctions.findByLocationInfo(srcTree, originalVariable.getLocationInfo());
                Tree dstInput = TreeUtilFunctions.findByLocationInfo(dstTree, variableDeclaration3.getLocationInfo());
                if (srcInput == null || dstInput == null) continue;
                boolean eligible = true;
                switch (renameVariableRefactoring.getRefactoringType()) {
                    case REPLACE_VARIABLE_WITH_ATTRIBUTE: {
                        srcInput = TreeUtilFunctions.getParentUntilType(srcInput, "VariableDeclarationStatement");
                        dstInput = TreeUtilFunctions.getParentUntilType(dstInput, "FieldDeclaration");
                        if (!mappingStore.isSrcMapped(srcInput) && !mappingStore.isDstMapped(dstInput)) break;
                        continue block8;
                    }
                    case REPLACE_ATTRIBUTE_WITH_VARIABLE: {
                        srcInput = TreeUtilFunctions.getParentUntilType(srcInput, "FieldDeclaration");
                        dstInput = TreeUtilFunctions.getParentUntilType(dstInput, "VariableDeclarationStatement");
                        if (!mappingStore.isSrcMapped(srcInput) && !mappingStore.isDstMapped(dstInput)) break;
                        continue block8;
                    }
                    case RENAME_PARAMETER: {
                        eligible = !renameVariableRefactoring.isInsideExtractedOrInlinedMethod();
                        break;
                    }
                    case RENAME_VARIABLE: {
                        Set<AbstractCodeMapping> references = renameVariableRefactoring.getReferences();
                        for (AbstractCodeMapping abstractCodeMapping : references) {
                            if (((RenameVariableRefactoring)refactoring).isInsideExtractedOrInlinedMethod() && this.multipleInstancesWithSameDescription(refactoringList, ((RenameVariableRefactoring)refactoring).getOperationBefore(), ((RenameVariableRefactoring)refactoring).getOperationAfter())) {
                                eligible = false;
                            }
                            if (!eligible || !(abstractCodeMapping instanceof LeafMapping)) continue;
                            this.findVariablesAndMatch(srcTree, dstTree, abstractCodeMapping, renameVariableRefactoring.getOriginalVariable().getVariableName(), renameVariableRefactoring.getRenamedVariable().getVariableName());
                        }
                        eligible = false;
                        break;
                    }
                    case PARAMETERIZE_VARIABLE: {
                        boolean bl = eligible = !renameVariableRefactoring.isInsideExtractedOrInlinedMethod();
                        if (!eligible) break;
                        while (!TreeUtilFunctions.isStatement(srcInput.getType().name) && srcInput.getType() != null) {
                            srcInput = srcInput.getParent();
                        }
                        if (TreeUtilFunctions.isStatement(srcInput.getType().name)) {
                            new LeafMatcher().match(srcInput, dstInput, mappingStore);
                        }
                        eligible = false;
                        break;
                    }
                    case LOCALIZE_PARAMETER: {
                        boolean bl = eligible = !renameVariableRefactoring.isInsideExtractedOrInlinedMethod();
                        if (!eligible) break;
                        while (!TreeUtilFunctions.isStatement(dstInput.getType().name) && dstInput.getType() != null) {
                            dstInput = dstInput.getParent();
                        }
                        if (TreeUtilFunctions.isStatement(dstInput.getType().name)) {
                            new LeafMatcher().match(srcInput, dstInput, mappingStore);
                        }
                        eligible = false;
                        break;
                    }
                    default: {
                        eligible = false;
                    }
                }
                if (!eligible) continue;
                new LeafMatcher().match(srcInput, dstInput, mappingStore);
                continue;
            }
            if (refactoring instanceof ModifyClassAnnotationRefactoring) {
                modifiedAnnotationRefactoring = (ModifyClassAnnotationRefactoring)refactoring;
                if (!((ModifyClassAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationBefore().getTypeName().equals(((ModifyClassAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter().getTypeName())) continue;
                ProjectASTDiffer.processModifiedAnnotation(srcTree, dstTree, mappingStore, ((ModifyClassAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationBefore(), ((ModifyClassAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter());
                continue;
            }
            if (refactoring instanceof ModifyMethodAnnotationRefactoring) {
                modifiedAnnotationRefactoring = (ModifyMethodAnnotationRefactoring)refactoring;
                if (!((ModifyMethodAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationBefore().getTypeName().equals(((ModifyMethodAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter().getTypeName())) continue;
                ProjectASTDiffer.processModifiedAnnotation(srcTree, dstTree, mappingStore, ((ModifyMethodAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationBefore(), ((ModifyMethodAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter());
                continue;
            }
            if (refactoring instanceof ModifyAttributeAnnotationRefactoring) {
                modifiedAnnotationRefactoring = (ModifyAttributeAnnotationRefactoring)refactoring;
                if (!((ModifyAttributeAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationBefore().getTypeName().equals(((ModifyAttributeAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter().getTypeName())) continue;
                ProjectASTDiffer.processModifiedAnnotation(srcTree, dstTree, mappingStore, ((ModifyAttributeAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationBefore(), ((ModifyAttributeAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter());
                continue;
            }
            if (!(refactoring instanceof ModifyVariableAnnotationRefactoring) || !((ModifyVariableAnnotationRefactoring)(modifiedAnnotationRefactoring = (ModifyVariableAnnotationRefactoring)refactoring)).getAnnotationBefore().getTypeName().equals(((ModifyVariableAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter().getTypeName())) continue;
            ProjectASTDiffer.processModifiedAnnotation(srcTree, dstTree, mappingStore, ((ModifyVariableAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationBefore(), ((ModifyVariableAnnotationRefactoring)modifiedAnnotationRefactoring).getAnnotationAfter());
        }
    }

    private void processArgumentMappings(Tree srcTree, Tree dstTree, List<Refactoring> refactoringList, Refactoring refactoring, List<AbstractCodeMapping> argumentMappings) {
        if (!ProjectASTDiffer.multipleInstancesWithSameDescription(refactoringList, refactoring)) {
            for (AbstractCodeMapping expressionMapping : argumentMappings) {
                Tree t1 = TreeUtilFunctions.findByLocationInfo(srcTree, expressionMapping.getFragment1().getLocationInfo());
                Tree t2 = TreeUtilFunctions.findByLocationInfo(dstTree, expressionMapping.getFragment2().getLocationInfo());
                new LeafMatcher().match(t1, t2, this.optimizationMappingStore);
            }
        }
    }

    private boolean multipleInstancesWithSameDescription(List<Refactoring> refactoringList, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter) {
        int counter1 = 0;
        int counter2 = 0;
        for (Refactoring r : refactoringList) {
            if (r.getRefactoringType().equals((Object)RefactoringType.EXTRACT_OPERATION)) {
                if (!((ExtractOperationRefactoring)r).getExtractedOperation().equals(operationAfter)) continue;
                ++counter1;
                continue;
            }
            if (!r.getRefactoringType().equals((Object)RefactoringType.INLINE_OPERATION) || !((InlineOperationRefactoring)r).getInlinedOperation().equals(operationBefore)) continue;
            ++counter2;
        }
        return counter1 > 1 || counter2 > 1;
    }

    private static void processModifiedAnnotation(Tree srcTree, Tree dstTree, ExtendedMultiMappingStore mappingStore, UMLAnnotation annotationBefore, UMLAnnotation annotationAfter) {
        Tree dstAnnotationTree;
        Tree srcAnnotationTree = TreeUtilFunctions.findByLocationInfo(srcTree, annotationBefore.getLocationInfo());
        if (srcAnnotationTree != null & (dstAnnotationTree = TreeUtilFunctions.findByLocationInfo(dstTree, annotationAfter.getLocationInfo())) != null) {
            new BasicTreeMatcher().match(srcAnnotationTree, dstAnnotationTree, mappingStore);
        }
        mappingStore.addMapping(srcAnnotationTree, dstAnnotationTree);
    }

    private void findVariablesAndMatch(Tree srcTree, Tree dstTree, AbstractCodeMapping abstractCodeMapping, String originalVariableName, String renamedVariableName) {
        Tree srcStatement = TreeUtilFunctions.findByLocationInfo(srcTree, abstractCodeMapping.getFragment1().getLocationInfo());
        Tree dstStatement = TreeUtilFunctions.findByLocationInfo(dstTree, abstractCodeMapping.getFragment2().getLocationInfo());
        List<Tree> srcRefs = TreeUtilFunctions.findVariable(srcStatement, originalVariableName);
        List<Tree> dstRefs = TreeUtilFunctions.findVariable(dstStatement, renamedVariableName);
        if (srcRefs == null || dstRefs == null) {
            return;
        }
        if (srcRefs.size() == 1 && dstRefs.size() == 1) {
            this.optimizationMappingStore.addMapping(srcRefs.get(0), dstRefs.get(0));
        } else if (srcRefs.size() == dstRefs.size()) {
            for (int i = 0; i < srcRefs.size(); ++i) {
                this.optimizationMappingStore.addMapping(srcRefs.get(i), dstRefs.get(i));
            }
        }
    }

    private void processClassImplementedInterfaces(Tree srcTree, Tree dstTree, UMLClassBaseDiff classDiff, ExtendedMultiMappingStore mappingStore) {
        List<UMLType> srcImplementedInterfaces = classDiff.getOriginalClass().getImplementedInterfaces();
        List<UMLType> dstImplementedInterfaces = classDiff.getNextClass().getImplementedInterfaces();
        List<UMLType> removedOnes = classDiff.getRemovedImplementedInterfaces();
        block0: for (UMLType srcUmlType : srcImplementedInterfaces) {
            if (removedOnes.contains(srcUmlType)) continue;
            Tree srcInterfaceTree = TreeUtilFunctions.findByLocationInfo(srcTree, srcUmlType.getLocationInfo());
            for (UMLType dstUmlType : dstImplementedInterfaces) {
                if (!dstUmlType.getClassType().equals(srcUmlType.getClassType())) continue;
                Tree dstInterfaceTree = TreeUtilFunctions.findByLocationInfo(dstTree, dstUmlType.getLocationInfo());
                mappingStore.addMappingRecursively(srcInterfaceTree, dstInterfaceTree);
                continue block0;
            }
        }
    }

    private void processClassAttributes(Tree srcTree, Tree dstTree, UMLAbstractClassDiff classDiff, ExtendedMultiMappingStore mappingStore) {
        Set<org.apache.commons.lang3.tuple.Pair<UMLAttribute, UMLAttribute>> pairs = classDiff.getCommonAtrributes();
        for (org.apache.commons.lang3.tuple.Pair<UMLAttribute, UMLAttribute> pair : pairs) {
            this.processFieldDeclaration(srcTree, dstTree, (UMLAttribute)pair.getLeft(), (UMLAttribute)pair.getRight(), mappingStore);
        }
        List<UMLAttributeDiff> attributeDiffList = classDiff.getAttributeDiffList();
        for (UMLAttributeDiff umlAttributeDiff : attributeDiffList) {
            this.processFieldDeclarationByAttrDiff(srcTree, dstTree, umlAttributeDiff, mappingStore);
        }
        List<UMLEnumConstantDiff> list = classDiff.getEnumConstantDiffList();
        for (UMLEnumConstantDiff enumConstantDiff : list) {
            this.processFieldDeclarationByEnumConstantDiff(srcTree, dstTree, enumConstantDiff, mappingStore);
        }
    }

    private void processFieldDeclarationByAttrDiff(Tree srcTree, Tree dstTree, UMLAttributeDiff umlAttributeDiff, ExtendedMultiMappingStore mappingStore) {
        this.processFieldDeclaration(srcTree, dstTree, umlAttributeDiff.getRemovedAttribute(), umlAttributeDiff.getAddedAttribute(), mappingStore);
        if (umlAttributeDiff.getInitializerMapper().isPresent()) {
            UMLOperationBodyMapper umlOperationBodyMapper = umlAttributeDiff.getInitializerMapper().get();
            this.processMethod(srcTree, dstTree, umlOperationBodyMapper, mappingStore);
        }
    }

    private void processFieldDeclarationByEnumConstantDiff(Tree srcTree, Tree dstTree, UMLEnumConstantDiff umlEnumConstantDiff, ExtendedMultiMappingStore mappingStore) {
        this.processFieldDeclaration(srcTree, dstTree, umlEnumConstantDiff.getRemovedEnumConstant(), umlEnumConstantDiff.getAddedEnumConstant(), mappingStore);
        if (umlEnumConstantDiff.getAnonymousClassDiff().isPresent()) {
            UMLAnonymousClassDiff anonymousClassDiff = umlEnumConstantDiff.getAnonymousClassDiff().get();
            this.processAnonymousClassDiff(srcTree, dstTree, anonymousClassDiff, mappingStore);
        }
    }

    private void processAnonymousClassDiff(Tree srcTree, Tree dstTree, UMLAnonymousClassDiff anonymousClassDiff, ExtendedMultiMappingStore mappingStore) {
        List<UMLOperationBodyMapper> operationBodyMapperList = anonymousClassDiff.getOperationBodyMapperList();
        for (UMLOperationBodyMapper umlOperationBodyMapper : operationBodyMapperList) {
            this.processMethod(srcTree, dstTree, umlOperationBodyMapper, mappingStore);
        }
    }

    private void processFieldDeclaration(Tree srcTree, Tree dstTree, UMLAttribute srcUMLAttribute, UMLAttribute dstUMLAttribute, ExtendedMultiMappingStore mappingStore) {
        Tree srcAttr = TreeUtilFunctions.findByLocationInfo(srcTree, srcUMLAttribute.getLocationInfo());
        Tree dstAttr = TreeUtilFunctions.findByLocationInfo(dstTree, dstUMLAttribute.getLocationInfo());
        if (srcAttr == null || dstAttr == null) {
            return;
        }
        Tree srcFieldDeclaration = TreeUtilFunctions.getParentUntilType(srcAttr, "FieldDeclaration");
        Tree dstFieldDeclaration = TreeUtilFunctions.getParentUntilType(dstAttr, "FieldDeclaration");
        if (srcFieldDeclaration == null) {
            srcFieldDeclaration = TreeUtilFunctions.getParentUntilType(srcAttr, "EnumConstantDeclaration");
        }
        if (dstFieldDeclaration == null) {
            dstFieldDeclaration = TreeUtilFunctions.getParentUntilType(dstAttr, "EnumConstantDeclaration");
        }
        if (srcFieldDeclaration != null && dstFieldDeclaration != null && srcFieldDeclaration.getMetrics().hash == dstFieldDeclaration.getMetrics().hash) {
            mappingStore.addMappingRecursively(srcFieldDeclaration, dstFieldDeclaration);
            return;
        }
        if (srcAttr.getMetrics().hash == dstAttr.getMetrics().hash) {
            mappingStore.addMappingRecursively(srcAttr, dstAttr);
        }
        mappingStore.addMapping(srcFieldDeclaration, dstFieldDeclaration);
        this.matchFieldAllModifiers(srcFieldDeclaration, dstFieldDeclaration, srcUMLAttribute, dstUMLAttribute, mappingStore);
        if ((srcUMLAttribute.getType().getLocationInfo() == null || dstUMLAttribute.getType().getLocationInfo() == null) && srcUMLAttribute instanceof UMLEnumConstant && dstUMLAttribute instanceof UMLEnumConstant) {
            new LeafMatcher().match(srcAttr, dstAttr, mappingStore);
            return;
        }
        Tree srcType = TreeUtilFunctions.findByLocationInfo(srcTree, srcUMLAttribute.getType().getLocationInfo());
        Tree dstType = TreeUtilFunctions.findByLocationInfo(dstTree, dstUMLAttribute.getType().getLocationInfo());
        if (srcType != null && dstType != null && srcType.isIsoStructuralTo(dstType)) {
            mappingStore.addMappingRecursively(srcType, dstType);
        } else {
            new LeafMatcher().match(srcType, dstType, mappingStore);
        }
        Tree srcVarDeclaration = TreeUtilFunctions.findByLocationInfo(srcTree, srcUMLAttribute.getVariableDeclaration().getLocationInfo());
        Tree dstVarDeclaration = TreeUtilFunctions.findByLocationInfo(dstTree, dstUMLAttribute.getVariableDeclaration().getLocationInfo());
        mappingStore.addMapping(srcVarDeclaration, dstVarDeclaration);
        new LeafMatcher().match(srcVarDeclaration, dstVarDeclaration, mappingStore);
        this.processJavaDocs(srcTree, dstTree, srcUMLAttribute.getJavadoc(), dstUMLAttribute.getJavadoc(), mappingStore);
        if (srcVarDeclaration != null && dstVarDeclaration != null) {
            mappingStore.addMapping(srcVarDeclaration.getChild(0), dstVarDeclaration.getChild(0));
        }
    }

    private void matchFieldAllModifiers(Tree srcFieldDeclaration, Tree dstFieldDeclaration, UMLAttribute srcUMLAttribute, UMLAttribute dstUMLAttribute, ExtendedMultiMappingStore mappingStore) {
        this.matchModifiersForField(srcFieldDeclaration, dstFieldDeclaration, srcUMLAttribute.getVisibility().toString(), dstUMLAttribute.getVisibility().toString(), mappingStore);
        if (srcUMLAttribute.isFinal() && dstUMLAttribute.isFinal()) {
            this.matchModifierForField(srcFieldDeclaration, dstFieldDeclaration, "final", mappingStore);
        }
        if (srcUMLAttribute.isVolatile() && dstUMLAttribute.isVolatile()) {
            this.matchModifierForField(srcFieldDeclaration, dstFieldDeclaration, "volatile", mappingStore);
        }
        if (srcUMLAttribute.isStatic() && dstUMLAttribute.isStatic()) {
            this.matchModifierForField(srcFieldDeclaration, dstFieldDeclaration, "static", mappingStore);
        }
        if (srcUMLAttribute.isTransient() && dstUMLAttribute.isTransient()) {
            this.matchModifierForField(srcFieldDeclaration, dstFieldDeclaration, "transient", mappingStore);
        }
    }

    private void matchModifiersForField(Tree srcFieldDeclaration, Tree dstFieldDeclaration, String srcModifier, String dstModifier, ExtendedMultiMappingStore mappingStore) {
        Tree srcModifierTree = this.findAttributeModifierByLabel(srcFieldDeclaration, srcModifier);
        Tree dstModifierTree = this.findAttributeModifierByLabel(dstFieldDeclaration, dstModifier);
        if (srcModifierTree != null && dstModifierTree != null) {
            mappingStore.addMapping(srcModifierTree, dstModifierTree);
        }
    }

    private void matchModifierForField(Tree srcFieldDeclaration, Tree dstFieldDeclaration, String modifier, ExtendedMultiMappingStore mappingStore) {
        Tree srcModifierTree = this.findAttributeModifierByLabel(srcFieldDeclaration, modifier);
        Tree dstModifierTree = this.findAttributeModifierByLabel(dstFieldDeclaration, modifier);
        if (srcModifierTree != null && dstModifierTree != null) {
            mappingStore.addMapping(srcModifierTree, dstModifierTree);
        }
    }

    private Tree findAttributeModifierByLabel(Tree anyFieldDeclaration, String label) {
        if (anyFieldDeclaration.getChildren().size() > 0) {
            for (Tree child : anyFieldDeclaration.getChildren()) {
                if (child.getLabel().equals(label)) {
                    return child;
                }
                if (!child.getType().name.equals("VariableDeclarationFragment")) continue;
                break;
            }
        }
        return null;
    }

    private void processSuperClass(Tree srcTree, Tree dstTree, UMLClassBaseDiff classDiff, ExtendedMultiMappingStore mappingStore) {
        UMLType srcParentUML = classDiff.getOldSuperclass();
        UMLType dstParentUML = classDiff.getNewSuperclass();
        if (srcParentUML != null && dstParentUML != null) {
            Tree srcParentClassTree = TreeUtilFunctions.findByLocationInfo(srcTree, srcParentUML.getLocationInfo());
            Tree dstParentClassTree = TreeUtilFunctions.findByLocationInfo(dstTree, dstParentUML.getLocationInfo());
            if (srcParentClassTree != null && dstParentClassTree != null && srcParentClassTree.isIsoStructuralTo(dstParentClassTree)) {
                mappingStore.addMappingRecursively(srcParentClassTree, dstParentClassTree);
            }
        }
    }

    private void processPackageDeclaration(Tree srcTree, Tree dstTree, ExtendedMultiMappingStore mappingStore) {
        Tree srcPackageDeclaration = this.findPackageDeclaration(srcTree);
        Tree dstPackageDeclaration = this.findPackageDeclaration(dstTree);
        if (srcPackageDeclaration != null && dstPackageDeclaration != null) {
            mappingStore.addMappingRecursively(srcPackageDeclaration, dstPackageDeclaration);
        }
    }

    private Tree findPackageDeclaration(Tree inputTree) {
        String searchingType = "PackageDeclaration";
        if (!inputTree.getChildren().isEmpty()) {
            List children = inputTree.getChildren();
            for (Tree child : children) {
                if (!child.getType().name.equals(searchingType)) continue;
                return child;
            }
        }
        return null;
    }

    private void processImports(Tree srcTree, Tree dstTree, UMLImportListDiff importDiffList, ExtendedMultiMappingStore mappingStore) {
        Tree dstImportStatement;
        Tree srcImportStatement;
        if (importDiffList == null) {
            return;
        }
        Set<org.apache.commons.lang3.tuple.Pair<UMLImport, UMLImport>> commonImports = importDiffList.getCommonImports();
        String searchingType = "ImportDeclaration";
        if (!commonImports.isEmpty()) {
            for (org.apache.commons.lang3.tuple.Pair pair : commonImports) {
                srcImportStatement = this.findImportByTypeAndLabel(srcTree, searchingType, (UMLImport)pair.getLeft());
                dstImportStatement = this.findImportByTypeAndLabel(dstTree, searchingType, (UMLImport)pair.getRight());
                if (srcImportStatement == null || dstImportStatement == null) continue;
                mappingStore.addMappingRecursively(srcImportStatement, dstImportStatement);
            }
        }
        for (Map.Entry entry : importDiffList.getGroupedImports().entrySet()) {
            Set srcImportSet = (Set)entry.getKey();
            UMLImport dstImport = (UMLImport)entry.getValue();
            Tree dstImportStatement2 = this.findImportByTypeAndLabel(dstTree, searchingType, dstImport);
            for (UMLImport srcUMLImport : srcImportSet) {
                Tree srcImportStatement2 = this.findImportByTypeAndLabel(srcTree, searchingType, srcUMLImport);
                mappingStore.addMappingRecursively(srcImportStatement2, dstImportStatement2);
            }
        }
        for (Map.Entry entry : importDiffList.getUnGroupedImports().entrySet()) {
            UMLImport srcImport = (UMLImport)entry.getKey();
            Set dstImportSet = (Set)entry.getValue();
            Tree srcImportStatement3 = this.findImportByTypeAndLabel(srcTree, searchingType, srcImport);
            for (UMLImport dstUMLImport : dstImportSet) {
                Tree dstImportStatement3 = this.findImportByTypeAndLabel(dstTree, searchingType, dstUMLImport);
                mappingStore.addMappingRecursively(srcImportStatement3, dstImportStatement3);
            }
        }
        for (org.apache.commons.lang3.tuple.Pair pair : importDiffList.getChangedImports()) {
            srcImportStatement = this.findImportByTypeAndLabel(srcTree, searchingType, (UMLImport)pair.getLeft());
            dstImportStatement = this.findImportByTypeAndLabel(dstTree, searchingType, (UMLImport)pair.getRight());
            mappingStore.addMappingRecursively(srcImportStatement, dstImportStatement);
        }
    }

    private Tree findImportByTypeAndLabel(Tree inputTree, String searchingType, UMLImport label) {
        for (Tree treeNode : inputTree.getChildren()) {
            if (!treeNode.getType().name.equals(searchingType) || !treeNode.getChild(0).getLabel().equals(label.getName()) || treeNode.getPos() != label.getLocationInfo().getStartOffset()) continue;
            if (label.isOnDemand()) {
                if (treeNode.getChild(0).getEndPos() + 3 != treeNode.getEndPos()) continue;
                return treeNode;
            }
            return treeNode;
        }
        return null;
    }

    private void processMethodSignature(Tree srcOperationNode, Tree dstOperationNode, UMLOperationBodyMapper umlOperationBodyMapper, ExtendedMultiMappingStore mappingStore) {
        if (srcOperationNode == null || dstOperationNode == null) {
            return;
        }
        ArrayList<String> searchingTypes = new ArrayList<String>();
        searchingTypes.add("SimpleName");
        searchingTypes.add("PrimitiveType");
        searchingTypes.add("Block");
        for (String type : searchingTypes) {
            Pair<Tree, Tree> matched = this.matchBasedOnType(srcOperationNode, dstOperationNode, type);
            if (matched == null) continue;
            mappingStore.addMapping((Tree)matched.first, (Tree)matched.second);
        }
        if (umlOperationBodyMapper.getOperation1() != null && umlOperationBodyMapper.getOperation2() != null) {
            if (umlOperationBodyMapper.getOperation1().isStatic() && umlOperationBodyMapper.getOperation2().isStatic()) {
                this.matchModifier(srcOperationNode, dstOperationNode, "static", mappingStore);
            }
            if (umlOperationBodyMapper.getOperation1().isFinal() && umlOperationBodyMapper.getOperation2().isFinal()) {
                this.matchModifier(srcOperationNode, dstOperationNode, "final", mappingStore);
            }
            if (umlOperationBodyMapper.getOperation1().isAbstract() && umlOperationBodyMapper.getOperation2().isAbstract()) {
                this.matchModifier(srcOperationNode, dstOperationNode, "abstract", mappingStore);
            }
            if (umlOperationBodyMapper.getOperation1().isSynchronized() && umlOperationBodyMapper.getOperation2().isSynchronized()) {
                this.matchModifier(srcOperationNode, dstOperationNode, "synchronized", mappingStore);
            }
            if (umlOperationBodyMapper.getOperation1().isNative() && umlOperationBodyMapper.getOperation2().isNative()) {
                this.matchModifier(srcOperationNode, dstOperationNode, "native", mappingStore);
            }
            String v1 = umlOperationBodyMapper.getOperation1().getVisibility().toString();
            String v2 = umlOperationBodyMapper.getOperation2().getVisibility().toString();
            Tree tree1 = TreeUtilFunctions.findChildByTypeAndLabel(srcOperationNode, "Modifier", v1);
            Tree tree2 = TreeUtilFunctions.findChildByTypeAndLabel(dstOperationNode, "Modifier", v2);
            if (tree1 != null && tree2 != null) {
                mappingStore.addMappingRecursively(tree1, tree2);
            }
        }
    }

    private Pair<Tree, Tree> matchBasedOnType(Tree srcOperationNode, Tree dstOperationNode, String searchingType) {
        if (srcOperationNode == null || dstOperationNode == null) {
            return null;
        }
        Tree srcModifier = TreeUtilFunctions.findChildByType(srcOperationNode, searchingType);
        Tree dstModifier = TreeUtilFunctions.findChildByType(dstOperationNode, searchingType);
        if (srcModifier != null && dstModifier != null) {
            return new Pair((Object)srcModifier, (Object)dstModifier);
        }
        return null;
    }

    private void processClassDeclarationMapping(Tree srcTree, Tree dstTree, UMLClassBaseDiff classDiff, ExtendedMultiMappingStore mappingStore) {
        String AST_type = "TypeDeclaration";
        if (classDiff.getOriginalClass().isEnum()) {
            AST_type = "EnumDeclaration";
        }
        Tree srcTypeDeclaration = TreeUtilFunctions.findByLocationInfo(srcTree, classDiff.getOriginalClass().getLocationInfo(), AST_type);
        Tree dstTypeDeclaration = TreeUtilFunctions.findByLocationInfo(dstTree, classDiff.getNextClass().getLocationInfo(), AST_type);
        if (srcTypeDeclaration == null || dstTypeDeclaration == null) {
            return;
        }
        if (srcTypeDeclaration.getParent() != null && dstTypeDeclaration.getParent() != null && srcTypeDeclaration.getParent().getType().name.equals("TypeDeclarationStatement") && dstTypeDeclaration.getParent().getType().name.equals("TypeDeclarationStatement")) {
            mappingStore.addMapping(srcTypeDeclaration.getParent(), dstTypeDeclaration.getParent());
        }
        mappingStore.addMapping(srcTypeDeclaration, dstTypeDeclaration);
        String v1 = classDiff.getOriginalClass().getVisibility().toString();
        String v2 = classDiff.getNextClass().getVisibility().toString();
        Tree tree1 = TreeUtilFunctions.findChildByTypeAndLabel(srcTypeDeclaration, "Modifier", v1);
        Tree tree2 = TreeUtilFunctions.findChildByTypeAndLabel(dstTypeDeclaration, "Modifier", v2);
        if (tree1 != null && tree2 != null) {
            mappingStore.addMappingRecursively(tree1, tree2);
        }
        ArrayList<String> searchingTypes = new ArrayList<String>();
        searchingTypes.add("SimpleName");
        searchingTypes.add("TYPE_DECLARATION_KIND");
        for (String string : searchingTypes) {
            Pair<Tree, Tree> matched = this.matchBasedOnType(srcTypeDeclaration, dstTypeDeclaration, string);
            if (matched == null) continue;
            mappingStore.addMapping((Tree)matched.first, (Tree)matched.second);
        }
        if (classDiff.getOriginalClass().isStatic() && classDiff.getNextClass().isStatic()) {
            this.matchModifier(srcTypeDeclaration, dstTypeDeclaration, "static", mappingStore);
        }
        if (classDiff.getOriginalClass().isFinal() && classDiff.getNextClass().isFinal()) {
            this.matchModifier(srcTypeDeclaration, dstTypeDeclaration, "final", mappingStore);
        }
        if (classDiff.getOriginalClass().isAbstract() && classDiff.getNextClass().isAbstract()) {
            this.matchModifier(srcTypeDeclaration, dstTypeDeclaration, "abstract", mappingStore);
        }
        for (org.apache.commons.lang3.tuple.Pair pair : classDiff.getTypeParameterDiffList().getCommonTypeParameters()) {
            Tree srcTypeParam = TreeUtilFunctions.findByLocationInfo(srcTypeDeclaration, ((UMLTypeParameter)pair.getLeft()).getLocationInfo());
            Tree dstTypeParam = TreeUtilFunctions.findByLocationInfo(dstTypeDeclaration, ((UMLTypeParameter)pair.getRight()).getLocationInfo());
            mappingStore.addMappingRecursively(srcTypeParam, dstTypeParam);
        }
        this.processSuperClass(srcTypeDeclaration, dstTypeDeclaration, classDiff, mappingStore);
        this.processClassImplementedInterfaces(srcTypeDeclaration, dstTypeDeclaration, classDiff, mappingStore);
        this.processJavaDocs(srcTypeDeclaration, dstTypeDeclaration, classDiff.getOriginalClass().getJavadoc(), classDiff.getNextClass().getJavadoc(), mappingStore);
        this.processClassAnnotations(srcTypeDeclaration, dstTypeDeclaration, classDiff.getAnnotationListDiff(), mappingStore);
    }

    private void matchModifier(Tree srcTypeDeclaration, Tree dstTypeDeclaration, String modifier, ExtendedMultiMappingStore mappingStore) {
        String type = "Modifier";
        Tree srcTree = TreeUtilFunctions.findChildByTypeAndLabel(srcTypeDeclaration, type, modifier);
        Tree dstTree = TreeUtilFunctions.findChildByTypeAndLabel(dstTypeDeclaration, type, modifier);
        if (srcTree != null && dstTree != null) {
            mappingStore.addMapping(srcTree, dstTree);
        }
    }

    private static class OptimizationData {
        List<AbstractCodeMapping> lastStepMappings;
        ExtendedMultiMappingStore optimizationMappingStore;

        public OptimizationData(List<AbstractCodeMapping> lastStepMappings, ExtendedMultiMappingStore optimizationMappingStore) {
            this.lastStepMappings = lastStepMappings;
            this.optimizationMappingStore = optimizationMappingStore;
        }
    }
}

