/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.tree.Tree;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MappingExportModel
implements Serializable {
    String firstType;
    String secondType;
    String firstLabel;
    String secondLabel;
    String firstParentType;
    String secondParentType;
    int firstPos;
    int secondPos;
    int firstEndPos;
    int secondEndPos;
    @JsonIgnore
    int firstHash;
    @JsonIgnore
    int secondHash;

    MappingExportModel() {
    }

    public MappingExportModel(String firstType, String firstLabel, int firstPos, int firstEndPos, int firstHash, String firstParentType, String secondType, String secondLabel, int secondPos, int secondEndPos, int secondHash, String secondParentType) {
        this.firstType = firstType;
        this.secondType = secondType;
        this.firstLabel = firstLabel;
        this.secondLabel = secondLabel;
        this.firstPos = firstPos;
        this.secondPos = secondPos;
        this.firstEndPos = firstEndPos;
        this.secondEndPos = secondEndPos;
        this.firstHash = firstHash;
        this.secondHash = secondHash;
        this.firstParentType = firstParentType;
        this.secondParentType = secondParentType;
    }

    public int getFirstHash() {
        return this.firstHash;
    }

    public int getSecondHash() {
        return this.secondHash;
    }

    public void setFirstHash(int firstHash) {
        this.firstHash = firstHash;
    }

    public void setSecondHash(int secondHash) {
        this.secondHash = secondHash;
    }

    public String getFirstType() {
        return this.firstType;
    }

    public void setFirstType(String firstType) {
        this.firstType = firstType;
    }

    public String getSecondType() {
        return this.secondType;
    }

    public void setSecondType(String secondType) {
        this.secondType = secondType;
    }

    public String getFirstLabel() {
        return this.firstLabel;
    }

    public void setFirstLabel(String firstLabel) {
        this.firstLabel = firstLabel;
    }

    public String getSecondLabel() {
        return this.secondLabel;
    }

    public void setSecondLabel(String secondLabel) {
        this.secondLabel = secondLabel;
    }

    public int getFirstPos() {
        return this.firstPos;
    }

    public void setFirstPos(int firstPos) {
        this.firstPos = firstPos;
    }

    public int getSecondPos() {
        return this.secondPos;
    }

    public void setSecondPos(int secondPos) {
        this.secondPos = secondPos;
    }

    public int getFirstEndPos() {
        return this.firstEndPos;
    }

    public void setFirstEndPos(int firstEndPos) {
        this.firstEndPos = firstEndPos;
    }

    public int getSecondEndPos() {
        return this.secondEndPos;
    }

    public void setSecondEndPos(int secondEndPos) {
        this.secondEndPos = secondEndPos;
    }

    public String getFirstParentType() {
        return this.firstParentType;
    }

    public void setFirstParentType(String firstParentType) {
        this.firstParentType = firstParentType;
    }

    public String getSecondParentType() {
        return this.secondParentType;
    }

    public void setSecondParentType(String secondParentType) {
        this.secondParentType = secondParentType;
    }

    public String toString() {
        return "MappingExportModel{firstType='" + this.firstType + "', secondType='" + this.secondType + "', firstLabel='" + this.firstLabel + "', secondLabel='" + this.secondLabel + "', firstParentType='" + this.firstParentType + "', secondParentType='" + this.secondParentType + "', firstPos=" + this.firstPos + ", secondPos=" + this.secondPos + ", firstEndPos=" + this.firstEndPos + ", secondEndPos=" + this.secondEndPos + ", firstHash=" + this.firstHash + ", secondHash=" + this.secondHash + "}";
    }

    public static List<MappingExportModel> exportModelList(Iterable<Mapping> mappings) {
        ArrayList<MappingExportModel> exportList = new ArrayList<MappingExportModel>();
        for (Mapping mapping : mappings) {
            MappingExportModel mappingExportModel = new MappingExportModel(((Tree)mapping.first).getType().name, ((Tree)mapping.first).getLabel(), ((Tree)mapping.first).getPos(), ((Tree)mapping.first).getEndPos(), ((Tree)mapping.first).hashCode(), ((Tree)mapping.first).getParent() == null ? "" : ((Tree)mapping.first).getParent().getType().name, ((Tree)mapping.second).getType().name, ((Tree)mapping.second).getLabel(), ((Tree)mapping.second).getPos(), ((Tree)mapping.second).getEndPos(), ((Tree)mapping.second).hashCode(), ((Tree)mapping.second).getParent() == null ? "" : ((Tree)mapping.second).getParent().getType().name);
            exportList.add(mappingExportModel);
        }
        exportList.sort(Comparator.comparing(MappingExportModel::getFirstPos).thenComparing(exportModel -> -1 * exportModel.getFirstEndPos()).thenComparing(MappingExportModel::getFirstType).thenComparing(MappingExportModel::getSecondPos).thenComparing(MappingExportModel::getFirstParentType).thenComparing(MappingExportModel::getSecondParentType));
        return exportList;
    }

    public static String exportString(Iterable<Mapping> mappings) throws JsonProcessingException {
        List<MappingExportModel> mappingExportModels = MappingExportModel.exportModelList(mappings);
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(mappingExportModels);
    }

    public static void exportToFile(File outputFile, Iterable<Mapping> mappings) throws IOException {
        List<MappingExportModel> mappingExportModels = MappingExportModel.exportModelList(mappings);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, mappingExportModels);
    }
}

