/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.astDiff.utils;

import com.github.gumtreediff.io.TreeIoUtils;
import com.github.gumtreediff.matchers.Mapping;
import com.github.gumtreediff.tree.DefaultTree;
import com.github.gumtreediff.tree.FakeTree;
import com.github.gumtreediff.tree.Tree;
import com.github.gumtreediff.tree.TreeContext;
import com.github.gumtreediff.utils.Pair;
import gr.uom.java.xmi.LocationInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class TreeUtilFunctions {
    private static FakeTree _instance;

    public static Tree findByLocationInfo(Tree tree, LocationInfo locationInfo) {
        int endoffset;
        int startoffset = locationInfo.getStartOffset();
        Tree treeBetweenPositions = TreeUtilFunctions.getTreeBetweenPositions(tree, startoffset, endoffset = locationInfo.getEndOffset());
        if (treeBetweenPositions == null) {
            return null;
        }
        if (treeBetweenPositions.getType().name.equals("METHOD_INVOCATION_ARGUMENTS")) {
            if (treeBetweenPositions.getChildren().size() > 0) {
                if (treeBetweenPositions.getChild(0).getPos() == startoffset && treeBetweenPositions.getChild(0).getEndPos() == endoffset) {
                    return treeBetweenPositions.getChild(0);
                }
                return treeBetweenPositions;
            }
            return treeBetweenPositions;
        }
        return treeBetweenPositions;
    }

    public static Tree findByLocationInfo(Tree tree, LocationInfo locationInfo, String type) {
        int startoffset = locationInfo.getStartOffset();
        int endoffset = locationInfo.getEndOffset();
        return TreeUtilFunctions.getTreeBetweenPositions(tree, startoffset, endoffset, type);
    }

    public static Tree getTreeBetweenPositions(Tree tree, int position, int endPosition) {
        for (Tree t : tree.preOrder()) {
            if (t.getPos() < position || t.getEndPos() > endPosition) continue;
            return t;
        }
        return null;
    }

    public static Tree getTreeBetweenPositions(Tree tree, int position, int endPosition, String type) {
        for (Tree t : tree.preOrder()) {
            if (t.getPos() < position || t.getEndPos() > endPosition || !t.getType().name.equals(type)) continue;
            return t;
        }
        return null;
    }

    public static Tree getTreeBetweenPositionsSecure(Tree tree, int position, int endPosition, String type, String parentType, String label) {
        for (Tree t : tree.preOrder()) {
            String t_parentType;
            if (t.getPos() != position || t.getEndPos() != endPosition || !t.getType().name.equals(type) || !t.getLabel().equals(label) || !(t_parentType = t.getParent() != null ? t.getParent().getType().name : "").equals(parentType)) continue;
            return t;
        }
        return null;
    }

    public static Tree findChildByType(Tree tree, String type) {
        if (!tree.getChildren().isEmpty()) {
            for (Tree child : tree.getChildren()) {
                if (!child.getType().name.equals(type)) continue;
                return child;
            }
        }
        return null;
    }

    public static Tree findChildByTypeAndLabel(Tree tree, String type, String label) {
        if (!tree.getChildren().isEmpty()) {
            for (Tree child : tree.getChildren()) {
                if (!child.getType().name.equals(type) || !child.getLabel().equals(label)) continue;
                return child;
            }
        }
        return null;
    }

    public static Pair<Tree, Tree> pruneTrees(Tree src, Tree dst, Map<Tree, Tree> srcCopy, Map<Tree, Tree> dstCopy) {
        Tree prunedSrc = TreeUtilFunctions.deepCopyWithMapPruning(src, srcCopy);
        Tree prunedDst = TreeUtilFunctions.deepCopyWithMapPruning(dst, dstCopy);
        return new Pair((Object)prunedSrc, (Object)prunedDst);
    }

    public static Tree deepCopyWithMapPruning(Tree tree, Map<Tree, Tree> cpyMap) {
        if (tree.getType().name.equals("Block") && tree.getChildren().size() != 0) {
            return null;
        }
        DefaultTree copy = TreeUtilFunctions.makeDefaultTree(tree);
        cpyMap.put((Tree)copy, tree);
        if (tree.getType().name.equals("AnonymousClassDeclaration")) {
            return copy;
        }
        for (Tree child : tree.getChildren()) {
            Tree childCopy = TreeUtilFunctions.deepCopyWithMapPruning(child, cpyMap);
            if (childCopy == null) continue;
            copy.addChild(childCopy);
        }
        if (copy.getChildren().size() == 0) {
            copy.setParent(tree.getParent());
        }
        return copy;
    }

    public static DefaultTree makeDefaultTree(Tree other) {
        DefaultTree defaultTree = new DefaultTree(null);
        defaultTree.setType(other.getType());
        defaultTree.setLabel(other.getLabel());
        defaultTree.setPos(other.getPos());
        defaultTree.setLength(other.getLength());
        defaultTree.setChildren(new ArrayList());
        defaultTree.setMetrics(other.getMetrics());
        return defaultTree;
    }

    public static Tree deepCopyWithMap(Tree tree, Map<Tree, Tree> cpyMap) {
        DefaultTree copy = TreeUtilFunctions.makeDefaultTree(tree);
        cpyMap.put((Tree)copy, tree);
        for (Tree child : tree.getChildren()) {
            copy.addChild(TreeUtilFunctions.deepCopyWithMap(child, cpyMap));
        }
        return copy;
    }

    public static FakeTree getFakeTreeInstance() {
        if (_instance == null) {
            _instance = new FakeTree(new Tree[0]);
        }
        return _instance;
    }

    public static Tree getFinalRoot(Tree tree) {
        if (tree.isRoot()) {
            return tree;
        }
        if (tree.getParent() instanceof FakeTree) {
            return tree;
        }
        return TreeUtilFunctions.getFinalRoot(tree.getParent());
    }

    public static Tree getParentUntilType(Tree tree, String matchingType) {
        if (tree.getType().name.equals(matchingType)) {
            return tree;
        }
        if (tree.getParent() != null) {
            return TreeUtilFunctions.getParentUntilType(tree.getParent(), matchingType);
        }
        return null;
    }

    public static Tree loadTree(String name) {
        try {
            FileInputStream resourceAsStream = FileUtils.openInputStream((File)new File(name));
            return TreeIoUtils.fromXml().generateFrom().stream((InputStream)resourceAsStream).getRoot();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to load test resource: %s", name), e);
        }
    }

    public static void writeTree(Tree tree, String filePath) {
        TreeContext srcTC = new TreeContext();
        srcTC.setRoot(tree);
        try {
            TreeIoUtils.toXml((TreeContext)srcTC).writeTo(filePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isStatement(String type) {
        switch (type) {
            case "AssertStatement": 
            case "Block": 
            case "BreakStatement": 
            case "ConstructorInvocation": 
            case "ContinueStatement": 
            case "DoStatement": 
            case "EmptyStatement": 
            case "EnhancedForStatement": 
            case "ExpressionStatement": 
            case "ForStatement": 
            case "IfStatement": 
            case "LabeledStatement": 
            case "ReturnStatement": 
            case "SuperConstructorInvocation": 
            case "SwitchCase": 
            case "SwitchStatement": 
            case "SynchronizedStatement": 
            case "ThrowStatement": 
            case "TryStatement": 
            case "TypeDeclarationStatement": 
            case "VariableDeclarationStatement": 
            case "WhileStatement": {
                return true;
            }
        }
        return false;
    }

    public static boolean isPartOfJavadoc(Tree srcSubTree) {
        if (srcSubTree.getType().name.equals("Javadoc")) {
            return true;
        }
        if (srcSubTree.getParent() == null) {
            return false;
        }
        return TreeUtilFunctions.isPartOfJavadoc(srcSubTree.getParent());
    }

    public static List<Tree> findVariable(Tree inputTree, String variableName) {
        if (inputTree == null) {
            return null;
        }
        boolean _seen = false;
        ArrayList<Tree> refs = new ArrayList<Tree>();
        for (Tree tree : inputTree.preOrder()) {
            if (!tree.getType().name.equals("SimpleName") || !tree.getLabel().equals(variableName)) continue;
            refs.add(tree);
            _seen = true;
        }
        return refs;
    }

    public static boolean hasSameTypeAndLabel(Tree t1, Tree t2) {
        return TreeUtilFunctions.hasSameType(t1, t2) && t1.getLabel().equals(t2.getLabel());
    }

    public static boolean hasSameType(Tree t1, Tree t2) {
        return t1.getType().name.equals(t2.getType().name);
    }

    public static boolean isIsomorphicTo(Tree t1, Tree t2) {
        if (!TreeUtilFunctions.hasSameTypeAndLabel(t1, t2)) {
            return false;
        }
        if (t1.getChildren().size() != t2.getChildren().size()) {
            return false;
        }
        for (int i = 0; i < t1.getChildren().size(); ++i) {
            boolean isChildrenIsomophic = TreeUtilFunctions.isIsomorphicTo(t1.getChild(i), t2.getChild(i));
            if (isChildrenIsomophic) continue;
            return false;
        }
        return true;
    }

    public static boolean areBothFromThisType(Mapping mapping, String simpleName) {
        return TreeUtilFunctions.areBothFromThisType((Tree)mapping.first, (Tree)mapping.second, simpleName);
    }

    public static boolean areBothFromThisType(Tree t1, Tree t2, String simpleName) {
        return t1.getType().name.equals(simpleName) && t2.getType().name.equals(simpleName);
    }
}

