/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class ExternalProcess {
    ExternalProcess() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(File workingDir, String ... commandAndArgs) {
        try {
            Process p = new ProcessBuilder(commandAndArgs).directory(workingDir).redirectErrorStream(true).start();
            try {
                StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream());
                outputGobbler.run();
                p.waitFor();
                if (p.exitValue() != 0) throw new RuntimeException("Error executing command " + commandAndArgs + ":\n" + outputGobbler.getOutput());
                String string = outputGobbler.getOutput();
                return string;
            }
            finally {
                ExternalProcess.close(p.getInputStream());
                ExternalProcess.close(p.getOutputStream());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error executing command " + commandAndArgs, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error executing command " + commandAndArgs, e);
        }
    }

    private static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private final InputStream is;
        private final StringBuffer output = new StringBuffer();

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.output.append(line + "\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getOutput() {
            return this.output.toString();
        }
    }
}

