/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.util;

import java.util.EnumSet;
import org.refactoringminer.api.RefactoringType;

public class RefactoringRelationship
implements Comparable<RefactoringRelationship> {
    private static final EnumSet<RefactoringType> typesWithMainEntityAfter = EnumSet.of(RefactoringType.EXTRACT_AND_MOVE_OPERATION, new RefactoringType[]{RefactoringType.EXTRACT_INTERFACE, RefactoringType.EXTRACT_OPERATION, RefactoringType.EXTRACT_SUPERCLASS, RefactoringType.PULL_UP_ATTRIBUTE, RefactoringType.PULL_UP_OPERATION});
    private final RefactoringType refactoringType;
    private final String entityBefore;
    private final String entityAfter;

    public RefactoringRelationship(RefactoringType refactoringType, String entityBefore, String entityAfter) {
        if (refactoringType == null || entityBefore == null || entityAfter == null) {
            throw new IllegalArgumentException("arguments should not be null");
        }
        this.refactoringType = refactoringType;
        this.entityBefore = RefactoringRelationship.normalize(entityBefore).trim();
        this.entityAfter = RefactoringRelationship.normalize(entityAfter).trim();
    }

    public RefactoringType getRefactoringType() {
        return this.refactoringType;
    }

    public String getEntityBefore() {
        return this.entityBefore;
    }

    public String getEntityAfter() {
        return this.entityAfter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RefactoringRelationship) {
            RefactoringRelationship other = (RefactoringRelationship)obj;
            return other.refactoringType.equals((Object)this.refactoringType) && other.entityBefore.equals(this.entityBefore) && other.entityAfter.equals(this.entityAfter);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entityAfter.hashCode();
        result = 31 * result + this.entityBefore.hashCode();
        result = 31 * result + this.refactoringType.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s\t%s\t%s", this.refactoringType.getDisplayName(), this.entityBefore, this.entityAfter);
    }

    public static String normalize(String entity) {
        return RefactoringRelationship.normalizeParameters(RefactoringRelationship.stripTypeArguments(entity).replace('#', '.')).replace(" ", "");
    }

    public static String parentOf(String entity) {
        return entity.substring(0, entity.lastIndexOf(46));
    }

    private static String normalizeParameters(String r) {
        int indexOfPar = ((String)r).indexOf(40);
        if (indexOfPar != -1) {
            String paramsS = ((String)r).substring(indexOfPar + 1, ((String)r).indexOf(41));
            CharSequence[] paramsA = paramsS.split("\\s*,\\s*");
            if (paramsA.length == 0 || paramsA[0].isEmpty()) {
                return r;
            }
            for (int i = 0; i < paramsA.length; ++i) {
                if (paramsA[i].indexOf(32) != -1) {
                    paramsA[i] = ((String)paramsA[i]).substring(0, ((String)paramsA[i]).indexOf(32));
                }
                if (((String)paramsA[i]).lastIndexOf(46) != -1) {
                    paramsA[i] = ((String)paramsA[i]).substring(((String)paramsA[i]).lastIndexOf(46) + 1);
                }
                paramsA[i] = ((String)paramsA[i]).substring(Math.max(((String)paramsA[i]).lastIndexOf(46) + 1, 0));
            }
            r = ((String)r).substring(0, indexOfPar) + "(" + String.join((CharSequence)",", paramsA) + ")";
        }
        return r;
    }

    private static String stripTypeArguments(String entity) {
        StringBuilder sb = new StringBuilder();
        int openGenerics = 0;
        for (int i = 0; i < entity.length(); ++i) {
            char c = entity.charAt(i);
            if (c == '<') {
                ++openGenerics;
            }
            if (openGenerics == 0) {
                sb.append(c);
            }
            if (c != '>') continue;
            --openGenerics;
        }
        return sb.toString();
    }

    public String getMainEntity() {
        if (typesWithMainEntityAfter.contains((Object)this.refactoringType)) {
            return this.entityAfter;
        }
        return this.entityBefore;
    }

    public String getSecondaryEntity() {
        if (typesWithMainEntityAfter.contains((Object)this.refactoringType)) {
            return this.entityBefore;
        }
        return this.entityAfter;
    }

    @Override
    public int compareTo(RefactoringRelationship o) {
        int rt = this.getRefactoringType().compareTo(o.getRefactoringType());
        int cm = this.getMainEntity().compareTo(o.getMainEntity());
        int cs = this.getSecondaryEntity().compareTo(o.getSecondaryEntity());
        int ct = this.refactoringType.compareTo(o.refactoringType);
        return rt != 0 ? rt : (cm != 0 ? cm : (cs != 0 ? cs : ct));
    }

    public GroupKey getGroupKey() {
        return new GroupKey(this.refactoringType, this.getMainEntity());
    }

    public static class GroupKey
    implements Comparable<GroupKey> {
        private final RefactoringType refactoringType;
        private final String mainEntity;

        public GroupKey(RefactoringType refactoringType, String mainEntity) {
            this.refactoringType = refactoringType;
            this.mainEntity = mainEntity;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GroupKey) {
                GroupKey other = (GroupKey)obj;
                return other.refactoringType.equals((Object)this.refactoringType) && other.mainEntity.equals(this.mainEntity);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mainEntity.hashCode();
            result = 31 * result + this.refactoringType.hashCode();
            return result;
        }

        @Override
        public int compareTo(GroupKey o) {
            int rt = this.refactoringType.compareTo(o.refactoringType);
            int cm = this.mainEntity.compareTo(o.mainEntity);
            int ct = this.refactoringType.compareTo(o.refactoringType);
            return rt != 0 ? rt : (cm != 0 ? cm : ct);
        }

        public String toString() {
            return String.format("%s\t%s", this.refactoringType.getDisplayName(), this.mainEntity);
        }
    }
}

