/*
 * Decompiled with CFR 0.152.
 */
package com.tschuchort.compiletesting;

import com.tschuchort.compiletesting.UtilsKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a8\u0006\u000b"}, d2={"findToolsJarFromJdk", "Ljava/io/File;", "jdkHome", "getJavacVersionString", "", "javacCommand", "isJavac9OrLater", "", "javacVersionString", "parseVersionString", "output", "kotlin-compile-testing"})
public final class JavacUtilsKt {
    @NotNull
    public static final String getJavacVersionString(@NotNull String javacCommand) {
        Intrinsics.checkNotNullParameter((Object)javacCommand, (String)"javacCommand");
        Process javacProc = new ProcessBuilder(CollectionsKt.listOf((Object[])new String[]{javacCommand, "-version"})).redirectErrorStream(true).start();
        Buffer buffer = new Buffer();
        Process process = javacProc;
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"javacProc");
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"javacProc.inputStream");
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)buffer.outputStream(), (int)0, (int)2, null);
        javacProc.waitFor();
        String output = buffer.readUtf8();
        String string = JavacUtilsKt.parseVersionString(output);
        if (string == null) {
            throw (Throwable)new IllegalStateException("Command '" + javacCommand + " -version' did not print expected output. " + "Output was: '" + output + '\'');
        }
        return string;
    }

    @Nullable
    public static final String parseVersionString(@NotNull String output) {
        String string;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        MatchResult matchResult = Regex.find$default((Regex)new Regex("javac (.*)?[\\s\\S]*"), (CharSequence)output, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            string = (String)matchResult2.getMatch().getGroupValues().get(1);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavac9OrLater(@NotNull String javacVersionString) {
        Intrinsics.checkNotNullParameter((Object)javacVersionString, (String)"javacVersionString");
        try {
            void minorv;
            void majorv;
            MatchResult matchResult;
            MatchResult matchResult2 = new Regex("([0-9]*)(?:\\.([0-9]*))?(?:\\.([0-9]*))?(.*)").matchEntire((CharSequence)javacVersionString);
            MatchResult matchResult3 = matchResult2;
            if (matchResult2 == null) throw (Throwable)new IllegalArgumentException("Could not match version regex");
            MatchResult.Destructured destructured = matchResult3.getDestructured();
            matchResult3 = destructured;
            if (destructured == null) throw (Throwable)new IllegalArgumentException("Could not match version regex");
            MatchResult matchResult4 = matchResult = matchResult3;
            boolean bl = false;
            String string = (String)matchResult4.getMatch().getGroupValues().get(1);
            matchResult4 = matchResult;
            bl = false;
            String string2 = (String)matchResult4.getMatch().getGroupValues().get(2);
            matchResult4 = matchResult;
            bl = false;
            String string3 = (String)matchResult4.getMatch().getGroupValues().get(3);
            matchResult4 = matchResult;
            bl = false;
            String otherv = (String)matchResult4.getMatch().getGroupValues().get(4);
            CharSequence charSequence = (CharSequence)majorv;
            boolean bl2 = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)charSequence);
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl4 = false;
                String string4 = "Major version can not be blank";
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            void var5_4 = majorv;
            bl2 = false;
            if (Integer.parseInt((String)var5_4) == 1) {
                CharSequence charSequence2 = (CharSequence)minorv;
                bl2 = false;
                boolean bl5 = !StringsKt.isBlank((CharSequence)charSequence2);
                bl2 = false;
                bl = false;
                if (!bl5) {
                    boolean bl6 = false;
                    String string5 = "Minor version can not be blank if major version is 1";
                    throw (Throwable)new IllegalStateException(string5.toString());
                }
            }
            void var5_7 = majorv;
            bl2 = false;
            if (Integer.parseInt((String)var5_7) == 1) {
                void var5_8 = minorv;
                bl2 = false;
                if (Integer.parseInt((String)var5_8) >= 9) return true;
            }
            void var5_10 = majorv;
            bl2 = false;
            if (Integer.parseInt((String)var5_10) < 9) return false;
            return true;
        }
        catch (Throwable t) {
            throw (Throwable)new IllegalArgumentException("Could not parse javac version string: '" + javacVersionString + '\'', t);
        }
    }

    @NotNull
    public static final File findToolsJarFromJdk(@NotNull File jdkHome2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)jdkHome2, (String)"jdkHome");
        File file2 = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"../lib/tools.jar"));
        if (file2 == null) {
            file2 = file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"lib/tools.jar"));
        }
        if (file2 == null) {
            file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"tools.jar"));
        }
        if (file == null) {
            throw (Throwable)new IllegalStateException("Can not find tools.jar from JDK with path " + jdkHome2.getAbsolutePath());
        }
        return file;
    }
}

