/*
 * Decompiled with CFR 0.152.
 */
package com.tschuchort.compiletesting;

import com.tschuchort.compiletesting.UtilsKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a8\u0006\u000b"}, d2={"findToolsJarFromJdk", "Ljava/io/File;", "jdkHome", "getJavacVersionString", "", "javacCommand", "isJavac9OrLater", "", "javacVersionString", "parseVersionString", "output", "kotlin-compile-testing"})
public final class JavacUtilsKt {
    @NotNull
    public static final String getJavacVersionString(@NotNull String javacCommand) {
        Intrinsics.checkNotNullParameter((Object)javacCommand, (String)"javacCommand");
        Object[] objectArray = new String[]{javacCommand, "-version"};
        Process javacProc = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).redirectErrorStream(true).start();
        Buffer buffer = new Buffer();
        InputStream inputStream = javacProc.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"javacProc.inputStream");
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)buffer.outputStream(), (int)0, (int)2, null);
        javacProc.waitFor();
        String output = buffer.readUtf8();
        String string = JavacUtilsKt.parseVersionString(output);
        if (string == null) {
            throw new IllegalStateException("Command '" + javacCommand + " -version' did not print expected output. Output was: '" + output + '\'');
        }
        return string;
    }

    @Nullable
    public static final String parseVersionString(@NotNull String output) {
        String string;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        MatchResult matchResult = Regex.find$default((Regex)new Regex("javac (.*)?[\\s\\S]*"), (CharSequence)output, (int)0, (int)2, null);
        if (matchResult == null) {
            string = null;
        } else {
            MatchResult.Destructured destructured = matchResult.getDestructured();
            if (destructured == null) {
                string = null;
            } else {
                MatchResult.Destructured destructured2 = destructured;
                boolean bl = false;
                string = (String)destructured2.getMatch().getGroupValues().get(1);
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavac9OrLater(@NotNull String javacVersionString) {
        Intrinsics.checkNotNullParameter((Object)javacVersionString, (String)"javacVersionString");
        try {
            MatchResult.Destructured destructured;
            MatchResult matchResult = new Regex("([0-9]*)(?:\\.([0-9]*))?(?:\\.([0-9]*))?(.*)").matchEntire((CharSequence)javacVersionString);
            MatchResult.Destructured destructured2 = destructured = matchResult == null ? null : matchResult.getDestructured();
            if (destructured == null) {
                throw new IllegalArgumentException("Could not match version regex");
            }
            MatchResult.Destructured destructured3 = destructured;
            matchResult = destructured3;
            boolean bl = false;
            String majorv = (String)matchResult.getMatch().getGroupValues().get(1);
            MatchResult.Destructured destructured4 = destructured3;
            boolean bl2 = false;
            String minorv = (String)destructured4.getMatch().getGroupValues().get(2);
            MatchResult.Destructured destructured5 = destructured3;
            boolean bl3 = false;
            String patchv = (String)destructured5.getMatch().getGroupValues().get(3);
            MatchResult.Destructured destructured6 = destructured3;
            boolean bl4 = false;
            String otherv = (String)destructured6.getMatch().getGroupValues().get(4);
            CharSequence charSequence = majorv;
            bl4 = false;
            boolean bl5 = !StringsKt.isBlank((CharSequence)charSequence);
            bl4 = false;
            boolean bl6 = false;
            if (!bl5) {
                boolean bl7 = false;
                String string = "Major version can not be blank";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String string = majorv;
            bl4 = false;
            if (Integer.parseInt(string) == 1) {
                CharSequence charSequence2 = minorv;
                bl4 = false;
                boolean bl8 = !StringsKt.isBlank((CharSequence)charSequence2);
                bl4 = false;
                bl6 = false;
                if (!bl8) {
                    boolean bl9 = false;
                    String string2 = "Minor version can not be blank if major version is 1";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            String string3 = majorv;
            bl4 = false;
            if (Integer.parseInt(string3) == 1) {
                String string4 = minorv;
                bl4 = false;
                if (Integer.parseInt(string4) >= 9) return true;
            }
            String string5 = majorv;
            bl4 = false;
            if (Integer.parseInt(string5) < 9) return false;
            return true;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not parse javac version string: '" + javacVersionString + '\'', t);
        }
    }

    @NotNull
    public static final File findToolsJarFromJdk(@NotNull File jdkHome2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)jdkHome2, (String)"jdkHome");
        File file2 = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"../lib/tools.jar"));
        if (file2 == null) {
            File file3 = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"lib/tools.jar"));
            if (file3 == null) {
                File file4 = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome2, (String)"tools.jar"));
                if (file4 == null) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Can not find tools.jar from JDK with path ", (Object)jdkHome2.getAbsolutePath()));
                }
                file = file4;
            } else {
                file = file3;
            }
        } else {
            file = file2;
        }
        return file;
    }
}

